<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\StorageBatchOperations;

class Counters extends \Google\Model
{
  /**
   * @var string
   */
  public $failedObjectCount;
  /**
   * @var string
   */
  public $succeededObjectCount;
  /**
   * @var string
   */
  public $totalBytesFound;
  /**
   * @var string
   */
  public $totalObjectCount;

  /**
   * @param string
   */
  public function setFailedObjectCount($failedObjectCount)
  {
    $this->failedObjectCount = $failedObjectCount;
  }
  /**
   * @return string
   */
  public function getFailedObjectCount()
  {
    return $this->failedObjectCount;
  }
  /**
   * @param string
   */
  public function setSucceededObjectCount($succeededObjectCount)
  {
    $this->succeededObjectCount = $succeededObjectCount;
  }
  /**
   * @return string
   */
  public function getSucceededObjectCount()
  {
    return $this->succeededObjectCount;
  }
  /**
   * @param string
   */
  public function setTotalBytesFound($totalBytesFound)
  {
    $this->totalBytesFound = $totalBytesFound;
  }
  /**
   * @return string
   */
  public function getTotalBytesFound()
  {
    return $this->totalBytesFound;
  }
  /**
   * @param string
   */
  public function setTotalObjectCount($totalObjectCount)
  {
    $this->totalObjectCount = $totalObjectCount;
  }
  /**
   * @return string
   */
  public function getTotalObjectCount()
  {
    return $this->totalObjectCount;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Counters::class, 'Google_Service_StorageBatchOperations_Counters');
