<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DataManager;

class UserProperties extends \Google\Collection
{
  protected $collection_key = 'additionalUserProperties';
  protected $additionalUserPropertiesType = UserProperty::class;
  protected $additionalUserPropertiesDataType = 'array';
  /**
   * @var string
   */
  public $customerType;
  /**
   * @var string
   */
  public $customerValueBucket;

  /**
   * @param UserProperty[]
   */
  public function setAdditionalUserProperties($additionalUserProperties)
  {
    $this->additionalUserProperties = $additionalUserProperties;
  }
  /**
   * @return UserProperty[]
   */
  public function getAdditionalUserProperties()
  {
    return $this->additionalUserProperties;
  }
  /**
   * @param string
   */
  public function setCustomerType($customerType)
  {
    $this->customerType = $customerType;
  }
  /**
   * @return string
   */
  public function getCustomerType()
  {
    return $this->customerType;
  }
  /**
   * @param string
   */
  public function setCustomerValueBucket($customerValueBucket)
  {
    $this->customerValueBucket = $customerValueBucket;
  }
  /**
   * @return string
   */
  public function getCustomerValueBucket()
  {
    return $this->customerValueBucket;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UserProperties::class, 'Google_Service_DataManager_UserProperties');
