<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2FileStoreCollection extends \Google\Model
{
  protected $includeRegexesType = GooglePrivacyDlpV2FileStoreRegexes::class;
  protected $includeRegexesDataType = '';
  protected $includeTagsType = GooglePrivacyDlpV2TagFilters::class;
  protected $includeTagsDataType = '';

  /**
   * @param GooglePrivacyDlpV2FileStoreRegexes
   */
  public function setIncludeRegexes(GooglePrivacyDlpV2FileStoreRegexes $includeRegexes)
  {
    $this->includeRegexes = $includeRegexes;
  }
  /**
   * @return GooglePrivacyDlpV2FileStoreRegexes
   */
  public function getIncludeRegexes()
  {
    return $this->includeRegexes;
  }
  /**
   * @param GooglePrivacyDlpV2TagFilters
   */
  public function setIncludeTags(GooglePrivacyDlpV2TagFilters $includeTags)
  {
    $this->includeTags = $includeTags;
  }
  /**
   * @return GooglePrivacyDlpV2TagFilters
   */
  public function getIncludeTags()
  {
    return $this->includeTags;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2FileStoreCollection::class, 'Google_Service_DLP_GooglePrivacyDlpV2FileStoreCollection');
