<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Mon portefeuille','section' => 'Code and tracking','page' => '']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Mon portefeuille','section' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Code and tracking'),'page' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('')]); ?>

    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>

    <div class="max-w-5xl mx-auto font-inter" x-data="walletManager()">

        <div class="mb-10 mt-10">
            <h2 class="text-[26px] font-medium text-[#000000] mb-4">Code</h2>
            <hr class="border-gray-200 mb-6">

            <!-- Signature Code -->
            <div class="flex items-start justify-between mb-8">
                <div>
                    <div class="flex items-center gap-4">
                        <p class="text-[16px] font-medium text-[#000000]">Signature Code</p>

                        <label class="relative inline-flex items-center cursor-pointer">
                            <input type="checkbox"
                                   class="sr-only peer"
                                   x-model="signatureCode.is_active">
                            <div class="w-11 h-6 bg-gray-300 rounded-full peer-checked:bg-blue-500 transition-all"></div>
                            <div class="absolute left-1 top-1 w-4 h-4 bg-white rounded-full shadow transition-all peer-checked:translate-x-5"></div>
                        </label>
                    </div>

                    <p class="text-sm text-gray-500 mt-2">
                        Your permanent key to exclusive savings, anytime.
                    </p>
                </div>

                <button class="px-4 py-2 border rounded-lg text-sm hover:bg-gray-50 transition"
                        @click="openSignature = true">
                    Manage Code
                </button>
            </div>

            <!-- Prestige Code -->
            <div class="flex items-start justify-between">
                <div>
                    <div class="flex items-center gap-4">
                        <p class="text-[16px] font-medium text-[#000000]">Prestige Code</p>

                        <label class="relative inline-flex items-center cursor-pointer">
                            <input type="checkbox"
                                   class="sr-only peer"
                                   x-model="prestigeCode.is_active">
                            <div class="w-11 h-6 bg-gray-300 rounded-full peer-checked:bg-blue-500 transition-all"></div>
                            <div class="absolute left-1 top-1 w-4 h-4 bg-white rounded-full shadow transition-all peer-checked:translate-x-5"></div>
                        </label>
                    </div>

                    <p class="text-sm text-gray-500 mt-2">
                        Only available a few times per year. We'll notify you when it's active.
                    </p>
                </div>

                <button class="px-4 py-2 border rounded-lg text-sm hover:bg-gray-50 transition"
                        @click="openPrestige = true">
                    Manage Code
                </button>
            </div>
        </div>

        <!-- Tracking Section -->
        <h1 class="text-[26px] font-medium text-[#1D1D1E] mb-6">Tracking</h1>

        <div class="bg-white rounded-2xl overflow-hidden">
            <table class="min-w-full divide-y rounded-2xl divide-gray-100 text-sm">
                <thead class="bg-[#F6F7F5] rounded-2xl text-gray-700 font-medium">
                    <tr>
                        <th class="px-6 py-3 text-left">Transaction ID</th>
                        <th class="px-6 py-3 text-left">Amount</th>
                        <th class="px-6 py-3 text-left">Payment Method</th>
                        <th class="px-6 py-3 text-left">Date</th>
                        <th class="px-6 py-3 text-left">Status</th>
                    </tr>
                </thead>

                <tbody class="divide-y divide-gray-100 text-gray-700">
                    <template x-for="transaction in transactions" :key="transaction.id">
                        <tr>
                            <td class="px-6 py-3" x-text="'#' + transaction.id"></td>
                            <td class="px-6 py-3" x-text="transaction.amount + ' TND'"></td>
                            <td class="px-6 py-3" x-text="transaction.payment_method"></td>
                            <td class="px-6 py-3" x-text="transaction.date"></td>
                            <td class="px-6 py-3">
                            <span x-show="transaction.status === 'success'"
      class="inline-flex items-center justify-center gap-1 px-2 py-0.5 rounded-full text-[13px] bg-[#DBECDD] text-[#436653] font-medium min-w-[90px]">
    <span class="w-1.5 h-1.5 rounded-full bg-[#5F9873]"></span>
    Success
</span>

<span x-show="transaction.status === 'pending'"
      class="inline-flex items-center justify-center gap-1 px-2 py-0.5 rounded-full text-[13px] bg-[#F7DCC9] text-[#6F492D] font-medium min-w-[90px]">
    <span class="w-1.5 h-1.5 rounded-full bg-[#DF7630]"></span>
    Pending
</span>

<span x-show="transaction.status === 'failed'"
      class="inline-flex items-center justify-center gap-1 px-2 py-0.5 rounded-full text-[13px] bg-[#FBDCD9] text-[#7C4944] font-medium min-w-[90px]">
    <span class="w-1.5 h-1.5 rounded-full bg-[#E26154]"></span>
    Failed
</span>
                            </td>
                        </tr>
                    </template>

                    <tr x-show="transactions.length === 0">
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            No transactions found
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Modal Signature Code -->
        <div x-show="openSignature"
             x-cloak
             class="fixed inset-0 bg-black/40 z-50 flex items-center justify-center"
             @click.self="openSignature = false">

            <div class="bg-white w-full max-w-lg rounded-2xl p-6 shadow-xl" @click.stop>
                <h2 class="font-medium text-lg mb-4">Signature Code</h2>

                <div class="flex items-center justify-between mb-4">
                    <input type="text"
                           x-model="signatureCode.code"
                           class="text-3xl font-semibold border-0 focus:ring-0 p-0"
                           maxlength="20">
                    <button @click="copyToClipboard(signatureCode.code)"
                            class="px-4 py-2 border bg-[#F6F7F5] rounded-lg text-sm hover:bg-gray-50">
                        Copy
                    </button>
                </div>

                <p class="font-medium text-gray-700 mb-1">Status</p>
                <p class="flex items-center gap-2 text-sm mb-2">
                    <span class="w-2 h-2 rounded-full"
                          :class="signatureCode.is_active ? 'bg-green-600' : 'bg-red-600'"></span>
                    <span x-text="signatureCode.is_active ? 'Active' : 'Inactive'"></span>
                </p>

               <div class="mb-4">


    <p class="px-3 py-2  text-gray-800 text-sm">
        <span x-text="prestigeCode.discount"></span>%
    </p>
</div>

                <div class="flex justify-between mt-6">
                    <button @click="openSignature = false"
                            class="px-4 py-2 border rounded-lg bg-[#F6F7F5] text-gray-600 hover:bg-[#F6F7F5]">
                        Cancel
                    </button>
                    <button @click="saveSignatureCode()"
                            class="px-4 py-2 bg-[#F6F7F5] border text-black rounded-lg hover:bg-[#F6F7F5]">
                        Submit
                    </button>
                </div>
            </div>
        </div>

        <!-- Modal Prestige Code -->
        <div x-show="openPrestige"
             x-cloak
             class="fixed inset-0 bg-black/40 z-50 flex items-center justify-center"
             @click.self="openPrestige = false">

            <div class="bg-white w-full max-w-lg rounded-2xl p-6 shadow-xl" @click.stop>
                <h2 class="font-medium text-lg mb-4">Prestige Code</h2>

                <div class="flex items-center justify-between mb-4">
                    <input type="text"
                           x-model="prestigeCode.code"
                           class="text-3xl font-semibold border-0 focus:ring-0 p-0"
                           maxlength="20">
                    <button @click="copyToClipboard(prestigeCode.code)"
                            class="px-4 py-2 border bg-[#F6F7F5] rounded-lg text-sm hover:bg-gray-50">
                        Copy
                    </button>
                </div>

                <p class="font-medium text-gray-700 mb-1">Status</p>
                <p class="flex items-center gap-2 text-sm mb-2">
                    <span class="w-2 h-2 rounded-full"
                          :class="prestigeCode.is_active ? 'bg-green-600' : 'bg-red-600'"></span>
                    <span x-text="prestigeCode.is_active ? 'Active' : 'Inactive'"></span>
                </p>

             <div class="mb-4">


    <p class="px-3 py-2  text-gray-800 text-sm">
        <span x-text="prestigeCode.discount"></span>%
    </p>
</div>

                <div class="flex justify-between mt-6">
                    <button @click="openPrestige = false"
                            class="px-4 py-2 border rounded-lg bg-[#F6F7F5] text-gray-600 hover:bg-[#F6F7F5]">
                        Cancel
                    </button>
                    <button @click="savePrestigeCode()"
                             class="px-4 py-2 bg-[#F6F7F5] border text-black rounded-lg hover:bg-[#F6F7F5]">
                        Submit
                    </button>
                </div>
            </div>
        </div>

    </div>

    <script>
        function walletManager() {
            return {
                openSignature: false,
                openPrestige: false,

                // Données statiques des codes
                signatureCode: {
                    code: 'ALPHA5',
                    is_active: true,
                    discount: 20
                },

                prestigeCode: {
                    code: 'ALPHA20',
                    is_active: false,
                    discount: 20
                },

                // Données statiques des transactions
                transactions: [
                    {
                        id: 1001,
                        amount: '150.00',
                        payment_method: 'BIAT Bank',
                        date: '2025-10-21',
                        status: 'success'
                    },
                    {
                        id: 1002,
                        amount: '75.00',
                        payment_method: 'Poste Tunisienne',
                        date: '2025-11-01',
                        status: 'pending'
                    },
                    {
                        id: 1003,
                        amount: '220.00',
                        payment_method: 'Amen Bank',
                        date: '2025-11-05',
                        status: 'failed'
                    }
                ],

                // Sauvegarder le code signature
                saveSignatureCode() {
                    localStorage.setItem('signatureCode', JSON.stringify(this.signatureCode));
                    this.showNotification('Signature code updated successfully!');
                    this.openSignature = false;
                },

                // Sauvegarder le code prestige
                savePrestigeCode() {
                    localStorage.setItem('prestigeCode', JSON.stringify(this.prestigeCode));
                    this.showNotification('Prestige code updated successfully!');
                    this.openPrestige = false;
                },

                // Copier dans le presse-papier
                copyToClipboard(text) {
                    navigator.clipboard.writeText(text).then(() => {
                        this.showNotification('Code copied to clipboard!');
                    }).catch(() => {
                        alert('Failed to copy code');
                    });
                },

                // Afficher une notification
                showNotification(message) {
                    alert(message);
                },

                // Initialisation
                init() {
                    const savedSignatureCode = localStorage.getItem('signatureCode');
                    const savedPrestigeCode = localStorage.getItem('prestigeCode');

                    if (savedSignatureCode) {
                        this.signatureCode = JSON.parse(savedSignatureCode);
                    }

                    if (savedPrestigeCode) {
                        this.prestigeCode = JSON.parse(savedPrestigeCode);
                    }

                    console.log('Wallet Manager initialized');
                    console.log('openSignature:', this.openSignature);
                    console.log('openPrestige:', this.openPrestige);
                }
            }
        }
    </script>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/affiliate/codeandtracking.blade.php ENDPATH**/ ?>