<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Dashboard Étudiant','points' => $points,'section' => 'Home','page' => '']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Dashboard Étudiant','points' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($points),'section' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Home'),'page' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('')]); ?>

    <!-- Header Section -->
    <div class="mt-2 ml-16  mb-8">
        <h2 class="text-4xl font-bold text-gray-900">
            Hello <span class="capitalize"><?php echo e(Auth::user()->name ?? 'Bechir'); ?></span>
        </h2>

        <div class="flex items-center   gap-x-10">
            <p class="text-4xl font-bold bg-gradient-to-r from-blue-500 via-pink-500 to-red-500 bg-clip-text text-transparent">
                How can I help you today ?
            </p>

            <!-- Bouton Ask Nova -->
           <a href="<?php echo e(url('/student/nova')); ?>"
   class="relative ml-6 mt-4 px-6 py-1 rounded-full font-semibold text-xl
          bg-white hover:scale-105 transition-transform duration-300 group">
    <span class="absolute inset-0 rounded-full bg-gradient-to-r from-blue-500 via-pink-500 to-orange-500 p-[1.5px]">
        <span class="flex h-full w-full items-center justify-center rounded-full bg-white"></span>
    </span>

    <!-- 👇 Taille 16px + semi-bold -->
    <span class="relative text-[16px] font-semibold
                 bg-gradient-to-r from-blue-500 via-pink-500 to-orange-500
                 bg-clip-text text-transparent">
        Ask Nova
    </span>
</a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="px-8 pb-10">

        <!-- Statistiques Principales en Cards -->


        <!-- Section: Activité Récente (7 derniers jours) -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 mb-8">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                    <i class="ri-line-chart-line text-indigo-600"></i>
                    Recent Activity (Last 7 days)
                </h3>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="text-center p-4 bg-blue-50 rounded-xl">
                    <div class="text-4xl font-bold text-blue-600 mb-1"><?php echo e($recentActivity['tasks_completed']); ?></div>
                    <p class="text-sm text-gray-600">Tasks Completed</p>
                </div>
                <div class="text-center p-4 bg-purple-50 rounded-xl">
                    <div class="text-4xl font-bold text-purple-600 mb-1"><?php echo e($recentActivity['goals_completed']); ?></div>
                    <p class="text-sm text-gray-600">Goals Achieved</p>
                </div>
                <div class="text-center p-4 bg-pink-50 rounded-xl">
                    <div class="text-4xl font-bold text-pink-600 mb-1"><?php echo e($recentActivity['nova_conversations']); ?></div>
                    <p class="text-sm text-gray-600">Nova Conversations</p>
                </div>
            </div>
        </div>

        <!-- 2 Colonnes: Tasks et Sessions -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">

            <!-- Today's Tasks -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <i class="ri-checkbox-line text-blue-600"></i>
                        Today's Tasks
                    </h3>
                    <a href="<?php echo e(route('student.goals')); ?>" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
                        View all →
                    </a>
                </div>

                <?php if($todayTasks->count() > 0): ?>
                    <div class="space-y-3">
                        <?php $__currentLoopData = $todayTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center gap-3 p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition">
                            <div class="flex-shrink-0">
                                <input type="checkbox" class="w-5 h-5 rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-medium text-gray-900 truncate"><?php echo e($task->title); ?></p>
                                <?php if($task->category): ?>
                                <span class="text-xs text-gray-500"><?php echo e($task->category); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-8 text-gray-400">
                        <i class="ri-checkbox-circle-line text-5xl mb-2"></i>
                        <p class="text-sm">No pending tasks for today! 🎉</p>
                    </div>
                <?php endif; ?>
            </div>

           <!-- Upcoming Meetings (Zoom) -->
<div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
    <div class="flex items-center justify-between mb-6">
        <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
            <i class="ri-calendar-event-line text-green-600"></i>
            Upcoming Meetings
        </h3>
        <a href="/student/live-sessions" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
            View all →
        </a>
    </div>

    <?php if($upcomingSessions->count() > 0): ?>
        <div class="space-y-3">
            <?php $__currentLoopData = $upcomingSessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="flex items-start gap-3 p-3 border-l-4 border-green-500 rounded-lg hover:bg-gray-50 transition">

                <div class="flex-shrink-0 bg-green-50 p-2 rounded-lg">
                    <i class="ri-video-chat-line text-green-600 text-lg"></i>
                </div>

                <div class="flex-1 min-w-0">
                    <p class="text-sm font-semibold text-gray-900">
                        <?php echo e($session->topic); ?>

                    </p>

                    <p class="text-xs text-gray-500 mt-1">
                        <i class="ri-time-line"></i>
                        <?php echo e(\Carbon\Carbon::parse($session->start_time)->format('d M, H:i')); ?>

                    </p>

                    <?php if($session->password): ?>
                    <p class="text-xs text-gray-500 mt-1">
                        <i class="ri-lock-line"></i> Password: <?php echo e($session->password); ?>

                    </p>
                    <?php endif; ?>
                </div>

                <a href="/student/live-sessions" target="_blank"
                    class="flex-shrink-0 text-xs bg-green-100 text-green-700 px-3 py-1 rounded-full hover:bg-green-200 transition">
                    Join
                </a>

            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="text-center py-8 text-gray-400">
            <i class="ri-calendar-check-line text-5xl mb-2"></i>
            <p class="text-sm">No upcoming meetings</p>
        </div>
    <?php endif; ?>
</div>


        </div>

        <!-- Urgent Goals & Groups -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">

            <!-- Urgent Goals -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <i class="ri-alarm-warning-line text-red-600"></i>
                        Urgent Goals
                    </h3>
                    <a href="<?php echo e(route('student.goals')); ?>" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
                        View all →
                    </a>
                </div>

                <?php if($urgentGoals->count() > 0): ?>
                    <div class="space-y-3">
                        <?php $__currentLoopData = $urgentGoals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-start gap-3 p-3 bg-red-50 border border-red-100 rounded-lg">
                            <div class="flex-1">
                                <p class="text-sm font-semibold text-gray-900"><?php echo e($goal->title); ?></p>
                                <div class="flex items-center gap-3 mt-2 text-xs">
                                    <span class="flex items-center gap-1 text-red-600">
                                        <i class="ri-calendar-line"></i>
                                        Due: <?php echo e(\Carbon\Carbon::parse($goal->due_date)->format('d M Y')); ?>

                                    </span>
                                    <?php if($goal->priority): ?>
                                    <span class="px-2 py-0.5 bg-red-200 text-red-700 rounded-full">
                                        <?php echo e($goal->priority); ?>

                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <span class="flex-shrink-0 px-3 py-1 text-xs rounded-full
                                <?php if($goal->status == 'in_progress'): ?> bg-yellow-100 text-yellow-700
                                <?php else: ?> bg-gray-100 text-gray-600
                                <?php endif; ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $goal->status))); ?>

                            </span>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-8 text-gray-400">
                        <i class="ri-checkbox-circle-line text-5xl mb-2"></i>
                        <p class="text-sm">No urgent goals! You're all caught up! ✨</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- My Groups -->
            <div id="groups-section" class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <i class="ri-group-line text-blue-600"></i>
                        My Group
                    </h3>
                    <span class="text-sm text-gray-500"><?php echo e($groupsCount); ?> groups</span>
                </div>

                <?php if($userGroups->count() > 0): ?>
                    <div class="space-y-3">
                        <?php $__currentLoopData = $userGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center gap-4 p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-lg hover:shadow-md transition">
                            <div class="flex-shrink-0 w-12 h-12 bg-indigo-600 rounded-xl flex items-center justify-center text-white font-bold text-lg">
                                <?php echo e(strtoupper(substr($group->name, 0, 1))); ?>

                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-semibold text-gray-900 truncate"><?php echo e($group->name); ?></p>
                                <p class="text-xs text-gray-500 truncate"><?php echo e($group->description ?? 'No description'); ?></p>
                            </div>
                            <span class="flex-shrink-0 text-xs bg-indigo-100 text-indigo-700 px-3 py-1 rounded-full">
                                <?php echo e(ucfirst($group->role)); ?>

                            </span>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-8 text-gray-400">
                        <i class="ri-group-line text-5xl mb-2"></i>
                        <p class="text-sm">You're not in any groups yet</p>
                    </div>
                <?php endif; ?>
            </div>

        </div>

        <!-- Recent Projects -->
        <?php if($projects->count() > 0): ?>
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 mt-8">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                    <i class="ri-folder-open-line text-orange-600"></i>
                    Recent Projects
                </h3>
                <a href="<?php echo e(route('student.projects.index')); ?>" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
                    View all →
                </a>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="p-4 border border-gray-200 rounded-xl hover:shadow-md transition">
                    <div class="flex items-start justify-between mb-3">
                        <div class="flex-shrink-0 w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center">
                            <i class="ri-file-code-line text-orange-600 text-xl"></i>
                        </div>
                        <span class="text-xs px-2 py-1 rounded-full
                            <?php if($project->status == 'active'): ?> bg-green-100 text-green-700
                            <?php elseif($project->status == 'completed'): ?> bg-blue-100 text-blue-700
                            <?php else: ?> bg-gray-100 text-gray-600
                            <?php endif; ?>">
                            <?php echo e(ucfirst($project->status)); ?>

                        </span>
                    </div>
                    <h4 class="font-semibold text-gray-900 mb-1 truncate"><?php echo e($project->name); ?></h4>
                    <p class="text-xs text-gray-500 mb-2 line-clamp-2"><?php echo e($project->description ?? 'No description'); ?></p>
                    <div class="flex items-center justify-between text-xs text-gray-400">
                        <span><?php echo e($project->type); ?></span>
                        <span><?php echo e(\Carbon\Carbon::parse($project->created_at)->diffForHumans()); ?></span>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Recent Nova Conversations -->
        <?php if($recentConversations->count() > 0): ?>
        <div class="bg-gradient-to-r from-pink-50 to-purple-50 rounded-2xl shadow-sm border border-purple-100 p-6 mt-8">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                    <i class="ri-chat-smile-3-line text-pink-600"></i>
                    Recent Nova Conversations
                </h3>
                <a href="<?php echo e(route('student.nova.index')); ?>" class="text-sm text-pink-600 hover:text-pink-700 font-medium">
                    View all →
                </a>
            </div>

            <div class="space-y-3">
                <?php $__currentLoopData = $recentConversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('student.nova.index', $conversation->id)); ?>"
                   class="flex items-center gap-4 p-4 bg-white rounded-xl hover:shadow-md transition">
                    <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-pink-500 to-purple-500 rounded-full flex items-center justify-center text-white">
                        <i class="ri-sparkling-line"></i>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-gray-900 truncate"><?php echo e($conversation->title ?? 'Untitled Conversation'); ?></p>
                        <p class="text-xs text-gray-500"><?php echo e(\Carbon\Carbon::parse($conversation->last_message_at)->diffForHumans()); ?></p>
                    </div>
                    <i class="ri-arrow-right-line text-gray-400"></i>
                </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>

    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/student/dashboard.blade.php ENDPATH**/ ?>