<!-- ============================================ -->
<!-- SIDEBAR COMPONENT (sidebar.blade.php) -->
<!-- ============================================ -->
<?php if(Auth::check() && Auth::user()->role === 'affiliate'): ?>
<aside id="sidebar"
    class="sidebar w-64 bg-white border-r flex flex-col justify-between transition-all duration-300 overflow-hidden font-inter h-screen">

    <div class="flex-1 flex flex-col overflow-hidden h-full">

        <!-- Header -->
        <div class="flex items-center justify-between px-4 py-3 flex-shrink-0 border-b border-gray-100">
            <div class="flex items-center gap-2">
                <span class="font-semibold text-gray-800 text-lg sidebar-text transition-all duration-300">
                    AL Plateforme
                </span>
            </div>

            <button id="toggleSidebar"
    class="text-[#0d0d0d0d] hover:text-black hover:bg-[#F6F7F5] p-2 rounded-lg transition">
                <i class="ri-arrow-left-double-line text-xl"></i>
            </button>
        </div>

        <!-- MENU AFFILIATE -->
        <nav class="  flex-shrink-0">

            <a href="<?php echo e(route('affiliate.dashboard')); ?>"
               class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
                      <?php echo e(request()->routeIs('affiliate.dashboard')
                          ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                          : 'text-gray-700 hover:bg-gray-100'); ?>">
               <img src="<?php echo e(asset('assets/icons/dashboard right section/dashboard.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
                <span class="sidebar-text text-[14px]">Dashboard</span>
            </a>

             <a href="<?php echo e(route('affiliate.Transaction')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('affiliate.Transaction')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
      <img src="<?php echo e(asset('assets/icons/dashboard right section/wallet.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">

        <span class="sidebar-text text-[14px]">Transaction History</span>
    </a>

         <a href="<?php echo e(route('affiliate.codeandtracking')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('affiliate.codeandtracking')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
      <img src="<?php echo e(asset('assets/icons/dashboard right section/wallet.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">

        <span class="sidebar-text text-[14px]">Code and tracking </span>
    </a>

        <a href="<?php echo e(route('student.nova.index')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('student.nova.index')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/wallet.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px]">Nova</span>
    </a>

      <a href="<?php echo e(route('feedback.index')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('feedback.index')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
       <img src="<?php echo e(asset('assets/icons/dashboard right section/alert-triangle.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px]">Feedback & Reports</span>
    </a>

        </nav>

    </div>
</aside>
<?php endif; ?>
<?php if(Auth::check() && Auth::user()->role === 'teacher'): ?>
<!-- ============================================ -->
<!-- SIDEBAR TEACHER -->
<!-- ============================================ -->
<aside id="sidebar"
    class="sidebar w-64 bg-white border-r flex flex-col justify-between transition-all duration-300 overflow-hidden font-inter h-screen fixed top-0 left-0 z-[100]">

    <div class="flex-1 flex flex-col overflow-hidden h-full">

        <!-- Header -->
        <div class="flex items-center justify-between px-4 py-3 flex-shrink-0 border-b border-gray-100">
             <div class="flex items-center gap-2">
                <span class="font-semibold text-gray-800 text-lg sidebar-text transition-all duration-300">
                    AL Plateforme
                </span>
            </div>
            <button id="toggleSidebar" class="text-gray-600 hover:text-black">
                <i class="ri-arrow-left-double-line text-xl"></i>
            </button>
        </div>




        <!-- Menu principal -->
        <nav class="  flex-shrink-0">
            <a href="<?php echo e(route('teacher.dashboard')); ?>"
               class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
                      <?php echo e(request()->routeIs('teacher.dashboard')
                          ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                          : 'text-gray-700 hover:bg-gray-100'); ?>">
                <img src="<?php echo e(asset('assets/icons/dashboard right section/dashboard.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
                <span class="sidebar-text text-[14px]">Dashboard</span>
            </a>
  <a href="<?php echo e(route('teacher.Groupandclasses')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('teacher.Groupandclasses')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/task managment.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px]">Group and classes</span>
    </a>


  <a href="<?php echo e(route('teacher.live-sessions.index')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('teacher.live-sessions.index')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
<img src="<?php echo e(asset('assets/icons/dashboard right section/Schedule & lives.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">        <span class="sidebar-text text-[14px]">Live sessions</span>
    </a>


      <a href="<?php echo e(route('student.nova.index')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('student.nova.index')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/nova.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px]">Nova</span>
    </a>

                <a href="<?php echo e(route('teacher.Transaction')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('teacher.Transaction')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
      <img src="<?php echo e(asset('assets/icons/dashboard right section/wallet.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">

        <span class="sidebar-text text-[14px]">Transaction History</span>
    </a>

      <a href="<?php echo e(route('teacher.goals')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('student.goals')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/task managment.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px] text-[14px]">Task Management</span>
    </a>

      <a href="<?php echo e(route('feedback.index')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('feedback.index')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
       <img src="<?php echo e(asset('assets/icons/dashboard right section/alert-triangle.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px]">Feedback & Reports</span>
    </a>


        </nav>
 <?php if(request()->routeIs('student.nova.index')): ?>
<div class=" flex-1 flex flex-col overflow-hidden pt-4 min-h-0">
            <div class="px-6 mb-3 flex items-center justify-between flex-shrink-0">
                <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider sidebar-text">
                    Conversations
                    <span class="ml-2 text-indigo-600">(<?php echo e(count($conversations ?? [])); ?>)</span>
                </h3>
                <button id="new-chat-btn" class="text-indigo-600 hover:text-[#1D1D1E] sidebar-text" title="New Chat">
                    <i class="ri-add-line text-lg"></i>
                </button>
            </div>

            <!-- Liste des conversations avec scroll -->
            <div id="conversations-list" class="flex-1 overflow-y-auto px-3 space-y-1 min-h-0">
                <?php $__empty_1 = true; $__currentLoopData = $conversations ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="conversation-item cursor-pointer p-2 rounded-lg hover:bg-gray-50 transition group"
                     data-id="<?php echo e($conv->id); ?>">
                    <div class="flex items-start justify-between gap-2">
                        <div class="flex-1 min-w-0">
                            <p class="text-sm text-gray-800 truncate sidebar-text font-medium">
                                 <?php if($conv->lastUserMessage): ?>
        <?php echo e(Str::limit($conv->lastUserMessage->content, 45)); ?>

    <?php else: ?>
        New Conversation
    <?php endif; ?>
                            </p>

                        </div>
                        <button class="delete-conv opacity-0 group-hover:opacity-100 text-gray-400 hover:text-red-500 transition sidebar-text flex-shrink-0"
                                data-id="<?php echo e($conv->id); ?>"
                                onclick="event.stopPropagation()">
                            <i class="ri-delete-bin-line text-sm"></i>
                        </button>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-8 sidebar-text">
                    <i class="ri-message-3-line text-3xl text-gray-300 mb-2 block"></i>
                    <p class="text-xs text-gray-400">No conversations yet</p>
                    <p class="text-xs text-gray-400 mt-1">Start chatting with Nova!</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>

</aside>
<?php endif; ?>
<?php if(Auth::check() && Auth::user()->role === 'student'): ?>
<aside id="sidebar"
    class="sidebar w-64 bg-white border-r flex flex-col justify-between transition-all duration-300 overflow-hidden font-inter h-screen">
    <div class="flex-1 flex flex-col overflow-hidden h-full">
        <!-- Header -->
<div class="flex items-center justify-between px-4 py-3 flex-shrink-0">
            <div class="flex items-center gap-2">
                <span class="font-semibold text-gray-800 text-lg sidebar-text transition-all duration-300">
                    AL Plateforme
                </span>
            </div>

            <button id="toggleSidebar" class="text-gray-400 hover:text-black hover:bg-[#F6F7F5] p-2 rounded-lg transition">
                <i class="ri-arrow-left-double-line text-xl"></i>
            </button>


        </div>

        <!-- Menu principal -->
        <nav class="  flex-shrink-0">

    <a href="<?php echo e(route('student.dashboard')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('student.dashboard')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/dashboard.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px] " alt="icon">
        <span class="sidebar-text text-[14px]">Dashboard</span>
    </a>

    <a href="<?php echo e(route('student.projects.index')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('student.projects.*')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/FLOW.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px]">Flow</span>
    </a>

    <a href="<?php echo e(route('student.live-sessions.index')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('student.live-sessions.index')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/Schedule & lives.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px]">My Courses</span>
    </a>

    <a href="<?php echo e(route('student.nova.index')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('student.nova.index')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/nova.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px]">Nova</span>
    </a>

    <a href="<?php echo e(route('student.wallet')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('student.wallet')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/wallet.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">

        <span class="sidebar-text text-[14px]">Wallet</span>
    </a>

    <a href="<?php echo e(route('feedback.index')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('feedback.index')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/alert-triangle.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px]">Feedback & Reports</span>
    </a>

    <a href="<?php echo e(route('student.goals')); ?>"
       class="flex items-center gap-3 px-3.5 py-[7px] rounded-xl mx-2 transition
              <?php echo e(request()->routeIs('student.goals')
                  ? 'bg-[#F6F7F5] text-[#1D1D1E] font-medium'
                  : 'text-gray-700 hover:bg-gray-100'); ?>">
        <img src="<?php echo e(asset('assets/icons/dashboard right section/task managment.svg')); ?>" class="w-2 h-2 min-w-[20px] min-h-[20px]" alt="icon">
        <span class="sidebar-text text-[14px] text-[14px]">Task Management</span>
    </a>

</nav>

  <!-- Section Nova Conversations (seulement visible sur la page Nova) -->
        <?php if(request()->routeIs('student.nova.index')): ?>
<div class=" flex-1 flex flex-col overflow-hidden pt-4 min-h-0">
            <div class="px-6 mb-3 flex items-center justify-between flex-shrink-0">
                <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider sidebar-text">
                    Conversations
                    <span class="ml-2 text-indigo-600">(<?php echo e(count($conversations ?? [])); ?>)</span>
                </h3>
                <button id="new-chat-btn" class="text-indigo-600 hover:text-[#1D1D1E] sidebar-text" title="New Chat">
                    <i class="ri-add-line text-lg"></i>
                </button>
            </div>

            <!-- Liste des conversations avec scroll -->
            <div id="conversations-list" class="flex-1 overflow-y-auto px-3 space-y-1 min-h-0">
                <?php $__empty_1 = true; $__currentLoopData = $conversations ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="conversation-item cursor-pointer p-2 rounded-lg hover:bg-gray-50 transition group"
                     data-id="<?php echo e($conv->id); ?>">
                    <div class="flex items-start justify-between gap-2">
                        <div class="flex-1 min-w-0">
                            <p class="text-sm text-gray-800 truncate sidebar-text font-medium">
                                 <?php if($conv->lastUserMessage): ?>
        <?php echo e(Str::limit($conv->lastUserMessage->content, 45)); ?>

    <?php else: ?>
        New Conversation
    <?php endif; ?>
                            </p>

                        </div>
                        <button class="delete-conv opacity-0 group-hover:opacity-100 text-gray-400 hover:text-red-500 transition sidebar-text flex-shrink-0"
                                data-id="<?php echo e($conv->id); ?>"
                                onclick="event.stopPropagation()">
                            <i class="ri-delete-bin-line text-sm"></i>
                        </button>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-8 sidebar-text">
                    <i class="ri-message-3-line text-3xl text-gray-300 mb-2 block"></i>
                    <p class="text-xs text-gray-400">No conversations yet</p>
                    <p class="text-xs text-gray-400 mt-1">Start chatting with Nova!</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>

</aside>

</aside>
<?php endif; ?>
<!-- Menu profil en dehors de la sidebar -->
<div id="profile-menu" class="fixed bottom-2 left-2 transition-all duration-300 ease-in-out z-[9999]" style="width: calc(16rem - 1rem);">

    <!-- Bouton profil -->
    <button
    id="profile-toggle"
    type="button"
    class="profile-toggle-btn flex items-center gap-3 py-[7px] px-2 transition rounded-2xl hover:bg-[#F6F7F5] cursor-pointer bg-white ">

        <!-- Avatar -->
        <div class="flex items-center justify-center rounded-full bg-blue-500 text-white font-semibold w-8 h-8 flex-shrink-0">
            <?php echo e(strtoupper(substr(Auth::user()->name ?? 'A', 0, 1))); ?>

        </div>

        <!-- Infos utilisateur -->
        <div class="flex-1 min-w-0 text-left profile-info">
            <p class="font-medium text-gray-800 text-sm truncate">
                <?php echo e(Auth::user()->name ?? 'Utilisateur'); ?>

            </p>
        </div>

        <i class="ri-arrow-up-s-line text-gray-400 text-xl transition profile-info profile-arrow"></i>
    </button>

    <!-- Menu déroulant -->
    <div
        id="profile-dropdown"
        class="absolute left-0 bottom-full mb-2 bg-white shadow-2xl border-2 rounded-xl overflow-hidden w-64 hidden"
        style="z-index: 10000;">

        <!-- Info utilisateur -->
        <div class="px-4 py-3 border-b bg-gray-50">
            <div class="font-medium text-sm text-gray-900">
                <?php echo e(Auth::user()->name ?? 'User'); ?>

            </div>
            <div class="text-xs text-gray-600 mt-0.5">
                <?php echo e(Auth::user()->email ?? 'user@example.com'); ?>

            </div>
        </div>

        <!-- Menu items -->
        <a href="<?php echo e(route('student.account')); ?>"
           class="flex items-center gap-3 px-4 py-3 text-gray-700 hover:bg-gray-50 text-sm transition">
            <i class="ri-user-settings-line text-lg"></i>
            <span>My account</span>
        </a>



        <div class="border-t"></div>

        <form method="GET" action="<?php echo e(route('logout')); ?>">
            <?php echo csrf_field(); ?>
            <button type="submit"
                    class="flex items-center gap-3 w-full px-4 py-3 text-red-600 hover:bg-red-50 text-sm text-left transition">
                <i class="ri-logout-box-line text-lg"></i>
                <span>Logout</span>
            </button>
        </form>
    </div>
</div>

<!-- ⚠️ RETIREZ TOUT LE SCRIPT DE LA SIDEBAR -->
<!-- Le script sera géré uniquement dans le layout principal -->

<style>
.rotate-180 {
    transform: rotate(180deg);
    transition: transform 0.2s ease;
}

.sidebar {
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}

/* Rendre le haut scrollable sans affecter le bas */
.sidebar > .flex-1 {
    overflow-y: auto;
}

/* 🔥 FIX: Sidebar avec z-index inférieur aux modals */
#sidebar {
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    overflow: hidden;
    z-index: 40 !important; /* ⬅️ Changé de 50 à 40 */
}

/* Style des conversations */
.conversation-item {
    transition: all 0.2s ease;
}

/* 🔥 FIX: Profile menu avec z-index inférieur aux modals */
#profile-menu {
    z-index: 41 !important; /* ⬅️ Changé de 51 à 41 */
}

#profile-dropdown {
    z-index: 42 !important; /* ⬅️ Changé de 52 à 42 */
}

/* Scrollbar personnalisée pour la liste des conversations */
#conversations-list {
    scrollbar-width: thin;
    scrollbar-color: #d1d5db transparent;
    scroll-behavior: smooth;
}

#conversations-list::-webkit-scrollbar {
    width: 6px;
}

#conversations-list::-webkit-scrollbar-track {
    background: transparent;
}

#conversations-list::-webkit-scrollbar-thumb {
    background: #d1d5db;
    border-radius: 3px;
}

#conversations-list::-webkit-scrollbar-thumb:hover {
    background: #9ca3af;
}
</style>

<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/components/sidebar.blade.php ENDPATH**/ ?>