<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Mon portefeuille','section' => 'Wallet','page' => 'Online Payment']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Mon portefeuille','section' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Wallet'),'page' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Online Payment')]); ?>

    <div class="max-w-6xl mx-auto font-inter"
         x-data="{
            tab: 'history',
            withdraw: {
                method: '',
                amount: ''
            },

            submitWithdraw() {
                if (!this.withdraw.method || !this.withdraw.amount) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Missing Information',
                        text: 'Please select a method and enter an amount.'
                    });
                    return;
                }

                Swal.fire({
                    icon: 'success',
                    title: 'Withdraw Request Sent!',
                    html: `
                        <div style='text-align:left'>
                            <strong>Method:</strong> ${this.withdraw.method}<br>
                            <strong>Amount:</strong> ${this.withdraw.amount} TND
                        </div>
                    `,
                    timer: 2500,
                    showConfirmButton: false
                });

                this.withdraw.method = '';
                this.withdraw.amount = '';
            }
        }">

        <!-- 🔹 Onglets -->
        <div class="flex justify-center mb-10">

            <!-- History -->
            <button
                @click="tab = 'history'"
                :class="tab === 'history'
                    ? 'px-6 py-2 text-[#32312D] font-medium text-[32px]'
                    : 'px-6 py-2 text-[#C7C4C1] hover:text-gray-700 font-medium text-[32px]'">
                Transaction History
            </button>

            <!-- Withdraw -->
            <button
                @click="tab = 'withdraw'"
                class="ml-6"
                :class="tab === 'withdraw'
                    ? 'px-6 py-2 text-[#32312D] font-medium text-[32px]'
                    : 'px-6 py-2 text-[#C7C4C1] hover:text-gray-700 font-medium text-[32px]'">
                Withdraw
            </button>

        </div>

        <!-- ============================= -->
        <!-- 📋 HISTORY SECTION -->
        <!-- ============================= -->

        <div x-show="tab === 'history'" x-transition>
            <div class="max-w-5xl mx-auto">

                <h2 class="text-gray-700 font-medium mb-6">Transactions</h2>

                <div class="bg-white rounded-xl overflow-hidden">
                    <table class="min-w-full divide-y divide-gray-100 text-sm">

                        <thead class="bg-gray-50 text-gray-700 font-medium">
                        <tr>
                            <th class="px-6 py-3 text-left">ID</th>
                            <th class="px-6 py-3 text-left">Amount</th>
                            <th class="px-6 py-3 text-left">Payment method</th>
                            <th class="px-6 py-3 text-left">Date</th>
                            <th class="px-6 py-3 text-left">Status</th>
                        </tr>
                        </thead>

                        <tbody class="divide-y divide-gray-100 text-gray-600">

                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $bg = [
                                    'pending' => 'bg-[#F7DCC9] text-[#6F492D]',
                                    'success' => 'bg-[#DBECDD] text-[#436653]',
                                    'failed'  => 'bg-[#FBDCD9] text-[#7C4944]'
                                ];
                                $dot = [
                                    'pending' => 'bg-[#DF7630]',
                                    'success' => 'bg-[#5F9873]',
                                    'failed'  => 'bg-[#E26154]'
                                ];
                            ?>

                            <tr>
                                <td class="px-6 py-3"><?php echo e($t->id); ?></td>
                                <td class="px-6 py-3"><?php echo e(number_format($t->amount, 2)); ?> TND</td>
                                <td class="px-6 py-3"><?php echo e($t->paymentMethod->name ?? '—'); ?></td>
                                <td class="px-6 py-3"><?php echo e($t->created_at->format('Y-m-d')); ?></td>

                                <td class="px-6 py-3">
                                    <span class="inline-flex items-center justify-center min-w-[90px] gap-1 px-2 py-0.5 rounded-full text-[13px] <?php echo e($bg[$t->status]); ?>">
                                        <span class="w-1.5 h-1.5 rounded-full <?php echo e($dot[$t->status]); ?>"></span>
                                        <?php echo e(ucfirst($t->status)); ?>

                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>

                    </table>
                </div>
            </div>
        </div>

        <!-- ============================= -->
        <!-- 💸 WITHDRAW SECTION -->
        <!-- ============================= -->

        <div x-show="tab === 'withdraw'" x-transition>
            <div class="max-w-xl mx-auto bg-white rounded-2xl border p-8 shadow-sm">

                <h2 class="text-[26px] font-medium text-gray-900 mb-4">Withdraw Funds</h2>
                <p class="text-gray-500 mb-8">Choose a withdrawal method and request your payout.</p>

                <!-- Methods -->
                <div class="space-y-4 mb-6">

                    <label class="flex items-center gap-3 p-4 border rounded-lg cursor-pointer hover:bg-gray-50">
                        <input type="radio" name="withdraw_method" value="BIAT Bank" x-model="withdraw.method">
                        <span class="font-medium text-gray-800">BIAT Bank</span>
                    </label>

                    <label class="flex items-center gap-3 p-4 border rounded-lg cursor-pointer hover:bg-gray-50">
                        <input type="radio" name="withdraw_method" value="Poste Tunisienne" x-model="withdraw.method">
                        <span class="font-medium text-gray-800">Poste Tunisienne</span>
                    </label>

                    <label class="flex items-center gap-3 p-4 border rounded-lg cursor-pointer hover:bg-gray-50">
                        <input type="radio" name="withdraw_method" value="Amen Bank" x-model="withdraw.method">
                        <span class="font-medium text-gray-800">Amen Bank</span>
                    </label>

                </div>

                <!-- Amount -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Amount (TND)</label>
                    <input type="number"
                           x-model="withdraw.amount"
                           min="1"
                           class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-indigo-400">
                </div>

                <!-- Submit -->
                <button
                    @click="submitWithdraw()"
                    class="w-full py-3 bg-indigo-600 text-white rounded-lg text-lg hover:bg-indigo-700">
                    Submit Withdraw Request
                </button>

            </div>
        </div>

    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/affiliate/transaction.blade.php ENDPATH**/ ?>