<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Hero Section</title>

  <!-- Google Font: Inter -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
      font-family: 'Inter', sans-serif;
      overflow-x: hidden;
    }

    /* Section Hero - Garde la taille originale sur desktop */
    .hero-section {
      position: relative;
      background: url('https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/jan-kopriva-nex3P5iBnPg-unsplash%201.png') no-repeat center center/cover;
      height: 200vh;
      color: white;
      display: flex;
      align-items: flex-start;
      justify-content: center;
      text-align: center;
    }

    .hero-overlay {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.5);
    }

    .hero-content {
      position: relative;
      z-index: 2;
      max-width: 800px;
      padding: 20px;
    }

    .hero-content h2 {
      padding-top: 200px;
      font-weight: 900;
      font-size: 3.5rem;
      line-height: 1.5;
    }

    .hero-content p {
      font-size: 1.5rem;
      margin-top: 300px;
      font-weight: 700;
      padding-top: 150px;
    }
    
    /* Text sections - garde les tailles originales */
    .text-section {
      background: #fff;
      color: #000;
    }
    
    .text-section h2 {
      margin-top: 200px;
      margin-bottom: 200px;
      font-size: 3rem;
    }
    
    .text-scroll {
      position: relative;
      height: 400vh;
      background: #fff;
    }

    .text-scroll-new {
      position: relative;
      height: 300vh;
      background: url('https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/1.PNG') no-repeat center center/cover;
    }

    .text-scroll-new::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.4);
      z-index: 1;
    }

    .text-wrapper {
      position: sticky;
      top: 0;
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      overflow: hidden;
      text-align: center;
      padding: 0 5%;
    }

    .text-wrapper-new {
      position: sticky;
      top: 0;
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      overflow: hidden;
      text-align: center;
      padding: 0 5%;
      z-index: 2;
    }

    .text-item {
      position: absolute;
      font-size: 3rem;
      font-weight: 700;
      opacity: 0;
      transform: translateY(100px) scale(0.95);
      transition: all 0.9s ease;
    }

    .text-item-new {
      position: absolute;
      font-size: 3rem;
      font-weight: 700;
      color: white;
      opacity: 0;
      transform: translateY(100px) scale(0.95);
      transition: all 0.9s ease;
    }

    .text-item.active,
    .text-item-new.active {
      opacity: 1;
      transform: translateY(0) scale(1);
    }

    .text-item.exit-up,
    .text-item-new.exit-up {
      opacity: 0;
      transform: translateY(-100px) scale(0.95);
    }

    .text-item.exit-down,
    .text-item-new.exit-down {
      opacity: 0;
      transform: translateY(100px) scale(0.95);
    }

    /* Long text - garde les tailles originales */
    .long-text {
      font-size: 1.2rem;
      font-weight: 500;
      line-height: 1.7;
      max-width: 900px;
      text-align: center;
      margin: 0 auto;
    }

    .highlight-big {
      display: block;
      font-size: 2.5rem;
      font-weight: 900;
      margin: 30px 0;
    }

    /* Feature Section - garde les tailles originales */
    .feature-section {
      padding-top: 200px;
      background: #fff;
      color: #000;
      padding: 120px 20px;
    }

    .feature-section h2 {
      font-size: 2.8rem;
      font-weight: 700;
    }

    .feature-section p {
      padding-top: 100px;
      font-size: 1.1rem;
      font-weight: 600;
      color: #555;
    }
    
    /* Environment Card - garde les tailles originales sur desktop */
    .env-card {
      background: #fff;
      border-radius: 20px;
      box-shadow: 0 8px 30px rgba(0, 0, 0, 0.1);
      max-width: 1000px;
      margin: 0 80px;
    }

    .env-card img {
      border-radius: 20px 0 0 20px;
      object-fit: cover;
      height: 100%;
    }

    .env-title {
      font-size: 70px;
      font-weight: 800;
      text-align: center;
      margin-bottom: 60px;
    }

    .env-text {
      padding-top: 100px;
      font-size: 30px;
      font-weight: 600;
      color: #444;
      text-align: center;
      line-height: 1.6;
    }
    
    /* Cards Section - garde les tailles originales */
    .cards-section {
      background: #fff;
      padding: 10px 0px;
    }

    .cards-container {
      max-width: 1000px;
      margin: 0 80px;
    }

    .custom-card {
      border-radius: 30px;
      color: #fff;
      padding: 60px 50px;
      border: none;
      height: 600px;
      position: relative;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
    }

    .blue-card {
      background: #5a9fd4;
    }

    .red-card {
      background: #c94545;
    }

    .custom-card h2 {
      margin: 50px;
      font-size: 3.5rem;
      font-weight: 800;
      line-height: 1.1;
      margin-bottom: 40px;
    }

    .custom-card h3 {
      margin: 50px;
      font-size: 3.5rem;
      font-weight: 800;
      line-height: 1.1;
      color: rgba(0, 0, 0, 0.4);
    }

    .custom-card .btn-circle {
      width: 60px;
      height: 60px;
      border-radius: 50%;
      background: #2c2c2c;
      border: none;
      color: white;
      font-size: 2rem;
      display: flex;
      align-items: center;
      justify-content: center;
      transition: all 0.3s ease;
      cursor: pointer;
      align-self: flex-end;
    }

    .custom-card .btn-circle:hover {
      transform: scale(1.1);
      background: #000;
    }

    /* Learn Card - garde les tailles originales */
    .learn-card {
      background: #000;
      border-radius: 20px;
      overflow: hidden;
      max-width: 1000px;
      margin: 0 80px;
      height: 680px;
      min-height: 400px;
      position: relative;
    }

    .learn-background {
      position: absolute;
      top: 0;
      right: 0;
      width: 50%;
      height: 100%;
      overflow: hidden;
    }

    .learn-background img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      opacity: 1;
    }

    .learn-content {
      position: relative;
      z-index: 2;
      padding: 60px;
      height: 100%;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      width: 70%;
    }

    .learn-title {
      font-size: 65px;
      font-weight: 800;
      color: white;
      text-align: left;
      margin: 0;
      line-height: 1.1;
    }

    .learn-text {
      font-size: 30px;
      font-weight: 600;
      line-height: 1.4;
      color: white;
      text-align: center;
      padding-bottom: 140px;
      align-self: center;
      max-width: 100%;
    }

    /* Standard Section - garde les tailles originales */
    .standard-section {
      margin-top: 100px;
      background: #fff;
      color: #000;
    }

    .standard-section h2 {
      font-size: 2rem;
      font-weight: 800;
    }

    .standard-text {
      margin-top: 100px;
      max-width: 800px;
      font-size: 1.2rem;
      font-weight: 400;
      line-height: 1.8;
    }

    /* Future Section - garde les tailles originales */
    .future-section {
      background: #fff;
      color: #000;
    }

    .future-title {
      font-size: 60px;
      font-weight: 900;
      line-height: 1.1;
    }

    .future-section .lead {
      font-size: 1.2rem;
      line-height: 1.6;
    }

    .future-text {
      color: #444;
      max-width: 850px;
      font-size: 1.5rem;
      font-weight: 600;
      line-height: 1.8;
      margin: 0 auto;
    }

    /* Contact Section - garde les tailles originales */
    .contact-card {
      max-width: 100%;
      border-radius: 20px;
      overflow: hidden;
    }

    .contact-card img {
      object-fit: cover;
      height: 100%;
    }

    .contact-section h2 {
      font-size: 2.5rem;
      font-weight: 800;
    }

    .contact-section p {
      font-size: 1.3rem;
      font-weight: 600;
      color: #000000;
      max-width: 750px;
      line-height: 1.6;
    }

    .form-control {
      font-size: 1rem;
      padding: 8px 0;
    }

    /* Vision Section - garde les tailles originales */
    .vision-section {
      background: #f8f7fa;
    }

    .vision-subtitle {
      margin-top: 80px;
      font-size: 25px;
      font-weight: 600;
      line-height: 1.4;
      color: #444;
    }

    .vision-title {
      font-size: 60px;
      font-weight: 900;
      line-height: 1.2;
    }

    .btn-primary-gradient {
      background: linear-gradient(90deg, #6a11cb, #2575fc);
      color: #fff;
      border: none;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      transition: transform 0.2s ease;
    }

    .btn-primary-gradient:hover {
      transform: translateY(-2px);
      color: #fff;
    }

    .btn-outline-custom {
      background: #fff;
      color: #000;
      border: none;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      transition: transform 0.2s ease;
    }

    .btn-outline-custom:hover {
      transform: translateY(-2px);
      background: #f1f1f1;
    }

    /* RESPONSIVE - Seulement pour mobile/tablette */
    @media (max-width: 992px) {
      .hero-section {
        height: 150vh;
      }
      
      .hero-content h2 {
        padding-top: 150px;
        font-size: 3rem;
      }
      
      .hero-content p {
        margin-top: 200px;
        padding-top: 100px;
        font-size: 1.3rem;
      }
      
      .text-item,
      .text-item-new {
        font-size: 2.5rem;
      }
      
      .env-title {
        font-size: 50px;
        margin-bottom: 40px;
      }
      
      .env-text {
        padding-top: 60px;
        font-size: 22px;
      }
      
      .learn-title {
        font-size: 45px;
      }
      
      .learn-text {
        font-size: 22px;
        padding-bottom: 100px;
      }
      
      .future-title {
        font-size: 45px;
      }
      
      .vision-title {
        font-size: 45px;
      }
    }

    @media (max-width: 768px) {
      .hero-section {
        height: 120vh;
      }
      
      .hero-content h2 {
        padding-top: 100px;
        font-size: 2.5rem;
      }
      
      .hero-content p {
        margin-top: 150px;
        padding-top: 80px;
        font-size: 1.2rem;
      }
      
      .text-scroll,
      .text-scroll-new {
        height: 300vh;
      }
      
      .text-item,
      .text-item-new {
        font-size: 2rem;
        max-width: 90%;
      }
      
      .long-text {
        font-size: 1rem;
        max-width: 95%;
        padding: 0 20px;
      }
      
      .highlight-big {
        font-size: 2rem;
      }
      
      .feature-section {
        padding-top: 100px;
        padding: 80px 20px;
      }
      
      .feature-section h2 {
        font-size: 2.2rem;
      }
      
      .feature-section p {
        padding-top: 60px;
        font-size: 1rem;
      }
      
      .env-card {
        margin: 0 20px;
      }
      
      .env-card img {
        border-radius: 20px 20px 0 0;
      }
      
      .env-title {
        font-size: 40px;
        margin-bottom: 30px;
      }
      
      .env-text {
        padding-top: 40px;
        font-size: 18px;
      }
      
      .cards-container {
        margin: 0 20px;
      }
      
      .custom-card {
        height: 450px;
        padding: 40px 30px;
      }
      
      .custom-card h2,
      .custom-card h3 {
        margin: 20px;
        font-size: 2.5rem;
      }
      
      .learn-card {
        margin: 0 20px;
        height: 500px;
        min-height: 300px;
      }
      
      .learn-background {
        width: 60%;
      }
      
      .learn-content {
        padding: 40px 30px;
        width: 80%;
      }
      
      .learn-title {
        font-size: 40px;
      }
      
      .learn-text {
        font-size: 20px;
        padding-bottom: 80px;
      }
      
      .standard-section {
        margin-top: 60px;
      }
      
      .standard-text {
        margin-top: 60px;
        font-size: 1.1rem;
        max-width: 95%;
      }
      
      .future-title {
        font-size: 35px;
      }
      
      .future-text {
        font-size: 1.3rem;
        max-width: 95%;
      }
      
      .contact-section h2 {
        font-size: 2rem;
      }
      
      .contact-section p {
        font-size: 1.1rem;
      }
      
      .vision-title {
        font-size: 35px;
      }
      
      .vision-subtitle {
        margin-top: 50px;
        font-size: 20px;
      }
    }

    @media (max-width: 576px) {
      .hero-section {
        height: 100vh;
      }
      
      .hero-content h2 {
        padding-top: 80px;
        font-size: 2rem;
      }
      
      .hero-content p {
        margin-top: 100px;
        padding-top: 60px;
        font-size: 1.1rem;
      }
      
      .text-item,
      .text-item-new {
        font-size: 1.8rem;
      }
      
      .long-text {
        font-size: 0.95rem;
      }
      
      .highlight-big {
        font-size: 1.8rem;
      }
      
      .env-title {
        font-size: 32px;
      }
      
      .env-text {
        font-size: 16px;
      }
      
      .custom-card {
        height: 400px;
        padding: 30px 20px;
      }
      
      .custom-card h2,
      .custom-card h3 {
        margin: 15px;
        font-size: 2rem;
      }
      
      .learn-content {
        width: 90%;
        padding: 30px 20px;
      }
      
      .learn-title {
        font-size: 32px;
      }
      
      .learn-text {
        font-size: 18px;
        padding-bottom: 60px;
      }
      
      .future-title {
        font-size: 28px;
      }
      
      .future-text {
        font-size: 1.1rem;
      }
      
      .vision-title {
        font-size: 28px;
      }
      
      .vision-subtitle {
        font-size: 18px;
      }
      
      .vision-section .d-flex {
        flex-direction: column;
        align-items: center;
        gap: 15px;
      }
      
      .vision-section .btn {
        width: 100%;
        max-width: 280px;
      }
    }
  </style>
</head>
<body>

  <!-- Section Hero -->
  <section class="hero-section">
    <div class="hero-overlay"></div>
    <div class="hero-content">
      <h2>Built with care. Engineered<br>with purpose.</h2>
      <p>
        Every pixel, every course, every feature — built to make you feel something. 
        To remind you why you started.
      </p>
    </div>
  </section>
  
<section class="text-scroll">
  <div class="text-wrapper">
    <h2 class="text-item active">We Weren't Supposed to Build This.</h2>
    <h2 class="text-item">So</h2>
    <h2 class="text-item">We Did</h2>
   <div class="text-item long-text">
  <p>
    We grew up watching others lead.  They had the tools. The networks. The systems. <br><br>

    We had the will. But nothing built for us. No roadmap. No mentor. No clean path to follow. <br>
    But something kept us going —  A voice inside that said "you can build." <br><br>

    <span class="highlight-big">So we Did.</span> <br><br>

    We built this platform for the ones still searching.  The ones with late-night dreams and early-morning doubts. <br>
    This is more than code, AI, or design.  It's proof that ambition from here — from Tunisia — is worth everything. <br><br>

    Built with care. Backed by precision.  And made for the ones who refuse to settle.
  </p>
</div>
  </div>
</section>

<section class="feature-section py-5">
  <div class="container text-center">
    <h2 class="fw-bold display-5">
      Nothing About This Is Average.
    </h2>
    <p class="lead text-muted mt-3">
      This wasn't assembled. It was engineered —<br>
      piece by piece, problem by problem.
    </p>
  </div>
</section>

<section class="env-section">
  <div class="container d-flex justify-content-center">
    <div class="card env-card shadow-lg rounded-4 border-0 overflow-hidden">
      <div class="row g-0">
        
        <!-- Image gauche -->
        <div class="col-md-6">
          <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/lucas-amaral-natureza-encapsulada-4kv2%204.png" 
               class="img-fluid w-100 h-100 object-fit-cover" alt="Environment">
        </div>
        
        <!-- Texte droite -->
        <div class="col-md-6 p-5 text-center d-flex flex-column justify-content-start align-items-center">
          <h2 class="fw-bold env-title mb-5">
            All-in-One Environment
          </h2>
          <p class="env-text">
            A single space. Complete. Contained.
            Built to help you grow.
          </p>
        </div>
        
      </div>
    </div>
  </div>
</section>

<!-- Section Cards -->
<section class="cards-section">
  <div class="container d-flex justify-content-center">
    <div class="cards-container">
      <div class="row g-4">
        
        <!-- Card 1 -->
        <div class="col-md-6">
          <div class="card custom-card blue-card shadow-lg">
            <div>
              <h2 class="fw-bold mb-4">Learn<br>with Experts.</h2>
              <h3 class="fw-bold text-dark">Build<br>with AI.</h3>
            </div>
           
          </div>
        </div>

        <!-- Card 2 -->
        <div class="col-md-6">
          <div class="card custom-card red-card shadow-lg">
            <div>
              <h2 class="fw-bold mb-4">Tunisians<br>Don't Need<br>More Average.</h2>
            </div>
          
          </div>
        </div>

      </div>
    </div>
  </div>
</section>

<section class="learn-section">
  <div class="container d-flex justify-content-center">
    <div class="card learn-card shadow-lg rounded-4 border-0 overflow-hidden position-relative">
      <!-- Image en background -->
      <div class="learn-background">
        <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/12222.png" 
             alt="Learn by Building">
      </div>
      
      <!-- Contenu texte -->
      <div class="learn-content text-white text-center">
        <h2 class="learn-title fw-bold mb-4">Learn by Building</h2>
        <p class="learn-text fw-semibold">
          You don't just watch. You make. Live sessions guide you. Projects sharpen you. AI helps you push further.
        </p>
      </div>
    </div>
  </div>
</section>

<!-- Section Raising a New Standard -->
<section class="standard-section py-5">
  <div class="container text-center">
    <h2 class="fw-bold mb-4">Raising a New Standard.</h2>
    <p class="standard-text mx-auto">
      We're not here to teach trends. We're building the minds that will shape what's next.<br><br>
      This isn't about shortcuts or hype — it's about deep skill, real understanding, and relentless progress.<br><br>
      From Tunisia to the world, our vision is to raise the standard of tech education, create global builders, 
      and give power back to those who learn.
    </p>
  </div>
</section>

<section class="text-scroll-new">
  <div class="text-wrapper-new">
    <h2 class="text-item-new active">Most won't notice the beginning.</h2>
    <h2 class="text-item-new">Even fewer will follow it through.</h2>
    <h2 class="text-item-new">But you're here — and it's already begun.</h2>
  </div>
</section>

<section class="future-section py-5">
  <div class="container text-center">
    
    <!-- Titre principal -->
    <h2 class="future-title mt-5 mb-4">The Future is Already in Motion.</h2>
    
    <!-- Texte mis en avant -->
    <p class="lead fw-semibold mb-5 mt-5">
      What you see now is the foundation — built with intent, shaped by purpose.<br>
      But it's not the whole story. Not even close.
    </p>
    
    <!-- Paragraphes principaux -->
    <div class="future-text mx-auto mt-5">
      <p>
        Core is just the beginning. Soon: Core Plus, Core Pro, Core Ultra.  
        Not just more — deeper. Not just courses — a full learning system.  
        Stacked. Evolving. Built to grow with you.
      </p>
      
      <p>
        ALPlateforme is just the first chapter — the opening line in a much larger blueprint.  
        A growing ecosystem. New disciplines. New standards.
      </p>
      
      <p>
        We won't reveal it all now. That's not how real change works.  
        But if you've come this far, you already know: you're not here by accident.
      </p>
      
      <p class="fw-semibold">
        The future is unfolding — and you're not just watching it happen.  
        You're part of it.
      </p>
    </div>
    
  </div>
</section>

<section class="contact-section py-5">
  <div class="container">
    <div class="row justify-content-center">
      
      <!-- Colonne qui contient tout (texte + card) -->
      <div class="col-lg-10">
        
        <!-- Titre + Texte -->
        <div class="text-start mb-5">
          <h2 class="fw-bold mb-3">If it speaks to you — don't wait.</h2>
          <p>
            Core is just the beginning.<br>
            We're opening the doors quietly — to those who feel it before it's everywhere.<br>
            Leave your name, and when it's time, you'll be the first to know.
          </p>
        </div>

        <!-- Card -->
        <div class="card contact-card shadow-lg rounded-4 border-0 overflow-hidden">
          <div class="row g-0 align-items-stretch">
            
            <!-- Image gauche -->
            <div class="col-md-6">
              <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/christian-buehner-JQFHdpOKz2k-unsplash%201.png" 
                   class="img-fluid h-100 w-100 object-fit-cover" alt="Contact Image">
            </div>
            
            <!-- Formulaire droite -->
            <div class="col-md-6 p-5 text-start">
              <form>
                <div class="mb-4">
                  <label class="form-label fw-semibold">First name</label>
                  <input type="text" class="form-control border-0 border-bottom rounded-0 shadow-none">
                </div>
                <div class="mb-4">
                  <label class="form-label fw-semibold">Last name</label>
                  <input type="text" class="form-control border-0 border-bottom rounded-0 shadow-none">
                </div>
                <div class="mb-4">
                  <label class="form-label fw-semibold">E-mail</label>
                  <input type="email" class="form-control border-0 border-bottom rounded-0 shadow-none">
                </div>
                <div class="mb-4">
                  <label class="form-label fw-semibold">Phone number</label>
                  <input type="tel" class="form-control border-0 border-bottom rounded-0 shadow-none">
                </div>
                <button type="submit" class="btn btn-dark px-4 py-2 rounded-3">Submit</button>
              </form>
            </div>
            
          </div>
        </div>

      </div>
    </div>
  </div>
</section>

<!-- Section Vision -->
<section class="vision-section py-5 text-center">
  <div class="container">
    
    <!-- Titre -->
<h2 class="vision-title mb-3">Built by Tunisians. Powered by vision.</h2>
    
    <!-- Texte -->
<p class="vision-subtitle mb-5">
  World-class tech education. Built here. Built for impact.
</p>    
    <!-- Boutons -->
    <div class="d-flex justify-content-center gap-3 flex-wrap">
      <a href="#" class="btn btn-primary-gradient px-4 py-2 rounded-pill fw-semibold">
        Start Learning
      </a>
      <a href="#" class="btn btn-outline-custom px-4 py-2 rounded-pill fw-semibold">
        Learn more about Alplatform
      </a>
    </div>

  </div>
</section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
  // Script pour la première section
  const texts = document.querySelectorAll('.text-item');
  let currentIndex = 0;

  // Script pour la nouvelle section
  const textsNew = document.querySelectorAll('.text-item-new');
  let currentIndexNew = 0;

window.addEventListener('scroll', () => {
  // Gestion de la première section
  const section = document.querySelector('.text-scroll');
  const sectionTop = section.offsetTop;
  const scrollY = window.scrollY;

  const index = Math.min(
    Math.max(Math.floor((scrollY - sectionTop) / window.innerHeight), 0),
    texts.length - 1
  );

  if (index !== currentIndex) {
    if (index > currentIndex) {
      texts[currentIndex].classList.remove('active');
      texts[currentIndex].classList.add('exit-up');
    } else {
      texts[currentIndex].classList.remove('active');
      texts[currentIndex].classList.add('exit-down');
    }

    texts[index].classList.remove('exit-up', 'exit-down');
    texts[index].classList.add('active');

    currentIndex = index;
  }

  // Gestion de la nouvelle section
  const sectionNew = document.querySelector('.text-scroll-new');
  const sectionNewTop = sectionNew.offsetTop;

  const indexNew = Math.min(
    Math.max(Math.floor((scrollY - sectionNewTop) / window.innerHeight), 0),
    textsNew.length - 1
  );

  if (indexNew !== currentIndexNew) {
    if (indexNew > currentIndexNew) {
      textsNew[currentIndexNew].classList.remove('active');
      textsNew[currentIndexNew].classList.add('exit-up');
    } else {
      textsNew[currentIndexNew].classList.remove('active');
      textsNew[currentIndexNew].classList.add('exit-down');
    }

    textsNew[indexNew].classList.remove('exit-up', 'exit-down');
    textsNew[indexNew].classList.add('active');

    currentIndexNew = indexNew;
  }
});
</script>
</body>
</html><?php /**PATH /home/adlysfut/public_html/resources/views/Contact.blade.php ENDPATH**/ ?>