<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Alplatforme</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">

    <style>
        /* Global Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #ffffff;
        }

        /* Header Styles */
      /* Header Styles */
.am-header_five {
    padding: 20px 0;
    background: #ffffff;
    position: relative;
    z-index: 100;
}

.am-header_two_wrap {
    display: flex;
    align-items: center;
    justify-content: space-between;
    width: 100%;
}

.am-logo {
    flex-shrink: 0;
}

.am-logo img {
    height: 50px;
    width: auto;
}

/* Navigation Desktop */
.am-navigation {
    display: flex;
    align-items: center;
}

.am-nav-menu {
    display: flex;
    list-style: none;
    margin: 0;
    padding: 0;
    gap: 35px;
}

.nav-link {
    font-family: 'Inter', sans-serif;
    font-size: 16px;
    font-weight: 500;
    color: #1D1D1E;
    text-decoration: none;
    padding: 10px 0;
    transition: all 0.3s ease;
}

.nav-link:hover {
    color: #000000;
    font-weight: 600;
}

/* Burger Menu */
.burger-btn {
    background: none;
    border: none;
    width: 30px;
    height: 25px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    cursor: pointer;
    padding: 0;
}

.burger-btn span {
    width: 100%;
    height: 3px;
    background-color: #1D1D1E;
    transition: all 0.3s ease;
    border-radius: 2px;
}

.burger-btn:hover span {
    background-color: #000000;
}

/* Mobile Menu */
.offcanvas {
    background-color: #ffffff;
}

.offcanvas-title {
    font-family: 'Inter', sans-serif;
    font-weight: 700;
    color: #1D1D1E;
}

.mobile-nav-menu {
    list-style: none;
    padding: 0;
    margin: 0;
}

.mobile-nav-menu li {
    margin-bottom: 20px;
}

.mobile-nav-link {
    font-family: 'Inter', sans-serif;
    font-size: 18px;
    font-weight: 500;
    color: #1D1D1E;
    text-decoration: none;
    padding: 15px 0;
    display: block;
    transition: all 0.3s ease;
}

.mobile-nav-link:hover {
    color: #000000;
    font-weight: 600;
}

/* Responsive */
@media (max-width: 1199px) {
    .am-nav-menu {
        gap: 25px;
    }

    .nav-link {
        font-size: 15px;
    }
}

@media (max-width: 991px) {
    .am-header_five {
        padding: 15px 0;
    }

    .am-logo img {
        height: 40px;
    }
}

@media (max-width: 768px) {
    .am-header_five {
        padding: 15px 0;
    }

    .am-logo img {
        height: 40px;
    }
}

@media (max-width: 576px) {
    .am-logo img {
        height: 35px;
    }

    .burger-btn {
        width: 25px;
        height: 20px;
    }
}

@media (max-width: 400px) {
    .am-logo img {
        height: 35px;
    }
}



.nav-link.active {
    color: #000000;
    font-weight: 700;
}



.mobile-nav-link.active {
    color: #000000;
    font-weight: 700;
    background-color: #F5F4F7;
    border-radius: 8px;
    padding: 15px 10px;
}

        /* Main Section */
        .am-main {
            padding-top: 88px;
            margin-top: -88px;
            overflow: hidden;
            background: #ffffff;
        }

        /* Banner Section */
        .pb-themesection {
            padding: 1px 0;
            background: #ffffff;
        }

        .am-banner-potential {
            padding: 1px 0;
            background: #ffffff;
        }

        .am-banner-tutor {
            background-color: #FFFFFF;
            border-radius: 16px;
            padding: 40px 20px;
            max-width: 1350px;
            height: 600px;
            margin: 0 auto;
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        .banner-title {
            font-family: 'Inter', sans-serif;
            font-size: 70px;
            color: #000000;
            font-weight: 800;
            line-height: 1.2;
            margin-bottom: 30px;
        }

        .banner-subtitle {
            font-family: 'Inter', sans-serif;
            font-size: 24px;
            color: #1D1D1E;
            font-weight: 400;
            line-height: 1.5;
            margin-bottom: 30px;
        }

        .explore-btn {
            font-family: 'Inter', sans-serif;
            font-size: 18px;
            font-weight: 600;
            color: #FFFFFF;
            background-color: #000000;
            padding: 12px 24px;
            text-decoration: none;
            display: inline-block;
            border-radius: 10px;
            transition: all 0.3s ease;
        }

        .explore-btn:hover {
            background-color: #333333;
            transform: translateY(-2px);
            color: #FFFFFF;
        }

        /* Mobile Responsive Styles */
        @media (max-width: 1200px) {
            .banner-title {
                font-size: 60px;
            }

            .banner-subtitle {
                font-size: 22px;
            }
        }

        @media (max-width: 992px) {
            .am-banner-tutor {
                height: 500px;
                padding: 30px 20px;
            }

            .banner-title {
                font-size: 50px;
                margin-bottom: 25px;
            }

            .banner-subtitle {
                font-size: 20px;
                margin-bottom: 25px;
            }
        }

        @media (max-width: 768px) {
            .am-main {
                padding-top: 70px;
                margin-top: -70px;
            }

            .am-header_five {
                padding: 15px 0;
            }

            .am-logo img {
                height: 40px;
            }

            .am-banner-tutor {
                height: auto;
                min-height: 450px;
                padding: 40px 15px;
                border-radius: 12px;
            }

            .banner-title {
                font-size: 40px;
                margin-bottom: 20px;
            }

            .banner-subtitle {
                font-size: 18px;
                margin-bottom: 20px;
                padding: 0 10px;
            }

            .banner-subtitle br {
                display: none;
            }

            .explore-btn {
                font-size: 16px;
                padding: 10px 20px;
            }
        }

        @media (max-width: 576px) {
            .am-banner-tutor {
                min-height: 400px;
                padding: 30px 10px;
            }

            .banner-title {
                font-size: 32px;
                font-weight: 700;
            }

            .banner-subtitle {
                font-size: 16px;
                line-height: 1.6;
            }
        }

        @media (max-width: 400px) {
            .am-logo img {
                height: 35px;
            }

            .banner-title {
                font-size: 28px;
            }

            .banner-subtitle {
                font-size: 14px;
            }

            .explore-btn {
                font-size: 14px;
                padding: 8px 16px;
            }
        }

        /* Animation Classes */
        @keyframes fadeUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fade-up {
            animation: fadeUp 0.8s ease forwards;
        }

        .delay-300 {
            animation-delay: 0.3s;
            opacity: 0;
        }

        .delay-400 {
            animation-delay: 0.4s;
            opacity: 0;
        }

        .delay-500 {
            animation-delay: 0.5s;
            opacity: 0;
        }

        .info-card {
    background-color: #F5F4F7;
    border-radius: 20px;
    display: flex;
    flex-direction: row;
    align-items: stretch;
    justify-content: space-between;
    min-height: 400px;
    overflow: hidden;
}

.info-content {
    width: 50%;
    padding: 40px 20px;
    position: relative;
    display: flex;
    flex-direction: column;
}

.info-title {
    font-family: 'Inter', sans-serif;
    font-size: 48px;
    color: #1D1D1E;
    font-weight: 700;
    line-height: 1.2;
    margin-bottom: 20px;
}

.info-description {
    font-family: 'Inter', sans-serif;
    font-size: 22px;
    color: #1D1D1E;
    font-weight: 400;
    text-align: center;
    line-height: 1.5;
}

.info-image {
    width: 50%;
    padding: 0;
    margin: 0;
    height: 100%;
    display: flex;
}

.info-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    margin: 0;
    padding: 0;
}

/* Responsive Styles */
@media (max-width: 1200px) {
    .info-title {
        font-size: 42px;
    }

    .info-description {
        font-size: 20px;
    }
}

@media (max-width: 992px) {
    .info-title {
        font-size: 36px;
    }

    .info-description {
        font-size: 18px;
    }

    .info-content {
        padding: 30px 15px;
    }
}

@media (max-width: 768px) {
    .info-card {
        flex-direction: column;
        min-height: auto;
    }

    .info-content,
    .info-image {
        width: 100%;
    }

    .info-content {
        padding: 40px 20px 30px;
        order: 2;
    }

    .info-image {
        height: 250px;
        order: 1;
    }

    .info-title {
        font-size: 32px;
        margin-bottom: 15px;
    }

    .info-description {
        font-size: 16px;
    }

    .desktop-break {
        display: none;
    }
}

@media (max-width: 576px) {
    .info-card {
        border-radius: 16px;
    }

    .info-content {
        padding: 30px 20px;
    }

    .info-image {
        height: 200px;
    }

    .info-title {
        font-size: 28px;
    }

    .info-description {
        font-size: 15px;
        padding: 0 10px;
    }
}

@media (max-width: 400px) {
    .info-title {
        font-size: 24px;
    }

    .info-description {
        font-size: 14px;
    }

    .info-image {
        height: 180px;
    }
}

/* Animation au scroll (optionnel) */
.info-card {
    opacity: 0;
    transform: translateY(30px);
    transition: all 0.8s ease;
}

.info-card.visible {
    opacity: 1;
    transform: translateY(0);
}

.info-card-reverse {
    background-color: #F5F4F7;
    border-radius: 20px;
    display: flex;
    flex-direction: row;
    align-items: stretch;
    justify-content: space-between;
    min-height: 400px;
    overflow: hidden;
}

.info-image-reverse {
    width: 50%;
    padding: 0;
    margin: 0;
    height: 100%;
    display: flex;
}

.info-image-reverse img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.info-content-reverse {
    width: 50%;
    padding: 40px 20px;
    position: relative;
    display: flex;
    flex-direction: column;
}

/* Responsive pour la section inversée */
@media (max-width: 768px) {
    .info-card-reverse {
        flex-direction: column;
        min-height: auto;
    }

    .info-content-reverse,
    .info-image-reverse {
        width: 100%;
    }

    .info-content-reverse {
        padding: 40px 20px 30px;
        order: 2;
    }

    .info-image-reverse {
        height: 250px;
        order: 1;
    }
}

@media (max-width: 576px) {
    .info-card-reverse {
        border-radius: 16px;
    }

    .info-content-reverse {
        padding: 30px 20px;
    }

    .info-image-reverse {
        height: 200px;
    }
}

@media (max-width: 400px) {
    .info-image-reverse {
        height: 180px;
    }
}

/* Animation pour section inversée */
.info-card-reverse {
    opacity: 0;
    transform: translateY(30px);
    transition: all 0.8s ease;
}

.info-card-reverse.visible {
    opacity: 1;
    transform: translateY(0);
}

/* Section Carousel */
.carousel-section {
    background-color: #F5F4F7;
    overflow: hidden;
}

.carousel-title {
    font-family: 'Inter', sans-serif;
    font-size: 42px;
    color: #000000;
    font-weight: 700;
    line-height: 1.3;
}

.gradient-text {
    background: linear-gradient(90deg, #8A86E9, #CA5EF6);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    font-weight: 700;
}

/* Fix pour scroll horizontal uniquement */
.carousel-container {
    margin: 50px 0;
    width: 100vw;
    position: relative;
    left: 50%;
    right: 50%;
    margin-left: -50vw;
    margin-right: -50vw;
    overflow: hidden; /* Empêche le débordement vertical */
}

.carousel-track {
    display: flex;
    overflow-x: auto; /* Scroll horizontal seulement */
    overflow-y: hidden; /* Pas de scroll vertical */
    gap: 16px;
    padding: 30px 100px;
    scroll-snap-type: x mandatory;
    -webkit-overflow-scrolling: touch;
    scrollbar-width: none;
    height: 690px; /* Hauteur fixe */
    align-items: center; /* Centre les cartes verticalement */
}

.carousel-track::-webkit-scrollbar {
    display: none;
}

/* Flip Cards avec hauteur fixe */
.flip-card {
    perspective: 1000px;
    width: calc(23vw - 32px);
    min-width: 350px;
    height: 630px;
    max-height: 630px;
    scroll-snap-align: center;
    flex-shrink: 0;
    flex-grow: 0;
}

.flip-inner {
    width: 100%;
    height: 100%;
    max-height: 630px;
    transition: transform 0.8s;
    transform-style: preserve-3d;
    position: relative;
    border-radius: 20px;
}

.flip-card.flipped .flip-inner {
    transform: rotateY(180deg);
}

.flip-front, .flip-back {
    position: absolute;
    width: 100%;
    height: 100%;
    backface-visibility: hidden;
    padding: 24px;
    border-radius: 20px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    background: #fff;
}

.flip-back {
    transform: rotateY(180deg);
}

/* Typography */
.card-title, .card-title-white {
    font-family: 'Inter', sans-serif;
    font-size: 30px;
    font-weight: 700;
}

.card-title {
    color: #1D1D1E;
}

.card-title-white {
    color: #FFFFFF;
}

.card-subtitle, .card-subtitle-white {
    font-family: 'Inter', sans-serif;
    font-size: 20px;
    font-weight: 700;
}

.card-subtitle {
    color: #1D1D1E;
}

.card-subtitle-white {
    color: #FFFFFF;
}

.card-text {
    font-family: 'Inter', sans-serif;
    font-size: 20px;
    color: #1D1D1E;
    font-weight: 700;
}

/* Buttons */
.flip-button, .flip-buttonferme {
    position: absolute;
    bottom: 24px;
    right: 24px;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    border: none;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    z-index: 10;
    transition: transform 0.3s;
}

.flip-button:hover, .flip-buttonferme:hover {
    transform: scale(1.1);
}

.flip-button {
    background-color: #000;
}

.flip-buttonferme {
    background-color: #fff;
}

/* Glow Effect */
.glow-line-border {
    position: absolute;
    inset: -4px;
    border-radius: 24px;
    background: linear-gradient(135deg, #0D93FF, #C25FEA, #EE4476, #ED6D10);
    filter: blur(10px);
    pointer-events: none;
    z-index: 1;
}

.content {
    z-index: 2;
    position: relative;
}

/* Slider Images */
.before-image, .after-image {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    max-height: 100%;
    z-index: 1;
}

.before-image {
    clip-path: inset(0 50% 0 0);
}

.after-image {
    clip-path: inset(0 0 0 50%);
}

.slider {
    position: absolute;
    left: 50%;
    top: 0;
    width: 4px;
    height: 100%;
    background: #fff;
    cursor: ew-resize;
    z-index: 2;
    transform: translateX(-50%);
}

.slider-handle {
    position: absolute;
    top: 50%;
    width: 20px;
    height: 20px;
    background: #fff;
    border-radius: 50%;
    transform: translate(-50%, -50%);
    box-shadow: 0 2px 10px rgba(0,0,0,0.3);
}

/* Responsive */
@media (max-width: 1200px) {
    .carousel-title {
        font-size: 36px;
    }

    .carousel-track {
        height: 610px;
        padding: 30px 50px;
    }

    .flip-card {
        width: 35vw;
        min-width: 300px;
        height: 550px;
        max-height: 550px;
    }

    .flip-inner {
        max-height: 550px;
    }
}

@media (max-width: 992px) {
    .carousel-title {
        font-size: 32px;
    }

    .carousel-track {
        height: 560px;
    }

    .flip-card {
        width: 45vw;
        min-width: 280px;
        height: 500px;
        max-height: 500px;
    }

    .flip-inner {
        max-height: 500px;
    }

    .card-title, .card-title-white {
        font-size: 26px;
    }

    .card-subtitle, .card-subtitle-white, .card-text {
        font-size: 16px;
    }
}

@media (max-width: 768px) {
    .carousel-title {
        font-size: 28px;
        padding: 0 20px;
    }

    .carousel-track {
        height: 510px;
        padding: 20px 20px;
        gap: 12px;
    }

    .flip-card {
        width: 75vw;
        min-width: 260px;
        height: 450px;
        max-height: 450px;
    }

    .flip-inner {
        max-height: 450px;
    }

    .flip-front, .flip-back {
        padding: 20px;
    }

    .flip-button, .flip-buttonferme {
        width: 35px;
        height: 35px;
        bottom: 20px;
        right: 20px;
    }
}

@media (max-width: 576px) {
    .carousel-title {
        font-size: 24px;
    }

    .carousel-track {
        height: 460px;
    }

    .flip-card {
        width: 85vw;
        min-width: 240px;
        height: 400px;
        max-height: 400px;
    }

    .flip-inner {
        max-height: 400px;
    }

    .card-title, .card-title-white {
        font-size: 22px;
    }

    .card-subtitle, .card-subtitle-white, .card-text {
        font-size: 14px;
    }
}

.permission-section {
    background-color: #F5F4F7;
}

.permission-card {
    background-color: #FFFFFF;
    border-radius: 20px;
    display: flex;
    flex-direction: row;
    align-items: stretch;
    justify-content: space-between;
    min-height: 400px;
    overflow: hidden;
    box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
}

.permission-image {
    width: 50%;
    padding: 0;
    margin: 0;
    display: flex;
    align-items: center;
    justify-content: center;
}

.permission-image img {
    width: 100%;
    height: 630px;
    object-fit: cover;
}

.permission-content {
    width: 60%;
    padding: 40px 20px;
    flex-direction: column;
    justify-content: center;
}

.permission-title-wrapper {
    padding-bottom: 50px;
    text-align: left;
    margin-bottom: 30px;
}

.permission-title {
    font-family: 'Inter', sans-serif;
    font-size: 40px;
    color: #1D1D1E;
    font-weight: 700;
    line-height: 1.3;
}

.permission-text-wrapper {
    display: flex;
    align-items: center;
}

.permission-text {
    font-family: 'Inter', sans-serif;
    font-size: 22px;
    color: #1D1D1E;
    font-weight: 600;
    text-align: left;
    line-height: 1.5;
}

/* Animation */
.permission-card {
    opacity: 0;
    transform: translateY(30px);
    transition: all 0.8s ease;
}

.permission-card.visible {
    opacity: 1;
    transform: translateY(0);
}

/* Responsive */
@media (max-width: 1200px) {
    .permission-image img {
        height: 550px;
    }

    .permission-title {
        font-size: 32px;
    }

    .permission-text {
        font-size: 20px;
    }
}

@media (max-width: 992px) {
    .permission-image img {
        height: 500px;
    }

    .permission-title {
        font-size: 28px;
    }

    .permission-text {
        font-size: 18px;
    }

    .permission-content {
        padding: 30px 20px;
    }
}

@media (max-width: 768px) {
    .permission-card {
        flex-direction: column;
        min-height: auto;
    }

    .permission-image,
    .permission-content {
        width: 100%;
    }

    .permission-image img {
        height: 300px;
        width: 100%;
    }

    .permission-content {
        padding: 30px 20px;
        text-align: center;
    }

    .permission-title-wrapper,
    .permission-text {
        text-align: center;
    }

    .permission-title {
        font-size: 26px;
        margin-bottom: 20px;
    }

    .permission-text {
        font-size: 16px;
    }

    .desktop-break {
        display: none;
    }
}

@media (max-width: 576px) {
    .permission-card {
        border-radius: 16px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
    }

    .permission-image img {
        height: 250px;
    }

    .permission-content {
        padding: 25px 15px;
    }

    .permission-title {
        font-size: 24px;
    }

    .permission-text {
        font-size: 15px;
        font-weight: 500;
    }
}

@media (max-width: 400px) {
    .permission-image img {
        height: 200px;
    }

    .permission-title {
        font-size: 20px;
    }

    .permission-text {
        font-size: 14px;
    }

    .permission-content {
        padding: 20px 15px;
    }
}

/* Section Courses */
.courses-section {
    background-color: #F5F4F7;
}

.courses-title {
    font-family: 'Inter', sans-serif;
    font-size: 36px;
    color: #000000;
    font-weight: 700;
}

.courses-subtitle {
    color: #6E6E72;
    font-weight: 800;
}

.courses-cards-container {
    display: flex;
    justify-content: center;
    gap: 24px;
    flex-wrap: wrap;
}

/* Course Flip Cards */
.course-flip-card {
    perspective: 1000px;
    width: 500px;
    height: 400px;
    max-width: 100%;
}

.course-flip-inner {
    width: 100%;
    height: 100%;
    transition: transform 0.8s;
    transform-style: preserve-3d;
    position: relative;
    background-color: #FFFFFF;
    box-shadow: 0 0 20px rgba(0,0,0,0.15);
    border-radius: 16px;
}

.course-flip-card.flipped .course-flip-inner {
    transform: rotateY(180deg);
}

.course-flip-front, .course-flip-back {
    position: absolute;
    width: 100%;
    height: 100%;
    backface-visibility: hidden;
    padding: 24px;
    border-radius: 16px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}

.course-flip-back {
    transform: rotateY(180deg);
}

/* AI Course specific */
.ai-course .course-actions {
    position: absolute;
    bottom: 24px;
    left: 24px;
    right: 24px;
    z-index: 2; /* Au-dessus de l'image */
    background: rgba(255, 255, 255, 0.9);
    padding: 10px;
    border-radius: 8px;
}

.course-image-container {

    border-radius: 8px;
    padding: 10px;
    position: absolute;
    bottom: 70px; /* Laisse de l'espace pour les boutons */
    left: 24px;
    right: 24px;
    text-align: center;
    z-index: 1; /* Sous les boutons */
}

.course-image {
    display: block;
    width: 100%;
    max-width: 300px;
    margin: 0 auto;
    border-radius: 8px;
    object-fit: cover;
}

/* Typography */
.course-card-title {
    font-family: 'Inter', sans-serif;
    font-size: 25px;
    color: #1D1D1E;
    font-weight: 700;
    margin-bottom: 10px;
}

.course-card-subtitle {
    font-family: 'Inter', sans-serif;
    font-size: 20px;
    color: #1D1D1E;
    font-weight: 700;
    margin-bottom: 10px;
}

.course-card-text {
    padding-top:20px;
    font-family: 'Inter', sans-serif;
    font-size: 20px;
    color: #1B1B1B;
    font-weight: 600;
}

/* Buttons */
.course-flip-btn {
    position: absolute;
    bottom: 24px;
    right: 24px;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background-color: #000;
    border: none;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: transform 0.3s;
}

.course-flip-btn:hover {
    transform: scale(1.1);
}

.course-flip-close {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background-color: #fff;
    border: none;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: transform 0.3s;
}

.course-flip-close:hover {
    transform: scale(1.1);
}

.learn-more-btn {
    font-family: 'Inter', sans-serif;
    font-size: 14px;
    font-weight: 700;
    color: #FFFFFF;
    background-color: #000;
    padding: 8px 16px;
    border-radius: 20px;
    border: none;
    cursor: pointer;
    transition: all 0.3s;
}

.learn-more-btn:hover {
    background-color: #333;
    transform: translateY(-2px);
}

.course-actions {
    display: flex;
    gap: 16px;
    align-items: center;
}

/* Responsive */
@media (max-width: 1200px) {
    .course-flip-card {
        width: 450px;
    }
}

@media (max-width: 992px) {
    .courses-title {
        font-size: 32px;
    }

    .course-flip-card {
        width: 400px;
        height: 380px;
    }

    .course-card-title {
        font-size: 23px;
    }

    .course-card-subtitle {
        font-size: 18px;
    }
}

@media (max-width: 768px) {
    .courses-title {
        font-size: 28px;
        padding: 0 20px;
    }

    .courses-cards-container {
        flex-direction: column;
        align-items: center;
    }

    .course-flip-card {
        width: 90%;
        max-width: 400px;
        height: 350px;
    }

    .course-card-title {
        font-size: 21px;
    }

    .course-card-subtitle {
        font-size: 17px;
    }

    .course-card-text {
        font-size: 14px;
    }
}

@media (max-width: 576px) {
    .courses-title {
        font-size: 24px;
    }

    .courses-subtitle {
        display: block;
        margin-top: 5px;
    }

    .course-flip-card {
        width: 95%;
        height: 320px;
    }

    .course-flip-front, .course-flip-back {
        padding: 20px;
    }

    .course-card-title {
        font-size: 19px;
    }

    .course-card-subtitle {
        font-size: 16px;
    }

    .course-flip-btn, .course-flip-close {
        width: 35px;
        height: 35px;
        bottom: 15px;
        right: 15px;
    }

    .course-image {
        max-width: 200px;
    }
}

@media (max-width: 400px) {
    .courses-title {
        font-size: 20px;
    }

    .course-flip-card {
        height: 300px;
    }

    .course-card-title {
        font-size: 17px;
    }

    .course-card-subtitle {
        font-size: 15px;
    }

    .course-card-text {
        font-size: 13px;
    }
}

.backend-section {
    background-color: #F5F4F7;
}

.backend-card {
    background-color: #FFFFFF;
    border-radius: 20px;
    display: flex;
    flex-direction: row;
    align-items: stretch;
    height: 400px;
    width: 100%;
    max-width: 1030px;
    overflow: hidden;
    margin: 0 auto;
    box-shadow: 0 0 20px rgba(0,0,0,0.15);
}

.backend-content {
    width: 50%;
    padding: 40px 20px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}

.backend-title {
    font-family: 'Inter', sans-serif;
    font-size: 25px;
    color: #1D1D1E;
    font-weight: 700;
    margin-bottom: 20px;
}

.backend-description {
    font-family: 'Inter', sans-serif;
    font-size: 20px;
    color: #1D1D1E;
    font-weight: 700;
    line-height: 1.5;
    margin-top: auto;
    padding-top: 50px;
}

.backend-image {
    width: 50%;
    padding: 0;
    margin: 0;
    height: 100%;
}

.backend-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* Animation */
.backend-card {
    opacity: 0;
    transform: translateY(30px);
    transition: all 0.8s ease;
}

.backend-card.visible {
    opacity: 1;
    transform: translateY(0);
}

/* Responsive */
@media (max-width: 1200px) {
    .backend-card {
        max-width: 900px;
    }
}

@media (max-width: 992px) {
    .backend-card {
        height: 350px;
    }

    .backend-title {
        font-size: 23px;
    }

    .backend-description {
        font-size: 18px;
    }
}

@media (max-width: 768px) {
    .backend-card {
        flex-direction: column;
        height: auto;
    }

    .backend-content,
    .backend-image {
        width: 100%;
    }

    .backend-content {
        padding: 30px 20px;
        order: 2;
    }

    .backend-image {
        height: 250px;
        order: 1;
    }

    .backend-description {
        padding-top: 20px;
    }

    .backend-title {
        text-align: center;
    }

    .backend-description {
        text-align: center;
    }
}

@media (max-width: 576px) {
    .backend-card {
        border-radius: 16px;
    }

    .backend-content {
        padding: 25px 15px;
    }

    .backend-image {
        height: 200px;
    }

    .backend-title {
        font-size: 21px;
    }

    .backend-description {
        font-size: 16px;
        font-weight: 600;
    }
}

@media (max-width: 400px) {
    .backend-image {
        height: 180px;
    }

    .backend-title {
        font-size: 19px;
    }

    .backend-description {
        font-size: 14px;
    }

    .backend-content {
        padding: 20px 15px;
    }
}

.testimonials-section {
    background-color: #F5F4F7;
    direction: ltr;
}

.testimonials-header {
    margin-bottom: 3rem;
}

.testimonials-title {
    font-family: 'Inter', sans-serif;
    font-size: 45px;
    color: #1D1D1E;
    font-weight: 700;
    line-height: 1.2;
}

.testimonials-subtitle {
    font-family: 'Inter', sans-serif;
    font-size: 36px;
    color: #6E6E72;
    font-weight: 700;
    line-height: 1.3;
}

.testimonial-card {
    background-color: #fff;
    border-radius: 16px;
    padding: 24px;
    box-shadow: 0 0 20px rgba(0, 0, 0, 0.08);
    height: 100%;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    transition: transform 0.3s, box-shadow 0.3s;
}

.testimonial-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 30px rgba(0, 0, 0, 0.12);
}

.testimonial-text {
    font-family: 'Inter', sans-serif;
    font-size: 15px;
    color: #1D1D1E;
    font-weight: 700;
    line-height: 1.6;
    margin-bottom: 1.5rem;
}

.testimonial-author {
    display: flex;
    align-items: center;
    margin-top: auto;
}

.author-avatar {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    object-fit: cover;
    margin-right: 12px;
}

.author-info {
    display: flex;
    flex-direction: column;
}

.author-name {
    margin: 0;
    font-size: 16px;
    font-family: 'Inter', sans-serif;
    font-weight: 600;
    color: #1D1D1E;
}

.author-role {
    font-family: 'Inter', sans-serif;
    color: #6E6E72;
    font-size: 14px;
}

/* Animation */
.testimonial-card {
    opacity: 0;
    transform: translateY(30px);
    animation: fadeInUp 0.8s ease forwards;
}

.testimonial-card:nth-child(1) {
    animation-delay: 0.1s;
}

.testimonial-card:nth-child(2) {
    animation-delay: 0.2s;
}

.testimonial-card:nth-child(3) {
    animation-delay: 0.3s;
}

@keyframes fadeInUp {
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Responsive */
@media (max-width: 1200px) {
    .testimonials-title {
        font-size: 40px;
    }

    .testimonials-subtitle {
        font-size: 32px;
    }
}

@media (max-width: 992px) {
    .testimonials-title {
        font-size: 36px;
    }

    .testimonials-subtitle {
        font-size: 28px;
    }
}

@media (max-width: 768px) {
    .testimonials-title {
        font-size: 32px;
    }

    .testimonials-subtitle {
        font-size: 24px;
        padding-top: 1rem !important;
    }

    .testimonial-card {
        margin-bottom: 20px;
    }

    .testimonial-text {
        font-size: 14px;
    }
}

@media (max-width: 576px) {
    .testimonials-title {
        font-size: 28px;
    }

    .testimonials-subtitle {
        font-size: 20px;
    }

    .testimonial-card {
        padding: 20px;
    }

    .author-avatar {
        width: 45px;
        height: 45px;
    }

    .author-name {
        font-size: 15px;
    }

    .author-role {
        font-size: 13px;
    }
}

@media (max-width: 400px) {
    .testimonials-title {
        font-size: 24px;
    }

    .testimonials-subtitle {
        font-size: 18px;
    }

    .testimonial-text {
        font-size: 13px;
        font-weight: 600;
    }
}

.faq-section {
    background-color: #F5F4F7;
    direction: ltr;
}

.faq-header {
    margin-bottom: 3rem;
}

.faq-title {
    font-family: 'Inter', sans-serif;
    font-size: 45px;
    color: #1D1D1E;
    font-weight: 700;
    line-height: 1.2;
}

.faq-subtitle {
    font-family: 'Inter', sans-serif;
    font-size: 30px;
    color: #6E6E72;
    font-weight: 700;
    line-height: 1.3;
}

.faq-container {
    background-color: #ffffff;
    border-radius: 20px;
    padding: 30px;
    box-shadow: 0 0 30px rgba(0, 0, 0, 0.08);
}

.faq-item {
    background-color: #F5F4F7;
    border-radius: 16px;
    border: none;
    overflow: hidden;
    transition: all 0.3s ease;
}

.faq-item:hover {
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}

.faq-button {
    background-color: #F5F4F7;
    border-radius: 16px;
    border: none;
    padding: 20px;
    font-family: 'Inter', sans-serif;
    font-size: 16px;
    font-weight: 600;
    color: #1D1D1E;
    transition: all 0.3s ease;
}

.faq-button:not(.collapsed) {
    background-color: #F5F4F7;
    color: #000;
    font-weight: 700;
}

.faq-button:focus {
    box-shadow: none;
    border: none;
}

.faq-button::after {
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%231D1D1E'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");
    transition: transform 0.3s ease;
}

.faq-button:not(.collapsed)::after {
    transform: rotate(180deg);
}

.faq-answer {
    padding: 20px;
    font-family: 'Inter', sans-serif;
    font-size: 14px;
    color: #6E6E72;
    line-height: 1.6;
    background-color: #F5F4F7;
}

/* Responsive */
@media (max-width: 1200px) {
    .faq-title {
        font-size: 40px;
    }

    .faq-subtitle {
        font-size: 26px;
    }
}

@media (max-width: 992px) {
    .faq-title {
        font-size: 36px;
    }

    .faq-subtitle {
        font-size: 24px;
    }
}

@media (max-width: 768px) {
    .faq-title {
        font-size: 32px;
    }

    .faq-subtitle {
        font-size: 20px;
    }

    .faq-container {
        padding: 20px;
    }

    .faq-button {
        padding: 16px;
        font-size: 15px;
    }

    .faq-answer {
        padding: 16px;
        font-size: 13px;
    }
}

@media (max-width: 576px) {
    .faq-title {
        font-size: 28px;
    }

    .faq-subtitle {
        font-size: 18px;
    }

    .faq-container {
        padding: 15px;
        border-radius: 16px;
    }

    .faq-item {
        border-radius: 12px;
        margin-bottom: 10px !important;
    }

    .faq-button {
        padding: 14px;
        font-size: 14px;
        border-radius: 12px;
    }
}

@media (max-width: 400px) {
    .faq-title {
        font-size: 24px;
    }

    .faq-subtitle {
        font-size: 16px;
    }

    .faq-button {
        padding: 12px;
        font-size: 13px;
    }

    .faq-answer {
        font-size: 12px;
    }
}

/* Footer Section */
.footer-section {
    background-color: #000000;
    padding: 80px 0 40px;
    color: #ffffff;
}

.footer-content {
    text-align: center;
}

.footer-title {
    font-family: 'Inter', sans-serif;
    font-size: 36px;
    color: #ffffff;
    font-weight: 700;
    line-height: 1.3;
    margin-bottom: 20px;
}

.footer-subtitle {
    font-family: 'Inter', sans-serif;
    font-size: 18px;
    color: #B0B0B0;
    font-weight: 400;
    line-height: 1.5;
    margin-bottom: 40px;
}

.footer-actions {
    display: flex;
    justify-content: center;
    gap: 20px;
    margin-bottom: 60px;
    flex-wrap: wrap;
}

.btn-started {
    font-family: 'Inter', sans-serif;
    font-size: 16px;
    font-weight: 600;
    color: #000000;
    background-color: #ffffff;
    padding: 14px 28px;
    border-radius: 10px;
    text-decoration: none;
    transition: all 0.3s ease;
    display: inline-block;
}

.btn-started:hover {
    background-color: #f0f0f0;
    transform: translateY(-2px);
    color: #000000;
}

.btn-outline {
    font-family: 'Inter', sans-serif;
    font-size: 16px;
    font-weight: 600;
    color: #ffffff;
    background-color: transparent;
    padding: 14px 28px;
    border: 2px solid #ffffff;
    border-radius: 10px;
    text-decoration: none;
    transition: all 0.3s ease;
    display: inline-block;
}

.btn-outline:hover {
    background-color: #ffffff;
    color: #000000;
    transform: translateY(-2px);
}

.footer-nav {
    list-style: none;
    padding: 0;
    margin: 0;
    display: flex;
    justify-content: center;
    gap: 30px;
    flex-wrap: wrap;
    padding-top: 30px;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
}

.footer-nav li {
    margin: 0;
}

.footer-nav a {
    font-family: 'Inter', sans-serif;
    font-size: 14px;
    color: #B0B0B0;
    text-decoration: none;
    transition: color 0.3s ease;
    font-weight: 500;
}

.footer-nav a:hover {
    color: #ffffff;
}

/* Responsive */
@media (max-width: 992px) {
    .footer-section {
        padding: 60px 0 30px;
    }

    .footer-title {
        font-size: 32px;
    }

    .footer-subtitle {
        font-size: 16px;
    }
}

@media (max-width: 768px) {
    .footer-title {
        font-size: 28px;
        padding: 0 20px;
    }

    .footer-subtitle {
        font-size: 15px;
        padding: 0 20px;
    }

    .footer-actions {
        flex-direction: column;
        align-items: center;
        gap: 15px;
    }

    .btn-started,
    .btn-outline {
        width: 80%;
        max-width: 300px;
        text-align: center;
    }

    .footer-nav {
        gap: 20px;
    }
}

@media (max-width: 576px) {
    .footer-section {
        padding: 50px 0 25px;
    }

    .footer-title {
        font-size: 24px;
    }

    .footer-subtitle {
        font-size: 14px;
    }

    .btn-started,
    .btn-outline {
        font-size: 14px;
        padding: 12px 24px;
        width: 90%;
    }

    .footer-nav {
        flex-direction: column;
        gap: 15px;
    }

    .footer-nav a {
        font-size: 13px;
    }
}

@media (max-width: 400px) {
    .footer-title {
        font-size: 20px;
    }

    .footer-subtitle {
        font-size: 13px;
    }

    .btn-started,
    .btn-outline {
        font-size: 13px;
        padding: 10px 20px;
    }
}


.login-btn {
    font-family: 'Inter', sans-serif;
    font-size: 16px;
    font-weight: 600;
    color: #FFFFFF;
    background-color: #000000;
    padding: 12px 24px;
    text-decoration: none;
    display: inline-block;
    border-radius: 10px;
    transition: all 0.3s ease;
    margin-left: 30px;
}

.login-btn:hover {
    background-color: #333333;
    transform: translateY(-2px);
    color: #FFFFFF;
}

/* Responsive pour le bouton login */
@media (max-width: 1199px) {
    .login-btn {
        margin-left: 20px;
        font-size: 15px;
        padding: 10px 20px;
    }
}

@media (max-width: 991px) {
    .login-btn {
        margin-left: 15px;
        font-size: 14px;
        padding: 8px 16px;
    }
}

/* Mobile login button */
.mobile-login-btn {
    font-family: 'Inter', sans-serif;
    font-size: 16px;
    font-weight: 600;
    color: #FFFFFF;
    background-color: #000000;
    padding: 12px 24px;
    text-decoration: none;
    display: block;
    border-radius: 10px;
    transition: all 0.3s ease;
    margin-top: 20px;
    text-align: center;
}

.mobile-login-btn:hover {
    background-color: #333333;
    color: #FFFFFF;
}



      .carousel-section {
            background-color: #F5F4F7;
            overflow: hidden;
        }

        .carousel-title {
            font-family: 'Inter', sans-serif;
            font-size: 42px;
            color: #000000;
            font-weight: 700;
            line-height: 1.3;
        }

        .gradient-text {
            background: linear-gradient(90deg, #8A86E9, #CA5EF6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-weight: 700;
        }

        /* Fix pour scroll horizontal uniquement */
        .carousel-container {
            margin: 50px 0;
            width: 100vw;
            position: relative;
            left: 50%;
            right: 50%;
            margin-left: -50vw;
            margin-right: -50vw;
            overflow: hidden;
        }

        .carousel-track {
            display: flex;
            overflow-x: auto;
            overflow-y: hidden;
            gap: 24px;
            padding: 30px 100px;
            scroll-snap-type: x mandatory;
            -webkit-overflow-scrolling: touch;
            scrollbar-width: none;
            min-height: 700px;
            align-items: center;
        }

        .carousel-track::-webkit-scrollbar {
            display: none;
        }

        /* Flip Cards avec hauteur fixe */
        .flip-card {
            perspective: 1000px;
            width: 380px;
            height: 630px;
            scroll-snap-align: center;
            flex-shrink: 0;
        }

        .flip-inner {
            width: 100%;
            height: 100%;
            transition: transform 0.8s cubic-bezier(.4,0,.2,1);
            transform-style: preserve-3d;
            position: relative;
            border-radius: 20px;
        }

        .flip-card.flipped .flip-inner {
            transform: rotateY(180deg);
        }

        .flip-front, .flip-back {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            backface-visibility: hidden;
            padding: 24px;
            border-radius: 20px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            background: #fff;
        }

        .flip-front {
            z-index: 1;
        }

        .flip-back {
            transform: rotateY(180deg);
            z-index: 5;
        }

        /* Typography */
        .card-title, .card-title-white {
            font-family: 'Inter', sans-serif;
            font-size: 30px;
            font-weight: 700;
        }

        .card-title {
            color: #1D1D1E;
        }

        .card-title-white {
            color: #FFFFFF;
        }

        .card-subtitle, .card-subtitle-white {
            font-family: 'Inter', sans-serif;
            font-size: 20px;
            font-weight: 700;
        }

        .card-subtitle {
            color: #1D1D1E;
        }

        .card-subtitle-white {
            color: #FFFFFF;
        }

        .card-text {
            font-family: 'Inter', sans-serif;
            font-size: 20px;
            color: #1D1D1E;
            font-weight: 700;
        }

        /* Buttons */
        .flip-button {
            position: absolute;
            bottom: 24px;
            right: 24px;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            border: none;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 10;
            background: #000;
            color: #fff;
            transition: all 0.3s ease;
        }

        .flip-buttonferme {
            position: absolute;
            bottom: 24px;
            right: 24px;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            border: none;
            background: #fff;
            color: #000;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 10;
            box-shadow: 0 2px 8px rgba(0,0,0,0.25);
            transition: transform 0.3s ease;
        }

        .flip-button-close {
            align-self: flex-end;
            margin-top: auto;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            border: none;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            background: #000000;
            box-shadow: 0 2px 10px rgba(0,0,0,.2);
            transition: all 0.3s ease;
            z-index: 10;
        }

        .flip-button:hover, .flip-buttonferme:hover, .flip-button-close:hover {
            transform: scale(1.1);
        }

        /* Glow Effect */
        .glow-line-border {
            position: absolute;
            inset: -4px;
            border-radius: 24px;
            background: linear-gradient(135deg, #0D93FF, #C25FEA, #EE4476, #ED6D10);
            filter: blur(10px);
            pointer-events: none;
            z-index: 1;
        }

        .content {
            z-index: 2;
            position: relative;
        }

        /* Slider Images */
        .before-image, .after-image {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }

        .before-image {
            clip-path: inset(0 50% 0 0);
        }

        .after-image {
            clip-path: inset(0 0 0 50%);
        }

        .slider {
            position: absolute;
            left: 50%;
            top: 0;
            width: 4px;
            height: 100%;
            background: #fff;
            cursor: ew-resize;
            z-index: 2;
            transform: translateX(-50%);
            transition: left 0.1s ease-out;
        }

        .slider-handle {
            position: absolute;
            top: 50%;
            width: 20px;
            height: 20px;
            background: #fff;
            border-radius: 50%;
            transform: translate(-50%, -50%);
            box-shadow: 0 2px 10px rgba(0,0,0,.3);
            border: 2px solid #000;
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .carousel-title {
                font-size: 36px;
            }

            .carousel-track {
                min-height: 610px;
                padding: 30px 50px;
            }

            .flip-card {
                width: 35vw;
                min-width: 300px;
                height: 550px;
            }
        }

        @media (max-width: 992px) {
            .carousel-title {
                font-size: 32px;
            }

            .carousel-track {
                min-height: 560px;
            }

            .flip-card {
                width: 45vw;
                min-width: 280px;
                height: 500px;
            }

            .card-title, .card-title-white {
                font-size: 26px;
            }

            .card-subtitle, .card-subtitle-white, .card-text {
                font-size: 16px;
            }
        }

        @media (max-width: 768px) {
            .carousel-title {
                font-size: 28px;
                padding: 0 20px;
            }

            .carousel-track {
                min-height: 510px;
                padding: 20px 20px;
                gap: 12px;
            }

            .flip-card {
                width: 75vw;
                min-width: 260px;
                height: 450px;
            }

            .flip-front, .flip-back {
                padding: 20px;
            }

            .flip-button, .flip-buttonferme {
                width: 35px;
                height: 35px;
                bottom: 20px;
                right: 20px;
            }
        }

        @media (max-width: 576px) {
            .carousel-title {
                font-size: 24px;
            }

            .carousel-track {
                min-height: 460px;
            }

            .flip-card {
                width: 85vw;
                min-width: 240px;
                height: 400px;
            }

            .card-title, .card-title-white {
                font-size: 22px;
            }

            .card-subtitle, .card-subtitle-white, .card-text {
                font-size: 14px;
            }
        }


        .course-actions {
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.price-tag {
  background: #f2f2f2;
  padding: 6px 12px;
  border-radius: 20px;
  font-weight: 600;
  font-size: 14px;
}

.learn-more-btn {
  background: #0066ff;
  color: #fff;
  border: none;
  padding: 8px 18px;
  border-radius: 20px;
  cursor: pointer;
  font-weight: 600;
  transition: 0.3s;
}

.learn-more-btn:hover {
  background: #004ecc;
}


.containerr {
  position: relative;
  font-size: 20px;  /* un peu plus petit pour rentrer dans la carte */
  font-weight: bold;
  color: #555;
  margin: 20px 0;   /* espace autour */
}

.blurred {
  filter: blur(6px);
  user-select: none;
  text-align: center;
}

.magnifier {
  position: absolute;
  width: 100px;
  height: 100px;
  border-radius: 50%;
  overflow: hidden;
  border: 2px solid black;
  pointer-events: none;
  display: none;
}

.magnifier span {
  position: absolute;
  font-size: 20px;
  font-weight: bold;
  color: #555;
  filter: blur(0);
  top: 0;
  left: 0;
  white-space: nowrap;
}

    </style>
</head>

<body>
    <!-- Header -->
    <header class="am-header_five">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="am-header_two_wrap">
                    <!-- Logo -->
                    <strong class="am-logo">
                        <a href="/">
                            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/logoo.png" alt="Alplatforme Logo">
                        </a>
                    </strong>

                    <!-- Navigation Desktop -->
                    <nav class="am-navigation d-none d-lg-flex">
    <ul class="am-nav-menu">
        <li><a href="/" class="nav-link <?php echo e(Request::is('/') ? 'active' : ''); ?>">Home</a></li>
        <li><a href="/web-dev" class="nav-link <?php echo e(Request::is('web-dev') ? 'active' : ''); ?>">Front-End</a></li>
        <li><a href="/ai-dev" class="nav-link <?php echo e(Request::is('ai-dev') ? 'active' : ''); ?>">AI Development</a></li>
        <li><a href="/dataanalyst" class="nav-link <?php echo e(Request::is('dataanalyst') ? 'active' : ''); ?>">Data Analysis</a></li>
        <li><a href="/fulstack" class="nav-link <?php echo e(Request::is('fulstack') ? 'active' : ''); ?>">Full Stack</a></li>
        <li><a href="/Back-end" class="nav-link <?php echo e(Request::is('Back-end') ? 'active' : ''); ?>">Back-End</a></li>
        <li><a href="/Contact" class="nav-link <?php echo e(Request::is('Contact') ? 'active' : ''); ?>">Contact</a></li>
    </ul>
    <!-- Bouton Login -->
    <a href="/login" class="login-btn">Login</a>
</nav>

                    <!-- Burger Menu Button -->
                    <button class="burger-btn d-lg-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#mobileMenu">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu Offcanvas -->
    <div class="offcanvas offcanvas-end" tabindex="-1" id="mobileMenu">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title">Menu</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
        </div>
       <div class="offcanvas-body">
    <ul class="mobile-nav-menu">
        <li><a href="/" class="mobile-nav-link <?php echo e(Request::is('/') ? 'active' : ''); ?>">Home</a></li>
        <li><a href="/web-dev" class="mobile-nav-link <?php echo e(Request::is('web-dev') ? 'active' : ''); ?>">Front-End</a></li>
        <li><a href="/ai-dev" class="mobile-nav-link <?php echo e(Request::is('ai-dev') ? 'active' : ''); ?>">AI Development</a></li>
        <li><a href="/dataanalyst" class="mobile-nav-link <?php echo e(Request::is('dataanalyst') ? 'active' : ''); ?>">Data Analysis</a></li>
        <li><a href="/fulstack" class="mobile-nav-link <?php echo e(Request::is('fulstack') ? 'active' : ''); ?>">Full Stack</a></li>
        <li><a href="/Back-end" class="mobile-nav-link <?php echo e(Request::is('Back-end') ? 'active' : ''); ?>">Back-End</a></li>
        <li><a href="/Contact" class="mobile-nav-link <?php echo e(Request::is('Contact') ? 'active' : ''); ?>">Contact</a></li>
    </ul>
    <!-- Bouton Login Mobile -->
    <a href="/login" class="mobile-login-btn">Login</a>
</div>
    </div>
</header>
    <!-- Main Content -->
    <main class="am-main">
        <div class="page-home-three">
            <section class="pb-themesection">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="am-banner-potential am-banner-content-three">
                                <div class="container">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="am-banner-main">
                                                <div class="am-banner-content">
                                                    <div class="am-banner-tutor">
                                                        <h2 class="banner-title fade-up delay-300">
                                                            Driven by The Impossible
                                                        </h2>
                                                        <span class="banner-subtitle fade-up delay-400">
                                                            We believe that learning should be accessible,
                                                            inspiring and built for the real world,
                                                            that's <br> why every course we build is deep,
                                                            practical and designed for the real world — taught by<br> those who live it
                                                        </span>
                                                        <div class="am-explore-banner-button fade-up delay-500">
                                                            <a href="#" class="explore-btn">
                                                                Explore Now
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section class="pb-themesection py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="info-card">
          <!-- Texte à gauche -->
          <div class="info-content">
            <!-- Titre -->
            <div class="text-center">
              <h3 class="info-title">
                Everything In <br> One Place
              </h3>
            </div>
            <!-- Description -->
            <div class="d-flex flex-grow-1 align-items-center justify-content-center">
              <p class="info-description">
                Everything you need, exactly where <br class="desktop-break">
                you expect it — progress, sessions,<br class="desktop-break">
                and projects all in one place.
              </p>
            </div>
          </div>
          <!-- Image à droite -->
          <div class="info-image">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/Hero%20Image11.png"
              alt="Empowering learners image">
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Section Built-In Intelligence -->
<section class="pb-themesection py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="info-card-reverse">
          <!-- Image à gauche -->
          <div class="info-image-reverse">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/Hero%20Image11.png"
              alt="Built-In Intelligence image">
          </div>
          <!-- Texte à droite -->
          <div class="info-content-reverse">
            <!-- Titre -->
            <div class="text-center">
              <h3 class="info-title">
                Built-In<br> Intelligence
              </h3>
            </div>
            <!-- Description -->
            <div class="d-flex flex-grow-1 align-items-center justify-content-center">
              <p class="info-description">
                Quietly powerful, always available.<br class="desktop-break">
                It answers questions, explains code,<br class="desktop-break">
                and helps you move forward —<br class="desktop-break">
                without ever breaking your flow.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="pb-themesection py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="info-card">
          <!-- Texte à gauche -->
          <div class="info-content">
            <!-- Titre -->
            <div class="text-center">
              <h3 class="info-title">
                Built For Builders
              </h3>
            </div>
            <!-- Description -->
            <div class="d-flex flex-grow-1 align-items-center justify-content-center">
              <p class="info-description">
                This is where your ideas take shape<br class="desktop-break">
                and your progress becomes visible — <br class="desktop-break">
                code with purpose, visualize every<br class="desktop-break">
                step, and deliver results that matter.
              </p>
            </div>
          </div>
          <!-- Image à droite -->
          <div class="info-image">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/Hero%20Image11.png"
              alt="Built For Builders image">
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Section Carousel avec Flip Cards -->
<section class="carousel-section py-5">
        <div class="container pt-5">
            <!-- Titre -->
            <div class="row mb-5">
                <div class="col-12 text-center">
                    <h2 class="carousel-title">
                        Where curiosity meets
                        <span class="gradient-text">clarity</span>,
                        learning
                        <span class="gradient-text">Just Flows</span>
                    </h2>
                </div>
            </div>

            <!-- Cartes horizontales -->
            <div class="carousel-container">
                <div class="carousel-track">
                    <!-- Carte 1 - NOVA -->
                    <div class="flip-card">
                        <div class="flip-inner">
                            <div class="flip-front" style="padding: 3px; border-radius: 20px;">
                                <div class="glow-line-border"></div>
                                <div class="content" style="
                                    background-image: url('https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMG0.jpg');
                                    background-size: cover;
                                    background-position: center;
                                    background-repeat: no-repeat;
                                    padding: 40px;
                                    border-radius: 20px;
                                    background-color: rgb(0, 0, 0);
                                    z-index: 2;
                                    width: 100%;
                                    height: 100%;
                                ">
                                    <h4 class="card-title-white">NOVA</h4>
                                    <p class="card-subtitle-white">Designed for deep focus</p>
                                </div>
                                <button class="flip-buttonferme" data-bs-toggle="modal" data-bs-target="#novaModal">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="#000000" stroke-width="2" stroke-linecap="round"/>
        </svg>
    </button>
                            </div>
                            <div class="flip-back">
                                <div>
                                    <h4 class="card-title">Always one step ahead.</h4>
                                    <p class="card-text">Nova is built into your workspace — quiet, responsive, and always with you, day or night. It understands your code, catches what you mean, and responds the moment you need it. No commands. No searching. Just the right help, exactly when you need it.</p>
                                </div>
                                <button class="flip-button-close">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                        <path d="M20.7457 3.32851C20.3552 2.93798 19.722 2.93798 19.3315 3.32851L12.0371 10.6229L4.74275 3.32851C4.35223 2.93798 3.71906 2.93798 3.32854 3.32851C2.93801 3.71903 2.93801 4.3522 3.32854 4.74272L10.6229 12.0371L3.32856 19.3314C2.93803 19.722 2.93803 20.3551 3.32856 20.7457C3.71908 21.1362 4.35225 21.1362 4.74277 20.7457L12.0371 13.4513L19.3315 20.7457C19.722 21.1362 20.3552 21.1362 20.7457 20.7457C21.1362 20.3551 21.1362 19.722 20.7457 19.3315L13.4513 12.0371L20.7457 4.74272C21.1362 4.3522 21.1362 3.71903 20.7457 3.32851Z" fill="#FFFFFF"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Carte 2 - ACCESS -->
                    <div class="flip-card">
                        <div class="flip-inner">
                            <div class="flip-front" style="height: 100%; overflow: hidden; position: relative; border-radius: 20px;">
                                <div style="position: absolute; top: 20px; left: 0; right: 0; text-align: center; z-index: 3;">
                                    <h4 class="card-title-white">ACCESS</h4>
                                    <p class="card-subtitle-white">Always here, Always ready</p>
                                </div>
                                <div class="before-image" style="background: url('https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMG1.jpg') no-repeat center/cover;"></div>
                                <div class="after-image" style="background: url('https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMG2.jpg') no-repeat center/cover;"></div>
                                <div class="slider" id="slider1">
                                    <div class="slider-handle"></div>
                                </div>
                                 <button class="flip-button" data-bs-toggle="modal" data-bs-target="#accessModal">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
            <path d="M12 5v14M5 12h14" stroke="#fff" stroke-width="2" stroke-linecap="round"/>
        </svg>
    </button>
                            </div>
                            <div class="flip-back">
                                <div>
                                    <h4 class="card-title">FLOW</h4>
                                    <p class="card-text">Flow is your creative space — clean, quiet, and fully yours. Built for deep work, it lets you code, write, track progress, and submit without switching tools or breaking focus. Everything stays connected, so nothing gets in the way of your flow.</p>
                                </div>
                                <button class="flip-button-close">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                        <path d="M20.7457 3.32851C20.3552 2.93798 19.722 2.93798 19.3315 3.32851L12.0371 10.6229L4.74275 3.32851C4.35223 2.93798 3.71906 2.93798 3.32854 3.32851C2.93801 3.71903 2.93801 4.3522 3.32854 4.74272L10.6229 12.0371L3.32856 19.3314C2.93803 19.722 2.93803 20.3551 3.32856 20.7457C3.71908 21.1362 4.35225 21.1362 4.74277 20.7457L12.0371 13.4513L19.3315 20.7457C19.722 21.1362 20.3552 21.1362 20.7457 20.7457C21.1362 20.3551 21.1362 19.722 20.7457 19.3315L13.4513 12.0371L20.7457 4.74272C21.1362 4.3522 21.1362 3.71903 20.7457 3.32851Z" fill="#ffffff"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Carte 3 - FLOW -->
                    <div class="flip-card">
                        <div class="flip-inner">
                            <div class="flip-front" style="
                                background-image: url('https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMG3.jpg');
                                background-size: cover;
                                background-position: center;
                                background-repeat: no-repeat;
                                padding: 40px;
                                border-radius: 20px;
                                background-color: rgb(0, 0, 0);
                                z-index: 2;
                                width: 100%;
                                height: 100%;
                            ">
                                <div style="position: absolute; top: 20px; left: 0; right: 0; z-index: 3;">
                                    <h4 class="card-title">FLOW</h4>
                                    <p class="card-subtitle">Designed for deep focus</p>
                                </div>
                               <button class="flip-button" data-bs-toggle="modal" data-bs-target="#flowModal">
    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
        <path d="M12 5v14M5 12h14" stroke="#fff" stroke-width="2" stroke-linecap="round"/>
    </svg>
</button>
                            </div>
                            <div class="flip-back">
                                <div>
                                    <h4 class="card-title">Niro is your space to ask, share, and grow — together</h4>
                                    <p class="card-text">When you speak, someone listens. When you're stuck, someone's there. It's not just chat. It's connection that moves learning forward.</p>
                                </div>
                                <button class="flip-button-close">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                        <path d="M20.7457 3.32851C20.3552 2.93798 19.722 2.93798 19.3315 3.32851L12.0371 10.6229L4.74275 3.32851C4.35223 2.93798 3.71906 2.93798 3.32854 3.32851C2.93801 3.71903 2.93801 4.3522 3.32854 4.74272L10.6229 12.0371L3.32856 19.3314C2.93803 19.722 2.93803 20.3551 3.32856 20.7457C3.71908 21.1362 4.35225 21.1362 4.74277 20.7457L12.0371 13.4513L19.3315 20.7457C19.722 21.1362 20.3552 21.1362 20.7457 20.7457C21.1362 20.3551 21.1362 19.722 20.7457 19.3315L13.4513 12.0371L20.7457 4.74272C21.1362 4.3522 21.1362 3.71903 20.7457 3.32851Z" fill="#FFFFFF"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Carte 4 - FORGE -->
                    <div class="flip-card">
                        <div class="flip-inner">
                            <div class="flip-front" style="height: 100%; overflow: hidden; position: relative; border-radius: 20px;">
                                <div style="position: absolute; top: 20px; left: 0; right: 0; text-align: center; z-index: 3;">
                                    <h4 class="card-title-white">FORGE</h4>
                                    <p class="card-subtitle-white">Real work leaves a mark</p>
                                </div>
                                <div class="before-image" style="background: url('https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMG4.jpg') no-repeat center/cover;"></div>
                                <div class="after-image" style="background: url('https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMG5.jpg') no-repeat center/cover;"></div>
                                <div class="slider" id="slider2">
                                    <div class="slider-handle"></div>
                                </div>
                               <button class="flip-button" data-bs-toggle="modal" data-bs-target="#forgeModal">
    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
        <path d="M12 5v14M5 12h14" stroke="#fff" stroke-width="2" stroke-linecap="round"/>
    </svg>
</button>
                            </div>
                            <div class="flip-back">
                                <div>
                                    <h4 class="card-title">FORGE</h4>
                                    <p class="card-text">Forge isn't just about learning — it's about creating. You build real projects that showcase your skills and prepare you for what comes next. This is where knowledge meets impact.</p>
                                </div>
                                <button class="flip-button-close">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                        <path d="M20.7457 3.32851C20.3552 2.93798 19.722 2.93798 19.3315 3.32851L12.0371 10.6229L4.74275 3.32851C4.35223 2.93798 3.71906 2.93798 3.32854 3.32851C2.93801 3.71903 2.93801 4.3522 3.32854 4.74272L10.6229 12.0371L3.32856 19.3314C2.93803 19.722 2.93803 20.3551 3.32856 20.7457C3.71908 21.1362 4.35225 21.1362 4.74277 20.7457L12.0371 13.4513L19.3315 20.7457C19.722 21.1362 20.3552 21.1362 20.7457 20.7457C21.1362 20.3551 21.1362 19.722 20.7457 19.3315L13.4513 12.0371L20.7457 4.74272C21.1362 4.3522 21.1362 3.71903 20.7457 3.32851Z" fill="#FFFFFF"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Carte 5 - NIRO -->
                    <div class="flip-card">
                        <div class="flip-inner">
                            <div class="flip-front" style="
                                background-image: url('https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMG6.jpg');
                                background-size: cover;
                                background-position: center;
                                background-repeat: no-repeat;
                                padding: 40px;
                                border-radius: 20px;
                                background-color: rgb(0, 0, 0);
                                z-index: 2;
                                width: 100%;
                                height: 100%;
                            ">
                                <div style="position: absolute; top: 20px; left: 0; right: 0; text-align: center; z-index: 3;">
                                    <h4 class="card-title-white">NIRO</h4>
                                    <p class="card-subtitle-white">Where ideas meet</p>
                                </div>
                              <button class="flip-button" data-bs-toggle="modal" data-bs-target="#niroModal">
    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
        <path d="M12 5v14M5 12h14" stroke="#fff" stroke-width="2" stroke-linecap="round"/>
    </svg>
</button>
                            </div>
                            <div class="flip-back">
                                <div>
                                    <h4 class="card-title">Where knowledge meets impact</h4>
                                    <p class="card-text">It's about creating. You build real projects that showcase your skills and prepare you for what comes next. This is where knowledge meets impact, shaping the future you want to own.</p>
                                </div>
                                <button class="flip-button-close">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                        <path d="M20.7457 3.32851C20.3552 2.93798 19.722 2.93798 19.3315 3.32851L12.0371 10.6229L4.74275 3.32851C4.35223 2.93798 3.71906 2.93798 3.32854 3.32851C2.93801 3.71903 2.93801 4.3522 3.32854 4.74272L10.6229 12.0371L3.32856 19.3314C2.93803 19.722 2.93803 20.3551 3.32856 20.7457C3.71908 21.1362 4.35225 21.1362 4.74277 20.7457L12.0371 13.4513L19.3315 20.7457C19.722 21.1362 20.3552 21.1362 20.7457 20.7457C21.1362 20.3551 21.1362 19.722 20.7457 19.3315L13.4513 12.0371L20.7457 4.74272C21.1362 4.3522 21.1362 3.71903 20.7457 3.32851Z" fill="#FFFFFF"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<!-- Section Permission to Grow -->
<section class="permission-section pb-themesection py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="permission-card">
          <!-- Image à gauche -->
          <div class="permission-image">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/img7.jpg"
              alt="You don't need permission to grow">
          </div>
          <!-- Texte à droite -->
          <div class="permission-content">
            <!-- Titre -->
            <div class="permission-title-wrapper ">
              <h3 class="permission-title ">
                You don't need permission <br class="desktop-break"> to GROW.
              </h3>
            </div>
            <!-- Description -->
            <div class="permission-text-wrapper">
              <p class="permission-text">
                You don't need a degree to create. You need space....<br class="desktop-break">
                To think clearly. Build freely.<br class="desktop-break">
                And put your name on something that matters.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- Section Courses -->
<section class="courses-section py-5">
    <div class="container pt-5">
        <!-- Titre -->
        <div class="row mb-5">
            <div class="col-12 text-center">
                <h2 class="courses-title">
                    CORE:
                    <span class="courses-subtitle">Courses engineered for real-world mastery.</span>
                </h2>
            </div>
        </div>

        <!-- Two Flip Cards in One Line -->
        <div class="row">
            <div class="col-12 courses-cards-container">
                <!-- Card 1 - Full Stack -->
                <div class="course-flip-card">
  <div class="course-flip-inner">
    <div class="course-flip-front">
      <div class="course-content">
        <h4 class="course-card-title">Back-End </h4>
        <h3 class="course-card-subtitle">Build from nothing. Deploy to everywhere</h3>
        <p class="course-card-text">Build the logic, performance, and systems that power everything — secure, scalable, and silent by design.</p>
      </div>
      <!-- ✅ Boutons en bas -->
      <div class="course-actions d-flex justify-content-between align-items-center mt-4">
        <span class="price-tag">499/month</span>
        <button class="learn-more-btn">learn more</button>
      </div>
    </div>

    <div class="course-flip-back">
      <div class="course-content">
        <h4 class="course-card-title">6-months 6–8 hours/week Frontend + Backend projects</h4>
        <p class="course-card-text">Engage in hands-on projects over 6 months, dedicating 6–8 hours per week, guided by experts to build real-world solutions that evolve with your vision.</p>
      </div>
      <div class="course-actions d-flex justify-content-between align-items-center mt-4">
        <span class="price-tag">499/month</span>
        <button class="learn-more-btn">learn more</button>
      </div>
    </div>
  </div>
</div>


                <!-- Card 2 - AI Course -->
             <div class="course-flip-card">
  <div class="course-flip-inner">
 <div class="course-flip-front ">
  <div class="course-content">
    <h4 class="course-card-title">AI Course</h4>
    <p class="course-card-subtitle">Think in code, Act with vision</p>
    <p class="course-card-text">Learn how machines learn, build tools that adapt, predict, and evolve with purpose</p>
  </div>

  <div class="course-image text-center my-3">
    <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/Rectangle%2036.png"
         alt="Macbook"
         style="max-width: 100%; height: 100px;">
  </div>

  <div class="course-actions d-flex justify-content-between align-items-center mt-4">
    <span class="price-tag">499/month</span>
    <button class="learn-more-btn">learn more</button>
  </div>
</div>

    <div class="course-flip-back">
      <div class="course-content">
        <h4 class="course-card-title">6-months 6–8 hours/week AI + ML projects</h4>
        <p class="course-card-text">Engage in hands-on projects over 6 months, dedicating 6–8 hours per week, guided by experts to build real-world solutions that evolve with your vision.</p>
      </div>
      <div class="course-actions d-flex justify-content-between align-items-center mt-4">
        <span class="price-tag">499/month</span>
        <button class="learn-more-btn">learn more</button>
      </div>
    </div>
  </div>
</div>
            </div>
        </div>
    </div>
</section>

<!-- Section Courses Row 2 -->
<section class="courses-section" style="background-color: #F5F4F7;">
    <div class="container">
        <div class="row">
            <div class="col-12 courses-cards-container">
                <!-- Card 3 - Data Analysis -->
                <div class="course-flip-card">
                    <div class="course-flip-inner">
                    <div class="course-flip-front">
  <div class="course-content">
    <h4 class="course-card-title">Data Analysis</h4>
    <h3 class="course-card-subtitle">See the truth behind the numbers.</h3>
    <p class="course-card-text">
      From raw data to real impact — learn to analyze, visualize, and act with confidence.
    </p>
  </div>

  <!-- 🔍 Effet Loupe inséré ici -->
  <div class="containerr" id="containerr">
    <div class="blurred" id="blurred">56415610581561769 4565189415784186</div>
    <div class="magnifier" id="magnifier">
      <span id="clearText">56415610581561769 4565189415784186</span>
    </div>
  </div>

  <div class="course-actions d-flex justify-content-between align-items-center mt-4">
    <span class="price-tag">499/month</span>
    <button class="learn-more-btn">learn more</button>
  </div>
</div>
                        <div class="course-flip-back">
                            <div class="course-content">
                                <h4 class="course-card-title">6-months 6–8 hours/week Data + Analytics projects</h4>
                                <p class="course-card-text">Engage in hands-on projects over 6 months, dedicating 6–8 hours per week, guided by experts to build real-world solutions that evolve with your vision.</p>
                            </div>
                            <div class="course-actions">
                                <button class="learn-more-btn">Learn More</button>
                                <button class="course-flip-close" onclick="this.closest('.course-flip-card').classList.toggle('flipped')">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                        <path d="M20.7457 3.32851C20.3552 2.93798 19.722 2.93798 19.3315 3.32851L12.0371 10.6229L4.74275 3.32851C4.35223 2.93798 3.71906 2.93798 3.32854 3.32851C2.93801 3.71903 2.93801 4.3522 3.32854 4.74272L10.6229 12.0371L3.32856 19.3314C2.93803 19.722 2.93803 20.3551 3.32856 20.7457C3.71908 21.1362 4.35225 21.1362 4.74277 20.7457L12.0371 13.4513L19.3315 20.7457C19.722 21.1362 20.3552 21.1362 20.7457 20.7457C21.1362 20.3551 21.1362 19.722 20.7457 19.3315L13.4513 12.0371L20.7457 4.74272C21.1362 4.3522 21.1362 3.71903 20.7457 3.32851Z" fill="#0F0F0F"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Card 4 - Front-End -->
                <div class="course-flip-card">
                    <div class="course-flip-inner">
                        <div class="course-flip-front">
  <div class="course-content">
    <h4 class="course-card-title">Front-End</h4>
    <p class="course-card-subtitle">If You Can See It, You Can Create It</p>
    <p class="course-card-text">
      Code interfaces that load fast, feel smooth, and look stunning
    </p>
  </div>

  <!-- 🔽 Image ajoutée juste avant les boutons -->
  <div class="course-image text-center my-3">
    <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/macbook3.png"
         alt="Macbook"
         style="max-width: 100%; height: 140px;">
  </div>

  <div class="course-actions d-flex justify-content-between align-items-center mt-4">
    <span class="price-tag">499/month</span>
    <button class="learn-more-btn">learn more</button>
  </div>
</div>

                        <div class="course-flip-back">
                            <div class="course-content">
                                <h4 class="course-card-title">6-months 6–8 hours/week Frontend projects</h4>
                                <p class="course-card-text">Engage in hands-on projects over 6 months, dedicating 6–8 hours per week, guided by experts to build real-world solutions that evolve with your vision.</p>
                            </div>
                            <div class="course-actions">
                                <button class="learn-more-btn">Learn More</button>
                                <button class="course-flip-close" onclick="this.closest('.course-flip-card').classList.toggle('flipped')">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                        <path d="M20.7457 3.32851C20.3552 2.93798 19.722 2.93798 19.3315 3.32851L12.0371 10.6229L4.74275 3.32851C4.35223 2.93798 3.71906 2.93798 3.32854 3.32851C2.93801 3.71903 2.93801 4.3522 3.32854 4.74272L10.6229 12.0371L3.32856 19.3314C2.93803 19.722 2.93803 20.3551 3.32856 20.7457C3.71908 21.1362 4.35225 21.1362 4.74277 20.7457L12.0371 13.4513L19.3315 20.7457C19.722 21.1362 20.3552 21.1362 20.7457 20.7457C21.1362 20.3551 21.1362 19.722 20.7457 19.3315L13.4513 12.0371L20.7457 4.74272C21.1362 4.3522 21.1362 3.71903 20.7457 3.32851Z" fill="#0F0F0F"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="backend-section pb-themesection py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="backend-card">
          <!-- Texte à gauche -->
          <div class="backend-content">
            <h4 class="backend-title">Full Stack Course </h4>
            <p class="backend-description">Build the logic, performance, and systems that power everything — secure, scalable, and silent by design.

</p>
          </div>
          <!-- Image à droite -->
          <div class="backend-image">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMG5.jpg" alt="Back-End Development">
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- Section Testimonials -->
<section class="testimonials-section py-5">
  <div class="container">
    <div class="testimonials-header mb-5">
      <h2 class="testimonials-title">
        Voices that matter.
      </h2>
      <p class="testimonials-subtitle pt-5">
        Professors, creators, and pros share their experience.
      </p>
    </div>

    <div class="row g-4">
      <!-- Testimonial 1 -->
      <div class="col-md-4">
        <div class="testimonial-card">
          <p class="testimonial-text">
            AI-native platforms like Alplatform are the future, enabling business and L&D leaders to create dynamic, personalized, highly efficient training in an exciting rebirth of this profession.
          </p>
          <div class="testimonial-author">
            <img src="https://amento-bucket-poc-2.s3.amazonaws.com/optionbuilder/uploads/customer-01.png"
                 alt="Arlene M" class="author-avatar">
            <div class="author-info">
              <h5 class="author-name">Arlene M</h5>
              <small class="author-role">Agile District</small>
            </div>
          </div>
        </div>
      </div>

      <!-- Testimonial 2 -->
      <div class="col-md-4">
        <div class="testimonial-card">
          <p class="testimonial-text">
            AI-native platforms like Alplatform are the future, enabling business and L&D leaders to create dynamic, personalized, highly efficient training in an exciting rebirth of this profession.
          </p>
          <div class="testimonial-author">
            <img src="https://amento-bucket-poc-2.s3.amazonaws.com/optionbuilder/uploads/customer-02.png"
                 alt="Devon L" class="author-avatar">
            <div class="author-info">
              <h5 class="author-name">Devon L</h5>
              <small class="author-role">Classroom Teacher</small>
            </div>
          </div>
        </div>
      </div>

      <!-- Testimonial 3 -->
      <div class="col-md-4">
        <div class="testimonial-card">
          <p class="testimonial-text">
            AI-native platforms like Alplatform are the future, enabling business and L&D leaders to create dynamic, personalized, highly efficient training in an exciting rebirth of this profession.
          </p>
          <div class="testimonial-author">
            <img src="https://amento-bucket-poc-2.s3.amazonaws.com/optionbuilder/uploads/customer-03.png"
                 alt="Darlene R" class="author-avatar">
            <div class="author-info">
              <h5 class="author-name">Darlene R</h5>
              <small class="author-role">Academic Advisor</small>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- Section FAQ -->
<section class="faq-section pb-themesection pt-5 pb-5">
  <div class="container">
    <div class="faq-header mb-5">
      <h2 class="faq-title">
        The details, made simple.
      </h2>
      <p class="faq-subtitle pt-3">
        We've answered what matters most — so you can focus on what comes next:
      </p>
    </div>

    <!-- Carte blanche contenant les FAQs -->
    <div class="faq-container">
      <div class="accordion accordion-flush" id="accordionFlushExample">

        <!-- FAQ Item 1 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq1">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse1" aria-expanded="false" aria-controls="collapse1">
              How do I find a tutor?
            </button>
          </h2>
          <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="faq1" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              Use the search bar and filters on the "Find a Tutor" page to search for tutors by subject, availability, rating, and more.
            </div>
          </div>
        </div>

        <!-- FAQ Item 2 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq2">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse2" aria-expanded="false" aria-controls="collapse2">
              How do I book a session?
            </button>
          </h2>
          <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="faq2" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              Once you find a tutor, view their profile and select an available time slot that suits you. Click "Book Now" and follow the prompts to confirm your session.
            </div>
          </div>
        </div>

        <!-- FAQ Item 3 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq3">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse3" aria-expanded="false" aria-controls="collapse3">
              What if I need to cancel or reschedule a session?
            </button>
          </h2>
          <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="faq3" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              You can cancel or reschedule a session up to 24 hours before the scheduled time without penalty. Cancellations within 24 hours may incur a fee.
            </div>
          </div>
        </div>

        <!-- FAQ Item 4 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq4">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
              How do I pay for sessions?
            </button>
          </h2>
          <div id="collapse4" class="accordion-collapse collapse" aria-labelledby="faq4" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              Payments are made through our secure payment gateway using credit/debit cards or other available payment methods.
            </div>
          </div>
        </div>

        <!-- FAQ Item 5 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq5">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
              What should I do if my tutor doesn't show up?
            </button>
          </h2>
          <div id="collapse5" class="accordion-collapse collapse" aria-labelledby="faq5" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              If your tutor does not show up for a scheduled session, please contact our support team immediately for assistance and to arrange a refund or reschedule.
            </div>
          </div>
        </div>

        <!-- FAQ Item 6 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq6">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse6" aria-expanded="false" aria-controls="collapse6">
              How do I leave feedback for my tutor?
            </button>
          </h2>
          <div id="collapse6" class="accordion-collapse collapse" aria-labelledby="faq6" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              After your session, you will receive an email prompting you to rate your tutor and provide feedback. You can also do this from your account dashboard.
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>
<div class="modal fade" id="novaModal" tabindex="-1">
  <div class="modal-dialog modal-md modal-dialog-centered"> <!-- modal-md pour carré -->
    <div class="modal-content" style="
        border-radius:20px;      /* angles presque carrés */
        padding:50px;
        width:100%;
        max-width:520px;        /* carré + compact */
        margin:auto;
    ">

      <!-- HEADER -->
      <div class="border-0" style="display:flex; justify-content:flex-end;">

      </div>

      <div class="modal-body" style="text-align:left; padding-top:5; padding-bottom:5;">

        <!-- ICON + TITLE -->
     <div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
            <img src="/assets/icons/front labrrani/icons8-ai-384.png"
                 alt="NOVA icon"
                 style="width:40px; height:40px;">
            <h2 style="
                margin:0;
                font-size:30px;
                font-weight:700;
                background: linear-gradient(90deg, #0E69F1, #B518F0);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
            ">
                NOVA
            </h2>
        </div>

        <!-- SUBTITLE -->
        <h3 style="
            font-size:30px;
            font-weight:700;
            margin:0 0 15px 0;
                background: linear-gradient(90deg, #0E69F1, #B518F0);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        ">
            Always here, Always ready
        </h3>

        <!-- MAIN TITLE -->
        <h1 style="
            font-size:34px;
            font-weight:700;
            margin-bottom:15px;
            color:#111;
        ">
            Always one step ahead.
        </h1>

        <!-- DESCRIPTION -->
        <p style="font-size:20px; font-weight:700; line-height:1.6; color:1D1D1E; margin-bottom:0;">
            Nova is built into your workspace — quiet, responsive, and always with you, day or night.
            It understands your code, catches what you mean, and responds the moment you need it.
            No commands. No searching. Just the right help, exactly when you need it.
        </p>

      </div>


    </div>
  </div>
</div>


<div class="modal fade" id="forgeModal" tabindex="-1">
  <div class="modal-dialog modal-md modal-dialog-centered"> <!-- modal-md pour carré -->
    <div class="modal-content" style="
        border-radius:20px;      /* angles presque carrés */
        padding:50px;
        width:100%;
        max-width:520px;        /* carré + compact */
        margin:auto;
    ">

      <!-- HEADER -->
      <div class="border-0 " style="display:flex; justify-content:flex-end;">

      </div>

      <div class="modal-body" style="text-align:left; padding-top:5; padding-bottom:5;">

        <!-- ICON + TITLE -->
     <div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
            <img src="/assets/icons/front labrrani/Forge.svg"
                 alt="NOVA icon"
                 style="width:40px; height:40px;">
            <h2 style="
                margin:0;
                font-size:30px;
                font-weight:700;
                background: linear-gradient(90deg, #F97316F1, #93440D);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
            ">
                forge
            </h2>
        </div>

        <!-- SUBTITLE -->
        <h3 style="
            font-size:30px;
            font-weight:700;
            margin:0 0 15px 0;
                background: linear-gradient(90deg, #F97316, #93440D);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            padding-bottom:25px;
        ">
Real work leaves a mark         </h3>

        <!-- MAIN TITLE -->
        <h1 style="
            font-size:34px;
            font-weight:700;
            margin-bottom:15px;
            color:#111;
        ">

</h1>

        <!-- DESCRIPTION -->
        <p style="font-size:20px; font-weight:700; line-height:1.6; color:1D1D1E; margin-bottom:0;">
           Forge isn’t just about learning — it’s about creating. You build real projects that showcase your skills and prepare you for what comes next. This is where knowledge meets impact, shaping the future you want to own.
        </p>

      </div>


    </div>
  </div>
</div>

<div class="modal fade" id="accessModal" tabindex="-1">
 <div class="modal-dialog modal-md modal-dialog-centered"> <!-- modal-md pour carré -->
    <div class="modal-content" style="
        border-radius:20px;      /* angles presque carrés */
        padding:50px;
        width:100%;
        max-width:520px;        /* carré + compact */
        margin:auto;
    ">

      <!-- HEADER -->
      <div class="border-0" style="display:flex; justify-content:flex-end;">

      </div>

      <div class="modal-body" style="text-align:left; padding-top:5; padding-bottom:5;">

        <!-- ICON + TITLE -->
     <div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
            <img src="/assets/icons/front labrrani/access.svg"
                 alt="NOVA icon"
                 style="width:40px; height:40px;">
            <h2 style="
                margin:0;
                font-size:30px;
                font-weight:700;
                background: linear-gradient(90deg, #14B8A6, #09524A);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
            ">
                Access
            </h2>
        </div>

        <!-- SUBTITLE -->
        <h3 style="
            font-size:25px;
            font-weight:700;
            margin:0 0 15px 0;
                background: linear-gradient(90deg, #14B8A6, #09524A);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            padding-bottom:25px;
        ">
Always here , Always ready
        </h3>



        <!-- DESCRIPTION -->
        <p style="font-size:20px; font-weight:700; line-height:1.6; color:1D1D1E; margin-bottom:0;">
           Wherever you are, your space is already open.         On the couch at home. At a coffee table between tasks. No setup. No waiting. Just a quiet return to what matters. Because learning shouldn’t stop when life moves — it should move with you.
        </p>

      </div>


    </div>
  </div>
</div>

<!-- MODAL NIRO -->
<div class="modal fade" id="niroModal" tabindex="-1">
 <div class="modal-dialog modal-md modal-dialog-centered"> <!-- modal-md pour carré -->
    <div class="modal-content" style="
        border-radius:20px;      /* angles presque carrés */
        padding:50px;
        width:100%;
        max-width:520px;        /* carré + compact */
        margin:auto;
    ">

      <!-- HEADER -->
      <div class="border-0" style="display:flex; justify-content:flex-end;">

      </div>

      <div class="modal-body" style="text-align:left; padding-top:5; padding-bottom:5;">

        <!-- ICON + TITLE -->
     <div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
            <img src="/assets/icons/front labrrani/Niro.svg"
                 alt="NOVA icon"
                 style="width:40px; height:40px;">
            <h2 style="
                margin:0;
                font-size:30px;
                font-weight:700;
                background: linear-gradient(90deg, #169AB6, #1658B6);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
            ">
                Niro
            </h2>
        </div>

        <!-- SUBTITLE -->
        <h3 style="
            font-size:30px;
            font-weight:700;
            margin:0 0 15px 0;
                background: linear-gradient(90deg, #169AB6, #1658B6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
             padding-bottom:25px;
        ">
           Think together.
        </h3>



        <!-- DESCRIPTION -->
        <p style="font-size:20px; font-weight:700; line-height:1.6; color:1D1D1E; margin-bottom:0;">
           Niro is your space to ask, share, and grow — together. When you speak, someone listens. When you're stuck, someone’s there.                                        It’s not just chat. It’s connection that moves learning forward.
        </p>

      </div>


    </div>
  </div>
</div>


<div class="modal fade" id="flowModal" tabindex="-1">
  <div class="modal-dialog modal-md modal-dialog-centered"> <!-- modal-md pour carré -->
    <div class="modal-content" style="
        border-radius:20px;      /* angles presque carrés */
        padding:50px;
        width:100%;
        max-width:520px;        /* carré + compact */
        margin:auto;
    ">

      <!-- HEADER -->
      <div class="border-0" style="display:flex; justify-content:flex-end;">

      </div>

      <div class="modal-body" style="text-align:left; padding-top:5; padding-bottom:5;">

        <!-- ICON + TITLE -->
     <div style="display:flex; align-items:center; gap:10px; margin-bottom:10px;">
            <img src="/assets/icons/front labrrani/Flow.svg"
                 alt="NOVA icon"
                 style="width:40px; height:40px;">
            <h2 style="
                margin:0;
                font-size:30px;
                font-weight:700;
                background: linear-gradient(90deg, #EF4ACA, #FD5823);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;

            ">
                FLOW
            </h2>
        </div>

        <!-- SUBTITLE -->
        <h3 style="
            font-size:30px;
            font-weight:700;
            margin:0 0 15px 0;
                background: linear-gradient(90deg, #EF4ACA, #FD5823);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            padding-bottom:25px;
        ">
Designed for deep focus
        </h3>



        <!-- DESCRIPTION -->
        <p style="font-size:20px; font-weight:700; line-height:1.6; color:1D1D1E; margin-bottom:0;">
            Nova is built into your workspace — quiet, responsive, and always with you, day or night.
            It understands your code, catches what you mean, and responds the moment you need it.
            No commands. No searching. Just the right help, exactly when you need it.
        </p>

      </div>


    </div>
  </div>
</div>

<!-- Footer -->
<footer class="footer-section">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="footer-content">
                    <h2 class="footer-title" data-aos="fade-up" data-aos-duration="400" data-aos-easing="ease">
                        The standard isn't what's out there. It's what you choose to become
                    </h2>
                    <p class="footer-subtitle" data-aos="fade-up" data-aos-duration="500" data-aos-easing="ease">
                        The standard isn't what's out there. It's what you choose to become.
                    </p>
                    <div class="footer-actions" data-aos="fade-up" data-aos-duration="600" data-aos-easing="ease">
                        <a href="#" class="btn-started">Get Started Now</a>
                        <a href="#" class="btn-outline">Learn About Alplatforme</a>
                    </div>
                    <ul class="footer-nav">
                        <li><a href="#">About Us</a></li>
                        <li><a href="#">Terms and Conditions</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">FAQs</a></li>
                        <li><a href="#">Blogs</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>

        </div>
    </main>

    <!-- Bootstrap JS (optionnel mais utile pour le responsive) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
  const container = document.getElementById("containerr");
  const blurred = document.getElementById("blurred");
  const magnifier = document.getElementById("magnifier");
  const clearText = document.getElementById("clearText");

  container.addEventListener("mousemove", (e) => {
    magnifier.style.display = "block";
    const rect = container.getBoundingClientRect();
    const x = e.clientX - rect.left;
    const y = e.clientY - rect.top;

    magnifier.style.left = x - magnifier.offsetWidth / 2 + "px";
    magnifier.style.top = y - magnifier.offsetHeight / 2 + "px";

    clearText.style.left = -x + magnifier.offsetWidth / 2 + "px";
    clearText.style.top = -y + magnifier.offsetHeight / 2 + "px";
  });

  container.addEventListener("mouseleave", () => {
    magnifier.style.display = "none";
  });
</script>


    <script>
// Animation AOS pour le footer (si AOS est disponible)
document.addEventListener('DOMContentLoaded', function() {
    if (typeof AOS !== 'undefined') {
        AOS.init({
            once: true,
            offset: 50
        });
    }

    // Smooth scroll pour les liens du footer
    const footerLinks = document.querySelectorAll('.footer-nav a');
    footerLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            if (this.getAttribute('href').startsWith('#')) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            }
        });
    });
});
</script>
    <script>
// Amélioration de l'expérience FAQ
document.addEventListener('DOMContentLoaded', function() {
    // Auto-close other accordion items when one is opened
    const accordionButtons = document.querySelectorAll('.faq-button');

    accordionButtons.forEach(button => {
        button.addEventListener('click', function() {
            // Smooth scroll to the opened item
            setTimeout(() => {
                if (!this.classList.contains('collapsed')) {
                    this.scrollIntoView({
                        behavior: 'smooth',
                        block: 'center'
                    });
                }
            }, 350);
        });
    });
});
</script>
    <script>
// Animation au scroll pour la section Permission
document.addEventListener('DOMContentLoaded', function() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);

    const permissionCards = document.querySelectorAll('.permission-card');
    permissionCards.forEach(card => {
        observer.observe(card);
    });
});
</script>

    <script>
        // Animation on page load
        document.addEventListener('DOMContentLoaded', function() {
            const elements = document.querySelectorAll('.fade-up');
            elements.forEach(element => {
                element.style.opacity = '0';
                setTimeout(() => {
                    element.classList.add('fade-up');
                }, 100);
            });
        });
    </script>

    <script>
// Animation au scroll (optionnel)
document.addEventListener('DOMContentLoaded', function() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);

    const infoCards = document.querySelectorAll('.info-card');
    infoCards.forEach(card => {
        observer.observe(card);
    });
});
</script>
<script>
// Animation au scroll
document.addEventListener('DOMContentLoaded', function() {
    // Animation pour le banner
    const elements = document.querySelectorAll('.fade-up');
    elements.forEach(element => {
        element.style.opacity = '0';
        setTimeout(() => {
            element.classList.add('fade-up');
        }, 100);
    });

    // Configuration de l'observateur pour les sections
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);

    // Observer toutes les cards
    const infoCards = document.querySelectorAll('.info-card');
    infoCards.forEach(card => {
        observer.observe(card);
    });

    // Observer les cards inversées
    const reverseCards = document.querySelectorAll('.info-card-reverse');
    reverseCards.forEach(card => {
        observer.observe(card);
    });
});
</script>


<script>
document.addEventListener('DOMContentLoaded', () => {
    // Initialize course flip buttons
    const courseFlipButtons = document.querySelectorAll('.course-flip-btn, .course-flip-close');

    courseFlipButtons.forEach(button => {
        button.addEventListener('click', (e) => {
            e.preventDefault();
            const flipCard = button.closest('.course-flip-card');
            if (flipCard) {
                flipCard.classList.toggle('flipped');
            }
        });
    });

    // Learn More button functionality
    const learnMoreButtons = document.querySelectorAll('.learn-more-btn');

    learnMoreButtons.forEach(button => {
        button.addEventListener('click', (e) => {
            e.preventDefault();
            // Add your navigation or modal logic here
            console.log('Learn More clicked');
        });
    });
});
</script>

<script>
// Animation au scroll pour la section Backend
document.addEventListener('DOMContentLoaded', function() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);

    const backendCards = document.querySelectorAll('.backend-card');
    backendCards.forEach(card => {
        observer.observe(card);
    });
});
</script>

<script>
// Animation au scroll pour les testimonials
document.addEventListener('DOMContentLoaded', function() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach((entry, index) => {
            if (entry.isIntersecting) {
                setTimeout(() => {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }, index * 100);
            }
        });
    }, observerOptions);

    const testimonialCards = document.querySelectorAll('.testimonial-card');
    testimonialCards.forEach(card => {
        observer.observe(card);
    });
});
</script>
</body>
</html>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/welcome.blade.php ENDPATH**/ ?>