<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Live Classroom','section' => 'Live','page' => 'Session']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Live Classroom','section' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Live'),'page' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Session')]); ?>

    <div class="flex h-[calc(100vh-120px)] bg-gray-900 text-white rounded-2xl shadow-lg overflow-hidden border border-gray-800">

        <!-- 🎥 Zone principale vidéo -->
        <div class="flex-1 flex flex-col relative">
            <!-- Header -->
            <div class="flex justify-between items-center p-4 bg-gray-800 border-b border-gray-700">
                <div>
                    <h2 class="text-2xl font-bold"><?php echo e($session->title); ?></h2>
                    <p class="text-sm text-gray-400">
                        Enseignant : <?php echo e($session->teacher->name ?? 'Professeur'); ?>

                    </p>
                </div>
                <div class="flex gap-2">
                    <button id="btnStart" class="px-4 py-2 bg-green-600 rounded-lg hover:bg-green-700">Démarrer</button>
                    <button id="btnLeave" class="px-4 py-2 bg-red-600 rounded-lg hover:bg-red-700">Quitter</button>
                </div>
            </div>

            <!-- Vidéos -->
            <div class="flex-1 grid grid-cols-1 md:grid-cols-2 gap-4 p-6 overflow-y-auto">
                <div class="relative bg-gray-800 rounded-xl overflow-hidden border border-gray-700">
                    <video id="localVideo" autoplay playsinline muted class="w-full h-full object-cover rounded-xl"></video>
                    <div class="absolute bottom-2 left-2 bg-black/60 px-2 py-1 text-xs rounded">Moi</div>
                </div>

                <div class="relative bg-gray-800 rounded-xl overflow-hidden border border-gray-700">
                    <video id="remoteVideo" autoplay playsinline class="w-full h-full object-cover rounded-xl"></video>
                    <div class="absolute bottom-2 left-2 bg-black/60 px-2 py-1 text-xs rounded">Autre participant</div>
                </div>
            </div>
        </div>

        <!-- 💬 Chat -->
        <div class="w-80 bg-gray-800 border-l border-gray-700 flex flex-col">
            <div class="p-3 font-semibold border-b border-gray-700 flex justify-between items-center">
                <span>Chat en direct</span>
                <span class="text-xs text-gray-400">Session #<?php echo e($session->id); ?></span>
            </div>

            <div id="chatMessages" class="flex-1 p-3 overflow-y-auto space-y-3">
                <?php $__currentLoopData = $session->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="text-sm leading-tight">
                        <span class="font-semibold text-blue-400"><?php echo e($msg->sender->name ?? 'User'); ?>:</span>
                        <span class="text-gray-200"><?php echo e($msg->message); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <form id="chatForm" class="p-3 border-t border-gray-700 flex gap-2">
                <input id="messageInput" type="text"
                       class="flex-1 px-3 py-2 rounded-lg bg-gray-700 border border-gray-600 focus:outline-none"
                       placeholder="Écrire un message...">
                <button type="submit" class="bg-blue-600 px-3 py-2 rounded-lg hover:bg-blue-700">
                    <i class="fa-solid fa-paper-plane"></i>
                </button>
            </form>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/pusher-js@8.4.0/dist/web/pusher.min.js"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

   <script>
axios.defaults.headers.common['X-CSRF-TOKEN'] = document.querySelector('meta[name="csrf-token"]').content;

const sessionId = <?php echo e($session->id); ?>;
const chatMessages = document.getElementById('chatMessages');
const messageInput = document.getElementById('messageInput');
const chatForm = document.getElementById('chatForm');

// 🔹 Fonction pour charger les messages depuis le backend
async function loadMessages() {
    try {
        const res = await axios.get(`/student/live/${sessionId}/messages`);
        chatMessages.innerHTML = '';
        res.data.forEach(msg => {
            addMessageToChat(msg.sender?.name ?? 'User', msg.message);
        });
        chatMessages.scrollTop = chatMessages.scrollHeight;
    } catch (err) {
        console.error('Erreur de chargement des messages:', err);
    }
}

// 🔹 Fonction pour ajouter un message à la liste (DOM)
function addMessageToChat(sender, text) {
    const div = document.createElement('div');
    div.classList.add('text-sm', 'leading-tight');
    div.innerHTML = `<span class="font-semibold text-blue-400">${sender}:</span> <span class="text-gray-200">${text}</span>`;
    chatMessages.appendChild(div);
    chatMessages.scrollTop = chatMessages.scrollHeight;
}

// 🔹 Envoi du message (instantané)
chatForm.addEventListener('submit', async (e) => {
    e.preventDefault();
    const message = messageInput.value.trim();
    if (!message) return;

    try {
        // 1️⃣ Envoie à Laravel
        const res = await axios.post(`/student/live/${sessionId}/send-message`, { message });

        // 2️⃣ Affiche immédiatement le message localement
        addMessageToChat('Moi', message);

        // 3️⃣ Vide le champ
        messageInput.value = '';

    } catch (err) {
        console.error('Erreur d’envoi:', err);
        alert('Erreur lors de l’envoi du message.');
    }
});

// 🔹 Actualisation automatique pour les nouveaux messages
setInterval(loadMessages, 3000);
loadMessages();
</script>

    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

<script>
    const sessionId = <?php echo e($session->id); ?>;
    const chatMessages = document.getElementById('chatMessages');
    const messageInput = document.getElementById('messageInput');
    const chatForm = document.getElementById('chatForm');

    // Fonction pour charger les messages depuis le backend
    async function loadMessages() {
        try {
            const res = await axios.get(`/student/live/${sessionId}/messages`);
            chatMessages.innerHTML = '';
            res.data.forEach(msg => {
                const div = document.createElement('div');
                div.classList.add('text-sm', 'leading-tight');
                div.innerHTML = `
                    <span class="font-semibold text-blue-400">${msg.sender?.name ?? 'User'}:</span>
                    <span class="text-gray-200">${msg.message}</span>
                `;
                chatMessages.appendChild(div);
            });
            chatMessages.scrollTop = chatMessages.scrollHeight;
        } catch (err) {
            console.error('Erreur de chargement des messages:', err);
        }
    }

    // Fonction d’envoi de message
    chatForm.addEventListener('submit', async (e) => {
        e.preventDefault();
        const message = messageInput.value.trim();
        if (!message) return;
        try {
            await axios.post(`/student/live/${sessionId}/send-message`, { message });
            messageInput.value = '';
            loadMessages(); // recharge les messages après envoi
        } catch (err) {
            console.error('Erreur d’envoi:', err);
        }
    });

    // Actualisation automatique toutes les 3 secondes
    loadMessages();
    setInterval(loadMessages, 3000);
</script>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/student/live/show.blade.php ENDPATH**/ ?>