<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Today\'s Work','points' => auth()->user()->points ?? 0,'section' => 'Goals','page' => null]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Today\'s Work','points' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(auth()->user()->points ?? 0),'section' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Goals'),'page' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(null)]); ?>
    <div class="max-w-[1600px] mx-auto py-10 px-6 font-inter" x-data="goalsTable()">

        <!-- 🔹 HEADER -->
        <div class="mb-10">
            <h1 class="text-4xl font-bold text-gray-900 mb-3 tracking-tight">Your goals, beautifully organized.</h1>
            <p class="text-gray-600 text-base">Progress, designed beautifully.</p>
        </div>

        <!-- 🔸 FILTER BAR -->
        <div class="flex items-center gap-3 mb-6 pb-4 border-b border-gray-100">
            <button @click="filterBy('today')" :class="activeFilter === 'today' ? 'bg-indigo-600 text-white' : 'bg-white text-gray-700 border border-gray-300'" class="px-5 py-2 rounded-xl text-sm font-medium shadow-sm hover:bg-indigo-50">Today</button>
            <button @click="filterBy('week')" :class="activeFilter === 'week' ? 'bg-indigo-600 text-white' : 'bg-white text-gray-700 border border-gray-300'" class="px-5 py-2 rounded-xl text-sm font-medium shadow-sm hover:bg-indigo-50">This Week</button>
            <button @click="filterBy('month')" :class="activeFilter === 'month' ? 'bg-indigo-600 text-white' : 'bg-white text-gray-700 border border-gray-300'" class="px-5 py-2 rounded-xl text-sm font-medium shadow-sm hover:bg-indigo-50">This Month</button>
        </div>

        <!-- 🧩 MAIN CONTENT -->
        <div class="flex gap-6">
            <!-- ========================= -->
            <!-- 📋 TABLE SECTION (LEFT) -->
            <!-- ========================= -->
            <div class="flex-1">
                <div class="bg-white border border-gray-200 rounded-2xl shadow-sm overflow-hidden">
                    <table class="w-full text-left">
                        <thead class="bg-gray-50 border-b border-gray-200">
                            <tr>
                                <th class="px-6 py-3 text-sm font-semibold text-gray-600">Task</th>
                                <th class="px-6 py-3 text-sm font-semibold text-gray-600">State</th>
                                <th class="px-6 py-3 text-sm font-semibold text-gray-600">Priority</th>
                                <th class="px-6 py-3 text-sm font-semibold text-gray-600">Task Type</th>
                            </tr>
                        </thead>
                        <tbody>
                            <template x-for="task in filteredTasks" :key="task.id">
                                <tr class="hover:bg-gray-50 cursor-pointer transition" @click="openDetail(task)">
                                    <td class="px-6 py-4 text-gray-800 font-medium" x-text="task.title"></td>
                                    <td class="px-6 py-4">
                                        <span :class="{
                                            'bg-blue-100 text-blue-700': task.status === 'in_progress',
                                            'bg-green-100 text-green-700': task.status === 'done',
                                            'bg-red-100 text-red-700': task.status === 'not_started'
                                        }" class="px-3 py-1 text-xs font-semibold rounded-full" x-text="statusLabel(task.status)"></span>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span :class="{
                                            'bg-green-100 text-green-700': task.priority === 'low',
                                            'bg-yellow-100 text-yellow-700': task.priority === 'medium',
                                            'bg-red-100 text-red-700': task.priority === 'high'
                                        }" class="px-3 py-1 text-xs font-semibold rounded-full capitalize" x-text="task.priority"></span>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="px-3 py-1 text-xs font-semibold rounded-full bg-indigo-100 text-indigo-700" x-text="task.type"></span>
                                    </td>
                                </tr>
                            </template>

                            <tr x-show="filteredTasks.length === 0">
                                <td colspan="4" class="text-center py-8 text-gray-500 text-sm">No tasks found for this period.</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- ========================= -->
            <!-- 🧠 DETAIL PANEL (RIGHT) -->
            <!-- ========================= -->
            <div class="w-[450px]" x-show="selectedTask" x-transition>
                <div class="bg-white border border-gray-200 rounded-2xl shadow-xl sticky top-8 overflow-hidden">
                    <div class="bg-gray-50 px-6 py-4 border-b">
                        <h3 class="text-lg font-semibold text-gray-900">Today's Work</h3>
                    </div>

                    <div class="p-6">
                        <h2 class="text-xl font-bold text-gray-800 mb-2" x-text="selectedTask.title"></h2>
                        <div class="flex gap-2 mb-5">
                            <span :class="{
                                'bg-blue-100 text-blue-700': selectedTask.status === 'in_progress',
                                'bg-green-100 text-green-700': selectedTask.status === 'done',
                                'bg-red-100 text-red-700': selectedTask.status === 'not_started'
                            }" class="px-3 py-1 text-xs font-semibold rounded-full" x-text="statusLabel(selectedTask.status)"></span>
                            <span class="px-3 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-700 capitalize" x-text="selectedTask.priority"></span>
                            <span class="px-3 py-1 text-xs font-semibold rounded-full bg-indigo-100 text-indigo-700" x-text="selectedTask.type"></span>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Comment</label>
                            <textarea rows="3" class="w-full border border-gray-300 rounded-lg text-sm p-2 focus:ring-1 focus:ring-indigo-500" placeholder="Add a comment..." x-model="selectedTask.comment"></textarea>
                        </div>

                        <div class="mt-6">
                            <h4 class="text-sm font-semibold text-gray-800 mb-3">Sub-tasks</h4>
                            <template x-for="sub in selectedTask.subtasks" :key="sub.id">
                                <label class="flex items-center gap-3 mb-2">
                                    <input type="checkbox" x-model="sub.completed" class="w-4 h-4 text-indigo-600 border-gray-300 rounded">
                                    <span :class="sub.completed ? 'line-through text-gray-400' : 'text-gray-700'" x-text="sub.title"></span>
                                </label>
                            </template>
                        </div>

                        <div class="mt-8 flex justify-end">
                            <button @click="saveTask()" class="px-5 py-2.5 bg-indigo-600 text-white text-sm font-medium rounded-lg hover:bg-indigo-700">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Alpine.js logic -->
    <script>
        function goalsTable() {
            return {
                activeFilter: 'today',
                selectedTask: null,

                allTasks: <?php echo json_encode($tasks, 15, 512) ?>, // depuis ton contrôleur Laravel

                get filteredTasks() {
                    if (this.activeFilter === 'today') return this.allTasks;
                    return this.allTasks; // Tu peux ajouter filtrage par date ici
                },

                openDetail(task) {
                    this.selectedTask = JSON.parse(JSON.stringify(task));
                },

                filterBy(period) {
                    this.activeFilter = period;
                },

                statusLabel(status) {
                    return {
                        in_progress: 'In progress',
                        done: 'Well done',
                        not_started: 'Not started'
                    }[status] || 'Unknown';
                },

                saveTask() {
                    fetch(`/student/goals/${this.selectedTask.id}`, {
                        method: 'PUT',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        },
                        body: JSON.stringify(this.selectedTask)
                    }).then(() => alert('Task updated!'));
                }
            };
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/student/goals-table.blade.php ENDPATH**/ ?>