<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Task Management','points' => auth()->user()->points ?? 0,'section' => 'Task Management','page' => 'Status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Task Management','points' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(auth()->user()->points ?? 0),'section' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Task Management'),'page' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Status')]); ?>
    <div class="max-w-[1600px] mx-auto px-6 font-inter pb-20"
     x-data="goalsBoard()"
  x-init="
    let saveTimeout = null;
    $watch('modalTask', (newValue) => {
        if (showTaskModal && modalAutoSaveEnabled && newValue.id) {
            clearTimeout(saveTimeout);
            saveTimeout = setTimeout(() => saveTaskFromModal(true), 800);
        }
    }, { deep: true });
    $watch('currentView', value => {
        document.getElementById('breadcrumb-page').innerText =
            value === 'status' ? 'Status'
          : value === 'today' ? 'Today'
          : value === 'week' ? 'This Week'
          : 'This Month';
    });
">

        <!-- 📌 Header Section -->
        <div class="mb-10">
            <h1 class="text-4xl font-bold text-gray-900 mb-3 tracking-tight">Your goals, beautifully organized.</h1>
            <p class="text-gray-600 text-base">Progress, designed beautifully.</p>
        </div>

        <!-- 🔹 Filters Bar -->
      <div class="flex items-center gap-1 mb-4 ">

    <!-- Status View -->
    <button
        @click="setView('status')"
        :class="currentView === 'status'
            ? 'bg-[#F6F7F5] text-[#1D1D1E] rounded-full shadow-sm'
            : 'bg-white text-[#817F7B]  rounded-full hover:bg-[#F6F7F5] hover:border-[#F6F7F5]'"
        class="flex items-center px-4 py-2 text-sm font-medium transition-all">
                 <img src="<?php echo e(asset('assets/icons/Dashboard%20icons/Status.svg')); ?>" class="w-6 h-6 min-w-[24px] " alt="icon">

        <span class="px-2">Status </span>
    </button>

    <!-- Today -->
    <button
        @click="setView('today')"
        :class="currentView === 'today'
            ? 'bg-[#F6F7F5] text-[#1D1D1E] rounded-full shadow-sm'
            : 'bg-white text-[#817F7B]  rounded-full hover:bg-[#F6F7F5] hover:border-[#F6F7F5]'"
        class="flex items-center px-4 py-2 text-sm font-medium transition-all">
        <img src="<?php echo e(asset('assets/icons/Dashboard%20icons/today.svg')); ?>" class="w-6 h-6 min-w-[24px] " alt="icon">
        <span class="px-2">Today</span>
    </button>

    <!-- This Week -->
    <button
        @click="setView('week')"
        :class="currentView === 'week'
            ? 'bg-[#F6F7F5] text-[#1D1D1E] rounded-full shadow-sm'
            : 'bg-white text-[#817F7B]  rounded-full hover:bg-[#F6F7F5] hover:border-[#F6F7F5]'"
        class="flex items-center  px-4 py-2 text-sm font-medium transition-all">
         <img src="<?php echo e(asset('assets/icons/Dashboard%20icons/week.svg')); ?>" class="w-6 h-6 min-w-[24px] " alt="icon">
        <span>This week</span>
    </button>

</div>


        <!-- ====================================== -->
        <!-- 📊 STATUS VIEW (Kanban Board) -->
        <!-- ====================================== -->
        <div x-show="currentView === 'status'" class="flex gap-6">
<div class="flex-1 flex gap-6 items-start">
                <!-- NOT STARTED COLUMN -->
                <div class="flex-1 min-w-0 bg-[#fff9f8] rounded-2xl p-5 "
                     x-ref="notStartedCol"

                     @drop.prevent="handleDrop($event, 'not_started')"
                     @dragover.prevent
                     @dragenter.prevent="$el.classList.add('ring-2', 'ring-red-400')"
                     @dragleave.prevent="$el.classList.remove('ring-2', 'ring-red-400')">
     <div class="flex items-center gap-2.5 mb-5">

    <!-- Dot + Texte -->
    <div class="flex items-center gap-2 bg-[#FBDCD9] px-4 py-2 rounded-full shadow-sm">
        <div class="w-2.5 h-2.5 bg-red-500 rounded-full"></div>
        <h3 class="text-sm font-semibold text-[#7C4944] uppercase tracking-wide">Not Started</h3>
    </div>

    <!-- Compteur juste à droite -->


</div>


<div class="space-y-3 sortable-list">
                        <template x-for="goal in allGoals.notStarted" :key="goal.id">
                            <div class="group bg-white border border-red-100 rounded-xl p-5 hover:shadow-lg hover:border-red-300 transition-all duration-200 cursor-move relative"
                            :data-goal-id="goal.id"
                            draggable="true"
                                 @dragstart="handleDragStart($event, goal.id)"
                                 @dragend="handleDragEnd($event)">
                                <div class="flex items-start gap-1 mb-2">
                                    <i class="ri-draggable text-gray-400 cursor-move "></i>
                                    <input type="text"
                                           :value="goal.title"
                                           @change="updateGoal(goal.id, $event.target.value, goal.priority, goal.task_type)"
                                           @click.stop
                                           placeholder="Write your goal here..."
                                           class="flex-1 bg-transparent border-none text-sm text-gray-800 placeholder-gray-400 focus:outline-none font-medium">

                                    <button @click.stop="deleteGoal(goal.id)" class="opacity-0 group-hover:opacity-100 text-gray-400 hover:text-red-600 transition-all">
                                        <i class="ri-delete-bin-line text-base"></i>
                                    </button>
                                </div>

                               <div class="flex items-center gap-1 mt-3 ml-6">

    <!-- Priority Badge -->
    <span class="px-3 py-1 text-[11px] font-semibold rounded-full"
          :class="{
              'bg-green-100 text-green-700 border border-green-300': goal.priority === 'low',
              'bg-yellow-100 text-yellow-700 border border-yellow-300': goal.priority === 'medium',
              'bg-red-100 text-red-700 border border-red-300': goal.priority === 'high',
              'bg-gray-100 text-gray-600 border border-gray-300': !goal.priority
          }">
        <span x-text="goal.priority ? goal.priority.charAt(0).toUpperCase() + goal.priority.slice(1) : 'No Set'"></span>
    </span>

    <!-- Category Badge -->
    <span class="px-3 py-1 text-[11px] font-semibold rounded-full"
          :class="{
              'bg-blue-100 text-blue-700 border border-blue-300': goal.task_type === 'education',
              'bg-purple-100 text-purple-700 border border-purple-300': goal.task_type === 'personal',
              'bg-green-100 text-green-700 border border-green-300': goal.task_type === 'gym',
              'bg-pink-100 text-pink-700 border border-pink-300': goal.task_type === 'creative',
              'bg-orange-100 text-orange-700 border border-orange-300': goal.task_type === 'social',
              'bg-gray-100 text-gray-600 border border-gray-300': !goal.task_type
          }">
        <span x-text="goal.task_type ? goal.task_type.charAt(0).toUpperCase() + goal.task_type.slice(1) : 'No category'"></span>
    </span>

</div>
                            </div>
                        </template>

                        <div x-show="allGoals.notStarted.length === 0" class="text-center py-12 bg-white/50 rounded-xl border border-dashed border-red-200">
                            <i class="ri-inbox-line text-4xl text-red-300 mb-3 block"></i>
                            <p class="text-sm text-red-600">No tasks</p>
                        </div>

                        <button @click="addTask('not_started')" class="w-full text-left px-5 py-4 text-sm text-red-700 font-medium hover:bg-white/60 rounded-xl transition-all border border-dashed border-red-300 hover:border-red-400 flex items-center gap-2 bg-white/40">
                            <i class="ri-add-line text-lg"></i>
                            <span>Add new task</span>
                        </button>
                    </div>
                </div>

                <!-- IN PROGRESS COLUMN -->
                <div class="flex-1 min-w-0 bg-[#F3F8FD] rounded-2xl p-5 "
                     x-ref="inProgressCol"

                     @drop.prevent="handleDrop($event, 'in_progress')"
                     @dragover.prevent
                     @dragenter.prevent="$el.classList.add('ring-2', 'ring-blue-400')"
                     @dragleave.prevent="$el.classList.remove('ring-2', 'ring-blue-400')">
                    <div class="flex items-center gap-2.5 mb-5">

    <div class="flex items-center gap-2 bg-[#CEE6F7] px-4 py-2 rounded-full shadow-sm">
        <div class="w-2.5 h-2.5 bg-[#2382E3] rounded-full"></div>
        <h3 class="text-sm font-semibold text-[#2A4F76] uppercase tracking-wide">In Progress</h3>
    </div>



</div>


<div class="space-y-3 sortable-list">
                        <template x-for="goal in allGoals.inProgress" :key="goal.id">
                            <div class="group bg-white border border-blue-100 rounded-xl p-5 hover:shadow-lg hover:border-blue-300 transition-all duration-200 cursor-move relative"
                            :data-goal-id="goal.id"
                            draggable="true"
                                 @dragstart="handleDragStart($event, goal.id)"
                                 @dragend="handleDragEnd($event)">
                                <div class="flex items-start gap-1 mb-3">
                                    <i class="ri-draggable text-gray-400 cursor-move "></i>
                                    <input type="text"
                                           :value="goal.title"
                                             @change="updateGoal(goal.id, $event.target.value, goal.priority, goal.task_type)"
                                           @click.stop
                                           placeholder="Write your goal here..."
                                           class="flex-1 bg-transparent border-none text-sm text-gray-800 placeholder-gray-400 focus:outline-none font-medium">

                                    <button @click.stop="deleteGoal(goal.id)" class="opacity-0 group-hover:opacity-100 text-gray-400 hover:text-red-600 transition-all">
                                        <i class="ri-delete-bin-line text-base"></i>
                                    </button>
                                </div>

                                 <div class="flex items-center gap-1 mt-3 ml-6">

    <!-- Priority Badge -->
    <span class="px-3 py-1 text-[11px] font-semibold rounded-full"
          :class="{
              'bg-green-100 text-green-700 border border-green-300': goal.priority === 'low',
              'bg-yellow-100 text-yellow-700 border border-yellow-300': goal.priority === 'medium',
              'bg-red-100 text-red-700 border border-red-300': goal.priority === 'high',
              'bg-gray-100 text-gray-600 border border-gray-300': !goal.priority
          }">
        <span x-text="goal.priority ? goal.priority.charAt(0).toUpperCase() + goal.priority.slice(1) : 'No Set'"></span>
    </span>

    <!-- Category Badge -->
    <span class="px-3 py-1 text-[11px] font-semibold rounded-full"
          :class="{
              'bg-blue-100 text-blue-700 border border-blue-300': goal.task_type === 'education',
              'bg-purple-100 text-purple-700 border border-purple-300': goal.task_type === 'personal',
              'bg-green-100 text-green-700 border border-green-300': goal.task_type === 'gym',
              'bg-pink-100 text-pink-700 border border-pink-300': goal.task_type === 'creative',
              'bg-orange-100 text-orange-700 border border-orange-300': goal.task_type === 'social',
              'bg-gray-100 text-gray-600 border border-gray-300': !goal.task_type
          }">
        <span x-text="goal.task_type ? goal.task_type.charAt(0).toUpperCase() + goal.task_type.slice(1) : 'No category'"></span>
    </span>

</div>
                            </div>
                        </template>

                        <div x-show="allGoals.inProgress.length === 0" class="text-center py-12 bg-white/50 rounded-xl border border-dashed border-blue-200">
                            <i class="ri-loader-line text-4xl text-blue-300 mb-3 block"></i>
                            <p class="text-sm text-blue-600">No tasks</p>
                        </div>

                        <button @click="addTask('in_progress')" class="w-full text-left px-5 py-4 text-sm text-blue-700 font-medium hover:bg-white/60 rounded-xl transition-all border border-dashed border-blue-300 hover:border-blue-400 flex items-center gap-2 bg-white/40">
                            <i class="ri-add-line text-lg"></i>
                            <span>Add new task</span>
                        </button>
                    </div>
                </div>

                <!-- DONE COLUMN -->
                <div class="flex-1 min-w-0 bg-[#F6F9F7] rounded-2xl p-5 "
                     x-ref="doneCol"

                     @drop.prevent="handleDrop($event, 'done')"
                     @dragover.prevent
                     @dragenter.prevent="$el.classList.add('ring-2', 'ring-green-400')"
                     @dragleave.prevent="$el.classList.remove('ring-2', 'ring-green-400')">

                     <div class="flex items-center gap-2.5 mb-5">

    <div class="flex items-center gap-2 bg-[#DBECDD] px-4 py-2 rounded-full shadow-sm">
        <div class="w-2.5 h-2.5 bg-[#5F9873] rounded-full"></div>
        <h3 class="text-sm font-semibold text-[#436653] uppercase tracking-wide">Done</h3>
    </div>



</div>


<div class="space-y-3 sortable-list">
                        <template x-for="goal in allGoals.done" :key="goal.id">
                            <div class="group bg-white border border-green-100 rounded-xl p-5 hover:shadow-lg hover:border-green-300 transition-all duration-200 cursor-move relative opacity-95"
                                 draggable="true"
                                 :data-goal-id="goal.id"
                                 @dragstart="handleDragStart($event, goal.id)"
                                 @dragend="handleDragEnd($event)">
                                <div class="flex items-start gap-1 mb-3">
                                    <i class="ri-draggable text-gray-400 cursor-move "></i>
                                    <input type="text"
                                           :value="goal.title"
                                             @change="updateGoal(goal.id, $event.target.value, goal.priority, goal.task_type)"
                                           @click.stop
                                           placeholder="Write your goal here..."
                                           class="flex-1 bg-transparent border-none text-sm text-gray-600 placeholder-gray-400 focus:outline-none font-medium ">

                                    <button @click.stop="deleteGoal(goal.id)" class="opacity-0 group-hover:opacity-100 text-gray-400 hover:text-red-600 transition-all">
                                        <i class="ri-delete-bin-line text-base"></i>
                                    </button>
                                </div>

                                  <div class="flex items-center gap-1 mt-3 ml-6">

    <!-- Priority Badge -->
    <span class="px-3 py-1 text-[11px] font-semibold rounded-full"
          :class="{
              'bg-green-100 text-green-700 border border-green-300': goal.priority === 'low',
              'bg-yellow-100 text-yellow-700 border border-yellow-300': goal.priority === 'medium',
              'bg-red-100 text-red-700 border border-red-300': goal.priority === 'high',
              'bg-gray-100 text-gray-600 border border-gray-300': !goal.priority
          }">
        <span x-text="goal.priority ? goal.priority.charAt(0).toUpperCase() + goal.priority.slice(1) : 'No Set'"></span>
    </span>

    <!-- Category Badge -->
    <span class="px-3 py-1 text-[11px] font-semibold rounded-full"
          :class="{
              'bg-blue-100 text-blue-700 border border-blue-300': goal.task_type === 'education',
              'bg-purple-100 text-purple-700 border border-purple-300': goal.task_type === 'personal',
              'bg-green-100 text-green-700 border border-green-300': goal.task_type === 'gym',
              'bg-pink-100 text-pink-700 border border-pink-300': goal.task_type === 'creative',
              'bg-orange-100 text-orange-700 border border-orange-300': goal.task_type === 'social',
              'bg-gray-100 text-gray-600 border border-gray-300': !goal.task_type
          }">
        <span x-text="goal.task_type ? goal.task_type.charAt(0).toUpperCase() + goal.task_type.slice(1) : 'No category'"></span>
    </span>

</div>
                            </div>
                        </template>

                        <div x-show="allGoals.done.length === 0" class="text-center py-12 bg-white/50 rounded-xl border border-dashed border-green-200">
                            <i class="ri-checkbox-circle-line text-4xl text-green-300 mb-3 block"></i>
                            <p class="text-sm text-green-600">No completed tasks</p>
                        </div>

                        <button @click="addTask('done')" class="w-full text-left px-5 py-4 text-sm text-green-700 font-medium hover:bg-white/60 rounded-xl transition-all border border-dashed border-green-300 hover:border-green-400 flex items-center gap-2 bg-white/40">
                            <i class="ri-add-line text-lg"></i>
                            <span>Add completed task</span>
                        </button>
                    </div>
                </div>
            </div>

            <!-- PROGRESS SIDEBAR -->
            <div class="w-80 flex-shrink-0">
                <div class="bg-gradient-to-br from-white to-gray-50 rounded-2xl p-7 border border-gray-200 shadow-lg sticky top-6">
                    <div class="flex items-center justify-between mb-6">
                        <h3 class="text-xl font-bold text-gray-900">Progress</h3>
                    </div>

                    <div class="space-y-5">
                        <div>
                            <h4 class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-4">Task Completion</h4>

                            <div class="mb-5 p-4 bg-white rounded-xl border border-gray-200">
                                <div class="flex items-center justify-between mb-2">
                                    <div class="flex items-center gap-2">
                                        <i class="ri-sun-line text-yellow-500 text-lg"></i>
                                        <span class="text-sm font-semibold text-gray-700">Today</span>
                                    </div>
                                    <span class="text-lg font-bold text-gray-900"><?php echo e($todayProgress); ?>%</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-3 overflow-hidden">
                                    <div class="bg-gradient-to-r from-green-400 to-green-600 h-3 rounded-full transition-all duration-500 shadow-sm"
                                         style="width: <?php echo e($todayProgress); ?>%"></div>
                                </div>
                            </div>

                            <div class="mb-5 p-4 bg-white rounded-xl border border-gray-200">
                                <div class="flex items-center justify-between mb-2">
                                    <div class="flex items-center gap-2">
                                        <i class="ri-calendar-week-line text-blue-500 text-lg"></i>
                                        <span class="text-sm font-semibold text-gray-700">This Week</span>
                                    </div>
                                    <span class="text-lg font-bold text-gray-900"><?php echo e($weekProgress); ?>%</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-3 overflow-hidden">
                                    <div class="bg-gradient-to-r from-blue-400 to-blue-600 h-3 rounded-full transition-all duration-500 shadow-sm"
                                         style="width: <?php echo e($weekProgress); ?>%"></div>
                                </div>
                            </div>

                            <div class="p-4 bg-white rounded-xl border border-gray-200">
                                <div class="flex items-center justify-between mb-2">
                                    <div class="flex items-center gap-2">
                                        <i class="ri-calendar-2-line text-purple-500 text-lg"></i>
                                        <span class="text-sm font-semibold text-gray-700">This Month</span>
                                    </div>
                                    <span class="text-lg font-bold text-gray-900"><?php echo e($monthProgress); ?>%</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-3 overflow-hidden">
                                    <div class="bg-gradient-to-r from-purple-400 to-purple-600 h-3 rounded-full transition-all duration-500 shadow-sm"
                                         style="width: <?php echo e($monthProgress); ?>%"></div>
                                </div>
                            </div>
                        </div>

                        <div class="pt-5 border-t border-gray-200">
                            <div class="grid grid-cols-3 gap-1 text-center">
                                <div class="bg-white rounded-lg p-3 border border-gray-200">
                                    <div class="text-2xl font-bold text-red-600" x-text="allGoals.notStarted.length"></div>
                                    <div class="text-xs text-gray-500 mt-1">To Start</div>
                                </div>
                                <div class="bg-white rounded-lg p-3 border border-gray-200">
                                    <div class="text-2xl font-bold text-blue-600" x-text="allGoals.inProgress.length"></div>
                                    <div class="text-xs text-gray-500 mt-1">Active</div>
                                </div>
                                <div class="bg-white rounded-lg p-3 border border-gray-200">
                                    <div class="text-2xl font-bold text-green-600" x-text="allGoals.done.length"></div>
                                    <div class="text-xs text-gray-500 mt-1">Done</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- ====================================== -->
        <!-- 📋 PROFESSIONAL TABLE VIEW (Today/Week/Month) -->
        <!-- ====================================== -->
        <div x-show="currentView !== 'status'">
            <div class="bg-gradient-to-br from-white to-gray-50 rounded-2xl border border-gray-200 shadow-sm overflow-hidden">
                <!-- Header with Stats -->
              <div class="bg-gradient-to-br from-blue-50 to-blue-100 px-8 py-6 border-b border-blue-200">
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold text-blue-900 mb-1" x-text="currentView === 'today' ? 'Today\'s Tasks' : currentView === 'week' ? 'This Week\'s Tasks' : 'This Month\'s Tasks'">Today's Tasks</h2>
            <p class="text-blue-600 text-sm" x-text="`${filteredGoals.length} task${filteredGoals.length !== 1 ? 's' : ''} scheduled`">0 tasks scheduled</p>
        </div>
        <button @click="addTaskToView()" class="flex items-center gap-2 px-5 py-2.5 bg-[#F6F7F5] text-gray-900 rounded-lg hover:bg-[#F6F7F5] transition-all text-sm font-semibold ">
            <i class="ri-add-circle-line text-lg"></i>
            <span>New Task</span>
        </button>
    </div>
    <!-- Quick Stats -->
    <div class="grid grid-cols-3 gap-4 mt-6">
        <div class="bg-white rounded-xl p-4 border border-blue-200 shadow-sm">
            <div class="flex items-center gap-1">
                <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center">
                    <i class="ri-circle-line text-red-500 text-xl"></i>
                </div>
                <div>
                    <div class="text-2xl font-bold text-gray-900" x-text="filteredGoals.filter(g => g.status === 'not_started').length">0</div>
                    <div class="text-xs text-gray-600 font-medium">Not Started</div>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-xl p-4 border border-blue-200 shadow-sm">
            <div class="flex items-center gap-1">
                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                    <i class="ri-loader-4-line text-blue-500 text-xl"></i>
                </div>
                <div>
                    <div class="text-2xl font-bold text-gray-900" x-text="filteredGoals.filter(g => g.status === 'in_progress').length">0</div>
                    <div class="text-xs text-gray-600 font-medium">In Progress</div>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-xl p-4 border border-blue-200 shadow-sm">
            <div class="flex items-center gap-1">
                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                    <i class="ri-checkbox-circle-line text-green-500 text-xl"></i>
                </div>
                <div>
                    <div class="text-2xl font-bold text-gray-900" x-text="filteredGoals.filter(g => g.status === 'done').length">0</div>
                    <div class="text-xs text-gray-600 font-medium">Completed</div>
                </div>
            </div>
        </div>
    </div>
</div>
                <!-- Table Content -->
                <div class="p-6">
                    <div class="bg-white rounded-xl border border-gray-200 overflow-hidden shadow-sm">
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead>
                                    <tr class="bg-gray-50 border-b border-gray-200">
                                        <th class="px-6 py-4 text-left">
                                            <div class="flex items-center gap-2 text-xs font-bold text-gray-600 uppercase tracking-wider">
                                                <i class="ri-file-list-3-line text-base text-gray-500"></i>
                                                <span>Task</span>
                                            </div>
                                        </th>
                                        <th class="px-6 py-4 text-left">
                                            <div class="flex items-center gap-2 text-xs font-bold text-gray-600 uppercase tracking-wider">
                                                <i class="ri-progress-3-line text-base text-gray-500"></i>
                                                <span>Status</span>
                                            </div>
                                        </th>
                                        <th class="px-6 py-4 text-left">
                                            <div class="flex items-center gap-2 text-xs font-bold text-gray-600 uppercase tracking-wider">
                                                <i class="ri-flag-2-line text-base text-gray-500"></i>
                                                <span>Priority</span>
                                            </div>
                                        </th>
                                        <th class="px-6 py-4 text-left">
                                            <div class="flex items-center gap-2 text-xs font-bold text-gray-600 uppercase tracking-wider">
                                                <i class="ri-bookmark-line text-base text-gray-500"></i>
                                                <span>Category</span>
                                            </div>
                                        </th>
                                        <th class="px-6 py-4 text-center">
                                            <div class="flex items-center justify-center gap-2 text-xs font-bold text-gray-600 uppercase tracking-wider">
                                                <i class="ri-settings-3-line text-base text-gray-500"></i>
                                                <span>Actions</span>
                                            </div>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-100">
                                    <template x-for="goal in filteredGoals" :key="goal.id">
                                       <tr class="hover:bg-gray-50 transition-colors group h-[50px]">
                                            <!-- Task -->
                                           <td class="px-6 py-2">
    <div class="flex items-center gap-1">
        <div class="w-1.5 h-1.5 rounded-full flex-shrink-0"
             :class="{
                 'bg-red-500': goal.status === 'not_started',
                 'bg-blue-500': goal.status === 'in_progress',
                 'bg-green-500': goal.status === 'done'
             }"></div>
        <input type="text"
               :value="goal.title"
               @change="updateGoal(goal.id, $event.target.value, goal.priority, goal.task_type)"
               placeholder="Task name..."
               class="flex-1 bg-transparent border-none text-sm text-gray-800 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 rounded-lg px-3 py-2 font-medium"
               :class="goal.status === 'done' ? '' : ''">

        <!-- Bouton pour ouvrir le modal -->
 <button @click.stop="openTaskModal(goal.status, goal)"
    class="opacity-0 group-hover:opacity-100 group border flex items-center gap-1 flex-shrink-0 p-1 text-text-black hover:text-black rounded-lg transition-all"
    title="View details">

    <img src="<?php echo e(asset('assets/icons/Dashboard icons/dock-left.svg')); ?>"
         class="w-5 h-5 min-w-[20px] transition duration-200
                invert group-hover:invert-0 group-hover:brightness-0"
         alt="icon">

    <span class="text-sm font-medium">Open</span>
</button>


    </div>
</td>

                                            <!-- Status -->
                                 <td class="px-6 py-2">
  <div x-data="{
        open: false,
        selected: goal.status,
        top: 0,
        left: 0,
        width: 0,
        showAbove: false,

        toggle(event) {
            this.open = !this.open;

            if (this.open) {
                let rect = event.target.getBoundingClientRect();
                this.width = rect.width;
                this.left = rect.left;

                let spaceBottom = window.innerHeight - rect.bottom;
                this.showAbove = spaceBottom < 140;

                this.top = this.showAbove
                    ? rect.top - 140
                    : rect.bottom;
            }
        },

        select(v) {
            this.selected = v;
            this.open = false;
            moveGoal(goal.id, v);
        }
    }"
    x-init="
        window.addEventListener('close-dropdowns', () => open = false);
        window.addEventListener('scroll', () => { open = false });
    "
    @click.away="open = false"
    class='relative'
>

        <!-- Button -->
        <button @click="toggle($event)"
                class=" px-3 py-2 rounded-full flex items-center gap-1 font-medium text-[12px] cursor-pointer transition "
                :class="{
                    'bg-[#CEE6F7] text-[#2A4F76]': selected==='in_progress',
                    'bg-[#DBECDD] text-[#436653] ': selected==='done',
                    'bg-[#FBDCD9] text-[#7C4944] ': selected==='not_started',
                }">

            <div class="w-2 h-2 rounded-full"
                :class="{
                    'bg-[#2382E3]': selected==='in_progress',
                    'bg-[#5F9873]': selected==='done',
                    'bg-[#E26154]': selected==='not_started',
                }"></div>

            <span>
                <span x-show="selected==='in_progress'">In progress</span>
                <span x-show="selected==='done'">Well done</span>
                <span x-show="selected==='not_started'">Not started</span>
            </span>
        </button>


        <!-- DROPDOWN -->
      <div x-show="open"
     x-transition
     class="fixed bg-white shadow-xl rounded-xl border p-2 space-y-1 z-[9999]"
     :style="`top: ${top}px; left: ${left}px; width: 200px`"
     @click.away="open = false">

    <!-- In progress -->



<div class="flex items-center gap-1">

    <!-- Icône à gauche (alignée) -->
    <i class="ri-draggable text-gray-400 text-lg"></i>

    <!-- Bouton arrondi -->
    <div @click="select('in_progress')"
         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-[#CEE6F7] w-40">

      <div class="w-3 h-3 rounded-full bg-blue-600"></div>

        <span class="text-sm font-medium text-[#2A4F76]">In progress</span>
    </div>



</div>



<div class="flex items-center gap-1">

    <!-- Icône à gauche (alignée) -->
    <i class="ri-draggable text-gray-400 text-lg"></i>

    <!-- Bouton arrondi -->
    <div @click="select('done')"
         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-[#DBECDD] w-40">

         <div class="w-3 h-3 rounded-full bg-green-600"></div>

        <span class="text-sm font-medium text-[#436653]">Well done</span>
    </div>



</div>


<div class="flex items-center gap-1">

    <!-- Icône à gauche (alignée) -->
    <i class="ri-draggable text-gray-400 text-lg"></i>

    <!-- Bouton arrondi -->
    <div @click="select('not_started')"
         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-red-50 w-40">

        <div class="w-3 h-3 rounded-full bg-red-600"></div>

        <span class="text-sm font-medium text-red-700">Not started</span>
    </div>



</div>
</div>
</div>

</td>


                                            <!-- Priority -->
                               <td class="px-6 py-2">
    <div x-data="{
            open: false,
            selected: goal.priority,
            top: 0,
            left: 0,
            width: 0,
            showAbove: false,

            toggle(event) {
                this.open = !this.open;

                if (this.open) {
                    let rect = event.target.getBoundingClientRect();

                    this.width = rect.width;
                    this.left = rect.left;

                    let spaceBottom = window.innerHeight - rect.bottom;
                    this.showAbove = spaceBottom < 140;

                    this.top = this.showAbove
                        ? rect.top - 140
                        : rect.bottom;
                }
            },

            select(v) {
                this.selected = v;
                this.open = false;
                updateGoal(goal.id, goal.title, v, goal.task_type);
            }
        }"
        x-init="
           window.addEventListener('close-dropdowns', () => open = false);
            window.addEventListener('scroll', () => { open = false });
        "
        @click.away="open = false"
        class="relative">

        <!-- Button -->
        <button @click="toggle($event)"
                class=" px-3 py-2 rounded-full flex items-center gap-1 font-medium text-[12px] cursor-pointer transition border"
                :class="{
                    'bg-[#DBECDD] text-[#436653] border-[#DBECDD]': selected==='low',
                    'bg-[#F2E3B7] text-[#685C41] border-[#F2E3B7]': selected==='medium',
                    'bg-[#FBDCD9] text-[#7C4944] border-[#FBDCD9]': selected==='high',
                    'bg-gray-100 text-gray-600 border-gray-200': !selected
                }">

            <div class="w-2 h-2 rounded-full"
                :class="{
                    'bg-[#5F9873]': selected==='low',
                    'bg-[#D8A32F]': selected==='medium',
                    'bg-[#E26154]': selected==='high',
                    'bg-gray-400': !selected
                }"></div>

            <span>
                <span x-show="selected==='low'">Low </span>
                <span x-show="selected==='medium'">Medium </span>
                <span x-show="selected==='high'">High </span>
                <span x-show="!selected">Not set</span>
            </span>
        </button>

        <!-- DROPDOWN -->
        <div x-show="open"
             x-transition
             class="fixed bg-white shadow-xl rounded-xl border p-2 space-y-1 z-[9999]"
             :style="`top: ${top}px; left: ${left}px; width: 200px`"
             @click.away="open = false">

            <!-- Low -->
            <div class="flex items-center gap-1">
                <i class="ri-draggable text-gray-400 text-lg"></i>
                <div @click="select('low')"
                     class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-[#DBECDD] w-40">
                    <div class="w-3 h-3 rounded-full bg-[#5F9873]"></div>
                    <span class="text-sm font-medium text-[#436653]">Low </span>
                </div>
            </div>

            <!-- Medium -->
            <div class="flex items-center gap-1">
                <i class="ri-draggable text-gray-400 text-lg"></i>
                <div @click="select('medium')"
                     class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-[#F2E3B7] w-40">
                    <div class="w-3 h-3 rounded-full bg-[#D8A32F]"></div>
                    <span class="text-sm font-medium text-[#685C41]">Medium </span>
                </div>
            </div>

            <!-- High -->
            <div class="flex items-center gap-1">
                <i class="ri-draggable text-gray-400 text-lg"></i>
                <div @click="select('high')"
                     class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-[#FBDCD9] w-40">
                    <div class="w-3 h-3 rounded-full bg-[#E26154]"></div>
                    <span class="text-sm font-medium text-[#7C4944]">High </span>
                </div>
            </div>
        </div>
    </div>
</td>


                                            <!-- Category -->
                               <td class="px-6 py-2">
    <div x-data="{
            open: false,
            selected: goal.task_type,
            top: 0,
            left: 0,
            width: 0,
            showAbove: false,

            toggle(event) {
                this.open = !this.open;

                if (this.open) {
                    let rect = event.target.getBoundingClientRect();

                    this.width = rect.width;
                    this.left = rect.left;

                    let spaceBottom = window.innerHeight - rect.bottom;
                    this.showAbove = spaceBottom < 180;

                    this.top = this.showAbove
                        ? rect.top - 180
                        : rect.bottom;
                }
            },

            select(v) {
                this.selected = v;
                this.open = false;
                updateGoal(goal.id, goal.title, goal.priority, v);
            }
        }"
        x-init="
           window.addEventListener('close-dropdowns', () => open = false);
            window.addEventListener('scroll', () => { open = false });
        "
        @click.away="open = false"
        class="relative">

        <!-- Button -->
        <button @click="toggle($event)"
                class=" px-3 py-2 rounded-full flex items-center gap-1 font-medium text-[12px] cursor-pointer transition border"
                :class="{
                    'bg-[#CEE6F7] text-[#2A4F76] border-blue-200': selected==='education',
                    'bg-purple-100 text-purple-800 border-purple-200': selected==='personal',
                    'bg-[#DBECDD] text-[#436653] border-green-200': selected==='gym',
                    'bg-[#FBDCD9] text-[#7C4944] border-pink-200': selected==='creative',
                    'bg-orange-100 text-orange-800 border-orange-200': selected==='social',
                    'bg-gray-100 text-gray-600 border-gray-200': !selected
                }">

            <div class="w-2 h-2 rounded-full"
                :class="{
                    'bg-[#2382E3]': selected==='education',
                    'bg-purple-500': selected==='personal',
                    'bg-[#5F9873]': selected==='gym',
                    'bg-[#E26154]': selected==='creative',
                    'bg-orange-500': selected==='social',
                    'bg-gray-400': !selected
                }"></div>

            <span>
                <span x-show="selected==='education'"> Education</span>
                <span x-show="selected==='personal'"> Personal</span>
                <span x-show="selected==='gym'"> Gym</span>
                <span x-show="selected==='creative'"> Creative</span>
                <span x-show="selected==='social'"> Social</span>
                <span x-show="!selected">No category</span>
            </span>
        </button>

        <!-- DROPDOWN -->
        <div x-show="open"
             x-transition
             class="fixed bg-white shadow-xl rounded-xl border p-2 space-y-1 z-[9999]"
             :style="`top: ${top}px; left: ${left}px; width: 200px`"
             @click.away="open = false">

            <!-- Education -->
            <div class="flex items-center gap-1">
                <i class="ri-draggable text-gray-400 text-lg"></i>
                <div @click="select('education')"
                     class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-blue-100 w-40">
                    <div class="w-3 h-3 rounded-full bg-blue-500"></div>
                    <span class="text-sm font-medium text-blue-800"> Education</span>
                </div>
            </div>

            <!-- Personal -->
            <div class="flex items-center gap-1">
                <i class="ri-draggable text-gray-400 text-lg"></i>
                <div @click="select('personal')"
                     class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-purple-100 w-40">
                    <div class="w-3 h-3 rounded-full bg-purple-500"></div>
                    <span class="text-sm font-medium text-purple-800"> Personal</span>
                </div>
            </div>

            <!-- Gym -->
            <div class="flex items-center gap-1">
                <i class="ri-draggable text-gray-400 text-lg"></i>
                <div @click="select('gym')"
                     class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-green-100 w-40">
                    <div class="w-3 h-3 rounded-full bg-green-500"></div>
                    <span class="text-sm font-medium text-green-800"> Gym</span>
                </div>
            </div>

            <!-- Creative -->
            <div class="flex items-center gap-1">
                <i class="ri-draggable text-gray-400 text-lg"></i>
                <div @click="select('creative')"
                     class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-pink-100 w-40">
                    <div class="w-3 h-3 rounded-full bg-pink-500"></div>
                    <span class="text-sm font-medium text-pink-800">Creative</span>
                </div>
            </div>

            <!-- Social -->
            <div class="flex items-center gap-1">
                <i class="ri-draggable text-gray-400 text-lg"></i>
                <div @click="select('social')"
                     class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-orange-100 w-40">
                    <div class="w-3 h-3 rounded-full bg-orange-500"></div>
                    <span class="text-sm font-medium text-orange-800"> Social</span>
                </div>
            </div>
        </div>
    </div>
</td>


                                            <!-- Actions -->
                                            <td class="px-6 py-2">
                                                <div class="flex items-center justify-center">
                                                    <button @click="deleteGoal(goal.id)"
                                                            class="p-2 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition-all opacity-0 group-hover:opacity-100">
                                                        <i class="ri-delete-bin-6-line text-lg"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    </template>
                                </tbody>
                            </table>

                            <!-- Empty State -->
                            <div x-show="filteredGoals.length === 0" class="text-center py-20">
                                <div class="inline-flex items-center justify-center w-20 h-20 bg-gray-100 rounded-full mb-4">
                                    <i class="ri-inbox-line text-4xl text-gray-400"></i>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2">No tasks for this period</h3>
                                <p class="text-gray-500 text-sm mb-6">Get started by creating your first task</p>
                                <button @click="addTaskToView()" class="inline-flex items-center gap-2 px-5 py-2.5 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition-all text-sm font-semibold">
                                    <i class="ri-add-line text-lg"></i>
                                    <span>Create Task</span>
                                </button>
                            </div>

                            <!-- MODAL DÉTAILLÉ STYLE ASANA/NOTION -->
<div x-show="showTaskModal"
     x-cloak
     @click.self="closeModal()"
     class="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-50 p-4">

    <div @click.stop
         class="bg-white rounded-2xl shadow-2xl w-full max-w-4xl max-h-[90vh] overflow-hidden"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 scale-95"
         x-transition:enter-end="opacity-100 scale-100">

        <!-- HEADER avec checkbox de completion -->
        <div class="px-8 py-6 border-b border-gray-200 bg-gradient-to-r from-gray-50 to-white">
            <div class="flex items-start gap-4">
                <!-- Checkbox de completion -->
                <button @click="modalTask.status = modalTask.status === 'done' ? 'in_progress' : 'done'"
                        class="mt-1 w-8 h-8 rounded-full border-2 flex items-center justify-center transition-all"
                        :class="modalTask.status === 'done'
                            ? 'bg-green-500 border-green-500'
                            : 'border-gray-300 hover:border-green-500'">
                    <i x-show="modalTask.status === 'done'" class="ri-check-line text-white text-xl"></i>
                </button>

                <div class="flex-1">
                    <!-- Titre éditable -->
                    <input type="text"
                           x-model="modalTask.title"
                           placeholder="Task name..."
                           class="text-2xl font-bold text-gray-900 w-full bg-transparent border-none focus:outline-none focus:ring-0 p-0 mb-3"
                           :class="modalTask.status === 'done' ? '' : ''">

                    <!-- Métadonnées en ligne -->
                    <div class="flex items-center gap-6 text-sm">


                        <!-- Status -->
                        <div class="flex items-center gap-2">
                            <i class="ri-progress-3-line text-gray-400"></i>
                            <span class="text-gray-600">Status</span>

                            <div x-data="{
    open: false,
    selected: modalTask.status,
    top: 0,
    left: 0,
    width: 0,
    showAbove: false,

    toggle(event) {
        window.dispatchEvent(new CustomEvent('close-dropdowns'));
        this.open = !this.open;

        if (this.open) {
            let rect = event.target.getBoundingClientRect();
            this.width = rect.width;
            this.left = rect.left;
            let spaceBottom = window.innerHeight - rect.bottom;
            this.showAbove = spaceBottom < 140;
            this.top = this.showAbove ? rect.top - 140 : rect.bottom;
        }
    },

    select(v) {
        this.selected = v;
        modalTask.status = v;
        this.open = false;
    }
}"
x-init="
    $watch('modalTask.status', value => selected = value);
    window.addEventListener('close-dropdowns', () => open = false);
    window.addEventListener('scroll', () => open = false);
"
@click.away="open = false"
class="relative"
>


                                <!-- Button -->
<button @click.stop="toggle($event)"
                                        class="px-4 py-1.5 rounded-full flex items-center gap-1 font-medium text-sm cursor-pointer transition border"
                                        :class="{
                                            'bg-blue-100 text-[#2A4F76] border-blue-200': selected==='in_progress',
                                            'bg-green-100 text-[#436653] border-green-200': selected==='done',
                                            'bg-red-100 text-[#7C4944] border-red-200': selected==='not_started',
                                        }">

                                    <div class="w-3 h-3 rounded-full"
                                        :class="{
                                            'bg-[#CEE6F7]': selected==='in_progress',
                                            'bg-[#436653]': selected==='done',
                                            'bg-[#E26154]': selected==='not_started',
                                        }"></div>

                                    <span>
                                        <span x-show="selected==='in_progress'">In progress</span>
                                        <span x-show="selected==='done'">Well done</span>
                                        <span x-show="selected==='not_started'">Not started</span>
                                    </span>
                                </button>

                                <!-- DROPDOWN -->
                                <div x-show="open"
                                     x-transition
                                     class="fixed bg-white shadow-xl rounded-xl border p-2 space-y-1 z-[9999]"
                                     :style="`top: ${top}px; left: ${left}px; width: 200px`"
                                     @click.away="open = false">

                                    <!-- In progress -->
                                    <div class="flex items-center gap-1">
                                        <i class="ri-draggable text-gray-400 text-lg"></i>
                                        <div @click="select('in_progress')"
                                             class="flex items-center gap-1 px-2 py-2 rounded-full cursor-pointer bg-[#CEE6F7] w-40">
                                            <div class="w-3 h-3 rounded-full bg-blue-600"></div>
                                            <span class="text-sm font-medium text-[#2A4F76]">In progress</span>
                                        </div>
                                    </div>

                                    <!-- Done -->
                                    <div class="flex items-center gap-1">
                                        <i class="ri-draggable text-gray-400 text-lg"></i>
                                        <div @click="select('done')"
                                             class="flex items-center gap-1 px-2 py-2 rounded-full cursor-pointer bg-[#DBECDD] w-40">
                                            <div class="w-3 h-3 rounded-full bg-green-600"></div>
                                            <span class="text-sm font-medium text-[#436653]">Well done</span>
                                        </div>
                                    </div>

                                    <!-- Not started -->
                                    <div class="flex items-center gap-1">
                                        <i class="ri-draggable text-gray-400 text-lg"></i>
                                        <div @click="select('not_started')"
                                             class="flex items-center gap-1 px-2 py-2 rounded-full cursor-pointer bg-red-50 w-40">
                                            <div class="w-3 h-3 rounded-full bg-red-600"></div>
                                            <span class="text-sm font-medium text-red-700">Not started</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Due Date -->
                        <div class="flex items-center gap-2">
                            <i class="ri-calendar-line text-gray-400"></i>
                            <span class="text-gray-600">Due date</span>
                            <input type="date"
                                   x-model="modalTask.due_date"
                                   class="px-3 py-1 bg-gray-100 border-none rounded-lg text-sm font-medium cursor-pointer focus:outline-none focus:ring-2 focus:ring-indigo-500">
                        </div>


                    </div>
                </div>

                <!-- Close button -->
                <button @click="closeModal()"
        class="text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg p-2 transition-all">
    <i class="ri-close-line text-2xl"></i>
</button>
            </div>
        </div>

        <!-- BODY: 2 colonnes -->
        <div class="flex h-[calc(90vh-200px)]">
            <!-- COLONNE GAUCHE: Contenu principal -->
<div class="flex-1 overflow-y-auto px-8 py-6 space-y-6"
     @scroll="window.dispatchEvent(new CustomEvent('close-dropdowns'))"
     @click="window.dispatchEvent(new CustomEvent('close-dropdowns'))">
                <!-- Priority & Category en badges -->
                <div class="flex items-center gap-1">
                    <!-- Priority -->
                    <div class="flex items-center gap-2">
                        <i class="ri-flag-2-line text-gray-400 text-sm"></i>
                        <span class="text-gray-600 text-sm">Priority</span>

                        <div x-data="{
                                open: false,
                                selected: modalTask.priority,
                                top: 0,
                                left: 0,
                                width: 0,
                                showAbove: false,

                             toggle(event) {
    window.dispatchEvent(new CustomEvent('close-dropdowns'));
    this.open = !this.open;
    if (this.open) {
                                        let rect = event.target.getBoundingClientRect();
                                        this.width = rect.width;
                                        this.left = rect.left;
                                        let spaceBottom = window.innerHeight - rect.bottom;
                                        this.showAbove = spaceBottom < 140;
                                        this.top = this.showAbove ? rect.top - 140 : rect.bottom;
                                    }
                                },

                                select(v) {
                                    this.selected = v;
                                    modalTask.priority = v;
                                    this.open = false;
                                }
                            }"
                           x-init="
    $watch('modalTask.priority', value => selected = value);
    window.addEventListener('close-dropdowns', () => open = false);
"
class="relative">

                            <!-- Button -->
<button @click.stop="toggle($event)"
                                    class="px-4 py-2 rounded-full flex items-center gap-1 font-medium text-xs cursor-pointer transition border"
                                    :class="{
                                        'bg-[#DBECDD] text-[#436653] border-[#DBECDD]': selected==='low',
                                        'bg-[#F2E3B7] text-[#685C41] border-[#F2E3B7]': selected==='medium',
                                        'bg-[#FBDCD9] text-[#7C4944] border-[#FBDCD9]': selected==='high',
                                        'bg-gray-100 text-gray-600 border-gray-200': !selected
                                    }">

                                <div class="w-3 h-3 rounded-full"
                                    :class="{
                                        'bg-[#5F9873]': selected==='low',
                                        'bg-[#D8A32F]': selected==='medium',
                                        'bg-[#E26154]': selected==='high',
                                        'bg-gray-400': !selected
                                    }"></div>

                                <span>
                                    <span x-show="selected==='low'">Low</span>
                                    <span x-show="selected==='medium'">Medium</span>
                                    <span x-show="selected==='high'">High</span>
                                    <span x-show="!selected">Not set</span>
                                </span>
                            </button>

                            <!-- DROPDOWN -->
                            <div x-show="open"
                                 x-transition
                                 class="fixed bg-white shadow-xl rounded-xl border p-2 space-y-1 z-[9999]"
                                 :style="`top: ${top}px; left: ${left}px; width: 200px`"
                                 @click.away="open = false">

                                <!-- Low -->
                                <div class="flex items-center gap-1">
                                    <i class="ri-draggable text-gray-400 text-lg"></i>
                                    <div @click="select('low')"
                                         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-[#DBECDD] w-40">
                                        <div class="w-3 h-3 rounded-full bg-[#5F9873]"></div>
                                        <span class="text-sm font-medium text-[#436653]">Low</span>
                                    </div>
                                </div>

                                <!-- Medium -->
                                <div class="flex items-center gap-1">
                                    <i class="ri-draggable text-gray-400 text-lg"></i>
                                    <div @click="select('medium')"
                                         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-[#F2E3B7] w-40">
                                        <div class="w-3 h-3 rounded-full bg-[#D8A32F]"></div>
                                        <span class="text-sm font-medium text-[#685C41]">Medium</span>
                                    </div>
                                </div>

                                <!-- High -->
                                <div class="flex items-center gap-1">
                                    <i class="ri-draggable text-gray-400 text-lg"></i>
                                    <div @click="select('high')"
                                         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-[#FBDCD9] w-40">
                                        <div class="w-3 h-3 rounded-full bg-[#E26154]"></div>
                                        <span class="text-sm font-medium text-[#7C4944]">High</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Category -->
                    <div class="flex items-center gap-2">
                        <i class="ri-bookmark-line text-gray-400 text-sm"></i>
                        <span class="text-gray-600 text-sm">Category</span>

                        <div x-data="{
                                open: false,
                                selected: modalTask.task_type,
                                top: 0,
                                left: 0,
                                width: 0,
                                showAbove: false,

                                toggle(event) {
    window.dispatchEvent(new CustomEvent('close-dropdowns'));
    this.open = !this.open;
    if (this.open) {
                                        let rect = event.target.getBoundingClientRect();
                                        this.width = rect.width;
                                        this.left = rect.left;
                                        let spaceBottom = window.innerHeight - rect.bottom;
                                        this.showAbove = spaceBottom < 180;
                                        this.top = this.showAbove ? rect.top - 180 : rect.bottom;
                                    }
                                },

                                select(v) {
                                    this.selected = v;
                                    modalTask.task_type = v;
                                    this.open = false;
                                }
                            }"
                           x-init="
    $watch('modalTask.task_type', value => selected = value);
    window.addEventListener('close-dropdowns', () => open = false);
"
class="relative">

                            <!-- Button -->
<button @click.stop="toggle($event)"
                                    class="px-4 py-2 rounded-full flex items-center gap-1 font-medium text-xs cursor-pointer transition border"
                                    :class="{
                                        'bg-blue-100 text-blue-800 border-blue-200': selected==='education',
                                        'bg-purple-100 text-purple-800 border-purple-200': selected==='personal',
                                        'bg-green-100 text-green-800 border-green-200': selected==='gym',
                                        'bg-pink-100 text-pink-800 border-pink-200': selected==='creative',
                                        'bg-orange-100 text-orange-800 border-orange-200': selected==='social',
                                        'bg-gray-100 text-gray-600 border-gray-200': !selected
                                    }">

                                <div class="w-3 h-3 rounded-full"
                                    :class="{
                                        'bg-blue-500': selected==='education',
                                        'bg-purple-500': selected==='personal',
                                        'bg-green-500': selected==='gym',
                                        'bg-pink-500': selected==='creative',
                                        'bg-orange-500': selected==='social',
                                        'bg-gray-400': !selected
                                    }"></div>

                                <span>
                                    <span x-show="selected==='education'">Education</span>
                                    <span x-show="selected==='personal'">Personal</span>
                                    <span x-show="selected==='gym'">Gym</span>
                                    <span x-show="selected==='creative'">Creative</span>
                                    <span x-show="selected==='social'">Social</span>
                                    <span x-show="!selected">No category</span>
                                </span>
                            </button>

                            <!-- DROPDOWN -->
                            <div x-show="open"
                                 x-transition
                                 class="fixed bg-white shadow-xl rounded-xl border p-2 space-y-1 z-[9999]"
                                 :style="`top: ${top}px; left: ${left}px; width: 200px`"
                                 @click.away="open = false">

                                <!-- Education -->
                                <div class="flex items-center gap-1">
                                    <i class="ri-draggable text-gray-400 text-lg"></i>
                                    <div @click="select('education')"
                                         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-blue-100 w-40">
                                        <div class="w-3 h-3 rounded-full bg-blue-500"></div>
                                        <span class="text-sm font-medium text-blue-800">Education</span>
                                    </div>
                                </div>

                                <!-- Personal -->
                                <div class="flex items-center gap-1">
                                    <i class="ri-draggable text-gray-400 text-lg"></i>
                                    <div @click="select('personal')"
                                         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-purple-100 w-40">
                                        <div class="w-3 h-3 rounded-full bg-purple-500"></div>
                                        <span class="text-sm font-medium text-purple-800">Personal</span>
                                    </div>
                                </div>

                                <!-- Gym -->
                                <div class="flex items-center gap-1">
                                    <i class="ri-draggable text-gray-400 text-lg"></i>
                                    <div @click="select('gym')"
                                         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-green-100 w-40">
                                        <div class="w-3 h-3 rounded-full bg-green-500"></div>
                                        <span class="text-sm font-medium text-green-800">Gym</span>
                                    </div>
                                </div>

                                <!-- Creative -->
                                <div class="flex items-center gap-1">
                                    <i class="ri-draggable text-gray-400 text-lg"></i>
                                    <div @click="select('creative')"
                                         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-pink-100 w-40">
                                        <div class="w-3 h-3 rounded-full bg-pink-500"></div>
                                        <span class="text-sm font-medium text-pink-800">Creative</span>
                                    </div>
                                </div>

                                <!-- Social -->
                                <div class="flex items-center gap-1">
                                    <i class="ri-draggable text-gray-400 text-lg"></i>
                                    <div @click="select('social')"
                                         class="flex items-center gap-1 px-4 py-2 rounded-full cursor-pointer bg-orange-100 w-40">
                                        <div class="w-3 h-3 rounded-full bg-orange-500"></div>
                                        <span class="text-sm font-medium text-orange-800">Social</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Task Description -->

                   <div>
                    <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
                        Commentaire
                    </h3>
                    <textarea x-model="modalTask.comment"
                              placeholder="Provide an overview of the task and related details."
                              rows="4"
                              class="w-full px-4 py-3   text-sm text-gray-700"></textarea>
                </div>
                <div>
                    <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
                        Task description
                    </h3>
                    <textarea x-model="modalTask.description"
                              placeholder="Provide an overview of the task and related details."
                              rows="4"
                              class="w-full px-4 py-3     text-sm text-gray-700"></textarea>
                </div>

                <!-- Sub-tasks / Checklist -->
                <div>
                    <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
                        Sub-tasks
                    </h3>
                    <div class="space-y-2">
                        <template x-for="(item, index) in modalTask.checklist" :key="index">
                            <div class="flex items-center gap-1 group hover:bg-gray-50 p-2 rounded-lg transition-colors">
                                <input type="checkbox"
                                       x-model="item.completed"
                                       class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500 cursor-pointer">
                                <input type="text"
                                       x-model="item.text"
                                       placeholder="Tâche"
                                       class="flex-1 bg-transparent border-none text-sm focus:outline-none"
                                       :class="item.completed ? 'line-through text-gray-500' : 'text-gray-700'">
                                <button @click="modalTask.checklist.splice(index, 1)"
                                        class="opacity-0 group-hover:opacity-100 text-red-400 hover:text-red-600 transition-all">
                                    <i class="ri-delete-bin-line text-lg"></i>
                                </button>
                            </div>
                        </template>
                        <button @click="modalTask.checklist.push({ text: '', completed: false })"
                                class="flex items-center gap-2 text-sm text-gray-500 hover:text-indigo-600 hover:bg-indigo-50 px-3 py-2 rounded-lg transition-all">
                            <i class="ri-add-line text-lg"></i>
                            <span>Add sub-task</span>
                        </button>
                    </div>
                </div>


            </div>


        </div>


    </div>
</div>

    <script>
   function goalsBoard() {
    return {
        draggedTaskId: null,
        currentView: localStorage.getItem('goalsView') ?? 'status',
        showTaskModal: false,
        modalTask: {
            id: null,
            title: '',
            description: '',
            comment: '',
            status: 'not_started',
            priority: '',
            task_type: '',
            due_date: '',
            notes: '',
            checklist: []
        },
        modalAutoSaveEnabled: false,

        closeModal() {
            this.showTaskModal = false;
            setTimeout(() => {
                window.location.reload();
            }, 150);
        },

        init() {
            // ✅ Attendre que Alpine ait rendu tous les éléments
            this.$nextTick(() => {
                setTimeout(() => {
                    this.initSortable();
                }, 150);
            });
        },

     initSortable() {
    const self = this;

    const columns = [
        { ref: 'notStartedCol', status: 'not_started' },
        { ref: 'inProgressCol', status: 'in_progress' },
        { ref: 'doneCol', status: 'done' }
    ];

    columns.forEach(col => {
        const columnEl = self.$refs[col.ref];
        if (!columnEl) return;

        const list = columnEl.querySelector('.sortable-list');
        if (!list) return;

        if (list._sortable) {
            list._sortable.destroy();
        }

        list._sortable = new Sortable(list, {
            group: 'goals',
            animation: 200,
            easing: 'cubic-bezier(0.25, 1, 0.5, 1)',

            // ✅ Classes pour les styles visuels
            ghostClass: 'sortable-ghost',
            chosenClass: 'sortable-chosen',
            dragClass: 'sortable-drag',

            handle: '.ri-draggable',
            filter: 'button',
            preventOnFilter: false,

            // ✅ Délai pour éviter les clics accidentels
            delay: 50,
            delayOnTouchOnly: true,

            // ✅ Tolérance pour le swap
            swapThreshold: 0.65,

            onStart: function(evt) {
                document.body.classList.add('is-dragging');
                evt.item.style.opacity = '1';
            },


      onEnd: async function(evt) {
    document.body.classList.remove('is-dragging');

    const goalId = evt.item.dataset.goalId;
    if (!goalId) return;

    // 🔥 SOLUTION : Annuler le déplacement DOM de SortableJS
    // On remet l'élément à sa position originale
    if (evt.from !== evt.to) {
        evt.from.insertBefore(evt.item, evt.from.children[evt.oldIndex] || null);
    }

    let newStatus = col.status;
    const toParent = evt.to.closest('[class*="bg-[#"]');

    if (toParent) {
        if (toParent.classList.contains('bg-[#fff9f8]')) {
            newStatus = 'not_started';
        } else if (toParent.classList.contains('bg-[#F3F8FD]')) {
            newStatus = 'in_progress';
        } else if (toParent.classList.contains('bg-[#F6F9F7]')) {
            newStatus = 'done';
        }
    }

    // 🔥 Trouver la task
    let task =
        self.allGoals.notStarted.find(g => g.id === parseInt(goalId)) ||
        self.allGoals.inProgress.find(g => g.id === parseInt(goalId)) ||
        self.allGoals.done.find(g => g.id === parseInt(goalId));

    if (!task) return;

    // 🔥 Retirer de l'ancienne colonne
    self.allGoals.notStarted = self.allGoals.notStarted.filter(g => g.id !== parseInt(goalId));
    self.allGoals.inProgress = self.allGoals.inProgress.filter(g => g.id !== parseInt(goalId));
    self.allGoals.done = self.allGoals.done.filter(g => g.id !== parseInt(goalId));

    // 🔥 Mettre à jour le status
    task.status = newStatus;

    // 🔥 Ajouter dans la nouvelle colonne à la bonne position
    const newIndex = evt.newIndex;
    if (newStatus === 'not_started') {
        self.allGoals.notStarted.splice(newIndex, 0, task);
    } else if (newStatus === 'in_progress') {
        self.allGoals.inProgress.splice(newIndex, 0, task);
    } else if (newStatus === 'done') {
        self.allGoals.done.splice(newIndex, 0, task);
    }

    // 🔥 Forcer Alpine à re-render
    self.allGoals = {
        notStarted: [...self.allGoals.notStarted],
        inProgress: [...self.allGoals.inProgress],
        done: [...self.allGoals.done]
    };

    // 🔥 Sauvegarder côté serveur
    await self.moveGoal(parseInt(goalId), newStatus);

    // Optionnel : sauvegarder l'ordre
    const orderedIds = self.allGoals[
        newStatus === 'not_started' ? 'notStarted' :
        newStatus === 'in_progress' ? 'inProgress' : 'done'
    ].map(g => g.id);

    try {
        await fetch('/student/goals/reorder', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                status: newStatus,
                order: orderedIds
            })
        });
    } catch (e) {
        console.error('Error saving new order:', e);
    }
}
        });
    });

    console.log('✅ SortableJS initialized for all columns');
},


            allGoals: {
                notStarted: <?php echo json_encode($notStarted, 15, 512) ?>,
                inProgress: <?php echo json_encode($inProgress, 15, 512) ?>,
                done: <?php echo json_encode($done, 15, 512) ?>
            },

            get allGoalsFlat() {
                return [
                    ...this.allGoals.notStarted,
                    ...this.allGoals.inProgress,
                    ...this.allGoals.done
                ];
            },

            get filteredGoals() {
                 this.refreshTrigger;
                if (this.currentView === 'status') {
                    return this.allGoalsFlat;
                }

                const now = new Date();
                const today = new Date(now.getFullYear(), now.getMonth(), now.getDate());

                return this.allGoalsFlat.filter(task => {
                    const taskDate = new Date(task.due_date ?? task.created_at);

                    switch(this.currentView) {
                        case 'today':
                            const taskToday = new Date(taskDate.getFullYear(), taskDate.getMonth(), taskDate.getDate());
                            return taskToday.getTime() === today.getTime();

                        case 'week':
                            const weekAgo = new Date(today);
                            weekAgo.setDate(weekAgo.getDate() - 7);
                            return taskDate >= weekAgo;

                        case 'month':
                            const monthAgo = new Date(today);
                            monthAgo.setMonth(monthAgo.getMonth() - 1);
                            return taskDate >= monthAgo;

                        default:
                            return true;
                    }
                });
            },

            // ✅ AJOUTER CETTE FONCTION POUR OUVRIR LE MODAL
            openTaskModal(status = 'not_started', task = null) {
                window.dispatchEvent(new CustomEvent('close-dropdowns'));

                if (task) {
                    // Éditer une tâche existante
                    this.modalTask = {
                        id: task.id,
                        title: task.title || '',
                        description: task.description || '',
                        status: task.status || status,
                        priority: task.priority || '',
                        comment: task.comment || '',
                        task_type: task.task_type || '',
                        due_date: task.due_date || '',
                        notes: task.notes || '',
                        checklist: task.checklist ? JSON.parse(task.checklist) : []
                    };
                } else {
                    // Créer une nouvelle tâche
                    this.modalTask = {
                        id: null,
                        title: '',
                        description: '',
                        status: status,
                        priority: '',
                        task_type: '',
                        due_date: '',
                        notes: '',
                        checklist: []
                    };
                }
                this.modalAutoSaveEnabled = false; // désactiver pendant le chargement

                this.showTaskModal = true;
                this.$nextTick(() => {
    this.modalAutoSaveEnabled = true; // activer l’autosave après ouverture
});
            },

            // ✅ AJOUTER CETTE FONCTION POUR SAUVEGARDER
            async saveTaskFromModal(auto = false) {
    // ✅ Ne pas sauvegarder si modal fermé
    if (!this.showTaskModal) return;

    // ✅ Skip autosave si titre vide
    if (auto && !this.modalTask.title.trim()) {
        return;
    }

    if (!auto && !this.modalTask.title.trim()) {
        alert('Please enter a task title');
        return;
    }

                try {
                    const data = {
                        title: this.modalTask.title,
                        description: this.modalTask.description,
                        comment: this.modalTask.comment,
                        status: this.modalTask.status,
                        priority: this.modalTask.priority,
                        task_type: this.modalTask.task_type,
                        due_date: this.modalTask.due_date,
                        notes: this.modalTask.notes,
                        checklist: JSON.stringify(this.modalTask.checklist)
                    };

                    let response;
                    if (this.modalTask.id) {
                        // Update existing task
                        response = await fetch(`/student/goals/${this.modalTask.id}`, {
                            method: 'PUT',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                            },
                            body: JSON.stringify(data)
                        });
                    } else {
                        // Create new task
                        response = await fetch('<?php echo e(route("student.goals.store")); ?>', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                            },
                            body: JSON.stringify(data)
                        });
                    }

                   if (response.ok) {
   const saved = await response.json();
const updated = saved.goal; // ✔ la vraie task retournée

if (this.modalTask.id) {
    let task = this.allGoalsFlat.find(g => g.id === this.modalTask.id);
if (task) {
    Object.assign(task, updated);

    this.allGoals = {
        notStarted: [...this.allGoals.notStarted],
        inProgress: [...this.allGoals.inProgress],
        done: [...this.allGoals.done]
    };
}}
    // 🔥 Sinon → c'est une nouvelle → on ajoute dans la bonne colonne
    else {
    if (updated.status === 'not_started') this.allGoals.notStarted.push(updated);
    if (updated.status === 'in_progress') this.allGoals.inProgress.push(updated);
    if (updated.status === 'done') this.allGoals.done.push(updated);

    // 🔥 Re-render pour Alpine
    this.allGoals = {
        notStarted: [...this.allGoals.notStarted],
        inProgress: [...this.allGoals.inProgress],
        done: [...this.allGoals.done],
    };
}
if (!auto) {
    this.showTaskModal = false;
    window.location.reload();
}
}
                } catch (error) {
                    console.error('Error saving task:', error);
                    alert('Failed to save task. Please try again.');
                }
            },

            setView(view) {
    this.currentView = view;
    localStorage.setItem('goalsView', view);
},

            handleDragStart(event, taskId) {
                this.draggedTaskId = taskId;
                event.target.classList.add('opacity-50', 'scale-95');
                event.dataTransfer.effectAllowed = 'move';
            },

            handleDragEnd(event) {
                event.target.classList.remove('opacity-50', 'scale-95');
                document.querySelectorAll('.ring-2').forEach(el => {
                    el.classList.remove('ring-2', 'ring-red-400', 'ring-blue-400', 'ring-green-400');
                });
            },

            async handleDrop(event, newStatus) {
                event.target.closest('[class*="bg-"]').classList.remove('ring-2', 'ring-red-400', 'ring-blue-400', 'ring-green-400');

                if (this.draggedTaskId) {
                    await this.moveGoal(this.draggedTaskId, newStatus);
                    this.draggedTaskId = null;
                }
            },

async addTask(status) {
    try {
        const response = await fetch('<?php echo e(route("student.goals.store")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ status, title: '' })
        });

        if (response.ok) {
            const json = await response.json();
            const newTask = json.goal; // ✔️ la vraie task

            if (status === 'not_started') this.allGoals.notStarted.push(newTask);
            if (status === 'in_progress') this.allGoals.inProgress.push(newTask);
            if (status === 'done') this.allGoals.done.push(newTask);

            // ✔️ Forcer Alpine à re-rendre
            this.allGoals = {
                notStarted: [...this.allGoals.notStarted],
                inProgress: [...this.allGoals.inProgress],
                done: [...this.allGoals.done]
            };
        }
    } catch (error) {
        console.error('Error adding task:', error);
        alert('Failed to add task.');
    }
}

,

   async addTaskToView() {
    let due_date = null;

    const now = new Date();
    const today = now.toISOString().slice(0, 10);

    if (this.currentView === 'today') {
        due_date = today;
    }

    if (this.currentView === 'week') {
        due_date = today;
    }

    if (this.currentView === 'month') {
        due_date = today;
    }

    try {
        const response = await fetch('<?php echo e(route("student.goals.store")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                title: '',
                status: 'not_started',
                due_date: due_date
            })
        });

        if (response.ok) {
            const newTask = await response.json();

            // 🔥 Ajouter dynamiquement dans la colonne Status
this.allGoals.notStarted.push(newTask.goal);

            // 🔥 FORCER le refresh de la vue en recréant l’objet
            this.allGoals = {
                notStarted: [...this.allGoals.notStarted],
                inProgress: [...this.allGoals.inProgress],
                done: [...this.allGoals.done]
            };
        }

    } catch (error) {
        console.error(error);
    }
},

       async updateGoal(id, title, priority = null, taskType = null) {
    try {
        // 🔥 Trouver la task pour récupérer son status actuel
        let goal =
            this.allGoals.notStarted.find(g => g.id === id)
         || this.allGoals.inProgress.find(g => g.id === id)
         || this.allGoals.done.find(g => g.id === id);

        const data = {
            title,
            status: goal ? goal.status : 'not_started'
        };
        if (priority !== null) data.priority = priority;
        if (taskType !== null) data.task_type = taskType;

        await fetch(`/student/goals/${id}`, {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify(data)
        });

        // ✅ Mettre à jour localement (goal est déjà défini)
        if (goal) {
            goal.title = title;
            if (priority !== null) goal.priority = priority;
            if (taskType !== null) goal.task_type = taskType;
        }

        // 🔥 Force Alpine refresh
        this.allGoals = {
            notStarted: [...this.allGoals.notStarted],
            inProgress: [...this.allGoals.inProgress],
            done: [...this.allGoals.done]
        };

    } catch (error) {
        console.error('Error updating goal:', error);
    }
},

           async deleteGoal(id) {
    if (!confirm('Are you sure you want to delete this task?')) return;

    try {
        const response = await fetch(`/student/goals/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            }
        });

        if (response.ok) {
            this.allGoals.notStarted = this.allGoals.notStarted.filter(g => g.id !== id);
            this.allGoals.inProgress = this.allGoals.inProgress.filter(g => g.id !== id);
            this.allGoals.done = this.allGoals.done.filter(g => g.id !== id);
        }
    } catch (error) {
        console.error('Error deleting goal:', error);
        alert('Failed to delete task.');
    }
},

 async moveGoal(id, newStatus) {
    try {
        const response = await fetch(`/student/goals/${id}/move`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ status: newStatus })
        });

        if (response.ok) {

            // 1. Trouver la task dans toutes les colonnes
            let task =
                this.allGoals.notStarted.find(g => g.id === id) ||
                this.allGoals.inProgress.find(g => g.id === id) ||
                this.allGoals.done.find(g => g.id === id);

            if (!task) return;

            // 2. Mettre à jour son statut
            task.status = newStatus;

            // ❗ IMPORTANT : NE PAS refaire push()
            // On ne touche pas aux listes ici
            // L'ordre est déjà géré par onEnd()

            // 🔥 Forcer Alpine à re-render
            this.allGoals = {
                notStarted: [...this.allGoals.notStarted],
                inProgress: [...this.allGoals.inProgress],
                done: [...this.allGoals.done]
            };
        }

    } catch (error) {
        console.error('Error moving goal:', error);
        alert('Failed to move task. Please try again.');
    }
}
        }
    }
</script>


<script>
document.addEventListener('click', function(e) {
    // Ne pas fermer si on clique sur un bouton qui ouvre un dropdown
    if (e.target.closest('[data-dropdown-toggle]')) return;

    window.dispatchEvent(new CustomEvent('close-all-dropdowns'));
});
</script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/student/goals.blade.php ENDPATH**/ ?>