<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Salle de Classe Zoom']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Salle de Classe Zoom']); ?>
    <meta name="zoom-domain" content="zoom.us">

    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #111827;
            color: white;
            font-family: Arial, sans-serif;
        }
        #loading {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            font-size: 1.2rem;
            color: #e5e7eb;
        }
        #zmmtg-root {
            display: none;
            width: 100vw;
            height: 100vh;
        }
    </style>

    <div id="loading">🔄 Chargement de la salle Zoom...</div>
    <div id="zmmtg-root"></div>
    <div id="aria-notify-area"></div>

    <!-- 🧩 Scripts Zoom chargés de manière synchrone -->
    <script src="https://source.zoom.us/2.18.0/lib/vendor/react.min.js"></script>
    <script src="https://source.zoom.us/2.18.0/lib/vendor/react-dom.min.js"></script>
    <script src="https://source.zoom.us/2.18.0/lib/vendor/redux.min.js"></script>
    <script src="https://source.zoom.us/2.18.0/lib/vendor/redux-thunk.min.js"></script>
    <script src="https://source.zoom.us/2.18.0/lib/vendor/lodash.min.js"></script>
    <script src="https://source.zoom.us/zoom-meeting-2.18.0.min.js"></script>

    <script>
        // ✅ Attendre que TOUS les scripts soient chargés
        window.addEventListener('load', function() {
            console.log("🔍 Vérification du SDK Zoom...");

            if (typeof ZoomMtg === "undefined") {
                document.getElementById('loading').innerHTML =
                    "❌ Erreur: SDK Zoom non disponible. <br>Rechargez la page.";
                console.error("ZoomMtg n'est pas défini");
                return;
            }

            console.log("✅ SDK Zoom chargé avec succès");

            ZoomMtg.setZoomJSLib('https://source.zoom.us/2.18.0/lib', '/av');
            ZoomMtg.preLoadWasm();
            ZoomMtg.prepareWebSDK();

            const meetConfig = {
                apiKey: "<?php echo e(env('ZOOM_CLIENT_ID')); ?>",
                meetingNumber: "<?php echo e($meeting->zoom_meeting_id); ?>",
                userName: "<?php echo e(Auth::user()->name); ?>",
                passWord: "<?php echo e($meeting->password ?? ''); ?>",
                leaveUrl: "<?php echo e(route('student.zoom.index')); ?>",
                role: 0,
                userEmail: "<?php echo e(Auth::user()->email); ?>",
            };

            console.log("📞 Configuration:", meetConfig);

            // 🔑 Récupération de la signature
            fetch(`/api/zoom-signature?meetingNumber=${meetConfig.meetingNumber}&role=${meetConfig.role}`)
                .then(res => {
                    if (!res.ok) {
                        throw new Error(`Erreur HTTP: ${res.status}`);
                    }
                    return res.json();
                })
                .then(data => {
                    console.log("🔐 Signature reçue:", data);

                    if (!data.signature) {
                        throw new Error("Signature manquante dans la réponse");
                    }

                    document.getElementById('loading').style.display = 'none';
                    document.getElementById('zmmtg-root').style.display = 'block';

                    ZoomMtg.init({
                        leaveUrl: meetConfig.leaveUrl,
                        disableInvite: true,
                        disableCallOut: true,
                        disableRecord: true,
                        disableJoinAudio: false,
                        audioPanelAlwaysOpen: false,
                        showMeetingHeader: true,
                        success: function () {
                            console.log("✅ Init réussi, tentative de join...");

                            ZoomMtg.join({
                                signature: data.signature,
                                meetingNumber: meetConfig.meetingNumber,
                                userName: meetConfig.userName,
                                apiKey: meetConfig.apiKey,
                                userEmail: meetConfig.userEmail,
                                passWord: meetConfig.passWord,
                                success: function (res) {
                                    console.log("✅ Réunion rejointe:", res);
                                },
                                error: function (err) {
                                    console.error("❌ Erreur join:", err);
                                    alert("Impossible de rejoindre: " + JSON.stringify(err));
                                },
                            });
                        },
                        error: function (err) {
                            console.error("❌ Erreur init:", err);
                            alert("Erreur d'initialisation: " + JSON.stringify(err));
                        },
                    });
                })
                .catch(err => {
                    console.error("❌ Erreur signature:", err);
                    document.getElementById('loading').innerHTML =
                        `❌ Erreur: ${err.message}<br><a href="<?php echo e(route('student.zoom.index')); ?>" class="text-blue-400">Retour</a>`;
                });
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/student/zoom/room.blade.php ENDPATH**/ ?>