<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Classes en direct (Google Meet)']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Classes en direct (Google Meet)']); ?>
    <div class="max-w-4xl mx-auto p-8">

        <h2 class="text-3xl font-bold text-gray-800 mb-6 text-center">
            🎥 Classes en direct (Google Meet)
        </h2>

        <!-- Bouton création -->
        <form method="POST" action="<?php echo e(route('student.meet.create')); ?>" class="text-center mb-10">
            <?php echo csrf_field(); ?>
            <button class="bg-green-600 hover:bg-green-700 text-white px-6 py-3 rounded-lg shadow-md">
                ➕ Créer une nouvelle réunion
            </button>
        </form>

        <!-- Messages -->
        <?php if(session('success')): ?>
            <div class="bg-green-100 text-green-800 p-3 rounded mb-6">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="bg-red-100 text-red-800 p-3 rounded mb-6">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <!-- Liste des réunions -->
        <div class="bg-white shadow-md rounded-lg overflow-hidden">
            <table class="w-full text-sm text-gray-700">
                <thead class="bg-gray-100 text-gray-800 uppercase text-xs">
                    <tr>
                        <th class="p-3 text-left">Titre</th>
                        <th class="p-3 text-left">Début</th>
                        <th class="p-3 text-left">Fin</th>
                        <th class="p-3 text-center">Lien</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $meetings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-b hover:bg-gray-50">
                            <td class="p-3"><?php echo e($meet->title); ?></td>
                            <td class="p-3"><?php echo e(\Carbon\Carbon::parse($meet->start_time)->format('d/m/Y H:i')); ?></td>
                            <td class="p-3"><?php echo e(\Carbon\Carbon::parse($meet->end_time)->format('H:i')); ?></td>
                            <td class="p-3 text-center">
                                <a href="<?php echo e($meet->meet_link); ?>" target="_blank"
                                   class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
                                    🔗 Rejoindre
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="p-6 text-center text-gray-500">
                                Aucune réunion pour le moment.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/student/meet/index.blade.php ENDPATH**/ ?>