<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Alplatforme</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">

<style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #000000; /* Changed to black */
            color: #ffffff; /* Added white text for readability */
        }

            .am-header_five {
    padding: 20px 0;
    background: #000000;
    position: relative;
    z-index: 100;
}

.am-header_two_wrap {
    display: flex;
    align-items: center;
    justify-content: space-between;
    width: 100%;
}

.am-logo {
    flex-shrink: 0;
}

.am-logo img {
    height: 50px;
    width: auto;
}

/* Navigation Desktop */
.am-navigation {
    display: flex;
    align-items: center;
}

.am-nav-menu {
    display: flex;
    list-style: none;
    margin: 0;
    padding: 0;
    gap: 35px;
}

.nav-linkk {
    font-family: 'Inter', sans-serif;
    font-size: 16px;
    font-weight: 500;
    color: #ffffff;
    text-decoration: none;
    padding: 10px 0;
    transition: all 0.3s ease;
}

.nav-linkk:hover {
    color: #ffffff;
    font-weight: 600;
}

/* Burger Menu */
.burger-btn {
    background: none;
    border: none;
    width: 30px;
    height: 25px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    cursor: pointer;
    padding: 0;
}

.burger-btn span {
    width: 100%;
    height: 3px;
    background-color: #ffffff;
    transition: all 0.3s ease;
    border-radius: 2px;
}

.burger-btn:hover span {
    background-color: #ffffff;
}

/* Mobile Menu */
.offcanvas {
    background-color: #ffffff;
}

.offcanvas-title {
    font-family: 'Inter', sans-serif;
    font-weight: 700;
    color: #1D1D1E;
}

.mobile-nav-menu {
    list-style: none;
    padding: 0;
    margin: 0;
}

.mobile-nav-menu li {
    margin-bottom: 20px;
}

.mobile-nav-link {
    font-family: 'Inter', sans-serif;
    font-size: 18px;
    font-weight: 500;
    color: #1D1D1E;
    text-decoration: none;
    padding: 15px 0;
    display: block;
    transition: all 0.3s ease;
}

.mobile-nav-link:hover {
    color: #000000;
    font-weight: 600;
}

/* Responsive */
@media (max-width: 1199px) {
    .am-nav-menu {
        gap: 25px;
    }

    .nav-linkk {
        font-size: 15px;
    }
}

        /* Main Section */
        .am-main {
            padding-top: 88px;
            margin-top: -88px;
            overflow: hidden;
            background: #000000; /* Changed to black */
        }

        /* Banner Section */
        .pb-themesection {
            padding: 1px 0;
            background: #000000; /* Changed to black */
        }

        .am-banner-potential {
            padding: 1px 0;
            background: #000000; /* Changed to black */
        }

        .am-banner-tutor {
             /* Dark gray instead of white */
            border-radius: 16px;
            padding: 40px 20px;
            max-width: 1350px;
            height: 600px;
            margin: 0 auto;
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        .banner-title {
            font-family: 'Inter', sans-serif;
            font-size: 70px;
            color: #ffffff; /* Changed to white */
            font-weight: 800;
            line-height: 1.2;
            margin-bottom: 30px;
        }

        .banner-subtitle {
            font-family: 'Inter', sans-serif;
            font-size: 24px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 400;
            line-height: 1.5;
            margin-bottom: 30px;
        }

        .explore-btn {
            font-family: 'Inter', sans-serif;
            font-size: 18px;
            font-weight: 600;
            color: #000000; /* Keep black text for contrast */
            background-color: #ffffff; /* Keep white background for contrast */
            padding: 12px 24px;
            text-decoration: none;
            display: inline-block;
            border-radius: 10px;
            transition: all 0.3s ease;
        }

        .explore-btn:hover {
            background-color: #f0f0f0;
            transform: translateY(-2px);
            color: #000000;
        }

        /* Mobile Responsive Styles */
        @media (max-width: 1200px) {
            .banner-title {
                font-size: 60px;
            }

            .banner-subtitle {
                font-size: 22px;
            }
        }

        @media (max-width: 992px) {
            .am-banner-tutor {
                height: 500px;
                padding: 30px 20px;
            }

            .banner-title {
                font-size: 50px;
                margin-bottom: 25px;
            }

            .banner-subtitle {
                font-size: 20px;
                margin-bottom: 25px;
            }
        }

        @media (max-width: 768px) {
            .am-main {
                padding-top: 70px;
                margin-top: -70px;
            }

            .am-header_five {
                padding: 15px 0;
            }

            .am-logo img {
                height: 40px;
            }

            .am-banner-tutor {
                height: auto;
                min-height: 450px;
                padding: 40px 15px;
                border-radius: 12px;
            }

            .banner-title {
                font-size: 40px;
                margin-bottom: 20px;
            }

            .banner-subtitle {
                font-size: 18px;
                margin-bottom: 20px;
                padding: 0 10px;
            }

            .banner-subtitle br {
                display: none;
            }

            .explore-btn {
                font-size: 16px;
                padding: 10px 20px;
            }
        }

        @media (max-width: 576px) {
            .am-banner-tutor {
                min-height: 400px;
                padding: 30px 10px;
            }

            .banner-title {
                font-size: 32px;
                font-weight: 700;
            }

            .banner-subtitle {
                font-size: 16px;
                line-height: 1.6;
            }
        }

        @media (max-width: 400px) {
            .am-logo img {
                height: 35px;
            }

            .banner-title {
                font-size: 28px;
            }

            .banner-subtitle {
                font-size: 14px;
            }

            .explore-btn {
                font-size: 14px;
                padding: 8px 16px;
            }
        }

        /* Animation Classes */
        @keyframes fadeUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fade-up {
            animation: fadeUp 0.8s ease forwards;
        }

        .delay-300 {
            animation-delay: 0.3s;
            opacity: 0;
        }

        .delay-400 {
            animation-delay: 0.4s;
            opacity: 0;
        }

        .delay-500 {
            animation-delay: 0.5s;
            opacity: 0;
        }

        .info-card {
            background-color: #1a1a1a; /* Changed to dark */
            border-radius: 20px;
            display: flex;
            flex-direction: row;
            align-items: stretch;
            justify-content: space-between;
            min-height: 400px;
            overflow: hidden;
        }

        .info-content {
            width: 50%;
            padding: 40px 20px;
            position: relative;
            display: flex;
            flex-direction: column;
        }

        .info-title {
            font-family: 'Inter', sans-serif;
            font-size: 30px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
            line-height: 1.2;
            margin-bottom: 20px;
        }

        .info-description {
            font-family: 'Inter', sans-serif;
            font-size: 22px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 400;
            text-align: center;
            line-height: 1.5;
        }

        .info-image {
            width: 50%;
            padding: 0;
            margin: 0;
            height: 100%;
            display: flex;
        }

        .info-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            margin: 0;
            padding: 0;
        }

        /* Responsive Styles */
        @media (max-width: 1200px) {
            .info-title {
                font-size: 32px;
            }

            .info-description {
                font-size: 20px;
            }
        }

        @media (max-width: 992px) {
            .info-title {
                font-size: 36px;
            }

            .info-description {
                font-size: 18px;
            }

            .info-content {
                padding: 30px 15px;
            }
        }

        @media (max-width: 768px) {
            .info-card {
                flex-direction: column;
                min-height: auto;
            }

            .info-content,
            .info-image {
                width: 100%;
            }

            .info-content {
                padding: 40px 20px 30px;
                order: 2;
            }

            .info-image {
                height: 250px;
                order: 1;
            }

            .info-title {
                font-size: 32px;
                margin-bottom: 15px;
            }

            .info-description {
                font-size: 16px;
            }

            .desktop-break {
                display: none;
            }
        }

        @media (max-width: 576px) {
            .info-card {
                border-radius: 16px;
            }

            .info-content {
                padding: 30px 20px;
            }

            .info-image {
                height: 200px;
            }

            .info-title {
                font-size: 28px;
            }

            .info-description {
                font-size: 15px;
                padding: 0 10px;
            }
        }

        @media (max-width: 400px) {
            .info-title {
                font-size: 24px;
            }

            .info-description {
                font-size: 14px;
            }

            .info-image {
                height: 180px;
            }
        }

        /* Animation au scroll (optionnel) */
        .info-card {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.8s ease;
        }

        .info-card.visible {
            opacity: 1;
            transform: translateY(0);
        }

        .info-card-reverse {
            background-color: #1a1a1a; /* Changed to dark */
            border-radius: 20px;
            display: flex;
            flex-direction: row;
            align-items: stretch;
            justify-content: space-between;
            min-height: 400px;
            overflow: hidden;
        }

        .info-image-reverse {
            width: 50%;
            padding: 0;
            margin: 0;
            height: 100%;
            display: flex;
        }

        .info-image-reverse img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .info-content-reverse {
            width: 50%;
            padding: 40px 20px;
            position: relative;
            display: flex;
            flex-direction: column;
        }

        /* Responsive pour la section inversée */
        @media (max-width: 768px) {
            .info-card-reverse {
                flex-direction: column;
                min-height: auto;
            }

            .info-content-reverse,
            .info-image-reverse {
                width: 100%;
            }

            .info-content-reverse {
                padding: 40px 20px 30px;
                order: 2;
            }

            .info-image-reverse {
                height: 250px;
                order: 1;
            }
        }

        @media (max-width: 576px) {
            .info-card-reverse {
                border-radius: 16px;
            }

            .info-content-reverse {
                padding: 30px 20px;
            }

            .info-image-reverse {
                height: 200px;
            }
        }

        @media (max-width: 400px) {
            .info-image-reverse {
                height: 180px;
            }
        }

        /* Animation pour section inversée */
        .info-card-reverse {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.8s ease;
        }

        .info-card-reverse.visible {
            opacity: 1;
            transform: translateY(0);
        }

        /* Section Carousel */
        .carousel-section {
            background-color: #000000; /* Changed to black */
            overflow: hidden;
        }

        .carousel-title {
            font-family: 'Inter', sans-serif;
            font-size: 42px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
            line-height: 1.3;
        }

        .gradient-text {
            background: linear-gradient(90deg, #8A86E9, #CA5EF6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-weight: 700;
        }

        /* Fix pour scroll horizontal uniquement */
        .carousel-container {
            margin: 50px 0;
            width: 100vw;
            position: relative;
            left: 50%;
            right: 50%;
            margin-left: -50vw;
            margin-right: -50vw;
            overflow: hidden; /* Empêche le débordement vertical */
        }

        .carousel-track {
            display: flex;
            overflow-x: auto; /* Scroll horizontal seulement */
            overflow-y: hidden; /* Pas de scroll vertical */
            gap: 16px;
            padding: 30px 100px;
            scroll-snap-type: x mandatory;
            -webkit-overflow-scrolling: touch;
            scrollbar-width: none;
            height: 690px; /* Hauteur fixe */
            align-items: center; /* Centre les cartes verticalement */
        }

        .carousel-track::-webkit-scrollbar {
            display: none;
        }

        /* Flip Cards avec hauteur fixe */
        .flip-card {
            perspective: 1000px;
            width: calc(23vw - 32px);
            min-width: 350px;
            height: 630px;
            max-height: 630px;
            scroll-snap-align: center;
            flex-shrink: 0;
            flex-grow: 0;
        }

        .flip-inner {
            width: 100%;
            height: 100%;
            max-height: 630px;
            transition: transform 0.8s;
            transform-style: preserve-3d;
            position: relative;
            border-radius: 20px;
        }

        .flip-card.flipped .flip-inner {
            transform: rotateY(180deg);
        }

        .flip-front, .flip-back {
            position: absolute;
            width: 100%;
            height: 100%;
            backface-visibility: hidden;
            padding: 24px;
            border-radius: 20px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            background: #1a1a1a; /* Changed to dark */
        }

        .flip-back {
            transform: rotateY(180deg);
        }

        /* Typography */
        .card-title, .card-title-white {
            font-family: 'Inter', sans-serif;
            font-size: 30px;
            font-weight: 700;
        }

        .card-title {
            color: #ffffff; /* Changed to white */
        }

        .card-title-white {
            color: #FFFFFF;
        }

        .card-subtitle, .card-subtitle-white {
            font-family: 'Inter', sans-serif;
            font-size: 20px;
            font-weight: 700;
        }

        .card-subtitle {
            color: #cccccc; /* Changed to light gray */
        }

        .card-subtitle-white {
            color: #FFFFFF;
        }

        .card-text {
            font-family: 'Inter', sans-serif;
            font-size: 20px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 700;
        }

        /* Buttons */
        .flip-button, .flip-buttonferme {
            position: absolute;
            bottom: 24px;
            right: 24px;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            border: none;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 10;
            transition: transform 0.3s;
        }

        .flip-button:hover, .flip-buttonferme:hover {
            transform: scale(1.1);
        }

        .flip-button {
            background-color: #fff;
        }

        .flip-buttonferme {
            background-color: #000;
        }

        /* Glow Effect */
        .glow-line-border {
            position: absolute;
            inset: -4px;
            border-radius: 24px;
            background: linear-gradient(135deg, #0D93FF, #C25FEA, #EE4476, #ED6D10);
            filter: blur(10px);
            pointer-events: none;
            z-index: 1;
        }

        .content {
            z-index: 2;
            position: relative;
        }

        /* Slider Images */
        .before-image, .after-image {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            max-height: 100%;
            z-index: 1;
        }

        .before-image {
            clip-path: inset(0 50% 0 0);
        }

        .after-image {
            clip-path: inset(0 0 0 50%);
        }

        .slider {
            position: absolute;
            left: 50%;
            top: 0;
            width: 4px;
            height: 100%;
            background: #fff;
            cursor: ew-resize;
            z-index: 2;
            transform: translateX(-50%);
        }

        .slider-handle {
            position: absolute;
            top: 50%;
            width: 20px;
            height: 20px;
            background: #fff;
            border-radius: 50%;
            transform: translate(-50%, -50%);
            box-shadow: 0 2px 10px rgba(0,0,0,0.3);
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .carousel-title {
                font-size: 36px;
            }

            .carousel-track {
                height: 610px;
                padding: 30px 50px;
            }

            .flip-card {
                width: 35vw;
                min-width: 300px;
                height: 550px;
                max-height: 550px;
            }

            .flip-inner {
                max-height: 550px;
            }
        }

        @media (max-width: 992px) {
            .carousel-title {
                font-size: 32px;
            }

            .carousel-track {
                height: 560px;
            }

            .flip-card {
                width: 45vw;
                min-width: 280px;
                height: 500px;
                max-height: 500px;
            }

            .flip-inner {
                max-height: 500px;
            }

            .card-title, .card-title-white {
                font-size: 26px;
            }

            .card-subtitle, .card-subtitle-white, .card-text {
                font-size: 16px;
            }
        }

        @media (max-width: 768px) {
            .carousel-title {
                font-size: 28px;
                padding: 0 20px;
            }

            .carousel-track {
                height: 510px;
                padding: 20px 20px;
                gap: 12px;
            }

            .flip-card {
                width: 75vw;
                min-width: 260px;
                height: 450px;
                max-height: 450px;
            }

            .flip-inner {
                max-height: 450px;
            }

            .flip-front, .flip-back {
                padding: 20px;
            }

            .flip-button, .flip-buttonferme {
                width: 35px;
                height: 35px;
                bottom: 20px;
                right: 20px;
            }
        }

        @media (max-width: 576px) {
            .carousel-title {
                font-size: 24px;
            }

            .carousel-track {
                height: 460px;
            }

            .flip-card {
                width: 85vw;
                min-width: 240px;
                height: 400px;
                max-height: 400px;
            }

            .flip-inner {
                max-height: 400px;
            }

            .card-title, .card-title-white {
                font-size: 22px;
            }

            .card-subtitle, .card-subtitle-white, .card-text {
                font-size: 14px;
            }
        }

        .permission-section {
            background-color: #000000; /* Changed to black */
        }

        .permission-card {
            background-color: #1a1a1a; /* Changed to dark */
            border-radius: 20px;
            display: flex;
            flex-direction: row;
            align-items: stretch;
            justify-content: space-between;
            min-height: 400px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
        }

        .permission-image {
            width: 50%;
            padding: 0;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .permission-image img {
            width: 100%;
            height: 630px;
            object-fit: cover;
        }

        .permission-content {
            width: 50%;
            padding: 40px 20px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .permission-title-wrapper {
            text-align: left;
            margin-bottom: 30px;
        }

        .permission-title {
            font-family: 'Inter', sans-serif;
            font-size: 35px;
            color: #ffffff; /* Changed to white */
            font-weight: 600;
            line-height: 1.3;
        }

        .permission-text-wrapper {
            display: flex;
            align-items: center;
        }

        .permission-text {
            font-family: 'Inter', sans-serif;
            font-size: 22px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 600;
            text-align: left;
            line-height: 1.5;
        }

        /* Animation */
        .permission-card {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.8s ease;
        }

        .permission-card.visible {
            opacity: 1;
            transform: translateY(0);
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .permission-image img {
                height: 550px;
            }

            .permission-title {
                font-size: 32px;
            }

            .permission-text {
                font-size: 20px;
            }
        }

        @media (max-width: 992px) {
            .permission-image img {
                height: 500px;
            }

            .permission-title {
                font-size: 28px;
            }

            .permission-text {
                font-size: 18px;
            }

            .permission-content {
                padding: 30px 20px;
            }
        }

        @media (max-width: 768px) {
            .permission-card {
                flex-direction: column;
                min-height: auto;
            }

            .permission-image,
            .permission-content {
                width: 100%;
            }

            .permission-image img {
                height: 300px;
                width: 100%;
            }

            .permission-content {
                padding: 30px 20px;
                text-align: center;
            }

            .permission-title-wrapper,
            .permission-text {
                text-align: center;
            }

            .permission-title {
                font-size: 26px;
                margin-bottom: 20px;
            }

            .permission-text {
                font-size: 16px;
            }

            .desktop-break {
                display: none;
            }
        }

        @media (max-width: 576px) {
            .permission-card {
                border-radius: 16px;
                box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            }

            .permission-image img {
                height: 250px;
            }

            .permission-content {
                padding: 25px 15px;
            }

            .permission-title {
                font-size: 24px;
            }

            .permission-text {
                font-size: 15px;
                font-weight: 500;
            }
        }

        @media (max-width: 400px) {
            .permission-image img {
                height: 200px;
            }

            .permission-title {
                font-size: 20px;
            }

            .permission-text {
                font-size: 14px;
            }

            .permission-content {
                padding: 20px 15px;
            }
        }

        /* Section Courses */
        .courses-section {
            background-color: #000000; /* Changed to black */
        }

        .courses-title {
            font-family: 'Inter', sans-serif;
            font-size: 36px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
        }

        .courses-subtitle {
            color: #cccccc; /* Changed to light gray */
            font-weight: 800;
        }

        .courses-cards-container {
            display: flex;
            justify-content: center;
            gap: 24px;
            flex-wrap: wrap;
        }

        /* Course Flip Cards */
        .course-flip-card {
            perspective: 1000px;
            width: 500px;
            height: 400px;
            max-width: 100%;
        }

        .course-flip-inner {
            width: 100%;
            height: 100%;
            transition: transform 0.8s;
            transform-style: preserve-3d;
            position: relative;
            background-color: #1a1a1a; /* Changed to dark */
            box-shadow: 0 0 20px rgba(0,0,0,0.15);
            border-radius: 16px;
        }

        .course-flip-card.flipped .course-flip-inner {
            transform: rotateY(180deg);
        }

        .course-flip-front, .course-flip-back {
            position: absolute;
            width: 100%;
            height: 100%;
            backface-visibility: hidden;
            padding: 24px;
            border-radius: 16px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .course-flip-back {
            transform: rotateY(180deg);
        }

        /* AI Course specific */
        .ai-course {
            position: relative;
        }

        .course-image-container {
            background-color: #000000; /* Changed to black */
            border-radius: 0;
            padding: 10px;
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
        }

        .course-image {
            display: block;
            width: 100%;
            max-width: 300px;
            margin: 0 auto;
            border-radius: 8px;
            object-fit: cover;
        }

        /* Typography */
        .course-card-title {
            font-family: 'Inter', sans-serif;
            font-size: 25px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
            margin-bottom: 10px;
        }

        .course-card-subtitle {
            font-family: 'Inter', sans-serif;
            font-size: 20px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 700;
            margin-bottom: 10px;
        }

        .course-card-text {
            font-family: 'Inter', sans-serif;
            font-size: 15px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 700;
        }

        /* Buttons */
        .course-flip-btn {
            position: absolute;
            bottom: 24px;
            right: 24px;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: #fff;
            border: none;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: transform 0.3s;
        }

        .course-flip-btn:hover {
            transform: scale(1.1);
        }

        .course-flip-close {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: #000;
            border: none;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: transform 0.3s;
        }

        .course-flip-close:hover {
            transform: scale(1.1);
        }

        .learn-more-btn {
            font-family: 'Inter', sans-serif;
            font-size: 14px;
            font-weight: 700;
            color: #000;
            background-color: #fff;
            padding: 8px 16px;
            border-radius: 20px;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
        }

        .learn-more-btn:hover {
            background-color: #f0f0f0;
            transform: translateY(-2px);
        }

        .course-actions {
            display: flex;
            gap: 16px;
            align-items: center;
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .course-flip-card {
                width: 450px;
            }
        }

        @media (max-width: 992px) {
            .courses-title {
                font-size: 32px;
            }

            .course-flip-card {
                width: 400px;
                height: 380px;
            }

            .course-card-title {
                font-size: 23px;
            }

            .course-card-subtitle {
                font-size: 18px;
            }
        }

        @media (max-width: 768px) {
            .courses-title {
                font-size: 28px;
                padding: 0 20px;
            }

            .courses-cards-container {
                flex-direction: column;
                align-items: center;
            }

            .course-flip-card {
                width: 90%;
                max-width: 400px;
                height: 350px;
            }

            .course-card-title {
                font-size: 21px;
            }

            .course-card-subtitle {
                font-size: 17px;
            }

            .course-card-text {
                font-size: 14px;
            }
        }

        @media (max-width: 576px) {
            .courses-title {
                font-size: 24px;
            }

            .courses-subtitle {
                display: block;
                margin-top: 5px;
            }

            .course-flip-card {
                width: 95%;
                height: 320px;
            }

            .course-flip-front, .course-flip-back {
                padding: 20px;
            }

            .course-card-title {
                font-size: 19px;
            }

            .course-card-subtitle {
                font-size: 16px;
            }

            .course-flip-btn, .course-flip-close {
                width: 35px;
                height: 35px;
                bottom: 15px;
                right: 15px;
            }

            .course-image {
                max-width: 200px;
            }
        }

        @media (max-width: 400px) {
            .courses-title {
                font-size: 20px;
            }

            .course-flip-card {
                height: 300px;
            }

            .course-card-title {
                font-size: 17px;
            }

            .course-card-subtitle {
                font-size: 15px;
            }

            .course-card-text {
                font-size: 13px;
            }
        }

        .backend-section {
            background-color: #000000; /* Changed to black */
        }

        .backend-card {
            background-color: #1a1a1a; /* Changed to dark */
            border-radius: 20px;
            display: flex;
            flex-direction: row;
            align-items: stretch;
            height: 400px;
            width: 100%;
            max-width: 1030px;
            overflow: hidden;
            margin: 0 auto;
            box-shadow: 0 0 20px rgba(0,0,0,0.15);
        }

        .backend-content {
            width: 50%;
            padding: 40px 20px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .backend-title {
            font-family: 'Inter', sans-serif;
            font-size: 25px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
            margin-bottom: 20px;
        }

        .backend-description {
            font-family: 'Inter', sans-serif;
            font-size: 20px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 700;
            line-height: 1.5;
            margin-top: auto;
            padding-top: 50px;
        }

        .backend-image {
            width: 50%;
            padding: 0;
            margin: 0;
            height: 100%;
        }

        .backend-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /* Animation */
        .backend-card {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.8s ease;
        }

        .backend-card.visible {
            opacity: 1;
            transform: translateY(0);
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .backend-card {
                max-width: 900px;
            }
        }

        @media (max-width: 992px) {
            .backend-card {
                height: 350px;
            }

            .backend-title {
                font-size: 23px;
            }

            .backend-description {
                font-size: 18px;
            }
        }

        @media (max-width: 768px) {
            .backend-card {
                flex-direction: column;
                height: auto;
            }

            .backend-content,
            .backend-image {
                width: 100%;
            }

            .backend-content {
                padding: 30px 20px;
                order: 2;
            }

            .backend-image {
                height: 250px;
                order: 1;
            }

            .backend-description {
                padding-top: 20px;
            }

            .backend-title {
                text-align: center;
            }

            .backend-description {
                text-align: center;
            }
        }

        @media (max-width: 576px) {
            .backend-card {
                border-radius: 16px;
            }

            .backend-content {
                padding: 25px 15px;
            }

            .backend-image {
                height: 200px;
            }

            .backend-title {
                font-size: 21px;
            }

            .backend-description {
                font-size: 16px;
                font-weight: 600;
            }
        }

        @media (max-width: 400px) {
            .backend-image {
                height: 180px;
            }

            .backend-title {
                font-size: 19px;
            }

            .backend-description {
                font-size: 14px;
            }

            .backend-content {
                padding: 20px 15px;
            }
        }

        .testimonials-section {
            background-color: #000000; /* Changed to black */
            direction: ltr;
        }

        .testimonials-header {
            margin-bottom: 3rem;
        }

        .testimonials-title {
            font-family: 'Inter', sans-serif;
            font-size: 45px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
            line-height: 1.2;
        }

        .testimonials-subtitle {
            font-family: 'Inter', sans-serif;
            font-size: 36px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 700;
            line-height: 1.3;
        }

        .testimonial-card {
            background-color: #1a1a1a; /* Changed to dark */
            border-radius: 16px;
            padding: 24px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.08);
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            transition: transform 0.3s, box-shadow 0.3s;
        }

        .testimonial-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 30px rgba(0, 0, 0, 0.12);
        }

        .testimonial-text {
            font-family: 'Inter', sans-serif;
            font-size: 15px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 700;
            line-height: 1.6;
            margin-bottom: 1.5rem;
        }

        .testimonial-author {
            display: flex;
            align-items: center;
            margin-top: auto;
        }

        .author-avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
            margin-right: 12px;
        }

        .author-info {
            display: flex;
            flex-direction: column;
        }

        .author-name {
            margin: 0;
            font-size: 16px;
            font-family: 'Inter', sans-serif;
            font-weight: 600;
            color: #ffffff; /* Changed to white */
        }

        .author-role {
            font-family: 'Inter', sans-serif;
            color: #888888; /* Changed to darker gray */
            font-size: 14px;
        }

        /* Animation */
        .testimonial-card {
            opacity: 0;
            transform: translateY(30px);
            animation: fadeInUp 0.8s ease forwards;
        }

        .testimonial-card:nth-child(1) {
            animation-delay: 0.1s;
        }

        .testimonial-card:nth-child(2) {
            animation-delay: 0.2s;
        }

        .testimonial-card:nth-child(3) {
            animation-delay: 0.3s;
        }

        @keyframes fadeInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .testimonials-title {
                font-size: 40px;
            }

            .testimonials-subtitle {
                font-size: 32px;
            }
        }

        @media (max-width: 992px) {
            .testimonials-title {
                font-size: 36px;
            }

            .testimonials-subtitle {
                font-size: 28px;
            }
        }

        @media (max-width: 768px) {
            .testimonials-title {
                font-size: 32px;
            }

            .testimonials-subtitle {
                font-size: 24px;
                padding-top: 1rem !important;
            }

            .testimonial-card {
                margin-bottom: 20px;
            }

            .testimonial-text {
                font-size: 14px;
            }
        }

        @media (max-width: 576px) {
            .testimonials-title {
                font-size: 28px;
            }

            .testimonials-subtitle {
                font-size: 20px;
            }

            .testimonial-card {
                padding: 20px;
            }

            .author-avatar {
                width: 45px;
                height: 45px;
            }

            .author-name {
                font-size: 15px;
            }

            .author-role {
                font-size: 13px;
            }
        }

        @media (max-width: 400px) {
            .testimonials-title {
                font-size: 24px;
            }

            .testimonials-subtitle {
                font-size: 18px;
            }

            .testimonial-text {
                font-size: 13px;
                font-weight: 600;
            }
        }

        .faq-section {
            background-color: #000000; /* Changed to black */
            direction: ltr;
        }

        .faq-header {
            margin-bottom: 3rem;
        }

        .faq-title {
            font-family: 'Inter', sans-serif;
            font-size: 45px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
            line-height: 1.2;
        }

        .faq-subtitle {
            font-family: 'Inter', sans-serif;
            font-size: 30px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 700;
            line-height: 1.3;
        }

        .faq-container {
            background-color: #1a1a1a; /* Changed to dark */
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.08);
        }

        .faq-item {
            background-color: #2a2a2a; /* Changed to darker gray */
            border-radius: 16px;
            border: none;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .faq-item:hover {
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .faq-button {
            background-color: #2a2a2a; /* Changed to darker gray */
            border-radius: 16px;
            border: none;
            padding: 20px;
            font-family: 'Inter', sans-serif;
            font-size: 16px;
            font-weight: 600;
            color: #ffffff; /* Changed to white */
            transition: all 0.3s ease;
        }

        .faq-button:not(.collapsed) {
            background-color: #2a2a2a;
            color: #ffffff;
            font-weight: 700;
        }

        .faq-button:focus {
            box-shadow: none;
            border: none;
        }

        .faq-button::after {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23ffffff'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");
            transition: transform 0.3s ease;
        }

        .faq-button:not(.collapsed)::after {
            transform: rotate(180deg);
        }

        .faq-answer {
            padding: 20px;
            font-family: 'Inter', sans-serif;
            font-size: 14px;
            color: #cccccc; /* Changed to light gray */
            line-height: 1.6;
            background-color: #2a2a2a;
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .faq-title {
                font-size: 40px;
            }

            .faq-subtitle {
                font-size: 26px;
            }
        }

        @media (max-width: 992px) {
            .faq-title {
                font-size: 36px;
            }

            .faq-subtitle {
                font-size: 24px;
            }
        }

        @media (max-width: 768px) {
            .faq-title {
                font-size: 32px;
            }

            .faq-subtitle {
                font-size: 20px;
            }

            .faq-container {
                padding: 20px;
            }

            .faq-button {
                padding: 16px;
                font-size: 15px;
            }

            .faq-answer {
                padding: 16px;
                font-size: 13px;
            }
        }

        @media (max-width: 576px) {
            .faq-title {
                font-size: 28px;
            }

            .faq-subtitle {
                font-size: 18px;
            }

            .faq-container {
                padding: 15px;
                border-radius: 16px;
            }

            .faq-item {
                border-radius: 12px;
                margin-bottom: 10px !important;
            }

            .faq-button {
                padding: 14px;
                font-size: 14px;
                border-radius: 12px;
            }
        }

        @media (max-width: 400px) {
            .faq-title {
                font-size: 24px;
            }

            .faq-subtitle {
                font-size: 16px;
            }

            .faq-button {
                padding: 12px;
                font-size: 13px;
            }

            .faq-answer {
                font-size: 12px;
            }
        }

        /* Footer Section */
        .footer-section {
            background-color: #000000;
            padding: 80px 0 40px;
            color: #ffffff;
        }

        .footer-content {
            text-align: center;
        }

        .footer-title {
            font-family: 'Inter', sans-serif;
            font-size: 36px;
            color: #ffffff;
            font-weight: 700;
            line-height: 1.3;
            margin-bottom: 20px;
        }

        .footer-subtitle {
            font-family: 'Inter', sans-serif;
            font-size: 18px;
            color: #B0B0B0;
            font-weight: 400;
            line-height: 1.5;
            margin-bottom: 40px;
        }

        .footer-actions {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-bottom: 60px;
            flex-wrap: wrap;
        }

        .btn-started {
            font-family: 'Inter', sans-serif;
            font-size: 16px;
            font-weight: 600;
            color: #000000;
            background-color: #ffffff;
            padding: 14px 28px;
            border-radius: 10px;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-block;
        }

        .btn-started:hover {
            background-color: #f0f0f0;
            transform: translateY(-2px);
            color: #000000;
        }

        .btn-outline {
            font-family: 'Inter', sans-serif;
            font-size: 16px;
            font-weight: 600;
            color: #ffffff;
            background-color: transparent;
            padding: 14px 28px;
            border: 2px solid #ffffff;
            border-radius: 10px;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-block;
        }

        .btn-outline:hover {
            background-color: #ffffff;
            color: #000000;
            transform: translateY(-2px);
        }

        .footer-nav {
            list-style: none;
            padding: 0;
            margin: 0;
            display: flex;
            justify-content: center;
            gap: 30px;
            flex-wrap: wrap;
            padding-top: 30px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .footer-nav li {
            margin: 0;
        }

        .footer-nav a {
            font-family: 'Inter', sans-serif;
            font-size: 14px;
            color: #B0B0B0;
            text-decoration: none;
            transition: color 0.3s ease;
            font-weight: 500;
        }

        .footer-nav a:hover {
            color: #ffffff;
        }

        /* Responsive */
        @media (max-width: 992px) {
            .footer-section {
                padding: 60px 0 30px;
            }

            .footer-title {
                font-size: 32px;
            }

            .footer-subtitle {
                font-size: 16px;
            }
        }

        @media (max-width: 768px) {
            .footer-title {
                font-size: 28px;
                padding: 0 20px;
            }

            .footer-subtitle {
                font-size: 15px;
                padding: 0 20px;
            }

            .footer-actions {
                flex-direction: column;
                align-items: center;
                gap: 15px;
            }

            .btn-started,
            .btn-outline {
                width: 80%;
                max-width: 300px;
                text-align: center;
            }

            .footer-nav {
                gap: 20px;
            }
        }

        @media (max-width: 576px) {
            .footer-section {
                padding: 50px 0 25px;
            }

            .footer-title {
                font-size: 24px;
            }

            .footer-subtitle {
                font-size: 14px;
            }

            .btn-started,
            .btn-outline {
                font-size: 14px;
                padding: 12px 24px;
                width: 90%;
            }

            .footer-nav {
                flex-direction: column;
                gap: 15px;
            }

            .footer-nav a {
                font-size: 13px;
            }
        }

        @media (max-width: 400px) {
            .footer-title {
                font-size: 20px;
            }

            .footer-subtitle {
                font-size: 13px;
            }

            .btn-started,
            .btn-outline {
                font-size: 13px;
                padding: 10px 20px;
            }
        }

        .real-work-section {
            background-color: #000000; /* Changed to black */
            overflow: hidden;
        }

        .glow-wrapper {
            position: relative;
            padding: 20px;
        }

        .glow-line-border {
            position: absolute;
            inset: 0;
            border-radius: 30px;
            background: linear-gradient(135deg, #0D93FF, #C25FEA, #EE4476, #ED6D10);
            filter: blur(20px);
            opacity: 0.3;
            pointer-events: none;
            z-index: 0;
        }

        .inner-content {
            position: relative;
            z-index: 1;
            background: #000000; /* Changed to black */
            border-radius: 20px;
            padding: 60px 20px;
        }

        .section-header {
            margin-bottom: 50px;
        }

        .section-title {
            font-family: 'Inter', sans-serif;
            font-size: 50px;
            color: #ffffff; /* Changed to white */
            font-weight: 750;
            line-height: 1.2;
        }

        .cards-container {
            display: flex;
            justify-content: center;
        }

        .work-card {
            width: 400px;
            height: 400px;
            margin: 0 12px;
        }

        .card-inner {
            background-color: #1a1a1a; /* Changed to dark */
            border-radius: 16px;
            padding: 24px;
            height: 100%;
            display: flex;
            flex-direction: column;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s, box-shadow 0.3s;
        }

        .card-inner:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
        }

        .card-content {
            text-align: center;
            padding: 25px 0;
        }

        .card-title {
            font-family: 'Inter', sans-serif;
            font-size: 20px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
            margin-bottom: 30px;
        }

        .highlight-forge {
            background: linear-gradient(45deg, #F97316, #93440D);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            cursor: pointer;
            text-decoration: underline;
            font-size: 22px;
            font-weight: 700;
            transition: opacity 0.3s;
        }

        .highlight-forge:hover {
            opacity: 0.8;
        }

        .highlight-access {
            background: linear-gradient(45deg, #14B8A6, #09524A);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            cursor: pointer;
            text-decoration: underline;
            font-size: 20px;
            font-weight: 750;
            transition: opacity 0.3s;
        }

        .highlight-access:hover {
            opacity: 0.8;
        }

        .card-description {
            text-align: left;
            margin-left: 25px;
            font-family: 'Inter', sans-serif;
            font-size: 15px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 700;
            line-height: 1.6;
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .section-title {
                font-size: 45px;
            }

            .work-card {
                width: 380px;
                height: 380px;
            }
        }

        @media (max-width: 992px) {
            .section-title {
                font-size: 40px;
            }

            .inner-content {
                padding: 50px 20px;
            }

            .work-card {
                width: 350px;
                height: 360px;
                margin: 10px;
            }

            .card-title {
                font-size: 18px;
            }

            .highlight-forge {
                font-size: 20px;
            }

            .highlight-access {
                font-size: 18px;
            }
        }

        @media (max-width: 768px) {
            .section-title {
                font-size: 35px;
            }

            .glow-wrapper {
                padding: 10px;
            }

            .glow-line-border {
                filter: blur(15px);
            }

            .inner-content {
                padding: 40px 15px;
            }

            .work-card {
                width: 100%;
                max-width: 400px;
                height: auto;
                min-height: 320px;
                margin: 10px 0;
            }

            .card-description {
                text-align: center;
                margin-left: 0;
            }

            .desktop-break {
                display: none;
            }
        }

        @media (max-width: 576px) {
            .section-title {
                font-size: 28px;
            }

            .section-header {
                margin-bottom: 30px;
            }

            .card-inner {
                padding: 20px;
            }

            .card-title {
                font-size: 17px;
            }

            .highlight-forge {
                font-size: 18px;
            }

            .highlight-access {
                font-size: 17px;
            }

            .card-description {
                font-size: 14px;
                padding: 0 10px;
            }
        }

        @media (max-width: 400px) {
            .section-title {
                font-size: 24px;
            }

            .card-title {
                font-size: 16px;
            }

            .card-description {
                font-size: 13px;
            }
        }

        /* Developer Toolkit Carousel */
        .toolkit-carousel-container {
            margin-top: 60px;
        }

        .toolkit-scroll {
    display: flex;
    overflow-x: auto;
    overflow-y: hidden;
    gap: 5px;
    padding: 10px 10px;
    scroll-snap-type: x mandatory;
    -webkit-overflow-scrolling: touch;
    scrollbar-width: none;
    height: 690px;
    align-items: center;
    scroll-behavior: auto; /* Ajoutez cette ligne */
}

        .toolkit-scroll::-webkit-scrollbar {
            display: none;
        }

       .toolkit-card {
flex: 0 0 1100px;
  max-width: 1300px;
  height: 600px;
  scroll-snap-align: center;
  transition: transform 0.5s ease, opacity 0s, filter 0s ;
  transform: scale(0.9);
  filter: blur(3px) brightness(0.8);
  opacity: 0.7;
  z-index: 1;
}

.toolkit-card.active-card {
flex: 0 0 1100px;
  max-width: 1300px; /* Augmentez de 900px à 1100px */
transform: scale(0.9) ;
 filter: none;
  opacity: 1;
  z-index: 5;
}


        .toolkit-card-inner {
            background-color: #000000;
            border-radius: 20px;
            padding: 40px;
            height: 100%;
            display: flex;
            flex-direction: column;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .toolkit-header {
            padding: 60px 60px 40px;
        }

        .toolkit-title {
            font-family: 'Inter', sans-serif;
            font-size: 35px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
            margin-bottom: 15px;
        }

        .toolkit-subtitle {
            font-family: 'Inter', sans-serif;
            font-size: 26px;
            color: #cccccc; /* Changed to light gray */
            font-weight: 700;
        }

        .tech-buttons-container {
            display: flex;
            flex-direction: column;
            gap: 15px;
            align-items: center;
            justify-content: center;
            flex-grow: 1;
        }

        .tech-row {
            display: flex;
            justify-content: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        .tech-button {
            display: flex;
            align-items: center;
            background-color: #2a2a2a; /* Changed to darker gray */
            border-radius: 50px;
            padding: 8px 16px;
            gap: 12px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .tech-button:hover {
            background-color: #3a3a3a; /* Darker hover state */
            transform: translateY(-2px);
        }

        .tech-button img {
            width: 28px;
            height: 28px;
        }

        .tech-button span {
            font-family: 'Inter', sans-serif;
            font-size: 20px;
            color: #ffffff; /* Changed to white */
            font-weight: 500;
        }

        /* Timeline specific */
        .timeline-container {
            padding-left: 100px;
            display: flex;
            flex-direction: column;
            gap: 30px;
            justify-content: center;
            flex-grow: 1;
        }

        .timeline-item {
            display: flex;
            align-items: center;
            background-color: #2a2a2a; /* Changed to darker gray */
            border-radius: 50px;
            padding: 15px 25px;
            gap: 20px;
            width: fit-content;
        }

        .timeline-icon {
            width: 35px;
            height: 35px;
            filter: invert(1); /* Inverted for white icons on dark background */
        }

        .timeline-text {
            font-family: 'Inter', sans-serif;
            font-size: 30px;
            color: #ffffff; /* Changed to white */
            font-weight: 700;
        }

        /* Navigation */
        .carousel-nav {
            display: flex;
            justify-content: center;
            gap: 30px;
            margin-top: 30px;
            flex-wrap: wrap;
        }

        .nav-link {
            font-family: 'Inter', sans-serif;
            font-size: 24px;
            font-weight: 700;
            background: linear-gradient(90deg, #1658B6, #169AB6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            text-decoration: none;
            cursor: pointer;
            transition: opacity 0.3s;
        }

        .nav-link:hover {
            opacity: 0.7;
        }

        .nav-link.active {
            background: linear-gradient(90deg, #EF4ACA, #FD5823);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-weight: 800;
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .toolkit-card {
                flex: 0 0 80%;
            }

            .toolkit-title {
                font-size: 30px;
            }

            .toolkit-subtitle {
                font-size: 22px;
            }
        }

        @media (max-width: 768px) {
            .toolkit-card {
                flex: 0 0 90%;
                height: auto;
                min-height: 500px;
            }

            .toolkit-header {
                padding: 30px;
            }

            .toolkit-title {
                font-size: 24px;
            }

            .toolkit-subtitle {
                font-size: 18px;
            }

            .tech-button span {
                font-size: 16px;
            }

            .timeline-container {
                padding-left: 30px;
            }

            .timeline-text {
                font-size: 24px;
            }

            .nav-link {
                font-size: 20px;
            }
        }

        @media (max-width: 576px) {
            .toolkit-card {
                flex: 0 0 95%;
            }

            .tech-button {
                padding: 6px 12px;
            }

            .tech-button img {
                width: 20px;
                height: 20px;
            }

            .tech-button span {
                font-size: 14px;
            }

            .timeline-text {
                font-size: 20px;
            }

            .timeline-icon {
                width: 25px;
                height: 25px;
            }
        }

        .master-stack-container {
            margin-top: 80px;
            padding: 60px 0;
            position: relative;
        }

        .master-stack-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 20%;
            right: 20%;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1), transparent); /* Changed to white */
        }

        .master-stack-content {
            text-align: start;
            max-width: 900px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .master-title {
            font-family: 'Inter', sans-serif;
            font-size: 48px;
            font-weight: 800;
            color: #ffffff; /* Changed to white */
            margin-bottom: 30px;
            line-height: 1.2;
        }

        .master-description {
            font-family: 'Inter', sans-serif;
            font-size: 18px;
            font-weight: 400;
            color: #cccccc; /* Changed to light gray */
            line-height: 1.8;
            letter-spacing: 0.2px;
        }

        /* Animation */
        .master-stack-content {
            opacity: 0;
            transform: translateY(30px);
            animation: fadeInUp 1s ease forwards;
            animation-delay: 0.3s;
        }

        @keyframes fadeInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive */
        @media (max-width: 992px) {
            .master-stack-container {
                margin-top: 60px;
                padding: 50px 0;
            }

            .master-title {
                font-size: 40px;
            }

            .master-description {
                font-size: 16px;
            }
        }

        @media (max-width: 768px) {
            .master-title {
                font-size: 32px;
            }

            .master-description {
                font-size: 15px;
                line-height: 1.7;
            }

            .master-stack-container::before {
                left: 10%;
                right: 10%;
            }
        }

        @media (max-width: 576px) {
            .master-stack-container {
                margin-top: 40px;
                padding: 40px 0;
            }

            .master-title {
                font-size: 26px;
                margin-bottom: 20px;
            }

            .master-description {
                font-size: 14px;
            }
        }

        @media (max-width: 400px) {
            .master-title {
                font-size: 22px;
            }

            .master-description {
                font-size: 13px;
                line-height: 1.6;
            }
        }

        /* Machine Power Section */
        .machine-power-section {
            background: #000000;
            padding: 100px 0;
            position: relative;
            overflow: hidden;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            position: relative;
            z-index: 2;
        }

        .section-header {
            text-align: center;
            margin-bottom: 80px;
        }

        .main-title {
            font-family: 'Inter', sans-serif;
            font-size: 58px;
            font-weight: 800;
            color: #ffffff;
            margin-bottom: 30px;
            line-height: 1.1;
            letter-spacing: -0.02em;
        }

        .main-subtitle {
            font-family: 'Inter', sans-serif;
            font-size: 20px;
            font-weight: 400;
            color: #b0b0b0;
            line-height: 1.6;
            max-width: 600px;
            margin: 0 auto;
        }

        /* Content Layout - 30% texte, 70% image */
        .content-grid {
            display: flex;
            align-items: center;
            gap: 40px;
        }

        /* Features List - 30% */
        .features-list {
            width: 25%;
            display: flex;
            flex-direction: column;
            gap: 40px;
        }

        .feature-item {
            display: flex;
            align-items: flex-start;
            gap: 15px;
            opacity: 0;
            transform: translateY(30px);
            animation: fadeInUp 0.8s ease forwards;
        }

        .feature-item:nth-child(1) { animation-delay: 0.2s; }
        .feature-item:nth-child(2) { animation-delay: 0.4s; }
        .feature-item:nth-child(3) { animation-delay: 0.6s; }

        .feature-icon {
            width: 42px;
            height: 42px;
            flex-shrink: 0;
            filter: brightness(0) invert(1);
            transition: all 0.3s ease;
        }

        .feature-content h3 {
            font-family: 'Inter', sans-serif;
            font-size: 16px;
            font-weight: 700;
            color: #ffffff;
            margin-bottom: 8px;
        }

        .feature-highlight {
            background: linear-gradient(45deg, #4CAF50, #76FF03);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-weight: 700;
        }

        .feature-content p {
            font-family: 'Inter', sans-serif;
            font-size: 13px;
            font-weight: 400;
            color: #888888;
            line-height: 1.6;
        }

        /* Machine Visual - 70% */
        .machine-visual {
            width: 100%;
            position: relative;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .machine-container {
            position: relative;
            width: 100%;
            max-width: 600px;
            height: 450px;
        }

        .machine-image {
            width: 150%;
            height: 100%;
            object-fit: contain;
            border-radius: 16px;
        }

        /* Section Journey */
        .journey-section {
            background: #000;
            padding: 80px 0;
        }

        .journey-card {
            background: #1a1a1a;
            border-radius: 16px;
            padding: 40px 30px;
            color: #fff;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4);
            text-align: left;
            position: relative;
        }

        .journey-title {
            font-family: 'Inter', sans-serif;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 20px;
            color: #ffffff;
        }

        .journey-text {
            font-size: 24px;
            line-height: 1.6;
            color: #FFFFFF;
            font-weight: 500;
            margin-bottom: 40px;
            padding-top:20px;
        }

        .journey-btn-wrapper {
            text-align: right;
        }

        .journey-btn {
                        width:150px;

            display: inline-block;
            padding: 10px 32px;
            font-size: 16px;
            font-weight: 600;
            text-align:center;
            border-radius: 30px;
            color: #fff;
            text-decoration: none;
            background: #000;
            border: 2px solid transparent;
            background-clip: padding-box;
            position: relative;
            z-index: 1;
        }

        .journey-btn::before {
            content: '';
            position: absolute;
            inset: 0;
            border-radius: 30px;
            padding: 2px;
            background: linear-gradient(90deg, #0170E3, #0170E3, #0170E3, #0170E3);

            mask-composite: exclude;
            z-index: -1;
        }



        /* Responsive Design for Machine Power Section */
        @media (max-width: 1200px) {
            .main-title {
                font-size: 48px;
            }

            .main-subtitle {
                font-size: 18px;
            }

            .machine-container {
                 max-width: 800px; /* était 600px */
    height: 600px;
            }
        }

        @media (max-width: 992px) {
            .machine-power-section {
                padding: 80px 0;
            }

            .main-title {
                font-size: 42px;
            }

            .machine-container {
                max-width: 450px;
                height: 340px;
            }

            .feature-content h3 {
                font-size: 15px;
            }

            .feature-content p {
                font-size: 12px;
            }
        }

        @media (max-width: 768px) {
            .machine-power-section {
                padding: 60px 0;
            }

            .section-header {
                margin-bottom: 50px;
            }

            .main-title {
                font-size: 36px;
            }

            .main-subtitle {
                font-size: 16px;
            }

            .content-grid {
                flex-direction: column;
                gap: 40px;
            }

            .features-list,
            .machine-visual {
                width: 100%;
            }

            .machine-visual {
                order: -1;
            }

            .machine-container {
                max-width: 400px;
                height: 300px;
            }

            .features-list {
                gap: 30px;
            }
        }

        @media (max-width: 576px) {
            .container {
                padding: 0 15px;
            }

            .main-title {
                font-size: 28px;
            }

            .main-subtitle {
                font-size: 15px;
            }

            .machine-container {
                max-width: 320px;
                height: 240px;
            }

            .feature-icon {
                width: 36px;
                height: 36px;
            }

            .feature-item {
                gap: 12px;
            }

            .feature-content h3 {
                font-size: 14px;
            }

            .feature-content p {
                font-size: 11px;
            }
        }

        @media (max-width: 400px) {
            .main-title {
                font-size: 24px;
                line-height: 1.2;
            }

            .main-subtitle {
                font-size: 14px;
            }

            .machine-container {
                max-width: 280px;
                height: 210px;
            }
        }

                        .login-btn {
    font-family: 'Inter', sans-serif;
    font-size: 16px;
    font-weight: 600;
    color: #000000;
    background-color: #ffffff;
    padding: 12px 24px;
    text-decoration: none;
    display: inline-block;
    border-radius: 10px;
    transition: all 0.3s ease;
    margin-left: 30px;
}

.login-btn:hover {
    background-color: #333333;
    transform: translateY(-2px);
    color: #FFFFFF;
}

/* Responsive pour le bouton login */
@media (max-width: 1199px) {
    .login-btn {
        margin-left: 20px;
        font-size: 15px;
        padding: 10px 20px;
    }
}

@media (max-width: 991px) {
    .login-btn {
        margin-left: 15px;
        font-size: 14px;
        padding: 8px 16px;
    }
}

/* Mobile login button */
.mobile-login-btn {
    font-family: 'Inter', sans-serif;
    font-size: 16px;
    font-weight: 600;
    color: #FFFFFF;
    background-color: #000000;
    padding: 12px 24px;
    text-decoration: none;
    display: block;
    border-radius: 10px;
    transition: all 0.3s ease;
    margin-top: 20px;
    text-align: center;
}

.mobile-login-btn:hover {
    background-color: #333333;
    color: #FFFFFF;
}

.carousel-descriptions {
    text-align: center;
    margin-top: 30px;
    min-height: 80px;
    position: relative;
}

.carousel-desc {
    font-family: 'Inter', sans-serif;
    font-size: 18px;
    color: #616160;
    font-weight: 700;
    line-height: 1.6;
    max-width: 600px;
    margin: 0 auto;
    padding: 0 20px;
    opacity: 0;
    position: absolute;
    left: 0;
    right: 0;
    transform: translateY(10px);
    transition: opacity 0.4s ease, transform 0.4s ease;
    pointer-events: none;
}

.carousel-desc.active {
    opacity: 1;
    transform: translateY(0);
    position: relative;
    pointer-events: auto;
}

/* Responsive */
@media (max-width: 768px) {
    .carousel-desc {
        font-size: 16px;
    }

    .carousel-descriptions {
        min-height: 100px;
    }
}

@media (max-width: 576px) {
    .carousel-desc {
        font-size: 14px;
    }
}
    </style>
</head>

<body>
    <!-- Header -->
 <header class="am-header_five">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="am-header_two_wrap">
                    <!-- Logo -->
                    <strong class="am-logo">
                        <a href="/">
                            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/logoo.png" alt="Alplatforme Logo">
                        </a>
                    </strong>

                    <!-- Navigation Desktop -->
                    <nav class="am-navigation d-none d-lg-flex">
    <ul class="am-nav-menu">
        <li><a href="/" class="nav-linkk <?php echo e(Request::is('/') ? 'active' : ''); ?>">Home</a></li>
        <li><a href="/web-dev" class="nav-linkk <?php echo e(Request::is('web-dev') ? 'active' : ''); ?>">Front-End</a></li>
        <li><a href="/ai-dev" class="nav-linkk <?php echo e(Request::is('ai-dev') ? 'active' : ''); ?>">AI Development</a></li>
        <li><a href="/dataanalyst" class="nav-linkk <?php echo e(Request::is('dataanalyst') ? 'active' : ''); ?>">Data Analysis</a></li>
        <li><a href="/fulstack" class="nav-linkk <?php echo e(Request::is('fulstack') ? 'active' : ''); ?>">Full Stack</a></li>
        <li><a href="/Back-end" class="nav-linkk <?php echo e(Request::is('Back-end') ? 'active' : ''); ?>">Back-End</a></li>
        <li><a href="/Contact" class="nav-linkk <?php echo e(Request::is('Contact') ? 'active' : ''); ?>">Contact</a></li>
    </ul>
    <!-- Bouton Login -->
    <a href="/login" class="login-btn">Login</a>
</nav>

                    <!-- Burger Menu Button -->
                    <button class="burger-btn d-lg-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#mobileMenu">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu Offcanvas -->
    <div class="offcanvas offcanvas-end" tabindex="-1" id="mobileMenu">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title">Menu</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
        </div>
       <div class="offcanvas-body">
    <ul class="mobile-nav-menu">
        <li><a href="/" class="mobile-nav-link <?php echo e(Request::is('/') ? 'active' : ''); ?>">Home</a></li>
        <li><a href="/web-dev" class="mobile-nav-link <?php echo e(Request::is('web-dev') ? 'active' : ''); ?>">Front-End</a></li>
        <li><a href="/ai-dev" class="mobile-nav-link <?php echo e(Request::is('ai-dev') ? 'active' : ''); ?>">AI Development</a></li>
        <li><a href="/dataanalyst" class="mobile-nav-link <?php echo e(Request::is('dataanalyst') ? 'active' : ''); ?>">Data Analysis</a></li>
        <li><a href="/fulstack" class="mobile-nav-link <?php echo e(Request::is('fulstack') ? 'active' : ''); ?>">Full Stack</a></li>
        <li><a href="/Back-end" class="mobile-nav-link <?php echo e(Request::is('Back-end') ? 'active' : ''); ?>">Back-End</a></li>
        <li><a href="/Contact" class="mobile-nav-link <?php echo e(Request::is('Contact') ? 'active' : ''); ?>">Contact</a></li>
    </ul>
    <!-- Bouton Login Mobile -->
    <a href="/login" class="mobile-login-btn">Login</a>
</div>
    </div>
</header>

    <!-- Main Content -->
    <main class="am-main">
        <div class="page-home-three">
     <section class="pb-themesection">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="am-banner-potential am-banner-content-three">
                    <div class="container">
                        <div class="row">
                            <div class="col-12">
                                <div class="am-banner-main">
                                    <div class="am-banner-content">
                                        <div class="am-banner-tutor">
                                            <h2 class="banner-title fade-up delay-300">
                                                Think in Code. Act with Vision.
                                            </h2>
                                            <span class="pt-5 banner-subtitle fade-up delay-400">
                                                AI is not just a tool — it’s a reflection of how we think.
                                                We teach you to shape it, guide it, and build with it.
                                                Because when machines learn from us, they help us build what matters.
                                            </span>
                                            <div class="am-explore-banner-button fade-up delay-500">
                                                <a href="#" class="explore-btn">
                                                    Explore Now
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



         <section class="pb-themesection py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="info-card">
          <!-- Texte à gauche -->
          <div class="info-content">
            <!-- Titre -->
            <div class="text-center">
              <h3 class="info-title">
                Built to think with you —  not for you.
              </h3>
            </div>
            <!-- Description -->
            <div class="d-flex flex-grow-1 align-items-center justify-content-center">
              <p class="info-description">
                Nova becomes your thinking partner — shaping ideas,
                refining models, and unlocking what’s next.
                It doesn’t just respond. It thinks with you.
              </p>
            </div>
          </div>
          <!-- Image à droite -->
          <div class="info-image">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMGTEST1.png"
              alt="Nova coding co-pilot">
          </div>
        </div>
      </div>
    </div>
  </div>
</section>



<!-- Section Built-In Intelligence -->
<section class="pb-themesection py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="info-card-reverse">
          <!-- Image à gauche -->
          <div class="info-image-reverse">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMGTEST1.png"
              alt="AI training workspace image">
          </div>
          <!-- Texte à droite -->
          <div class="info-content-reverse">
            <!-- Titre -->
            <div class="text-center">
              <h3 class="info-title">
                Train. Test. Evolve —  all without breaking your flow.
              </h3>
            </div>
            <!-- Description -->
            <div class="d-flex flex-grow-1 align-items-center justify-content-center">
              <p class="info-description">
                One focused space for building AI — write prompts,
                train models, explore results.
                No clutter. No switching. Just seamless, hands-on progress.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>



<section class="pb-themesection py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="info-card">
          <!-- Texte à gauche -->
          <div class="info-content">
            <!-- Titre -->
            <div class="text-center">
              <h3 class="info-title">
                Real questions. Honest answers.
              </h3>
            </div>
            <!-- Description -->
            <div class="d-flex flex-grow-1 align-items-center justify-content-center">
              <p class="info-description">
                No one trains alone.
                From training hiccups to prompt rewrites,
                this is where peers help peers.
                No noise — just clarity, support, and real progress.
              </p>
            </div>
          </div>
          <!-- Image à droite -->
          <div class="info-image">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/IMGTEST1.png"
              alt="Real questions. Honest answers. image">
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- Section Real Work -->
<!-- Section Real Work with Developer Toolkit -->
<section class="real-work-section py-5">
    <div class="container pt-5">
        <div class="glow-wrapper">
            <div class="glow-line-border"></div>

            <div class="inner-content">
                <!-- Titre -->
                <div class="text-center section-header">
                    <h2 class="section-title">
                        The real work starts here.
                    </h2>
                </div>

                <!-- Cards Container (vos 2 cartes existantes) -->
                <div class="cards-container mb-5">
                    <div class="row justify-content-center">
                        <div class="col-12 d-flex justify-content-center flex-wrap">
                            <!-- Card 1 - Forge -->
                            <div class="work-card">
                                <div class="card-inner">
                                    <div class="card-content">
                                        <h4 class="card-title">
                                            Real-world projects,<br> powered by
                                            <span class="highlight-forge" onclick="openModal()">Forge</span>
                                        </h4>
                                        <p class="card-description">
                                            Design interfaces that feel real. Build<br class="desktop-break">
                                            logic that scales. Connect it all into<br class="desktop-break">
                                            websites that do more than run —<br class="desktop-break">
                                            they represent you.
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Card 2 - Access -->
                            <div class="work-card">
                                <div class="card-inner">
                                    <div class="card-content">
                                        <h4 class="card-title">
                                            <span class="highlight-access" onclick="openModal2()">Access</span>
                                            your dev studio —<br> wherever you are
                                        </h4>
                                        <p class="card-description">
                                            Build your backend on a train. Sketch<br class="desktop-break">
                                            your UI at a coffee shop. The full-stack<br class="desktop-break">
                                            experience is always one tab away
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Developer Toolkit Carousel -->
                <div class="toolkit-carousel-container">
        <div id="scroll-container" class="toolkit-scroll">
            <!-- Card 1 - Developer Toolkit -->
            <div id="card-toolkit" class="toolkit-card">
                <div class="toolkit-card-inner">
                    <div class="toolkit-header">
                        <h4 class="toolkit-title">Your Developer Toolkit</h4>
                        <p class="toolkit-subtitle">Learn the technologies powering the modern web.</p>
                    </div>

                    <div class="tech-buttons-container">
                        <!-- First Row -->
                        <div class="tech-row">
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/html5/html5-original.svg" alt="HTML">
                                <span>HTML</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/css3/css3-original.svg" alt="CSS">
                                <span>CSS</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/javascript/javascript-original.svg" alt="JavaScript">
                                <span>JavaScript</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/react/react-original.svg" alt="React">
                                <span>React</span>
                            </div>
                        </div>
                        <!-- Second Row -->
                        <div class="tech-row">
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/nodejs/nodejs-original.svg" alt="Node.js">
                                <span>Node.js</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/python/python-original.svg" alt="Python">
                                <span>Python</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/git/git-original.svg" alt="Git">
                                <span>Git</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Card 2 - Timeline (celle qu'on veut centrer par défaut) -->
            <div id="card-timeline" class="toolkit-card">
                <div class="toolkit-card-inner">
                    <div class="toolkit-header">
                        <h4 class="toolkit-title">Clarity from day one — see how you GROW</h4>
                    </div>

                    <div class="timeline-container">
                        <div class="timeline-item">
                            <img src="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6/svgs/solid/calendar.svg" alt="Calendar" class="timeline-icon">
                            <span class="timeline-text">16 weeks</span>
                        </div>
                        <div class="timeline-item">
                            <img src="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6/svgs/solid/clock.svg" alt="Time" class="timeline-icon">
                            <span class="timeline-text">4 Hours/week</span>
                        </div>
                        <div class="timeline-item">
                            <img src="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6/svgs/solid/certificate.svg" alt="Certified" class="timeline-icon">
                            <span class="timeline-text">Certified</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Card 3 - Learning Path -->
            <div id="card-learning" class="toolkit-card">
                <div class="toolkit-card-inner">
                    <div class="toolkit-header">
                        <h4 class="toolkit-title">Your Learning Path</h4>
                        <p class="toolkit-subtitle">Master the fundamentals step by step.</p>
                    </div>

                    <div class="tech-buttons-container">
                        <!-- Same buttons structure -->
                        <div class="tech-row">
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/html5/html5-original.svg" alt="HTML">
                                <span>HTML</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/css3/css3-original.svg" alt="CSS">
                                <span>CSS</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/javascript/javascript-original.svg" alt="JavaScript">
                                <span>JavaScript</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/react/react-original.svg" alt="React">
                                <span>React</span>
                            </div>
                        </div>
                        <div class="tech-row">
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/nodejs/nodejs-original.svg" alt="Node.js">
                                <span>Node.js</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/python/python-original.svg" alt="Python">
                                <span>Python</span>
                            </div>
                            <div class="tech-button">
                                <img src="https://cdn.jsdelivr.net/gh/devicons/devicon/icons/git/git-original.svg" alt="Git">
                                <span>Git</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation -->
        <div class="carousel-nav">
            <a href="#card-toolkit" class="nav-link" onclick="scrollToCard('card-toolkit', event)">Toolkit</a>
            <a href="#card-timeline" class="nav-link active" onclick="scrollToCard('card-timeline', event)">Timeline</a>
            <a href="#card-learning" class="nav-link" onclick="scrollToCard('card-learning', event)">Learning Path</a>
        </div>

         <div class="carousel-descriptions">
    <p id="desc-toolkit" class="carousel-desc">
       Your time. Your pace. Your progress.See what it takes. Know where you’re going. Track hours, follow your timeline, and earn your certification — all in one clear view.
    </p>
    <p id="desc-timeline" class="carousel-desc active">
        Everything you need to build — all in one place. Get coding environments, project files, design templates, and debugging tools without ever leaving your flow. No switching tabs. No setup stress. Just tools that work where and when you need them.
    </p>
    <p id="desc-learning" class="carousel-desc">
        Learn with clarity, not guesswork. Your journey is mapped from Day 1 — with structured tracks, real checkpoints, and clear outcomes. So you always know what you’re doing, why it matters, and what comes next.
    </p>
</div>
    </div>

             <div class="master-stack-container">
  <div class="row justify-content-center">
    <div class="col-12 col-lg-10">
      <div class="master-stack-content">
        <h2 class="master-title">Learn live. Build real.</h2>
        <p class="master-description">
          Great learning doesn’t stop at understanding — it moves into creation.
          Our live AI courses are designed to take you from first concepts to real, working systems.
          Led by professionals who build what they teach, each session is focused, intentional, and built for clarity.
          You won’t just follow along — you’ll build AI that thinks, adapts, and delivers.
        </p>
      </div>
    </div>
  </div>
</div>

            </div>
        </div>
    </div>
</section>

 <section class="machine-power-section">
        <div class="container">
            <!-- Header -->
            <div class="section-header">
                <h2 class="main-title">Meet true machine power</h2>
                <p class="main-subtitle">
                    When human code meets raw machine force — limits vanish, and futures begin.
                </p>
            </div>

            <!-- Content Grid -->
            <div class="content-grid">
                <!-- Features List - 30% -->
                <div class="features-list">
                    <div class="feature-item">
                        <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/eye%201.png"
                             alt="Vision Icon" class="feature-icon">
                        <div class="feature-content">
                            <h3>Built for Vision.</h3>
                            <p>Where ambition meets acceleration, your ideas run at the speed of thought.</p>
                        </div>
                    </div>

                    <div class="feature-item">
                        <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/cpu%201.png"
                             alt="CPU Icon" class="feature-icon">
                        <div class="feature-content">
                            <h3>Next-Gen GPUs Powered by NVIDIA A100</h3>
                            <p>and H100, the same architecture driving the world's most advanced AI.</p>
                        </div>
                    </div>

                    <div class="feature-item">
                        <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/clock-refresh%20(1)%204.png"
                             alt="Clock Icon" class="feature-icon">
                        <div class="feature-content">
                            <h3>Ready When You Are.</h3>
                            <p>No waiting, no setup. Just open, code, and watch performance keep pace with your mind.</p>
                        </div>
                    </div>
                </div>

                <!-- Machine Visual - 70% -->
                <div class="machine-visual">
                    <div class="machine-container">
                        <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/h100-og%20(1)0%201.png"
                             alt="NVIDIA H100 GPU" class="machine-image">
                    </div>
                </div>
            </div>
        </div>
    </section>

<!-- Section Permission to Grow -->
<!-- Section Guidance Personal -->
<section class="permission-section pb-themesection py-5">
  <div class="container">
    <!-- Titre en haut, en dehors de la carte -->
    <div class="row justify-content-center mb-5">
      <div class="col-12 text-center">
        <h2 style="font-family: 'Inter', sans-serif; font-size: 45px; color: #ffffff; font-weight: 700; line-height: 1.2;">
          Guidance that feels personal.<br>
          Because it is.
        </h2>
      </div>
    </div>

    <!-- Carte avec image et texte -->
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="permission-card">
          <!-- Image à gauche -->
          <div class="permission-image">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/img7.jpg"
              alt="Guidance that feels personal">
          </div>
          <!-- Texte à droite -->
          <div class="permission-content">
            <!-- Description -->
            <div class="permission-text-wrapper">
              <p class="permission-text">
With mentors by your side — and AI guiding your experiments — you move faster, with sharper insights.
<br class="desktop-break  pt-4">
                <br class="desktop-break pt-4">
Small groups mean smarter feedback, faster iteration, and room to explore freely.

<br class="desktop-break  pt-4">
                <br class="desktop-break  pt-4">
Learn live from experts who build AI models — not just explain them.<br class="desktop-break  pt-4">
                <br class="desktop-break  pt-4">
                Design. Train. Test. Deploy. One environment optimized for AI experimentation.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>







<!-- Section Testimonials -->
<section class="testimonials-section py-5">
  <div class="container">
    <div class="testimonials-header mb-5">
      <h2 class="testimonials-title">
        Voices that matter.
      </h2>
      <p class="testimonials-subtitle pt-5">
        Professors, creators, and pros share their experience.
      </p>
    </div>

    <div class="row g-4">
      <!-- Testimonial 1 -->
      <div class="col-md-4">
        <div class="testimonial-card">
          <p class="testimonial-text">
            AI-native platforms like Alplatform are the future, enabling business and L&D leaders to create dynamic, personalized, highly efficient training in an exciting rebirth of this profession.
          </p>
          <div class="testimonial-author">
            <img src="https://amento-bucket-poc-2.s3.amazonaws.com/optionbuilder/uploads/customer-01.png"
                 alt="Arlene M" class="author-avatar">
            <div class="author-info">
              <h5 class="author-name">Arlene M</h5>
              <small class="author-role">Agile District</small>
            </div>
          </div>
        </div>
      </div>

      <!-- Testimonial 2 -->
      <div class="col-md-4">
        <div class="testimonial-card">
          <p class="testimonial-text">
            AI-native platforms like Alplatform are the future, enabling business and L&D leaders to create dynamic, personalized, highly efficient training in an exciting rebirth of this profession.
          </p>
          <div class="testimonial-author">
            <img src="https://amento-bucket-poc-2.s3.amazonaws.com/optionbuilder/uploads/customer-02.png"
                 alt="Devon L" class="author-avatar">
            <div class="author-info">
              <h5 class="author-name">Devon L</h5>
              <small class="author-role">Classroom Teacher</small>
            </div>
          </div>
        </div>
      </div>

      <!-- Testimonial 3 -->
      <div class="col-md-4">
        <div class="testimonial-card">
          <p class="testimonial-text">
            AI-native platforms like Alplatform are the future, enabling business and L&D leaders to create dynamic, personalized, highly efficient training in an exciting rebirth of this profession.
          </p>
          <div class="testimonial-author">
            <img src="https://amento-bucket-poc-2.s3.amazonaws.com/optionbuilder/uploads/customer-03.png"
                 alt="Darlene R" class="author-avatar">
            <div class="author-info">
              <h5 class="author-name">Darlene R</h5>
              <small class="author-role">Academic Advisor</small>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Section Journey -->
<section class="journey-section py-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="journey-card">
          <h2 class="journey-title">Your journey starts here</h2>
          <p class="journey-text">
            One clear path. One complete experience.<br>From first line of code to real AI in action — built live, backed by pros, powered by raw machine force
          </p>
          <div class="journey-btn-wrapper">
            <a href="#" class="journey-btn">Buy</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Section FAQ -->
<section class="faq-section pb-themesection pt-5 pb-5">
  <div class="container">
    <div class="faq-header mb-5">
      <h2 class="faq-title">
The important stuff, explained simply.
      </h2>
      <p class="faq-subtitle pt-3">
We’ve answered what matters most — so you can focus on what comes next :      </p>
    </div>

    <!-- Carte blanche contenant les FAQs -->
    <div class="faq-container">
      <div class="accordion accordion-flush" id="accordionFlushExample">

        <!-- FAQ Item 1 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq1">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse1" aria-expanded="false" aria-controls="collapse1">
              How do I find a tutor?
            </button>
          </h2>
          <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="faq1" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              Use the search bar and filters on the "Find a Tutor" page to search for tutors by subject, availability, rating, and more.
            </div>
          </div>
        </div>

        <!-- FAQ Item 2 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq2">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse2" aria-expanded="false" aria-controls="collapse2">
              How do I book a session?
            </button>
          </h2>
          <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="faq2" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              Once you find a tutor, view their profile and select an available time slot that suits you. Click "Book Now" and follow the prompts to confirm your session.
            </div>
          </div>
        </div>

        <!-- FAQ Item 3 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq3">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse3" aria-expanded="false" aria-controls="collapse3">
              What if I need to cancel or reschedule a session?
            </button>
          </h2>
          <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="faq3" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              You can cancel or reschedule a session up to 24 hours before the scheduled time without penalty. Cancellations within 24 hours may incur a fee.
            </div>
          </div>
        </div>

        <!-- FAQ Item 4 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq4">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
              How do I pay for sessions?
            </button>
          </h2>
          <div id="collapse4" class="accordion-collapse collapse" aria-labelledby="faq4" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              Payments are made through our secure payment gateway using credit/debit cards or other available payment methods.
            </div>
          </div>
        </div>

        <!-- FAQ Item 5 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq5">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
              What should I do if my tutor doesn't show up?
            </button>
          </h2>
          <div id="collapse5" class="accordion-collapse collapse" aria-labelledby="faq5" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              If your tutor does not show up for a scheduled session, please contact our support team immediately for assistance and to arrange a refund or reschedule.
            </div>
          </div>
        </div>

        <!-- FAQ Item 6 -->
        <div class="accordion-item faq-item mb-3">
          <h2 class="accordion-header" id="faq6">
            <button class="accordion-button collapsed faq-button" type="button" data-bs-toggle="collapse"
              data-bs-target="#collapse6" aria-expanded="false" aria-controls="collapse6">
              How do I leave feedback for my tutor?
            </button>
          </h2>
          <div id="collapse6" class="accordion-collapse collapse" aria-labelledby="faq6" data-bs-parent="#accordionFlushExample">
            <div class="accordion-body faq-answer">
              After your session, you will receive an email prompting you to rate your tutor and provide feedback. You can also do this from your account dashboard.
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>


<!-- Footer -->
<footer class="footer-section">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="footer-content">
                    <h2 class="footer-title" data-aos="fade-up" data-aos-duration="400" data-aos-easing="ease">
                        The standard isn't what's out there. It's what you choose to become
                    </h2>
                    <p class="footer-subtitle" data-aos="fade-up" data-aos-duration="500" data-aos-easing="ease">
                        The standard isn't what's out there. It's what you choose to become.
                    </p>
                    <div class="footer-actions" data-aos="fade-up" data-aos-duration="600" data-aos-easing="ease">
                        <a href="#" class="btn-started">Get Started Now</a>
                        <a href="#" class="btn-outline">Learn About Alplatforme</a>
                    </div>
                    <ul class="footer-nav">
                        <li><a href="#">About Us</a></li>
                        <li><a href="#">Terms and Conditions</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">FAQs</a></li>
                        <li><a href="#">Blogs</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>

        </div>
    </main>

    <!-- Bootstrap JS (optionnel mais utile pour le responsive) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


      <script>
        // Fonction pour centrer une carte spécifique
       function scrollToCard(cardId, event) {
    if (event) {
        event.preventDefault();
    }

    const card = document.getElementById(cardId);
    const container = document.getElementById('scroll-container');

    if (card && container) {
        // AJOUTER ICI - Activer immédiatement la carte (enlever le blur)
        const cards = container.querySelectorAll('.toolkit-card');
        cards.forEach(c => c.classList.remove('active-card'));
        card.classList.add('active-card');

        // Calculer la position pour centrer la carte
        const cardRect = card.getBoundingClientRect();
        const containerRect = container.getBoundingClientRect();
        const cardCenter = card.offsetLeft + (card.offsetWidth / 2);
        const containerCenter = container.offsetWidth / 2;
        const scrollPosition = cardCenter - containerCenter;

        // Scroll vers la position calculée
        container.scrollTo({
            left: scrollPosition,
            behavior: 'smooth'
        });

        // Mettre à jour les classes actives dans la navigation
        updateActiveNavLink(cardId);
    }
}

        // Fonction pour mettre à jour le lien actif
        function updateActiveNavLink(activeCardId) {
            const navLinks = document.querySelectorAll('.nav-link');
            navLinks.forEach(link => {
                link.classList.remove('active');
                if (link.getAttribute('href') === '#' + activeCardId) {
                    link.classList.add('active');
                }
            });
        }

        // Fonction pour déterminer quelle carte est actuellement au centre
        function detectCenteredCard() {
    const container = document.getElementById('scroll-container');
    const cards = container.querySelectorAll('.toolkit-card');
    const containerRect = container.getBoundingClientRect();
    const containerCenter = containerRect.left + (containerRect.width / 2);

    let closestCard = null;
    let closestDistance = Infinity;

    cards.forEach(card => {
        const cardRect = card.getBoundingClientRect();
        const cardCenter = cardRect.left + (cardRect.width / 2);
        const distance = Math.abs(cardCenter - containerCenter);

        if (distance < closestDistance) {
            closestDistance = distance;
            closestCard = card;
        }
    });

    if (closestCard) {
        // Retirer l'effet actif des autres cartes
        cards.forEach(c => c.classList.remove('active-card'));
        // Activer la carte centrée
        closestCard.classList.add('active-card');
        // Mettre à jour la nav
        updateActiveNavLink(closestCard.id);
    }
}

        // Centrer la carte Timeline au chargement de la page
        window.addEventListener('load', function() {
            // Petit délai pour s'assurer que le DOM est complètement rendu
            setTimeout(function() {
                scrollToCard('card-timeline');
            }, 100);
        });

        // Détecter la carte centrée pendant le scroll
        const scrollContainer = document.getElementById('scroll-container');
        let scrollTimeout;

        scrollContainer.addEventListener('scroll', function() {
            clearTimeout(scrollTimeout);
            scrollTimeout = setTimeout(detectCenteredCard, 150);
        });

        // Alternative pour les navigateurs qui ne supportent pas bien scrollTo
        function fallbackScrollToCenter() {
            const container = document.getElementById('scroll-container');
            const timelineCard = document.getElementById('card-timeline');

            if (container && timelineCard) {
                // Méthode alternative utilisant scrollIntoView
                timelineCard.scrollIntoView({
                    behavior: 'auto',
                    inline: 'center',
                    block: 'nearest'
                });
            }
        }

        // Si la première méthode ne fonctionne pas, essayer la méthode alternative
        window.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                const container = document.getElementById('scroll-container');
                // Vérifier si la carte n'est pas déjà centrée
                if (container && container.scrollLeft === 0) {
                    fallbackScrollToCenter();
                }
            }, 200);
        });
    </script>


    <script>
// Animation AOS pour le footer (si AOS est disponible)
document.addEventListener('DOMContentLoaded', function() {
    if (typeof AOS !== 'undefined') {
        AOS.init({
            once: true,
            offset: 50
        });
    }

    // Smooth scroll pour les liens du footer
    const footerLinks = document.querySelectorAll('.footer-nav a');
    footerLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            if (this.getAttribute('href').startsWith('#')) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            }
        });
    });
});
</script>
    <script>
// Amélioration de l'expérience FAQ
document.addEventListener('DOMContentLoaded', function() {
    // Auto-close other accordion items when one is opened
    const accordionButtons = document.querySelectorAll('.faq-button');

    accordionButtons.forEach(button => {
        button.addEventListener('click', function() {
            // Smooth scroll to the opened item
            setTimeout(() => {
                if (!this.classList.contains('collapsed')) {
                    this.scrollIntoView({
                        behavior: 'smooth',
                        block: 'center'
                    });
                }
            }, 350);
        });
    });
});
</script>
    <script>
// Animation au scroll pour la section Permission
document.addEventListener('DOMContentLoaded', function() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);

    const permissionCards = document.querySelectorAll('.permission-card');
    permissionCards.forEach(card => {
        observer.observe(card);
    });
});
</script>
    <script>
document.addEventListener('DOMContentLoaded', () => {
    // Initialize sliders
    function initializeSlider(sliderId) {
        const slider = document.getElementById(sliderId);
        if (!slider) return;

        const flipFront = slider.closest('.flip-front');
        const beforeImage = flipFront.querySelector('.before-image');
        const afterImage = flipFront.querySelector('.after-image');
        let isDragging = false;

        const moveSlider = (e) => {
            if (!isDragging) return;
            e.preventDefault();

            const rect = flipFront.getBoundingClientRect();
            let x = (e.type.startsWith('touch') ? e.touches[0].clientX : e.clientX) - rect.left;
            x = Math.max(0, Math.min(x, rect.width));
            const percent = (x / rect.width) * 100;

            slider.style.left = `${percent}%`;
            beforeImage.style.clipPath = `inset(0 ${100 - percent}% 0 0)`;
            afterImage.style.clipPath = `inset(0 0 0 ${percent}%)`;
        };

        // Mouse events
        slider.addEventListener('mousedown', (e) => {
            isDragging = true;
            e.preventDefault();
        });

        document.addEventListener('mousemove', moveSlider);
        document.addEventListener('mouseup', () => {
            isDragging = false;
        });

        // Touch events for mobile
        slider.addEventListener('touchstart', (e) => {
            isDragging = true;
            e.preventDefault();
        });

        document.addEventListener('touchmove', moveSlider, { passive: false });
        document.addEventListener('touchend', () => {
            isDragging = false;
        });
    }

    // Initialize flip buttons
    function initializeFlipButtons() {
        document.querySelectorAll('.flip-button, .flip-buttonferme').forEach(button => {
            button.addEventListener('click', (e) => {
                e.preventDefault();
                e.stopPropagation();
                const flipCard = button.closest('.flip-card');
                if (flipCard) {
                    flipCard.classList.toggle('flipped');
                }
            });
        });
    }

    // Initialize everything
    initializeSlider('slider1');
    initializeSlider('slider2');
    initializeFlipButtons();

    // Optional: Add scroll buttons for better UX
    const track = document.querySelector('.carousel-track');
    if (track) {
        // Smooth scroll to specific card
        const scrollToCard = (index) => {
            const cards = track.querySelectorAll('.flip-card');
            if (cards[index]) {
                cards[index].scrollIntoView({ behavior: 'smooth', inline: 'center', block: 'nearest' });
            }
        };
    }
});
</script>
    <script>
        // Animation on page load
        document.addEventListener('DOMContentLoaded', function() {
            const elements = document.querySelectorAll('.fade-up');
            elements.forEach(element => {
                element.style.opacity = '0';
                setTimeout(() => {
                    element.classList.add('fade-up');
                }, 100);
            });
        });
    </script>

    <script>
// Animation au scroll (optionnel)
document.addEventListener('DOMContentLoaded', function() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);

    const infoCards = document.querySelectorAll('.info-card');
    infoCards.forEach(card => {
        observer.observe(card);
    });
});
</script>
<script>
// Animation au scroll
document.addEventListener('DOMContentLoaded', function() {
    // Animation pour le banner
    const elements = document.querySelectorAll('.fade-up');
    elements.forEach(element => {
        element.style.opacity = '0';
        setTimeout(() => {
            element.classList.add('fade-up');
        }, 100);
    });

    // Configuration de l'observateur pour les sections
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);

    // Observer toutes les cards
    const infoCards = document.querySelectorAll('.info-card');
    infoCards.forEach(card => {
        observer.observe(card);
    });

    // Observer les cards inversées
    const reverseCards = document.querySelectorAll('.info-card-reverse');
    reverseCards.forEach(card => {
        observer.observe(card);
    });
});
</script>


<script>
document.addEventListener('DOMContentLoaded', () => {
    // Initialize course flip buttons
    const courseFlipButtons = document.querySelectorAll('.course-flip-btn, .course-flip-close');

    courseFlipButtons.forEach(button => {
        button.addEventListener('click', (e) => {
            e.preventDefault();
            const flipCard = button.closest('.course-flip-card');
            if (flipCard) {
                flipCard.classList.toggle('flipped');
            }
        });
    });

    // Learn More button functionality
    const learnMoreButtons = document.querySelectorAll('.learn-more-btn');

    learnMoreButtons.forEach(button => {
        button.addEventListener('click', (e) => {
            e.preventDefault();
            // Add your navigation or modal logic here
            console.log('Learn More clicked');
        });
    });
});
</script>

<script>
// Animation au scroll pour la section Backend
document.addEventListener('DOMContentLoaded', function() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);

    const backendCards = document.querySelectorAll('.backend-card');
    backendCards.forEach(card => {
        observer.observe(card);
    });
});
</script>

<script>
// Animation au scroll pour les testimonials
document.addEventListener('DOMContentLoaded', function() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach((entry, index) => {
            if (entry.isIntersecting) {
                setTimeout(() => {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }, index * 100);
            }
        });
    }, observerOptions);

    const testimonialCards = document.querySelectorAll('.testimonial-card');
    testimonialCards.forEach(card => {
        observer.observe(card);
    });
});

function updateActiveNavLink(activeCardId) {
    // Mettre à jour les liens de navigation
    const navLinks = document.querySelectorAll('.nav-link');
    navLinks.forEach(link => {
        link.classList.remove('active');
        if (link.getAttribute('href') === '#' + activeCardId) {
            link.classList.add('active');
        }
    });

    // Mettre à jour les paragraphes
    const descriptions = document.querySelectorAll('.carousel-desc');
    descriptions.forEach(desc => {
        desc.classList.remove('active');
    });

    // Activer le paragraphe correspondant
    const cardType = activeCardId.replace('card-', ''); // toolkit, timeline, learning
    const activeDesc = document.getElementById('desc-' + cardType);
    if (activeDesc) {
        activeDesc.classList.add('active');
    }
}
</script>
</body>
</html>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/aidev.blade.php ENDPATH**/ ?>