<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Account Settings','section' => 'Account','page' => 'Settings']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Account Settings','section' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Account'),'page' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Settings')]); ?>
    <style>
    input[type="text"],
    input[type="email"],
    input[type="password"],
    input[type="date"],
    select,
    textarea {
        background-color: #F6F7F5 !important;
        border: 1px solid #D2D1CA !important;
        border-width: 1px !important;
    }
</style>
    <div class="min-h-screen flex items-center justify-center py-12 px-6">
        <!-- Container principal -->
        <div class="flex w-full max-w-6xl rounded-2xl shadow-xl bg-white overflow-hidden border border-gray-200 min-h-[700px]">

            <!-- Sidebar -->
            <aside class="w-64 bg-[#EEEEEE]/50 border-r border-gray-200 p-2">
                <div class="mb-8">
                    <div class="flex items-center space-x-6">

                        <div>

                            <p class="text-l text-gray-500 px-4 pt-2">Account</p>
                        </div>
                    </div>
                </div>

          <nav class="space-y-2"
     x-data="{ currentSection: 'account' }"
     @change-section.window="currentSection = $event.detail">

    <!-- Account -->
    <button @click="$dispatch('change-section', 'account')"
        :class="currentSection === 'account'
            ? 'bg-[#ECECEB] text-[#1D1D1E] font-medium text-[13px]'
            : 'text-gray-600 hover:bg-gray-100 font-normal text-[13px]'"
        class="flex items-center w-full rounded-md px-2 py-2 transition gap-1">
        <div class="w-6 h-6 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 font-semibold text-sm">
            <?php echo e(strtoupper(substr(Auth::user()->name ?? 'U', 0, 1))); ?>

        </div>
        <?php echo e(Auth::user()->name); ?>

    </button>

    <!-- Preferences -->
    <button @click="$dispatch('change-section', 'preferences')"
        :class="currentSection === 'preferences'
            ? 'bg-[#ECECEB] text-[#1D1D1E] font-medium text-[13px]'
            : 'text-gray-600 hover:bg-gray-100 font-normal text-[13px]'"
        class="flex items-center w-full rounded-md px-3 py-2 transition">
        <i class="ri-settings-3-line mr-3"
           :class="currentSection === 'preferences' ? 'text-[#1D1D1E]' : 'text-gray-400'"></i>
        Preferences
    </button>

    <!-- Notifications -->
    <button @click="$dispatch('change-section', 'notifications')"
        :class="currentSection === 'notifications'
            ? 'bg-[#ECECEB] text-[#1D1D1E] font-medium text-[13px]'
            : 'text-gray-600 hover:bg-gray-100 font-normal text-[13px]'"
        class="flex items-center w-full rounded-md px-3 py-2 transition">
        <i class="ri-notification-3-line mr-3"
           :class="currentSection === 'notifications' ? 'text-[#1D1D1E]' : 'text-gray-400'"></i>
        Notifications
    </button>
</nav>

            </aside>

            <!-- Main Content -->
            <main class="flex-1 overflow-y-auto p-10 relative"
                 x-data="{
                     currentSection: 'account',
                     showEmailModal: false,
                     showCodeModal: <?php echo e(session('open_code_modal') ? 'true' : 'false'); ?>,
                     showPasswordModal: false
                 }"
                 @change-section.window="currentSection = $event.detail">

                <!-- ========== ACCOUNT SECTION ========== -->
                <div x-show="currentSection === 'account'"
                     x-transition:enter="transition ease-out duration-200"
                     x-transition:enter-start="opacity-0 transform scale-95"
                     x-transition:enter-end="opacity-100 transform scale-100"
                     class="max-w-3xl mx-auto space-y-10">

                    <form action="<?php echo e(route('student.account.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <!-- Account Section -->
                        <section>
                            <h2 class="text-lg font-semibold text-gray-800 mb-6">Account</h2>
                            <div class="flex items-center mb-6">
                                <div class="w-16 h-16 rounded-full bg-gray-200 flex items-center justify-center text-gray-600 text-2xl font-bold">
                                    <?php echo e(strtoupper(substr(Auth::user()->name ?? 'U', 0, 1))); ?>

                                </div>
                                <div class="ml-6 flex-1">
                                    <label class="block text-sm text-gray-500 mb-1">Preferred name</label>
                                    <input type="text"
                                           name="name"
                                           value="<?php echo e(old('name', Auth::user()->name)); ?>"
                                           class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full md:w-auto focus:ring-blue-400 focus:border-blue-400">
                                </div>
                            </div>
                        </section>

                        <hr class="my-6 border-gray-200">

                        <!-- Account Security -->
                        <section>
                            <h2 class="text-lg font-semibold text-gray-800 mb-6">Account security</h2>
                            <div class="space-y-5">
                                <div class="flex justify-between items-center">
                                    <div>
                                        <p class="text-sm font-medium text-gray-700">Email</p>
                                        <p class="text-sm text-gray-500"><?php echo e(Auth::user()->email); ?></p>
                                    </div>
                                    <button type="button"
                                            @click="showEmailModal = true"
                                            class="text-sm border border-gray-300 rounded-md px-3 py-1 hover:bg-gray-100 transition">
                                        Change email
                                    </button>
                                </div>

                                <div class="flex justify-between items-center">
                                    <div>
                                        <p class="text-sm font-medium text-gray-700">Password</p>
                                        <p class="text-sm text-gray-500">Set a permanent password to login to your account.</p>
                                    </div>
                                    <button type="button"
                                            @click="showPasswordModal = true"
                                            class="text-sm border border-gray-300 rounded-md px-3 py-1 hover:bg-gray-100 transition">
                                        Change password
                                    </button>
                                </div>
                            </div>
                        </section>

                        <hr class="my-6 border-gray-200">

                        <!-- Personal Info -->
                        <section>
                            <h2 class="text-lg font-semibold text-gray-800 mb-6">Personal information</h2>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                                <div>
                                    <label class="block text-sm text-gray-600 mb-1">First name</label>
                                    <input type="text"
                                           name="first_name"
                                           value="<?php echo e(old('first_name', Auth::user()->first_name)); ?>"
                                           class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full focus:ring-blue-400 focus:border-blue-400">
                                </div>
                                <div>
                                    <label class="block text-sm text-gray-600 mb-1">Last name</label>
                                    <input type="text"
                                           name="last_name"
                                           value="<?php echo e(old('last_name', Auth::user()->last_name)); ?>"
                                           class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full focus:ring-blue-400 focus:border-blue-400">
                                </div>
                                <div>
                                    <label class="block text-sm text-gray-600 mb-1">Date of birth</label>
                                    <input type="date"
                                           name="date_of_birth"
                                           value="<?php echo e(old('date_of_birth', Auth::user()->date_of_birth ? Auth::user()->date_of_birth->format('Y-m-d') : '')); ?>"
                                           class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full focus:ring-blue-400 focus:border-blue-400">
                                </div>
   <div x-data="{ open: false, selected: '<?php echo e(old('gender', Auth::user()->gender ?? 'Male')); ?>' }" class="relative w-full">
    <label class="block text-sm text-gray-600 mb-1">Gender</label>

    <!-- Champ principal -->
    <button type="button" @click="open = !open"
        class="w-full bg-[#F6F7F5] border border-[#D2D1CA] rounded-md text-sm px-3 py-2 flex items-center justify-between focus:ring-2 focus:ring-blue-400 transition">
        <span x-text="selected"></span>
        <div class="flex items-center justify-center w-8 border-l border-[#D2D1CA]">
            <i class="ri-arrow-down-s-line text-gray-600 text-lg" :class="{ 'rotate-180': open }"></i>
        </div>
    </button>

    <!-- Menu déroulant -->
    <div x-show="open" @click.away="open = false"
         class="absolute right-0 mt-1 w-full bg-white border border-gray-200 rounded-lg shadow-lg overflow-hidden z-50"
         x-transition.origin.top.right>
        <template x-for="option in ['Male', 'Female', 'Other']" :key="option">
            <div @click="selected = option; open = false"
                 class="flex items-center justify-between px-4 py-2 text-sm cursor-pointer hover:bg-gray-50"
                 :class="{ 'bg-gray-50 font-medium': selected === option }">
                <span x-text="option"></span>
                <template x-if="selected === option">
                    <i class="ri-check-line text-gray-500"></i>
                </template>
            </div>
        </template>
    </div>

    <!-- Hidden input pour soumettre la valeur -->
    <input type="hidden" name="gender" x-model="selected">
</div>




                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-5 mt-6">
                                <div>
                                    <label class="block text-sm text-gray-600 mb-1">Phone number</label>
                                    <input type="text"
                                           name="phone"
                                           value="<?php echo e(old('phone', Auth::user()->phone)); ?>"
                                           placeholder="Enter phone number"
                                           class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full focus:ring-blue-400 focus:border-blue-400">
                                </div>
                                <div>
                                    <label class="block text-sm text-gray-600 mb-1">Second phone number</label>
                                    <input type="text"
                                           name="second_phone"
                                           value="<?php echo e(old('second_phone', Auth::user()->second_phone)); ?>"
                                           placeholder="Optional"
                                           class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full focus:ring-blue-400 focus:border-blue-400">
                                </div>
                            </div>

                            <!-- Address Section -->
                            <div class="mt-10">
                                <h3 class="text-md font-semibold text-gray-700 mb-4">Address</h3>
                                <hr class="mb-4 border-gray-200">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                                    <div>
                                        <label class="block text-sm text-gray-600 mb-1">Governorate</label>
                                        <input type="text"
                                               name="governorate"
                                               value="<?php echo e(old('governorate', Auth::user()->governorate)); ?>"
                                               placeholder="e.g. Tunis"
                                               class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full focus:ring-blue-400 focus:border-blue-400">
                                    </div>
                                    <div>
                                        <label class="block text-sm text-gray-600 mb-1">City</label>
                                        <input type="text"
                                               name="city"
                                               value="<?php echo e(old('city', Auth::user()->city)); ?>"
                                               placeholder="e.g. La Marsa"
                                               class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full focus:ring-blue-400 focus:border-blue-400">
                                    </div>
                                    <div>
                                        <label class="block text-sm text-gray-600 mb-1">Postal Code</label>
                                        <input type="text"
                                               name="postal_code"
                                               value="<?php echo e(old('postal_code', Auth::user()->postal_code)); ?>"
                                               placeholder="e.g. 2078"
                                               class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full focus:ring-blue-400 focus:border-blue-400">
                                    </div>
                                    <div>
                                        <label class="block text-sm text-gray-600 mb-1">Street Address</label>
                                        <input type="text"
                                               name="street_address"
                                               value="<?php echo e(old('street_address', Auth::user()->street_address)); ?>"
                                               placeholder="e.g. Avenue Habib Bourguiba"
                                               class="border border-gray-300 rounded-md text-sm px-3 py-2 w-full focus:ring-blue-400 focus:border-blue-400">
                                    </div>
                                </div>
                            </div>

                            <!-- Bouton Save -->
                            <div class="mt-8">
                                <button type="submit"
                                        class="bg-[#3984D3] hover:bg-[#2d74bf] text-white font-medium text-sm px-6 py-2.5 rounded-md transition">
                                     Save Changes
                                </button>
                            </div>
                        </section>
                    </form>
                </div>

                <!-- ========== PREFERENCES SECTION ========== -->
                <div x-show="currentSection === 'preferences'"
                     x-transition:enter="transition ease-out duration-200"
                     x-transition:enter-start="opacity-0 transform scale-95"
                     x-transition:enter-end="opacity-100 transform scale-100"
                     class="max-w-3xl mx-auto space-y-10">

                    <section>
                        <h2 class="text-lg font-semibold text-gray-800 mb-6">Preferences</h2>

                        <!-- Appearance -->
                        <div class="space-y-6">
                            <div>
                                <p class="text-sm font-medium text-gray-700 mb-2">Appearance</p>
                                <p class="text-xs text-gray-500 mb-3">Customize how AL Plateforme looks on your device.</p>
           <div x-data="{ open: false, selected: 'Light' }" class="relative w-full md:w-64">
    <button type="button" @click="open = !open"
        class="w-full bg-[#F6F7F5] border border-[#D2D1CA] rounded-md text-sm px-3 py-2 flex items-center justify-between focus:ring-2 focus:ring-blue-400 transition">
        <span x-text="selected"></span>
        <div class="flex items-center justify-center w-8 border-l border-[#D2D1CA]">
            <i class="ri-arrow-down-s-line text-gray-600 text-lg" :class="{ 'rotate-180': open }"></i>
        </div>
    </button>

    <div x-show="open" @click.away="open = false"
         class="absolute right-0 mt-1 w-full bg-white border border-gray-200 rounded-lg shadow-lg overflow-hidden z-50"
         x-transition.origin.top.right>
        <template x-for="option in ['Light']" :key="option">
            <div @click="selected = option; open = false"
                 class="flex items-center justify-between px-4 py-2 text-sm cursor-pointer hover:bg-gray-50"
                 :class="{ 'bg-gray-50 font-medium': selected === option }">
                <span x-text="option"></span>
                <template x-if="selected === option">
                    <i class="ri-check-line text-gray-500"></i>
                </template>
            </div>
        </template>
    </div>

    <input type="hidden" name="appearance" x-model="selected">
</div>
                            </div>

                            <hr class="border-gray-200">

                            <!-- Language and Time -->
                            <div>
                                <h3 class="text-md font-semibold text-gray-700 mb-4">Language and time</h3>
                                <div class="space-y-6">
                                    <div>
                                        <p class="text-sm font-medium text-gray-700 mb-1">Language</p>
                                        <p class="text-xs text-gray-500 mb-2">Change the language used in the user interface.</p>
                                       <div x-data="{ open: false, selected: 'English' }" class="relative w-full md:w-64">
    <button type="button" @click="open = !open"
        class="w-full bg-[#F6F7F5] border border-[#D2D1CA] rounded-md text-sm px-3 py-2 flex items-center justify-between focus:ring-2 focus:ring-blue-400 transition">
        <span x-text="selected"></span>
        <div class="flex items-center justify-center w-8 border-l border-[#D2D1CA]">
            <i class="ri-arrow-down-s-line text-gray-600 text-lg" :class="{ 'rotate-180': open }"></i>
        </div>
    </button>

    <div x-show="open" @click.away="open = false"
         class="absolute right-0 mt-1 w-full bg-white border border-gray-200 rounded-lg shadow-lg overflow-hidden z-50"
         x-transition.origin.top.right>
        <template x-for="option in ['English']" :key="option">
            <div @click="selected = option; open = false"
                 class="flex items-center justify-between px-4 py-2 text-sm cursor-pointer hover:bg-gray-50"
                 :class="{ 'bg-gray-50 font-medium': selected === option }">
                <span x-text="option"></span>
                <template x-if="selected === option">
                    <i class="ri-check-line text-gray-500"></i>
                </template>
            </div>
        </template>
    </div>

    <input type="hidden" name="language" x-model="selected">
</div>
                                    </div>

                                    <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4">
                                        <div class="flex-1 max-w-md">
                                            <p class="text-sm font-medium text-gray-700">Set time zone automatically</p>
                                            <p class="text-xs text-gray-500 mt-1">Reminders, notifications and emails are delivered based on your time zone.</p>
                                        </div>
                                        <label class="relative inline-flex items-center cursor-pointer flex-shrink-0">
                                            <input type="checkbox" class="sr-only peer" checked>
                                            <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:after:translate-x-full after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-500"></div>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div>
  <h2 class="text-lg font-semibold text-gray-800 mb-6">Notification settings</h2>

                        <div class="space-y-6">
                            <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4">
                                <div class="flex-1 max-w-md">
                                    <p class="text-sm font-medium text-gray-700">News about AL Plateforme</p>
                                    <p class="text-xs text-gray-500 mt-1">Keep up to date with news, events, and product releases!</p>
                                </div>
                                <label class="relative inline-flex items-center cursor-pointer flex-shrink-0">
                                    <input type="checkbox" class="sr-only peer" checked>
                                    <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:after:translate-x-full after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-500"></div>
                                </label>
                            </div>

                            <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4">
                                <div class="flex-1 max-w-md">
                                    <p class="text-sm font-medium text-gray-700">Send email notifications</p>
                                    <p class="text-xs text-gray-500 mt-1">Receive emails about activity in your workspace.</p>
                                </div>
                                <label class="relative inline-flex items-center cursor-pointer flex-shrink-0">
                                    <input type="checkbox" class="sr-only peer">
                                    <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:after:translate-x-full after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-500"></div>
                                </label>
                            </div>

                            <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4">
                                <div class="flex-1 max-w-md">
                                    <p class="text-sm font-medium text-gray-700">Push notifications</p>
                                    <p class="text-xs text-gray-500 mt-1">Receive push notifications on your device.</p>
                                </div>
                                <label class="relative inline-flex items-center cursor-pointer flex-shrink-0">
                                    <input type="checkbox" class="sr-only peer" checked>
                                    <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:after:translate-x-full after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-500"></div>
                                </label>
                            </div>
                        </div>

                            </div>
                        </div>
                    </section>
                </div>

               <div x-show="currentSection === 'notifications'"
     x-transition:enter="transition ease-out duration-200"
     x-transition:enter-start="opacity-0 transform scale-95"
     x-transition:enter-end="opacity-100 transform scale-100"
     class="max-w-3xl mx-auto space-y-10">

    <section>
        <h2 class="text-lg font-semibold text-gray-800 mb-6">Notification settings</h2>

        <!-- Account & Security -->
        <div class="space-y-4">
            <h3 class="text-md font-semibold text-gray-700 border-b border-gray-200 pb-2">Account & Security</h3>

            <template x-for="(item, i) in [
                { title: 'Login alerts', desc: 'Get notified when someone signs in from a new device.', checked: true },
                { title: 'Password & account changes', desc: 'Be alerted if your password or account details are updated.', checked: true },
                { title: 'Billing issues', desc: 'Get notified if a payment fails or your subscription is at risk.', checked: false }
            ]" :key="i">
                <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4 border-b border-gray-100 pb-4">
                    <div class="flex-1 max-w-md">
                        <p class="text-sm font-medium text-gray-700" x-text="item.title"></p>
                        <p class="text-xs text-gray-500 mt-1" x-text="item.desc"></p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer flex-shrink-0">
                        <input type="checkbox" class="sr-only peer" :checked="item.checked">
                        <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:after:translate-x-full after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-500"></div>
                    </label>
                </div>
            </template>
        </div>

        <!-- Learning & Progress -->
        <div class="space-y-4 mt-8">
            <h3 class="text-md font-semibold text-gray-700 border-b border-gray-200 pb-2">Learning & Progress</h3>

            <template x-for="(item, i) in [
                { title: 'New course releases', desc: 'Get notified when new courses or content are published.', checked: true },
                { title: 'Project feedback', desc: 'Alerts when your submitted work gets reviewed.', checked: true },
                { title: 'Progress reminders', desc: 'Gentle nudges to keep you on track with your learning.', checked: true }
            ]" :key="i">
                <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4 border-b border-gray-100 pb-4">
                    <div class="flex-1 max-w-md">
                        <p class="text-sm font-medium text-gray-700" x-text="item.title"></p>
                        <p class="text-xs text-gray-500 mt-1" x-text="item.desc"></p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer flex-shrink-0">
                        <input type="checkbox" class="sr-only peer" :checked="item.checked">
                        <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:after:translate-x-full after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-500"></div>
                    </label>
                </div>
            </template>
        </div>

        <!-- Promotions & Offers -->
        <div class="space-y-4 mt-8">
            <h3 class="text-md font-semibold text-gray-700 border-b border-gray-200 pb-2">Promotions & Offers</h3>

            <template x-for="(item, i) in [
                { title: 'Exclusive discounts', desc: 'Get notified about special deals and seasonal offers.', checked: true },
                { title: 'Bundle updates', desc: 'Alerts when new packs or programs are launched.', checked: true }
            ]" :key="i">
                <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4 border-b border-gray-100 pb-4">
                    <div class="flex-1 max-w-md">
                        <p class="text-sm font-medium text-gray-700" x-text="item.title"></p>
                        <p class="text-xs text-gray-500 mt-1" x-text="item.desc"></p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer flex-shrink-0">
                        <input type="checkbox" class="sr-only peer" :checked="item.checked">
                        <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:after:translate-x-full after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-500"></div>
                    </label>
                </div>
            </template>
        </div>

        <!-- Community -->
        <div class="space-y-4 mt-8">
            <h3 class="text-md font-semibold text-gray-700 border-b border-gray-200 pb-2">Community</h3>

            <template x-for="(item, i) in [
                { title: 'Replies to your questions', desc: 'Be notified when someone answers you.', checked: false },
                { title: 'Mentions & tags', desc: 'Get alerts when another learner mentions you.', checked: false }
            ]" :key="i">
                <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4 border-b border-gray-100 pb-4">
                    <div class="flex-1 max-w-md">
                        <p class="text-sm font-medium text-gray-700" x-text="item.title"></p>
                        <p class="text-xs text-gray-500 mt-1" x-text="item.desc"></p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer flex-shrink-0">
                        <input type="checkbox" class="sr-only peer" :checked="item.checked">
                        <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:after:translate-x-full after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-500"></div>
                    </label>
                </div>
            </template>
        </div>
    </section>
</div>

                <!-- ========== BILLING SECTION ========== -->
                <div x-show="currentSection === 'billing'"
                     x-transition:enter="transition ease-out duration-200"
                     x-transition:enter-start="opacity-0 transform scale-95"
                     x-transition:enter-end="opacity-100 transform scale-100"
                     class="max-w-3xl mx-auto space-y-10">

                    <section>
                        <h2 class="text-lg font-semibold text-gray-800 mb-6">Subscription & Billing</h2>

                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-6">
                            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                                <div>
                                    <h3 class="text-md font-semibold text-gray-800">Current Plan: Free</h3>
                                    <p class="text-sm text-gray-600 mt-1">Upgrade to access premium features</p>
                                </div>
                                <button class="bg-[#3984D3] hover:bg-[#2d74bf] text-white font-medium text-sm px-4 py-2 rounded-md transition whitespace-nowrap">
                                    Upgrade Plan
                                </button>
                            </div>
                        </div>

                        <div class="space-y-4">
                            <h3 class="text-md font-semibold text-gray-700">Billing History</h3>
                            <div class="border border-gray-200 rounded-lg p-8 text-center text-gray-500">
                                <i class="ri-file-list-line text-4xl mb-2 block"></i>
                                <p class="text-sm">No billing history available</p>
                            </div>
                        </div>
                    </section>
                </div>

                <!-- ========== SUPPORT SECTION ========== -->
                <div x-show="currentSection === 'support'"
                     x-transition:enter="transition ease-out duration-200"
                     x-transition:enter-start="opacity-0 transform scale-95"
                     x-transition:enter-end="opacity-100 transform scale-100"
                     class="max-w-3xl mx-auto space-y-10">

                    <section>
                        <h2 class="text-lg font-semibold text-gray-800 mb-6">Support</h2>

                        <div class="space-y-6">
                            <div class="border border-gray-200 rounded-lg p-6 hover:border-gray-300 transition">
                                <h3 class="text-md font-semibold text-gray-700 mb-2">📧 Contact Support</h3>
                                <p class="text-sm text-gray-600 mb-4">Have a question or need help? Our support team is here for you.</p>
                                <a href="mailto:support@alplateforme.com" class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                                    support@alplateforme.com
                                </a>
                            </div>

                            <div class="border border-gray-200 rounded-lg p-6 hover:border-gray-300 transition">
                                <h3 class="text-md font-semibold text-gray-700 mb-2">📚 Help Center</h3>
                                <p class="text-sm text-gray-600 mb-4">Browse our help articles and guides.</p>
                                <a href="#" class="text-blue-600 hover:text-blue-700 text-sm font-medium inline-flex items-center">
                                    Visit Help Center
                                    <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </a>
                            </div>

                            <div class="border border-gray-200 rounded-lg p-6 hover:border-gray-300 transition">
                                <h3 class="text-md font-semibold text-gray-700 mb-2">🐛 Report a Bug</h3>
                                <p class="text-sm text-gray-600 mb-4">Help us improve by reporting any issues you encounter.</p>
                                <button class="bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium text-sm px-4 py-2 rounded-md transition">
                                    Report Issue
                                </button>
                            </div>
                        </div>
                    </section>
                </div>

                <!-- Change Email Modal -->
                <div x-show="showEmailModal"
                     x-transition
                     class="fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50 z-50 p-4"
                     x-cloak>
                    <div @click.away="showEmailModal = false"
                         class="bg-white rounded-2xl shadow-xl w-full max-w-md p-8 relative">
                        <div class="text-center mb-6">
                            <h2 class="text-xl font-semibold text-gray-900 mb-2">Change Email</h2>
                            <p class="text-sm text-gray-600">
                                Your current email is
                                <span class="font-medium text-gray-800"><?php echo e(Auth::user()->email); ?></span>.<br>
                                We'll send a temporary verification code to this email.
                            </p>
                        </div>

                        <form action="<?php echo e(route('student.email.verification')); ?>" method="POST" class="space-y-4">
                            <?php echo csrf_field(); ?>
                            <button type="submit"
                                    class="w-full bg-[#3984D3] hover:bg-[#2d74bf] text-white font-medium text-sm py-2.5 rounded-md transition">
                                Send verification code
                            </button>

                            <button type="button"
                                    @click="showEmailModal = false"
                                    class="w-full border border-gray-300 text-gray-600 font-medium text-sm py-2.5 rounded-md hover:bg-gray-100 transition">
                                Cancel
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Code Verification Modal -->
                <div x-show="showCodeModal"
                     x-transition
                     class="fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50 z-50 p-4"
                     x-cloak>
                    <div @click.away="showCodeModal = false"
                         class="bg-white rounded-2xl shadow-xl w-full max-w-md p-8 relative">
                        <div class="text-center mb-6">
                            <h2 class="text-xl font-semibold text-gray-900 mb-2">Verify your email</h2>
                            <p class="text-sm text-gray-600">
                                Your current email is
                                <span class="font-medium text-gray-800"><?php echo e(Auth::user()->email); ?></span>.<br>
                                We've sent a temporary verification code to this email.
                            </p>
                        </div>

                        <form action="<?php echo e(route('student.email.confirm')); ?>" method="POST" class="space-y-5">
                            <?php echo csrf_field(); ?>

                            <div>
                                <label class="block text-sm text-gray-600 mb-1">Verification code</label>
                                <input type="text"
                                       name="code"
                                       placeholder="Enter verification code"
                                       required
                                       class="border border-gray-300 rounded-md text-sm px-3 py-2.5 w-full focus:ring-blue-400 focus:border-blue-400">
                            </div>

                            <div>
                                <label class="block text-sm text-gray-600 mb-1">New email address</label>
                                <input type="email"
                                       name="new_email"
                                       placeholder="Enter your new email"
                                       required
                                       class="border border-gray-300 rounded-md text-sm px-3 py-2.5 w-full focus:ring-blue-400 focus:border-blue-400">
                            </div>

                            <div class="space-y-2">
                                <button type="submit"
                                        class="w-full bg-[#3984D3] hover:bg-[#2d74bf] text-white font-medium text-sm py-2.5 rounded-md transition">
                                    Continue
                                </button>

                                <button type="button"
                                        @click="showCodeModal = false"
                                        class="w-full border border-gray-300 text-gray-600 font-medium text-sm py-2.5 rounded-md hover:bg-gray-100 transition">
                                    Cancel
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Change Password Modal -->
                <div x-show="showPasswordModal"
                     x-transition
                     class="fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50 z-50 p-4"
                     x-cloak>
                    <div @click.away="showPasswordModal = false"
                         class="bg-white rounded-2xl shadow-xl w-full max-w-md p-8 relative">
                        <div class="text-center mb-6">
                            <h2 class="text-xl font-semibold text-gray-900 mb-2">Change Password</h2>
                            <p class="text-sm text-gray-600">Enter your current password and choose a new one.</p>
                        </div>

                        <form action="<?php echo e(route('student.password.update')); ?>" method="POST" class="space-y-5">
                            <?php echo csrf_field(); ?>

                            <div>
                                <label class="block text-sm text-gray-600 mb-1">Current password</label>
                                <input type="password"
                                       name="current_password"
                                       placeholder="Enter current password"
                                       required
                                       class="border border-gray-300 rounded-md text-sm px-3 py-2.5 w-full focus:ring-blue-400 focus:border-blue-400">
                            </div>

                            <div>
                                <label class="block text-sm text-gray-600 mb-1">New password</label>
                                <input type="password"
                                       name="new_password"
                                       placeholder="Enter new password"
                                       required
                                       class="border border-gray-300 rounded-md text-sm px-3 py-2.5 w-full focus:ring-blue-400 focus:border-blue-400">
                            </div>

                            <div>
                                <label class="block text-sm text-gray-600 mb-1">Confirm new password</label>
                                <input type="password"
                                       name="new_password_confirmation"
                                       placeholder="Confirm new password"
                                       required
                                       class="border border-gray-300 rounded-md text-sm px-3 py-2.5 w-full focus:ring-blue-400 focus:border-blue-400">
                            </div>

                            <div class="space-y-2">
                                <button type="submit"
                                        class="w-full bg-[#3984D3] hover:bg-[#2d74bf] text-white font-medium text-sm py-2.5 rounded-md transition">
                                    Update Password
                                </button>

                                <button type="button"
                                        @click="showPasswordModal = false"
                                        class="w-full border border-gray-300 text-gray-600 font-medium text-sm py-2.5 rounded-md hover:bg-gray-100 transition">
                                    Cancel
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <?php if(session('error')): ?>
    <script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '<?php echo e(session('error')); ?>',
        confirmButtonColor: '#3984D3',
    });
    </script>
    <?php endif; ?>

    <?php if(session('success')): ?>
    <script>
    Swal.fire({
        icon: 'success',
        title: 'Success! ',
        text: '<?php echo e(session('success')); ?>',
        confirmButtonColor: '#3984D3',
    });
    </script>
    <?php endif; ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/student/account.blade.php ENDPATH**/ ?>