<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Mes Projets','section' => ' My Projects']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Mes Projets','section' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(' My Projects')]); ?>
    <div class="max-w-7xl mx-auto p-6">

        <!-- Header -->
        <div class="flex justify-between items-center mb-8">
            <div>
                <h2 class="text-2xl font-semibold text-gray-900">
                   My Projects
                </h2>
                <p class="text-sm text-gray-600 mt-1">
                    Manage your development projects
                </p>
            </div>
            <a href="<?php echo e(route('student.projects.create')); ?>"
               class="inline-flex items-center gap-1 px-6 py-2 bg-[#2282E2] hover:bg-gray-800 text-white text-sm font-medium rounded-lg transition">
                <i class="ri-add-line text-lg"></i>
                New project
            </a>
        </div>

        <?php if(session('success')): ?>
            <div class="bg-green-50 border border-green-200 text-green-800 p-4 rounded-lg mb-6">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="bg-red-50 border border-red-200 text-red-800 p-4 rounded-lg mb-6">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if($projects->isEmpty()): ?>
            <!-- État vide -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-12 text-center">
                <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z" />
                </svg>
                <h3 class="text-lg font-medium text-gray-900 mb-2">No project</h3>
                <p class="text-sm text-gray-600 mb-6">Create your first project to get started</p>
                <a href="<?php echo e(route('student.projects.create')); ?>"
                   class="inline-flex items-center gap-2 px-6 py-3 bg-[#2282E2] hover:bg-gray-800 text-white text-sm font-medium rounded-lg transition">
                    <i class="ri-add-line text-lg"></i>
                   Create a project
                </a>
            </div>
        <?php else: ?>
            <!-- Grille de projets -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $icons = [
                            'react' => ['icon' => 'ri-reactjs-line', 'color' => 'text-blue-500', 'bg' => 'bg-blue-50'],
                            'java' => ['icon' => 'ri-java-line', 'color' => 'text-red-500', 'bg' => 'bg-red-50'],
                            'python' => ['icon' => 'ri-terminal-box-line', 'color' => 'text-yellow-600', 'bg' => 'bg-yellow-50'],
                            'html' => ['icon' => 'ri-html5-line', 'color' => 'text-orange-500', 'bg' => 'bg-orange-50'],
                            'nodejs' => ['icon' => 'ri-nodejs-line', 'color' => 'text-green-600', 'bg' => 'bg-green-50'],
                            'other' => ['icon' => 'ri-file-code-line', 'color' => 'text-gray-500', 'bg' => 'bg-gray-50'],
                        ];
                        $typeInfo = $icons[$project->type] ?? $icons['other'];
                    ?>

                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden hover:shadow-md transition group">
                        <!-- Header -->
                        <div class="p-6">
                            <div class="flex items-start justify-between mb-4">
                                <div class="w-12 h-12 rounded-lg <?php echo e($typeInfo['bg']); ?> flex items-center justify-center">
                                    <i class="<?php echo e($typeInfo['icon']); ?> text-2xl <?php echo e($typeInfo['color']); ?>"></i>
                                </div>
                                <div class="relative" x-data="{ open: false }">
                                    <button @click="open = !open" class="text-gray-400 hover:text-gray-600">
                                        <i class="ri-more-2-fill text-xl"></i>
                                    </button>
                                    <div x-show="open"
                                         @click.away="open = false"
                                         class="absolute right-0 mt-2 w-48 bg-white shadow-lg border rounded-lg overflow-hidden z-10"
                                         style="display: none;">
                                        <form method="POST" action="<?php echo e(route('student.projects.destroy', $project->id)); ?>"
                                              onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce projet ?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="flex items-center gap-2 w-full px-4 py-2 text-red-600 hover:bg-red-50 text-sm">
                                                <i class="ri-delete-bin-line"></i>
                                                DELETE
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <h3 class="text-lg font-semibold text-gray-900 mb-2">
                                <?php echo e($project->name); ?>

                            </h3>
                            <p class="text-sm text-gray-600 mb-4 line-clamp-2">
                                <?php echo e($project->description ?? 'Aucune description'); ?>

                            </p>

                            <!-- Info -->
                            <div class="flex items-center gap-4 text-xs text-gray-500 mb-4">
                                <span class="flex items-center gap-1">
                                    <i class="ri-folder-line"></i>
                                    <?php echo e(ucfirst($project->type)); ?>

                                </span>
                                <span class="flex items-center gap-1">
                                    <i class="ri-time-line"></i>
                                    <?php echo e(\Carbon\Carbon::parse($project->created_at)->diffForHumans()); ?>

                                </span>
                            </div>

                            <!-- Actions -->
                            <div class="flex gap-2">
                                <a href="<?php echo e(route('student.projects.editor', $project->id)); ?>"
                                   class="flex-1 inline-flex items-center justify-center gap-2 px-4 py-2 bg-[#2282E2] hover:bg-gray-800 text-white text-sm font-medium rounded-lg transition">
                                    <i class="ri-code-line"></i>
                                    Open in editor
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH C:\Users\netta\Desktop\alplatforme\alplatforme\resources\views/student/projects/index.blade.php ENDPATH**/ ?>