<?php

use App\Http\Controllers\AuthController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Student\DashboardController;
use App\Http\Controllers\Student\WalletController;
use App\Http\Controllers\Student\NovaController;
use App\Http\Controllers\Student\GoalsController; // ✅ NOUVEAU
use App\Http\Controllers\Student\LiveSessionController;
use App\Http\Controllers\Student\FeedbackController;
use App\Http\Controllers\Student\AccountController;
use App\Http\Controllers\Student\EmailVerificationController;
use App\Http\Controllers\Student\LiveController;
use App\Http\Controllers\Student\ZoomController;

use App\Http\Controllers\Teacher\TeacherDashboardController;
use App\Http\Controllers\Teacher\TeacherTransactionController;
use App\Http\Controllers\Teacher\LiveSessionteacherController;
use App\Http\Controllers\Teacher\Teachergroupeandclasse;


use App\Http\Controllers\Affiliate\AffiliateTransactionController;
use App\Http\Controllers\Affiliate\AffiliateDashboardController;
use App\Http\Controllers\Affiliate\AffiliatecodeandtrackingController;

Route::middleware(['auth'])->group(function () {
    Route::get('/affiliate/dashboard', [AffiliateDashboardController::class, 'index'])->name('affiliate.dashboard');
    Route::get('/affiliate/Transaction', [AffiliateTransactionController::class, 'index'])->name('affiliate.Transaction');
     Route::get('/affiliate/codeandtracking', [AffiliatecodeandtrackingController::class, 'index'])->name('affiliate.codeandtracking');
});


Route::middleware(['auth'])->group(function () {
    Route::get('/teacher/dashboard', [TeacherDashboardController::class, 'index'])->name('teacher.dashboard');
    Route::get('/teacher/Transaction', [TeacherTransactionController::class, 'index'])->name('teacher.Transaction');
    Route::get('/teacher/student/{id}', [Teachergroupeandclasse::class, 'studentDetail'])
    ->name('teacher.student.detail');
});


Route::middleware(['auth'])->group(function () {
    Route::get('/teacher/Groupandclasses', [Teachergroupeandclasse::class, 'index'])->name('teacher.Groupandclasses');

});





Route::prefix('teacher')->middleware(['auth'])->group(function () {
    Route::get('/live-sessions', [LiveSessionteacherController::class, 'index'])->name('teacher.live-sessions.index');
Route::post('/live-sessions/create', [App\Http\Controllers\Student\ZoomController::class, 'create'])
    ->name('teacher.live-sessions.store');
Route::get('/teacher/zoom/start/{meetingId}', [ZoomController::class, 'start'])
    ->name('teacher.zoom.start');

});

Route::post('/teacher/live-sessions/{id}/update', [App\Http\Controllers\Student\ZoomController::class, 'update'])
    ->name('teacher.live-sessions.update')
    ->middleware('auth');

Route::delete('/teacher/live-sessions/{id}/delete', [App\Http\Controllers\Student\ZoomController::class, 'destroy'])
    ->name('teacher.live-sessions.destroy')
    ->middleware('auth');

    Route::post('/teacher/live-sessions/{id}/attachment', [App\Http\Controllers\Student\ZoomController::class, 'uploadAttachment'])
    ->name('teacher.live-sessions.attachment.upload')
    ->middleware('auth');

Route::delete('/teacher/live-sessions/{id}/attachment', [App\Http\Controllers\Student\ZoomController::class, 'deleteAttachment'])
    ->name('teacher.live-sessions.attachment.delete')
    ->middleware('auth');












Route::middleware(['auth'])->prefix('student/zoom')->name('student.zoom.')->group(function () {
    Route::get('/', [ZoomController::class, 'index'])->name('index');
    Route::post('/create', [ZoomController::class, 'create'])->name('create');

    // ✅ Signature pour le SDK
    Route::get('/signature', [ZoomController::class, 'generateSignature'])->name('signature');

    Route::get('/join/{meetingId}', [ZoomController::class, 'join'])->name('join');
});

Route::middleware(['auth'])->prefix('student/projects')->name('student.projects.')->group(function () {
    Route::get('/', [App\Http\Controllers\Student\ProjectController::class, 'index'])->name('index');
    Route::get('/create', [App\Http\Controllers\Student\ProjectController::class, 'create'])->name('create');
    Route::post('/store', [App\Http\Controllers\Student\ProjectController::class, 'store'])->name('store');
    Route::get('/editor/{id}', [App\Http\Controllers\Student\ProjectController::class, 'editor'])->name('editor');
    Route::post('/update-file/{id}', [App\Http\Controllers\Student\ProjectController::class, 'updateFile'])->name('updateFile');
    Route::delete('/destroy/{id}', [App\Http\Controllers\Student\ProjectController::class, 'destroy'])->name('destroy');
});



Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');

Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
Route::post('/register', [AuthController::class, 'register'])->name('register.submit');
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');


Route::middleware(['auth'])->group(function () {
    Route::get('/account', [AccountController::class, 'index'])->name('student.account');
Route::put('/student/account/update', [AccountController::class, 'updatePersonalInfo'])->name('student.account.update');
      Route::post('/student/email/send-code', [EmailVerificationController::class, 'sendVerificationCode'])->name('student.email.verification');
    Route::post('/student/email/confirm', [EmailVerificationController::class, 'confirmCode'])->name('student.email.confirm');
    Route::post('/student/password/update', [ChangePasswordController::class, 'update'])->name('student.password.update');
});

Route::prefix('student')->middleware(['auth'])->group(function () {
    Route::get('/live', [LiveController::class, 'index'])->name('student.live.index');
    Route::get('/live/{id}', [LiveController::class, 'show'])->name('student.live.show');
    Route::post('/live/{id}/send-message', [LiveController::class, 'sendMessage'])->name('student.live.sendMessage');
    Route::get('/live/{id}/messages', [LiveController::class, 'getMessages'])->name('student.live.getMessages');
    Route::post('/live/{id}/leave', [LiveController::class, 'leave'])->name('student.live.leave');
});
// 🧭 Dashboards selon le rôle
Route::middleware(['auth'])->group(function () {
    Route::get('/student/dashboard', [DashboardController::class, 'index'])->name('student.dashboard');
    Route::get('/student/courses', [DashboardController::class, 'courses'])->name('student.courses');
    Route::get('/student/wallet', [WalletController::class, 'index'])->name('student.wallet');
    Route::get('/student/flow', [DashboardController::class, 'flow'])->name('student.flow');
Route::post('/student/wallet/upload', [WalletController::class, 'uploadProof'])->name('student.wallet.upload');
    // ✅ NOUVELLES ROUTES POUR GOALS
    Route::get('/student/goals', [GoalsController::class, 'index'])->name('student.goals');
        Route::get('/teacher/goals', [GoalsController::class, 'index'])->name('teacher.goals');

    Route::post('/student/goals/reorder', [GoalsController::class, 'reorder'])
    ->name('student.goals.reorder');
    Route::post('/student/goals/store', [GoalsController::class, 'store'])->name('student.goals.store');
    Route::put('/student/goals/{id}', [GoalsController::class, 'update'])->name('student.goals.update');
    Route::delete('/student/goals/{id}', [GoalsController::class, 'destroy'])->name('student.goals.destroy');
    Route::post('/student/goals/{id}/move', [GoalsController::class, 'move'])->name('student.goals.move');
    Route::get('/student/goals/table', [GoalsController::class, 'table'])->name('student.goals.table');

    Route::get('/student/feedback', [FeedbackController::class, 'index'])->name('feedback.index');
Route::post('/feedback/store', [FeedbackController::class, 'store'])->name('student.feedback.store');

});



Route::middleware(['auth'])->prefix('student/nova')->name('student.nova.')->group(function () {
    Route::get('/', [NovaController::class, 'index'])->name('index');
    Route::post('/message', [NovaController::class, 'message'])->name('message');
    Route::post('/conversation/create', [NovaController::class, 'createConversation'])->name('conversation.create');
    Route::get('/conversation/{id}', [NovaController::class, 'loadConversation'])->name('conversation.load');
    Route::delete('/conversation/{id}', [NovaController::class, 'deleteConversation'])->name('conversation.delete');
    Route::get('/conversations', [NovaController::class, 'getConversations'])->name('conversations');
});

Route::middleware(['auth'])->prefix('student')->name('student.')->group(function () {
    Route::get('/live-sessions', [LiveSessionController::class, 'index'])->name('live-sessions.index');

    // Créer une session
    Route::post('/live-sessions', [LiveSessionController::class, 'store'])->name('live-sessions.store');

    // Créer une tâche
    Route::post('/live-sessions/task', [LiveSessionController::class, 'storeTask'])->name('live-sessions.task.store');

    // Toggle tâche
    Route::post('/live-sessions/task/{id}/toggle', [LiveSessionController::class, 'toggleTask'])->name('live-sessions.task.toggle');
Route::delete('/live-sessions/task/{id}', [LiveSessionController::class, 'destroyTask'])
    ->name('live-sessions.task.delete');

    Route::post('/live-sessions/task/{id}/update', [LiveSessionController::class, 'updateTask'])
     ->name('live-sessions.task.update');
Route::post('/live-sessions/{id}/move', [LiveSessionController::class, 'move'])->name('live-sessions.move');
Route::post('/live-sessions/{id}/update', [LiveSessionController::class, 'update'])
    ->name('live-sessions.update');
Route::delete('/live-sessions/{id}/delete', [LiveSessionController::class, 'destroy']);

});



Route::get('/', function () {
    return view('welcome');
});



Route::get('/web-dev', function () {
    return view('Webdev');
});

Route::get('/ai-dev', function () {
    return view('aidev');
});

Route::get('/dataanalyst', function () {
    return view('dataanalyst');
});


Route::get('/fulstack', function () {
    return view('fulstack');
});

Route::get('/Back-end', function () {
    return view('Back-end');
});

Route::get('/Contact', function () {
    return view('Contact');
});






