<x-app-layout
    title="{{ $student->first_name }} {{ $student->last_name }}"
    :section="'Teacher'"
    :page="'Student / ' . $student->first_name . ' ' . $student->last_name"
>
    <!-- ========================= -->
    <!-- 🎨 HEADER IMAGE (TOP)    -->
    <!-- ========================= -->
    <div class="w-full h-56 md:h-72 lg:h-80 overflow-hidden ">
        <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/Rectangle%20273.png"
             alt="Header"
             class="w-full h-full object-cover">
    </div>

    <!-- ========================= -->
    <!-- 👤 STUDENT HEADER         -->
    <!-- ========================= -->
    <div class="max-w-5xl mx-auto mt-10 px-4 md:px-0">

        <div class="flex items-center gap-5 mb-10">

            <!-- Avatar Rond -->
            <div class="w-16 h-16 rounded-full bg-gray-200 flex items-center justify-center text-xl font-semibold text-gray-700">
                {{ strtoupper(substr($student->first_name, 0, 1)) }}
            </div>

            <!-- Nom -->
            <h1 class="text-2xl font-semibold text-gray-800">
                {{ $student->first_name }} {{ $student->last_name }}
            </h1>
        </div>

        <!-- ========================= -->
        <!-- 📝 STUDENT INFO FORM      -->
        <!-- ========================= -->
        <div class="space-y-7">

            <!-- NAME -->
            <div class="grid grid-cols-3 gap-4 items-center">
                <span class="text-gray-500">Name</span>
                <span class="col-span-2 text-gray-800">{{ $student->first_name }}</span>
            </div>

            <!-- LAST NAME -->
            <div class="grid grid-cols-3 gap-4 items-center">
                <span class="text-gray-500">Last name</span>
                <span class="col-span-2 text-gray-800">{{ $student->last_name }}</span>
            </div>

            <!-- NOTES -->
            <div class="grid grid-cols-3 gap-4 items-center">
                <span class="text-gray-500">Notes</span>
                <input type="text"
                       class="col-span-2 px-3 py-2 bg-white border rounded-lg shadow-sm outline-none text-gray-700"
                       placeholder="Add note...">
            </div>

            <!-- PROJECT PROGRESS -->
            @php
                $project = rand(60, 100);

                $bg = $project >= 90 ? '#DBEFDC' : ($project >= 80 ? '#FBE8D4' : '#FAD4D4');
                $text = $project >= 90 ? '#2F6B36' : ($project >= 80 ? '#915D1C' : '#7D2F2F');

                $dot = $project >= 90 ? '#4EA85C' : ($project >= 80 ? '#DF7630' : '#D95B5B');
            @endphp



            <div class="grid grid-cols-3 gap-4 items-start mt-8">
    <span class="text-gray-500">Feedback</span>

    <textarea
        placeholder="Write feedback..."
        class="col-span-2 w-full h-40 px-4 py-3 rounded-xl bg-white border border-gray-200 shadow-sm
               focus:outline-none focus:ring-2 focus:ring-[#DBECDD] resize-none text-gray-700">
    </textarea>
</div>

        </div>

        <div class="flex items-center justify-between mb-4 mt-10">

    <!-- LABEL -->
    <span class="text-gray-600 text-sm">Attendance</span>

    <!-- BADGE + DROPDOWN -->
    <div class="flex items-center gap-2 w-[260px] pr-2 justify-between">

        <!-- BADGE (dot + %) -->
        <span class="inline-flex items-center gap-2 px-6 py-1.5 rounded-full text-[15px] font-medium flex-shrink-0"
              style="background-color: {{ $a_bg ?? '#FBE8D4' }}; color: {{ $a_text ?? '#915D1C' }};">

            <span class="w-3 h-3 rounded-full"
                  style="background-color: {{ $a_dot ?? '#DF7630' }};">
            </span>

            {{ $attendanceValue ?? 85 }}%
        </span>



    </div>

</div>

        <!-- ATTENDANCE TABLE -->
<div class="overflow-x-auto mt-4">
    <table class="min-w-full text-sm text-gray-700">

        <!-- TABLE HEAD -->
        <thead>
            <tr class="border-b text-gray-500">
                <th class="px-4 py-3 text-left font-light text-[15px] text-gray-600">Week</th>
                <th class="px-4 py-3 text-center font-light text-[15px] text-gray-600">Monday</th>
                <th class="px-4 py-3 text-center font-light text-[15px] text-gray-600">Tuesday</th>
                <th class="px-4 py-3 text-center font-light text-[15px] text-gray-600">Wednesday</th>
                <th class="px-4 py-3 text-center font-light text-[15px] text-gray-600">Thursday</th>
                <th class="px-4 py-3 text-center font-light text-[15px] text-gray-600">Friday</th>
                <th class="px-4 py-3 text-center font-light text-[15px] text-gray-600">Saturday</th>
                <th class="px-4 py-3 text-center font-light text-[15px] text-gray-600">Sunday</th>
            </tr>
        </thead>

        <!-- TABLE BODY -->
        <tbody class="divide-y">

        @for ($week = 1; $week <= 12; $week++)
            <tr class="h-12">

                <!-- Week number -->
                <td class="px-4 py-3 text-left font-medium text-gray-800">
                    {{ $week }}
                </td>

                <!-- Days checkboxes -->
                @foreach (['mon','tue','wed','thu','fri','sat','sun'] as $day)
                    <td class="px-4 py-3 text-center">
                        <input type="checkbox"
                               class="w-4 h-4 rounded border-gray-300">
                    </td>
                @endforeach

            </tr>
        @endfor

        </tbody>

    </table>
</div>

    </div>

</x-app-layout>
