<x-app-layout title="Live Sessions" :section="'Teacher'" :page="' Meetings'">
<div class="max-w-[1600px] mx-auto px-4 lg:px-6 font-inter"
  x-data="{
    activeView: 'table',
    showSessionModal: false,
    showStudentSessionModal: false,
    showChoiceModal: false,
    showTaskModal: false,
    selectedSlot: { day: '', hour: '', dayName: '' },
editStudentSessionModal: false,
selectedCalendarSession: {
    id: '',
    title: '',
    type: '',
    start: '',
    end: '',
    notes:'',
    subtasks: [],
},
saveCalendarSession() {
    fetch('/student/live-sessions/' + this.selectedCalendarSession.id + '/update', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify(this.selectedCalendarSession)
    }).then(() => console.log('Saved'));
},
         editMeetingModal: false,
selectedMeeting: { id:'', topic:'', start_time:'', end_time:'', description:'', subtasks: [], attachments: [] },
         autoSaveMeeting() {
             fetch('/teacher/live-sessions/' + this.selectedMeeting.id + '/update', {
                 method: 'POST',
                 headers: {
                     'Content-Type': 'application/json',
                     'X-CSRF-TOKEN': '{{ csrf_token() }}'
                 },
                 body: JSON.stringify(this.selectedMeeting)
             });
         },

         refreshPage() {
             window.location.reload();
         }
     }">

    <!-- 🏷️ HEADER -->
    <div class="mb-6 lg:mb-8">
        <h1 class="text-[32px] lg:text-[36px] font-bold text-gray-900 tracking-tight">
            Live Sessions
        </h1>
    </div>

    <!-- 🧩 MAIN LAYOUT -->
    <div class="grid grid-cols-1 xl:grid-cols-[1fr_280px] gap-6">

        <!-- 🧠 CALENDRIER DES GROUPES -->
        <div class="bg-white rounded-xl overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead>
                        <tr class="border-b border-gray-200">
                            <th class="w-28 sticky left-0 bg-white z-10 text-left px-4 py-3">
                                <div class="flex items-center gap-2 font-light text-[14px] text-[#817F7B]" style="font-family: 'Inter', sans-serif;">
                                    <i class="ri-time-line text-[#817F7B]"></i>
                                    <span>Time</span>
                                </div>
                            </th>
                            @foreach(['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'] as $day)
                                <th class="text-center px-3 py-2 min-w-[140px] font-light text-[14px]" style="color: #817F7B;">
                                    {{ $day }}
                                </th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $hours = ['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00'];
                            $dayNames = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
                        @endphp

                        @foreach($hours as $hour)
                            <tr class="border-b border-gray-100">
                                <td class="sticky left-0 bg-white z-10 px-4 py-4 align-top border-r border-gray-200">
                                    <div class="text-sm font-medium text-black">
                                        {{ $hour }}-<br>{{ sprintf('%02d:00', intval(explode(':',$hour)[0]) + 1) }}
                                    </div>
                                </td>

                               @foreach(['monday','tuesday','wednesday','thursday','friday','saturday','sunday'] as $dayIndex => $day)
    <td class="relative px-1 py-1 align-top border-l border-gray-100 bg-white group" style="height: 100px;">
        @php
            $currentHour = intval(explode(':', $hour)[0]);
            $nextHour = $currentHour + 1;

            $daySessions = $meetings->filter(function($m) use ($day, $currentHour) {
                $start = \Carbon\Carbon::parse($m->start_time);
                $dayOfWeek = strtolower($start->format('l'));
                $meetingHour = $start->hour;
                return $dayOfWeek === $day && $meetingHour === $currentHour;
            });

            $studentSessions = $calendarSessions->filter(function($s) use ($day, $currentHour) {
    $sessionHour = intval(substr($s->start_time, 0, 2));
    return strtolower($s->day_of_week) === $day && $sessionHour === $currentHour;
});
        @endphp

        @foreach($studentSessions as $session)
    @php
        $start = \Carbon\Carbon::parse($session->start_time);
        $end = \Carbon\Carbon::parse($session->end_time);
        $durationHours = $start->diffInMinutes($end) / 60;
        $heightPx = 100 * $durationHours - 6;

        // couleurs (comme student)
        $colors = [
            'project' => ['bg' => '#ffe4cc', 'dot' => '#ea580c'],
            'break'   => ['bg' => '#dbeafe', 'dot' => '#0284c7'],
            'meeting' => ['bg' => '#f3e8ff', 'dot' => '#9333ea'],
            'lunch'   => ['bg' => '#ffe4e6', 'dot' => '#e11d48'],
        ];
        $color = $colors[$session->type] ?? ['bg' => '#E5E7EB', 'dot' => '#6B7280'];
    @endphp

    <div class="absolute left-1 right-1 rounded-lg p-2 cursor-pointer hover:shadow-lg transition-all z-10"
     style="background-color: {{ $color['bg'] }}; height: {{ $heightPx }}px;"
     @click="
         editStudentSessionModal = true;
         selectedCalendarSession = {
             id: '{{ $session->id }}',
             title: '{{ addslashes($session->title) }}',
             type: '{{ $session->type }}',
             start: '{{ \Carbon\Carbon::parse($session->start_time)->format('H:i') }}',
             end: '{{ \Carbon\Carbon::parse($session->end_time)->format('H:i') }}',
             notes: `{{ $session->notes ?? '' }}`,
             subtasks: {{ json_encode($session->subtasks ?? []) }},
         };
     "
>

        <div class="flex items-start gap-2 mb-1">
            <div class="w-2 h-2 rounded-full mt-1" style="background-color: {{ $color['dot'] }};"></div>

            <div class="flex-1">
                <div class="text-sm font-semibold text-gray-700">
                    {{ $session->title }}
                </div>

                <div class="text-xs text-gray-500">
{{ \Carbon\Carbon::parse($session->start_time)->format('H:i') }}
-
{{ \Carbon\Carbon::parse($session->end_time)->format('H:i') }}                </div>
            </div>
        </div>

        <!-- Delete button -->
        <button
            @click.stop="
                if (confirm('Delete this session?')) {
                    fetch('/student/live-sessions/{{ $session->id }}/delete', {
                        method: 'DELETE',
                        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
                    }).then(() => window.location.reload());
                }
            "
            class="absolute bottom-1 right-1 text-gray-400 hover:text-red-600"
        >
            <i class="ri-delete-bin-line text-sm"></i>
        </button>
    </div>
@endforeach

        @if($daySessions->isEmpty())
            <button @click="
        showChoiceModal = true;
        selectedSlot = {
            day: '{{ $day }}',
            hour: '{{ $hour }}',
            end: (parseInt('{{ $hour }}'.split(':')[0]) + 1).toString().padStart(2,'0') + ':00',
            dayName: '{{ $dayNames[$dayIndex] }}'
        };
    "
                    class="absolute inset-0 w-full h-full opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center bg-gray-50/50 hover:bg-gray-100/50 z-0">
                <i class="ri-add-line text-2xl text-gray-400"></i>
            </button>
        @else
            @foreach($daySessions as $meeting)
                @php
                    $start = \Carbon\Carbon::parse($meeting->start_time);
                    $end = \Carbon\Carbon::parse($meeting->end_time);
                    $durationHours = $start->diffInMinutes($end) / 60;
                    $heightPx = 100 * $durationHours - 6;
                @endphp

                <div class="absolute left-1 right-1 rounded-lg p-3 cursor-pointer hover:shadow-lg transition-all z-10 group/meeting"
                     style="background-color:#DBECDD; height: {{ $heightPx }}px;"
                    @click="
    editMeetingModal = true;
    selectedMeeting = {
        id: '{{ $meeting->id }}',
        topic: '{{ addslashes($meeting->topic) }}',
        start_time: '{{ $start->format('H:i') }}',
        end_time: '{{ $end->format('H:i') }}',
        description: `{{ addslashes($meeting->description ?? '') }}`,
        subtasks: {{ json_encode($meeting->subtasks ?? []) }},
        attachments: {{ json_encode($meeting->attachments ?? []) }}
    };
">
                    <div class="flex flex-col h-full">
                        <div class="flex items-start gap-2 mb-2">
                            <div class="w-2 h-2 rounded-full mt-1 flex-shrink-0 bg-[#5F9873]"></div>
                            <div class="flex-1 min-w-0">
                                <h4 class="text-sm font-medium text-gray-700 line-clamp-2">{{ $meeting->topic }}</h4>
                                <p class="text-xs text-gray-500 mt-0.5">
                                    {{ $start->format('H:i') }} - {{ $end->format('H:i') }}
                                </p>
                            </div>
                            <!-- Edit Icon on hover -->
                            <div class="opacity-0 group-hover/meeting:opacity-100 transition-opacity">
                                <i class="ri-edit-line text-[#5F9873] text-lg"></i>
                            </div>
                        </div>
                        <div class="flex-1"></div>
                        <div class="flex items-center justify-between gap-2 mt-auto">
                            <a href="{{ route('student.zoom.join', $meeting->zoom_meeting_id) }}"
                               target="_blank"
                               @click.stop
                               class="inline-flex items-center gap-1.5 text-xs font-medium px-3 py-1.5 transition-all hover:bg-[#DBECDD]/20 border border-[#5F9873] text-[#436653] rounded">
                                <i class="ri-video-on-line text-sm"></i>
                                <span>Start</span>
                            </a>

                            <!-- Delete Button -->
                            <button
                                @click.stop="
                                    if (confirm('Delete this meeting?')) {
                                        fetch('/teacher/live-sessions/{{ $meeting->id }}/delete', {
                                            method: 'DELETE',
                                            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
                                        })
                                        .then(() => window.location.reload());
                                    }
                                "
                                class="opacity-0 group-hover/meeting:opacity-100 transition text-gray-500 hover:text-red-600">
                                <i class="ri-delete-bin-line text-lg"></i>
                            </button>
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </td>
@endforeach
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <!-- ✅ TO-DO LIST -->
         <div class="w-full xl:w-auto">
    <div class="bg-white rounded-xl overflow-hidden xl:sticky xl:top-10">

        <!-- HEADER -->
        <div class="px-5 py-2 pb-[13px] border-b border-gray-200">
            <h3 class="text-base font-bold text-gray-900">— To Do —</h3>
        </div>

       <div class="p-5 space-y-4 max-h-[800px] overflow-y-auto"
     x-data="{
        tasks: {{ json_encode($tasks) }},

        addTask() {
            let newTask = { id: null, title: '', completed: false, editing: true };
            this.tasks.unshift(newTask);

            fetch('{{ route('student.live-sessions.task.store') }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ title: '' })
            })
            .then(res => res.json())
            .then(data => {
                newTask.id = data.id;
            });
        },

        updateTask(task) {
            if (!task.id) return;
            fetch('/student/live-sessions/task/' + task.id + '/update', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ title: task.title })
            });
        },

        toggle(task) {
            fetch('/student/live-sessions/task/' + task.id + '/toggle', {
                method: 'POST',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
            });
            task.completed = !task.completed;
        },

        deleteTask(task, index) {
            fetch('/student/live-sessions/task/' + task.id, {
                method: 'DELETE',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
            });
            this.tasks.splice(index, 1);
        }
     }">
            <!-- TASKS -->
           <template x-for="(task, index) in tasks" :key="task.id ?? index">
    <div class="flex items-start justify-between group">

        <div class="flex items-start gap-3 flex-1">

            <!-- Checkbox -->
            <input type="checkbox"
                class="w-4 h-4 mt-1.5 rounded text-blue-600 cursor-pointer"
                :checked="task.completed"
                @change="toggle(task)">

            <!-- Titre -->
            <div class="flex-1 mb-1">

                <!-- Texte affiché -->
                <span x-show="!task.editing"
      @click="task.editing = true; $nextTick(() => $refs['input' + index].focus())"
      class="text-sm cursor-text"
      :class="task.completed ? 'line-through text-gray-400' : 'text-gray-700'">

    <span
        :class="!task.title ? 'text-gray-400' : ''"
        x-text="task.title || 'To Do...'"
    ></span>
</span>

                <!-- Input édition -->
                <input x-show="task.editing"
                       :x-ref="'input' + index"
                       x-model="task.title"
                       @input="updateTask(task)"
                       @blur="task.editing = false"
                       class="text-sm px-2 py-1 rounded w-full bg-transparent outline-none border-none focus:ring-0">
            </div>
        </div>

        <!-- Delete -->
        <button
            @click="deleteTask(task, index)"
            class="opacity-0 group-hover:opacity-100 text-gray-400 hover:text-red-600 transition">
            <i class="ri-delete-bin-line text-lg"></i>
        </button>

    </div>
</template>

            <!-- ADD TASK BUTTON -->
           <button
    @click="addTask()"
    class="w-full flex items-center gap-2 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-100 px-3 py-2 rounded transition">
    <i class="ri-add-line text-lg"></i>
    Add task
</button>
        </div>
    </div>
</div>

    </div>

    <!-- 🟢 MODAL : CREATE ZOOM MEETING -->
    <div x-show="showSessionModal" x-cloak @click.self="showSessionModal = false"
     class="fixed inset-0 bg-black/50 z-50 flex items-center justify-center p-4">

    <div class="bg-white rounded-xl shadow-2xl max-w-lg w-full" @click.stop>

        <!-- HEADER -->
        <div class="px-6 py-4 border-b border-gray-200 flex items-center justify-between">
            <h3 class="text-lg font-bold text-gray-900">Create  Meeting</h3>
            <button @click="showSessionModal = false" class="text-gray-400 hover:text-gray-600">
                <i class="ri-close-line text-xl"></i>
            </button>
        </div>

        <!-- FORM -->
        <form method="POST" action="{{ route('teacher.live-sessions.store') }}" class="p-6 space-y-5">
            @csrf

            <!-- HIDDEN DAY -->
            <input type="hidden" name="day" :value="selectedSlot.day">

            <!-- 🏷️ Title -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Meeting Title</label>
                <input type="text" name="topic" required placeholder="Enter meeting title..."
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>

            <!-- 👥 Group -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Group</label>
                <select name="group_id" required
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    @foreach($groups as $group)
                        <option value="{{ $group->id }}">{{ $group->name }}</option>
                    @endforeach
                </select>
            </div>

            <!-- 🕒 START HOUR -->
            <div x-data="{ open:false, value:selectedSlot.hour }" class="relative">
                <label class="block text-sm font-medium text-gray-700 mb-2">Start Hour</label>

                <button @click="open=!open" type="button"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg bg-white flex items-center justify-between">
                    <span x-text="value"></span>
                    <i class="ri-time-line text-gray-500"></i>
                </button>

                <input type="hidden" name="start_hour" x-model="value">

                <div x-show="open" @click.outside="open=false"
                     class="absolute z-50 mt-2 w-full bg-white border border-gray-200 rounded-lg shadow-lg max-h-48 overflow-y-auto">

                    @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00'] as $time)
                        <div @click="value='{{ $time }}'; open=false"
                             class="px-4 py-2 hover:bg-gray-100 cursor-pointer">
                            {{ $time }}
                        </div>
                    @endforeach

                </div>
            </div>

            <!-- ⏳ DURATION -->
            <div x-data="{ open:false, value:60 }" class="relative">
                <label class="block text-sm font-medium text-gray-700 mb-2">Duration</label>

                <button @click="open=!open" type="button"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg bg-white flex items-center justify-between">
                    <span x-text="value + ' minutes'"></span>
                    <i class="ri-arrow-down-s-line text-gray-500"></i>
                </button>

                <input type="hidden" name="duration" x-model="value">

                <div x-show="open" @click.outside="open=false"
                     class="absolute z-50 mt-2 w-full bg-white border border-gray-200 rounded-lg shadow-lg max-h-48 overflow-y-auto">

                    <div @click="value=30; open=false" class="px-4 py-2 hover:bg-gray-100 cursor-pointer">30 minutes</div>
                    <div @click="value=60; open=false" class="px-4 py-2 hover:bg-gray-100 cursor-pointer">1 hour</div>
                    <div @click="value=90; open=false" class="px-4 py-2 hover:bg-gray-100 cursor-pointer">1h 30m</div>
                    <div @click="value=120; open=false" class="px-4 py-2 hover:bg-gray-100 cursor-pointer">2 hours</div>

                </div>
            </div>

            <!-- 🚀 ACTIONS -->
            <div class="flex gap-3 pt-4">
                <button type="button" @click="showSessionModal = false"
                        class="flex-1 px-4 py-2 border border-gray-300 rounded-lg text-gray-700 font-medium hover:bg-gray-50 transition-colors">
                    Cancel
                </button>
                <button type="submit"
                        class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg font-medium hover:bg-blue-700 transition-colors">
                    Create
                </button>
            </div>
        </form>

    </div>
</div>

<!-- 🔵 MODAL : EDIT MEETING -->
<div x-show="editMeetingModal"
     x-cloak
     @click.self="editMeetingModal = false; refreshPage()"
     class="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-50 p-4">

    <div @click.stop
         class="bg-white rounded-2xl shadow-2xl w-full max-w-4xl max-h-[90vh] overflow-hidden"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 scale-95"
         x-transition:enter-end="opacity-100 scale-100">

        <!-- HEADER -->
        <div class="px-8 py-6 border-b border-gray-200 bg-gradient-to-r from-gray-50 to-white flex justify-between items-center">
            <input type="text"
                   x-model="selectedMeeting.topic"
                   @input="autoSaveMeeting()"
                   placeholder="Meeting title..."
                   class="text-2xl font-bold text-gray-900 w-full bg-transparent border-none focus:outline-none focus:ring-0 p-0">

            <button @click="editMeetingModal = false; refreshPage()"
                    class="text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg p-2 transition-all ml-4">
                <i class="ri-close-line text-2xl"></i>
            </button>
        </div>

        <!-- BODY : 2 columns -->
        <div class="flex h-[calc(90vh-120px)]">

            <!-- LEFT COLUMN -->
            <div class="flex-1 overflow-y-auto px-8 py-6 space-y-6">

                <!-- TIME -->
                <div class="grid grid-cols-2 gap-6">

                    <!-- START -->
                    <div x-data="{ open:false }" class="relative">
                        <label class="text-sm text-gray-600 font-medium">Start Time</label>

                        <button @click="open = !open"
                                type="button"
                                class="w-full px-4 py-2 mt-1 bg-gray-100 rounded-lg text-left text-sm flex justify-between items-center">
                            <span x-text="selectedMeeting.start_time || 'Select time'"></span>
                            <i class="ri-time-line text-gray-500"></i>
                        </button>

                        <div x-show="open" @click.outside="open = false"
                             class="absolute z-50 left-0 right-0 mt-2 bg-white border border-gray-200 rounded-lg shadow-md max-h-48 overflow-y-auto">

                            @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00'] as $time)
                                <div @click="selectedMeeting.start_time='{{ $time }}'; open=false; autoSaveMeeting()"
                                     class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                                     :class="{ 'bg-blue-50 font-semibold' : selectedMeeting.start_time === '{{ $time }}' }">
                                    {{ $time }}
                                </div>
                            @endforeach

                        </div>
                    </div>

                    <!-- END -->
                    <div x-data="{ open:false }" class="relative">
                        <label class="text-sm text-gray-600 font-medium">End Time</label>

                        <button @click="open = !open"
                                type="button"
                                class="w-full px-4 py-2 mt-1 bg-gray-100 rounded-lg text-left text-sm flex justify-between items-center">
                            <span x-text="selectedMeeting.end_time || 'Select time'"></span>
                            <i class="ri-time-line text-gray-500"></i>
                        </button>

                        <div x-show="open" @click.outside="open = false"
                             class="absolute z-50 left-0 right-0 mt-2 bg-white border border-gray-200 rounded-lg shadow-md max-h-48 overflow-y-auto">

                            @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00','19:00'] as $time)
                                <div @click="selectedMeeting.end_time='{{ $time }}'; open=false; autoSaveMeeting()"
                                     class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                                     :class="{ 'bg-blue-50 font-semibold' : selectedMeeting.end_time === '{{ $time }}' }">
                                    {{ $time }}
                                </div>
                            @endforeach

                        </div>
                    </div>

                </div>

                <!-- DESCRIPTION -->
                <div>
                    <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
                        <i class="ri-file-text-line"></i>
                        Description
                    </h3>

                    <textarea x-model="selectedMeeting.description"
                              @input="autoSaveMeeting()"
                              rows="4"
                              placeholder="Add meeting description..."
                              class="w-full px-4 py-3 bg-gray-50 rounded-lg text-sm text-gray-700 border-none focus:ring-2 focus:ring-blue-500"></textarea>
                </div>

                <!-- SUBTASKS -->
                <div>
                    <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
                        <i class="ri-checkbox-multiple-line"></i>
                        Tasks
                    </h3>

                    <div class="space-y-2">

                        <template x-for="(item, index) in selectedMeeting.subtasks" :key="index">
                            <div class="flex items-center gap-2 group hover:bg-gray-50 p-2 rounded-lg transition-all">

                                <input type="checkbox"
                                       x-model="item.completed"
                                       @change="autoSaveMeeting()"
                                       class="w-5 h-5 rounded border-gray-300 cursor-pointer text-[#5F9873] focus:ring-[#5F9873]">

                                <input type="text"
                                       x-model="item.text"
                                       @input="autoSaveMeeting()"
                                       placeholder="Sub-task..."
                                       class="flex-1 bg-transparent border-none text-sm focus:outline-none focus:ring-0"
                                       :class="item.completed ? 'line-through text-gray-400' : 'text-gray-700'">

                                <button @click="selectedMeeting.subtasks.splice(index,1); autoSaveMeeting();"
                                        class="opacity-0 group-hover:opacity-100 text-red-400 hover:text-red-600 transition-all">
                                    <i class="ri-delete-bin-line text-lg"></i>
                                </button>
                            </div>
                        </template>

                        <button @click="selectedMeeting.subtasks.push({text:'', completed:false}); autoSaveMeeting();"
                                class="flex items-center gap-2 text-sm text-gray-500 hover:text-[#5F9873] hover:bg-green-50 px-3 py-2 rounded-lg transition-all">
                            <i class="ri-add-line text-lg"></i>
                            Add task
                        </button>
                    </div>
                </div>
     <div>
    <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
        <i class="ri-attachment-line"></i>
        Attachments
    </h3>

    <!-- Upload Zone -->
    <div class="mb-4">
        <label class="flex flex-col items-center justify-center w-full h-24 border-2 border-gray-300 border-dashed rounded-lg cursor-pointer bg-gray-50 hover:bg-gray-100 transition-all">
            <div class="flex flex-col items-center justify-center pt-5 pb-6">
                <i class="ri-upload-cloud-line text-2xl text-gray-400 mb-1"></i>
                <p class="text-sm text-gray-500">Click to upload (PDF, Images, Docs)</p>
            </div>
        <input type="file"
       class="hidden"
       accept=".jpg,.jpeg,.png,.gif,.pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx"
       @change="
           let file = $event.target.files[0];
           if (!file) return;

           let formData = new FormData();
           formData.append('file', file);
           formData.append('_token', '{{ csrf_token() }}');

           let xhr = new XMLHttpRequest();
           xhr.open('POST', '/teacher/live-sessions/' + selectedMeeting.id + '/attachment', true);
           xhr.setRequestHeader('Accept', 'application/json');
           xhr.setRequestHeader('X-CSRF-TOKEN', '{{ csrf_token() }}');

           xhr.onload = function() {
               console.log('XHR Response:', xhr.responseText);
               let data = JSON.parse(xhr.responseText);
               if (data.success) {
                   selectedMeeting.attachments = data.attachments;
               } else {
                   alert(data.error || 'Upload failed');
               }
           };

           xhr.onerror = function() {
               alert('Network error');
           };

           xhr.send(formData);
           $event.target.value = '';
       ">
        </label>
    </div>

    <!-- Liste des fichiers -->
    <div class="space-y-2">
        <template x-for="(file, index) in (selectedMeeting.attachments || [])" :key="index">
            <div class="flex items-center gap-3 p-3 bg-gray-50 rounded-lg group">

                <!-- Icon selon type -->
                <div class="w-10 h-10 rounded-lg flex items-center justify-center"
                     :class="{
                         'bg-red-100 text-red-600': file.type === 'pdf',
                         'bg-blue-100 text-blue-600': file.type === 'doc',
                         'bg-green-100 text-green-600': file.type === 'excel',
                         'bg-orange-100 text-orange-600': file.type === 'ppt',
                         'bg-purple-100 text-purple-600': file.type === 'image',
                         'bg-gray-100 text-gray-600': !['pdf','doc','excel','ppt','image'].includes(file.type)
                     }">
                    <i :class="{
                        'ri-file-pdf-line': file.type === 'pdf',
                        'ri-file-word-line': file.type === 'doc',
                        'ri-file-excel-line': file.type === 'excel',
                        'ri-file-ppt-line': file.type === 'ppt',
                        'ri-image-line': file.type === 'image',
                        'ri-file-line': !['pdf','doc','excel','ppt','image'].includes(file.type)
                    }" class="text-xl"></i>
                </div>

                <!-- Nom du fichier -->
                <div class="flex-1 min-w-0">
                    <p class="text-sm font-medium text-gray-700 truncate" x-text="file.name"></p>
                    <p class="text-xs text-gray-400" x-text="(file.size / 1024).toFixed(1) + ' KB'"></p>
                </div>

                <!-- Actions -->
                <a :href="file.url"
                   target="_blank"
                   class="p-2 text-gray-400 hover:text-blue-600 transition">
                    <i class="ri-eye-line text-lg"></i>
                </a>

                <button @click="
                    if (confirm('Delete this file?')) {
                        fetch('/teacher/live-sessions/' + selectedMeeting.id + '/attachment', {
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify({ index: index })
                        })
                        .then(res => res.json())
                        .then(data => {
                            if (data.success) {
                                selectedMeeting.attachments = data.attachments;
                            }
                        });
                    }
                " class="p-2 text-gray-400 hover:text-red-600 transition opacity-0 group-hover:opacity-100">
                    <i class="ri-delete-bin-line text-lg"></i>
                </button>
            </div>
        </template>

        <!-- Empty state -->
        <div x-show="!selectedMeeting.attachments || selectedMeeting.attachments.length === 0"
             class="text-center py-4 text-gray-400 text-sm">
            No files attached yet
        </div>
    </div>
</div>
            </div>

            <!-- RIGHT COLUMN - Meeting Info -->
            <div class="w-80 bg-gray-50 border-l border-gray-200 p-6 overflow-y-auto">
                <h3 class="text-base font-bold text-gray-600 mb-4 flex items-center gap-2">
                    <i class="ri-information-line"></i>
                    Meeting Info
                </h3>

                <div class="space-y-4">
                    <div class="bg-white rounded-lg p-4 shadow-sm">
                        <p class="text-xs text-gray-500 mb-1">Status</p>
                        <span class="inline-flex items-center gap-1.5 px-2 py-1 bg-green-100 text-green-700 rounded-full text-xs font-medium">
                            <span class="w-1.5 h-1.5 bg-green-500 rounded-full"></span>
                            Scheduled
                        </span>
                    </div>

                    <div class="bg-white rounded-lg p-4 shadow-sm">
                        <p class="text-xs text-gray-500 mb-1">Duration</p>
                        <p class="text-sm font-medium text-gray-700" x-text="
                            (() => {
                                if (!selectedMeeting.start_time || !selectedMeeting.end_time) return '-';
                                let start = parseInt(selectedMeeting.start_time.split(':')[0]);
                                let end = parseInt(selectedMeeting.end_time.split(':')[0]);
                                let diff = end - start;
                                return diff + ' hour' + (diff > 1 ? 's' : '');
                            })()
                        "></p>
                    </div>



                </div>
            </div>

        </div>

    </div>
</div>
<div x-show="showChoiceModal" x-cloak @click.self="showChoiceModal = false"
     class="fixed inset-0 bg-black/50 z-[100000] flex items-center justify-center p-4">

    <div class="bg-white rounded-xl shadow-2xl p-6 w-full max-w-md">

        <h2 class="text-xl font-bold text-gray-900 mb-4 text-center">
            What do you want to create?
        </h2>

        <div class="space-y-4">

            <!-- ▶️ Bouton Zoom Meeting -->
            <button
                @click="
                    showChoiceModal = false;
                    showSessionModal = true;   // 👉 ceci ouvre TON modal Zoom existant
                "
                class="w-full px-4 py-3 bg-blue-600 text-white rounded-lg font-medium hover:bg-blue-700 transition"
            >
                Create Zoom Meeting
            </button>

            <!-- ▶️ Bouton Calendar Session (Project/Break...) -->
            <button
                @click="
                    showChoiceModal = false;
                    showStudentSessionModal = true; // 👉 modal comme étudiant
                "
                class="w-full px-4 py-3 bg-gray-100 rounded-lg font-medium hover:bg-gray-200 transition"
            >
                Create Calendar Session
            </button>

        </div>
    </div>
</div>

<!-- 🟣 MODAL : EDIT CALENDAR SESSION (STYLE STUDENT) -->
<div x-show="editStudentSessionModal"
     x-cloak
@click.self="editStudentSessionModal = false; refreshPage()"
     class="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-[100050] p-4">

    <div @click.stop
         class="bg-white rounded-2xl shadow-2xl w-full max-w-4xl max-h-[90vh] overflow-hidden"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 scale-95"
         x-transition:enter-end="opacity-100 scale-100">

        <!-- HEADER -->
        <div class="px-8 py-6 border-b border-gray-200 bg-gradient-to-r from-gray-50 to-white flex justify-between">

            <input type="text"
                   x-model="selectedCalendarSession.title"
                   @input="saveCalendarSession()"
                   placeholder="Session title..."
                   class="text-2xl font-bold text-gray-900 w-full bg-transparent border-none focus:outline-none focus:ring-0 p-0">

<button @click="editStudentSessionModal = false; refreshPage()"
                    class="text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg p-2 transition-all">
                <i class="ri-close-line text-2xl"></i>
            </button>
        </div>

        <!-- BODY -->
        <div class="flex h-[calc(90vh-120px)]">

            <!-- LEFT -->
            <div class="flex-1 overflow-y-auto px-8 py-6 space-y-6">

                <!-- TIME -->
                <div class="grid grid-cols-2 gap-6">

                    <!-- START -->
                    <div x-data="{ open:false }" class="relative">
                        <label class="text-sm text-gray-600 font-medium">Start Time</label>

                        <button @click="open = !open"
                                type="button"
                                class="w-full px-4 py-2 mt-1 bg-gray-100 rounded-lg flex justify-between items-center text-sm">
                            <span x-text="selectedCalendarSession.start"></span>
                            <i class="ri-time-line text-gray-500"></i>
                        </button>

                        <div x-show="open" @click.outside="open=false"
                             class="absolute left-0 right-0 mt-2 bg-white border rounded-lg shadow-md max-h-48 overflow-y-auto z-[200000]">

                            @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00'] as $time)
                                <div @click="selectedCalendarSession.start='{{ $time }}'; open=false; saveCalendarSession()"
                                     class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                                     :class="{ 'bg-blue-50 font-semibold' : selectedCalendarSession.start === '{{ $time }}' }">
                                    {{ $time }}
                                </div>
                            @endforeach

                        </div>
                    </div>

                    <!-- END -->
                    <div x-data="{ open:false }" class="relative">
                        <label class="text-sm text-gray-600 font-medium">End Time</label>

                        <button @click="open = !open"
                                type="button"
                                class="w-full px-4 py-2 mt-1 bg-gray-100 rounded-lg flex justify-between items-center text-sm">
                            <span x-text="selectedCalendarSession.end"></span>
                            <i class="ri-time-line text-gray-500"></i>
                        </button>

                        <div x-show="open" @click.outside="open=false"
                             class="absolute left-0 right-0 mt-2 bg-white border rounded-lg shadow-md max-h-48 overflow-y-auto z-[200000]">
                            @foreach(['09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00','19:00'] as $time)
                                <div @click="selectedCalendarSession.end='{{ $time }}'; open=false; saveCalendarSession()"
                                     class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                                     :class="{ 'bg-blue-50 font-semibold' : selectedCalendarSession.end === '{{ $time }}' }">
                                    {{ $time }}
                                </div>
                            @endforeach
                        </div>
                    </div>

                </div>

                <!-- DESCRIPTION -->
                <div>
                    <h3 class="text-base font-bold text-gray-600 mb-3">Description</h3>

<textarea x-model="selectedCalendarSession.notes"
                              @input="saveCalendarSession()"
                              rows="4"
                              class="w-full px-4 py-3 bg-gray-50 rounded-lg text-sm text-gray-700 border-none focus:ring-2 focus:ring-indigo-500"></textarea>
                </div>

                <!-- SUBTASKS -->
                <div>
                    <h3 class="text-base font-bold text-gray-600 mb-3">Tasks</h3>

                    <div class="space-y-2">

                        <template x-for="(item, index) in selectedCalendarSession.subtasks" :key="index">
                            <div class="flex items-center gap-2 p-2 rounded-lg group hover:bg-gray-50">

                                <input type="checkbox"
                                       x-model="item.completed"
                                       @change="saveCalendarSession()"
                                       class="w-5 h-5 rounded border-gray-300 cursor-pointer">

                                <input type="text"
                                       x-model="item.text"
                                       @input="saveCalendarSession()"
                                       placeholder="Sub-task..."
                                       class="flex-1 bg-transparent border-none text-sm focus:outline-none"
                                       :class="item.completed ? 'line-through text-gray-500' : 'text-gray-700'">

                                <button @click="selectedCalendarSession.subtasks.splice(index,1); saveCalendarSession()"
                                        class="opacity-0 group-hover:opacity-100 text-red-500 hover:text-red-700 transition">
                                    <i class="ri-delete-bin-line text-lg"></i>
                                </button>

                            </div>
                        </template>

                        <button @click="selectedCalendarSession.subtasks.push({text:'', completed:false}); saveCalendarSession()"
                                class="flex items-center gap-2 text-sm text-gray-500 hover:text-indigo-600 hover:bg-indigo-50 px-3 py-2 rounded-lg transition">
                            <i class="ri-add-line text-lg"></i>
                            Add task
                        </button>

                    </div>
                </div>

            </div>

        </div>

    </div>

</div>


<div x-show="showStudentSessionModal" x-cloak @click.self="showStudentSessionModal = false"
     class="fixed inset-0 bg-black/50 z-[100001] flex items-center justify-center p-4">

    <div class="bg-white rounded-xl shadow-2xl max-w-lg w-full" @click.stop>

        <!-- HEADER -->
        <div class="px-6 py-4 border-b border-gray-200 flex items-center justify-between">
            <h3 class="text-lg font-bold text-gray-900">Create Calendar Session</h3>
            <button @click="showStudentSessionModal = false" class="text-gray-400 hover:text-gray-600">
                <i class="ri-close-line text-xl"></i>
            </button>
        </div>

        <!-- FORM -->
        <form method="POST" action="{{ route('student.live-sessions.store') }}" class="p-6 space-y-5">
            @csrf

            <!-- HIDDEN DAY -->
            <input type="hidden" name="day_of_week" :value="selectedSlot.day">

            <!-- Title -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Title</label>
                <input type="text" name="title" required placeholder="Enter title..."
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg">
            </div>

            <!-- Type -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Type</label>
                <select name="type"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg">
                    <option value="project">Project</option>
                    <option value="meeting">Meeting</option>
                    <option value="break">Break</option>
                    <option value="lunch">Lunch</option>
                </select>
            </div>

            <!-- Start time -->
            <div x-data="{ open:false, value: selectedSlot.hour }" class="relative">
    <label class="block text-sm font-medium text-gray-700 mb-2">Start Time</label>

    <!-- Affichage -->
    <button @click="open = !open"
            type="button"
            class="w-full px-4 py-2 border border-gray-300 rounded-lg bg-white flex items-center justify-between">
        <span x-text="value"></span>
        <i class="ri-arrow-down-s-line text-gray-500"></i>
    </button>

    <input type="hidden" name="start_time" x-model="value">

    <!-- Dropdown -->
    <div x-show="open"
         @click.outside="open = false"
         class="absolute z-50 mt-2 w-full bg-white border border-gray-200 rounded-lg shadow-lg max-h-48 overflow-y-auto">

        @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00'] as $time)
            <div @click="value='{{ $time }}'; open=false"
                 class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                 :class="{ 'bg-blue-50 font-semibold' : value === '{{ $time }}' }">
                {{ $time }}
            </div>
        @endforeach

    </div>
</div>

            <!-- End time -->
            <div x-data="{ open:false, value: selectedSlot.end }" class="relative">
    <label class="block text-sm font-medium text-gray-700 mb-2">End Time</label>

    <!-- Affichage -->
    <button @click="open = !open"
            type="button"
            class="w-full px-4 py-2 border border-gray-300 rounded-lg bg-white flex items-center justify-between">
        <span x-text="value"></span>
        <i class="ri-arrow-down-s-line text-gray-500"></i>
    </button>

    <input type="hidden" name="end_time" x-model="value">

    <!-- Dropdown -->
    <div x-show="open"
         @click.outside="open = false"
         class="absolute z-50 mt-2 w-full bg-white border border-gray-200 rounded-lg shadow-lg max-h-48 overflow-y-auto">

        @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00','19:00'] as $time)
            <div @click="value='{{ $time }}'; open=false"
                 class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                 :class="{ 'bg-blue-50 font-semibold' : value === '{{ $time }}' }">
                {{ $time }}
            </div>
        @endforeach

    </div>
</div>

            <!-- Group -->
            <input type="hidden" name="group_id" value="{{ $groups->first()->id ?? '' }}">

            <!-- Actions -->
            <div class="flex gap-3 pt-4">
                <button type="button" @click="showStudentSessionModal = false"
                        class="flex-1 px-4 py-2 border border-gray-300 rounded-lg">
                    Cancel
                </button>
                <button type="submit"
                        class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg">
                    Create Session
                </button>
            </div>
        </form>
    </div>
</div>
</div>





<style>
[x-cloak] { display: none !important; }
</style>
</x-app-layout>
