<x-app-layout title="Mes groupes" :section="'Teacher'" :page="'Groups'">

    <div class="max-w-7xl mx-auto font-inter pt-10">

        <h1 class="text-4xl font-semibold text-[#1D1D1E] mb-6">My Groups</h1>

        @if($groups->isEmpty())
            <div class="bg-yellow-100 text-yellow-700 p-4 rounded-xl">
You are not currently associated with any group.            </div>
        @else
            <div class="bg-white rounded-2xl overflow-hidden">
                <table class="min-w-full divide-y divide-gray-100 text-sm">
                    <thead class="bg-[#F6F7F5] text-gray-700 font-medium">
                       <tr>
    <th class="px-6 py-3 text-left">ID</th>
    <th class="px-6 py-3 text-left">Name</th>
    <th class="px-6 py-3 text-left">Description</th>
    <th class="px-6 py-3 text-left">Created At</th>
    <th class="px-6 py-3 text-left">Students Count</th>
    <th class="px-6 py-3 text-left">Students</th>
</tr>
                    </thead>

                    <tbody class="divide-y divide-gray-100 text-gray-700">
                        @foreach($groups as $group)
                            <tr x-data="{ open: false }">

                                <td class="px-6 py-3">#{{ $group->id }}</td>

                                <td class="px-6 py-3 font-medium text-gray-900">
                                    {{ $group->name }}
                                </td>

                                <td class="px-6 py-3">
                                    {{ $group->description ?? '-' }}
                                </td>

                                <td class="px-6 py-3">
                                    {{ $group->created_at ? $group->created_at->format('Y-m-d') : '-' }}
                                </td>

                                <!-- Nombre d'étudiants -->
                                <td class="px-6 py-3 font-semibold text-gray-900">
                                    {{ $group->users->where('pivot.role', 'student')->count() }}
                                </td>

                                <td class="px-6 py-3">

                                    <!-- Bouton ouvrir modal -->
                                    <button
                                        @click="open = true"
                                        class="px-3 py-1 text-[13px] bg-[#EEF2FF] text-[#3730A3] rounded-lg font-medium hover:bg-[#E0E7FF] transition">
See students                                    </button>

                                    <!-- MODAL -->
                                  <!-- MODAL -->
<div
    x-show="open"
    x-cloak
    class="fixed inset-0 flex items-center justify-center bg-black/40 backdrop-blur-sm z-50">

    <div class="bg-white w-full max-w-3xl rounded-2xl shadow-2xl ">

        <!-- HEADER -->
<div class="w-full px-6 py-4 rounded-t-xl mb-6" style="background-color:#DBECDD;">
    <h2 class="text-2xl font-semibold text-[#436653]">
        Group {{ $group->id }} : {{ $group->name }}
    </h2>
</div>
<div class="pb-8 px-8">
        <h3 class="text-lg font-medium text-gray-600 mb-4">
            Student and Project
        </h3>

        <!-- TABLE -->
        <table class="w-full text-sm">
            <thead>
                <tr class="text-gray-500 border-b">
                   <th class="py-3 text-left font-light text-[15px] font-inter">Name</th>

                    <th class="py-3 text-left font-light text-[15px] font-inter">Attendance</th>

                    <th class="py-3 text-left font-light text-[15px] font-inter">Notes</th>
                </tr>
            </thead>

            <tbody class="divide-y">

                @foreach($group->users->where('pivot.role', 'student') as $student)

                    @php
                        // TEMPORARY RANDOM DATA (replace with real data)
                        $attendance = rand(60, 100);
                        $project = rand(60, 100);

                        $attColor = $attendance >= 90 ? 'bg-[#DBEFDC] text-[#2F6B36]' :
                                   ($attendance >= 80 ? 'bg-[#FBE8D4] text-[#915D1C]' :
                                                        'bg-[#FAD4D4] text-[#7D2F2F]');

                        $projColor = $project >= 90 ? 'bg-[#DBEFDC] text-[#2F6B36]' :
                                   ($project >= 80 ? 'bg-[#FBE8D4] text-[#915D1C]' :
                                                    'bg-[#FAD4D4] text-[#7D2F2F]');
                    @endphp

                    <tr class="h-16">

                        <!-- NAME -->
<td class="py-3 w-[260px]">
    <div class="flex items-center justify-between">

        <!-- Nom -->
        <span class="font-medium text-gray-800">
            {{ $student->first_name }} {{ $student->last_name }}
        </span>

        <!-- Bouton Open -->
       <a href="{{ route('teacher.student.detail', $student->id) }}"
   class="inline-flex items-center gap-2 px-2.5 py-1 border border-gray-600 rounded-lg
          text-gray-600 hover:bg-gray-100 transition">

    <!-- Icône dock-left -->
 <svg fill="#817F7B" width="25px" height="20px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M21 19V5c0-1.103-.897-2-2-2H5c-1.103 0-2 .897-2 2v14c0 1.103.897 2 2 2h14c1.103 0 2-.897 2-2zm-11 0V5h9l.002 14H10z"/></svg>

    <span class="text-[14px] font-light text-gray-700">Open</span>
</a>

 </div>
    </div>
</td>


                        <!-- ATTENDANCE -->
               <td class="py-3">
    <div class="flex justify-center">
        <span class="inline-flex items-center gap-2 px-3 py-1 rounded-full text-[15px] font-medium"
              style="background-color: {{ $attendance >= 90 ? '#DBEFDC' : ($attendance >= 80 ? '#FBE8D4' : '#FAD4D4') }};
                     color: {{ $attendance >= 90 ? '#2F6B36' : ($attendance >= 80 ? '#915D1C' : '#7D2F2F') }};">

            <!-- DOT -->
            <span class="w-3 h-3 rounded-full"
                  style="background-color: {{ $attendance >= 90 ? '#4EA85C' : ($attendance >= 80 ? '#DF7630' : '#D95B5B') }};">
            </span>

            {{ $attendance }}%
        </span>
    </div>
</td>



                        <!-- NOTES -->
                       <td class="py-3">
    <input type="text"
           placeholder="Add note..."
           class="w-full bg-transparent outline-none text-gray-700 text-[14px] font-light placeholder-gray-400" />
</td>

                    </tr>
                @endforeach

            </tbody>

        </table>

        <!-- CLOSE BUTTON -->
        <div class="mt-8 text-right">
            <button
                @click="open = false"
                class="px-5 py-2 bg-gray-800 text-white rounded-xl hover:bg-gray-900 transition">
                Fermer
            </button>
        </div>

    </div>
</div>

                                </td>

                            </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        @endif
    </div>

</x-app-layout>
