<x-app-layout title="Dashboard Enseignant" :section="'Teacher'" :page="'Dashboard'">

    <div class="px-8 font-inter  min-h-screen">

        <!-- HEADER -->
        <h1 class="text-3xl font-semibold text-gray-900 mb-6">Dashboard</h1>

        <!-- STATS CARDS -->
     <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8"
     x-data="{ openCard: null }">

    <!-- 🟦 Total Revenue -->
    <div class="bg-[#F7FAFE] border border-blue-100 rounded-2xl p-6 relative overflow-visible">
        <div class="flex items-center justify-between mb-2">
            <p class="font-inter text-[15px] font-normal text-[#1D1D1E]">Total revenue</p>

            <button
                @mouseenter="openCard = 'revenue'"
                @mouseleave="openCard = null"
                class="w-5 h-5 flex items-center justify-center rounded-full bg-gray-100 border border-gray-300 text-gray-700 text-xs font-medium">
                ?
            </button>

            <div x-show="openCard === 'revenue'"
                 x-transition
                 class="absolute -top-14 right-1/2 translate-x-1/2 w-56 bg-white text-center text-sm text-[#1D1D1E] font-inter font-normal p-2.5 rounded-xl shadow-lg border border-gray-100 z-50">
                Your total earnings from all time.
            </div>
        </div>
        <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E]">{{ $stats['total_revenue'] }}</h2>
    </div>

    <!-- 🟨 Revenue This Month -->
    <div class="bg-[#FDF9EE] border border-yellow-100 rounded-2xl p-6 relative overflow-visible">
        <div class="flex items-center justify-between mb-2">
            <p class="font-inter text-[15px] font-normal text-[#1D1D1E]">Revenue this month</p>

            <button
                @mouseenter="openCard = 'month'"
                @mouseleave="openCard = null"
                class="w-5 h-5 flex items-center justify-center rounded-full bg-gray-100 border border-gray-300 text-gray-700 text-xs font-medium">
                ?
            </button>

            <div x-show="openCard === 'month'"
                 x-transition
                 class="absolute -top-14 right-1/2 translate-x-1/2 w-60 bg-white text-center text-sm text-[#1D1D1E] font-inter font-normal p-2.5 rounded-xl shadow-lg border border-gray-100 z-50">
                Your confirmed earnings for the current month.
            </div>
        </div>
        <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E]">{{ $stats['month_revenue'] }}</h2>
        <p class="text-xs text-gray-400 mt-1">+23% from last month</p>
    </div>

    <!-- 🟥 Total Teaching Hours -->
    <div class="bg-[#FFF6F5] border border-red-100 rounded-2xl p-6 relative overflow-visible">
        <div class="flex items-center justify-between mb-2">
            <p class="font-inter text-[15px] font-normal text-[#1D1D1E]">Total Teaching Hours</p>

            <button
                @mouseenter="openCard = 'hours'"
                @mouseleave="openCard = null"
                class="w-5 h-5 flex items-center justify-center rounded-full bg-gray-100 border border-gray-300 text-gray-700 text-xs font-medium">
                ?
            </button>

            <div x-show="openCard === 'hours'"
                 x-transition
                 class="absolute -top-14 right-1/2 translate-x-1/2 w-60 bg-white text-center text-sm text-[#1D1D1E] font-inter font-normal p-2.5 rounded-xl shadow-lg border border-gray-100 z-50">
                Total hours you've taught across all courses.
            </div>
        </div>
        <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E]">{{ $stats['teaching_hours'] }}</h2>
    </div>

    <!-- ⚪ Balance -->
    <div class="bg-[#F9F8F6] border border-gray-100 rounded-2xl p-6 relative overflow-visible">
        <div class="flex items-center justify-between mb-2">
            <p class="font-inter text-[15px] font-normal text-[#1D1D1E]">Balance</p>

            <button
                @mouseenter="openCard = 'balance'"
                @mouseleave="openCard = null"
                class="w-5 h-5 flex items-center justify-center rounded-full bg-gray-100 border border-gray-300 text-gray-700 text-xs font-medium">
                ?
            </button>

            <div x-show="openCard === 'balance'"
                 x-transition
                 class="absolute -top-14 right-1/2 translate-x-1/2 w-52 bg-white text-center text-sm text-[#1D1D1E] font-inter font-normal p-2.5 rounded-xl shadow-lg border border-gray-100 z-50">
                Your available payout.
            </div>
        </div>
        <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E]">{{ $stats['balance'] }}</h2>
        <p class="text-xs text-gray-400 mt-1">23% from last month</p>
    </div>
</div>


        <!-- TOTAL REVENUE SECTION -->
<div class="bg-white border border-gray-100 rounded-2xl shadow-sm p-6">

    <!-- HEADER -->
    <div class="flex items-center justify-between mb-6">
        <div>
            <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E] mb-1">Total revenue</h2>
            <div class="flex items-end gap-2">
                <h3 class="font-inter text-[32px] font-semibold text-[#1D1D1E] leading-none">$250,000</h3>
                <span class="text-green-500 font-inter text-sm font-medium">↑ 42%</span>
            </div>
        </div>
    </div>

    <!-- CONTENU : CHART + DONUT côte à côte -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-10">

    <!-- 📈 Colonne Chart – largeur 50% -->
    <div>
        <canvas id="salesChart" height="130"></canvas>

        <div class="flex items-center justify-start gap-6 mt-4 text-sm font-inter text-[#1D1D1E]">
            <div class="flex items-center gap-2">
                <span class="w-4 h-0.5 bg-[#3b82f6]"></span>
                Jun 6–Jul 5, 2023
            </div>
            <div class="flex items-center gap-2 text-gray-400">
                <span class="w-4 h-0.5 bg-gray-300"></span>
                May 7–Jun 5, 2023
            </div>
        </div>
    </div>

    <!-- 🟩 Colonne Upcoming Sessions – largeur 50% -->
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 -mt-20">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                <i class="ri-calendar-event-line text-green-600"></i>
                Upcoming Meetings
            </h3>
            <a href="/student/live-sessions" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
                View all →
            </a>
        </div>

        @if($upcomingSessions->count() > 0)
            <div class="space-y-3">
                @foreach($upcomingSessions as $session)
                    <div class="flex items-start gap-3 p-3 border-l-4 border-green-500 rounded-lg hover:bg-gray-50 transition">
                        <div class="flex-shrink-0 bg-green-50 p-2 rounded-lg">
                            <i class="ri-video-chat-line text-green-600 text-lg"></i>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-semibold text-gray-900">
                                {{ $session->topic }}
                            </p>
                            <p class="text-xs text-gray-500 mt-1">
                                <i class="ri-time-line"></i>
                                {{ \Carbon\Carbon::parse($session->start_time)->format('d M, H:i') }}
                            </p>
                        </div>

                        <a href="{{ $session->join_url }}" target="_blank"
                            class="flex-shrink-0 text-xs bg-green-100 text-green-700 px-3 py-1 rounded-full hover:bg-green-200 transition">
                            Join
                        </a>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-8 text-gray-400">
                <i class="ri-calendar-check-line text-5xl mb-2"></i>
                <p class="text-sm">No upcoming meetings</p>
            </div>
        @endif
    </div>



</div>
</div>




 <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 pt-10 pb-20">

            <!-- Urgent Goals -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <i class="ri-alarm-warning-line text-red-600"></i>
                        Urgent Goals
                    </h3>
                    <a href="{{ route('student.goals') }}" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
                        View all →
                    </a>
                </div>

                @if($urgentGoals->count() > 0)
                    <div class="space-y-3">
                        @foreach($urgentGoals as $goal)
                        <div class="flex items-start gap-3 p-3 bg-red-50 border border-red-100 rounded-lg">
                            <div class="flex-1">
                                <p class="text-sm font-semibold text-gray-900">{{ $goal->title }}</p>
                                <div class="flex items-center gap-3 mt-2 text-xs">
                                    <span class="flex items-center gap-1 text-red-600">
                                        <i class="ri-calendar-line"></i>
                                        Due: {{ \Carbon\Carbon::parse($goal->due_date)->format('d M Y') }}
                                    </span>
                                    @if($goal->priority)
                                    <span class="px-2 py-0.5 bg-red-200 text-red-700 rounded-full">
                                        {{ $goal->priority }}
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <span class="flex-shrink-0 px-3 py-1 text-xs rounded-full
                                @if($goal->status == 'in_progress') bg-yellow-100 text-yellow-700
                                @else bg-gray-100 text-gray-600
                                @endif">
                                {{ ucfirst(str_replace('_', ' ', $goal->status)) }}
                            </span>
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-400">
                        <i class="ri-checkbox-circle-line text-5xl mb-2"></i>
                        <p class="text-sm">No urgent goals! You're all caught up! ✨</p>
                    </div>
                @endif
            </div>

            <!-- My Groups -->
            <div id="groups-section" class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <i class="ri-group-line text-blue-600"></i>
                        My Groups
                    </h3>
                    <span class="text-sm text-gray-500">{{ $groupsCount }} groups</span>
                </div>

                @if($userGroups->count() > 0)
                    <div class="space-y-3">
                        @foreach($userGroups as $group)
                        <div class="flex items-center gap-4 p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-lg hover:shadow-md transition">
                            <div class="flex-shrink-0 w-12 h-12 bg-indigo-600 rounded-xl flex items-center justify-center text-white font-bold text-lg">
                                {{ strtoupper(substr($group->name, 0, 1)) }}
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-semibold text-gray-900 truncate">{{ $group->name }}</p>
                                <p class="text-xs text-gray-500 truncate">{{ $group->description ?? 'No description' }}</p>
                            </div>
                            <span class="flex-shrink-0 text-xs bg-indigo-100 text-indigo-700 px-3 py-1 rounded-full">
                                {{ ucfirst($group->role) }}
                            </span>
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-400">
                        <i class="ri-group-line text-5xl mb-2"></i>
                        <p class="text-sm">You're not in any groups yet</p>
                    </div>
                @endif
            </div>

        </div>
    <!-- Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('salesChart').getContext('2d');

new Chart(ctx, {
    type: 'line',
    data: {
        labels: ['Jun 6', 'Jun 10', 'Jun 14', 'Jun 18', 'Jun 22', 'Jun 26', 'Jul 1', 'Jul 5'],
        datasets: [
            {
                label: 'Current Period',
                data: [5000, 8500, 4000, 9500, 6000, 7200, 4800, 5300],
                borderColor: '#20afed',
                backgroundColor: 'rgba(32,175,237,0.08)',
                borderWidth: 4,
                fill: true,
                tension: 0.4,
                pointRadius: 0
            },
            {
                label: 'Previous Period',
                data: [4000, 7000, 3000, 8500, 5000, 6500, 4200, 4700],
                borderColor: '#d1d5db',
                borderDash: [4, 4],
                borderWidth: 1.5,
                fill: false,
                tension: 0.4,
                pointRadius: 0
            }
        ]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false },
            tooltip: {
                backgroundColor: '#fff',
                titleColor: '#111827',
                bodyColor: '#111827',
                borderColor: '#e5e7eb',
                borderWidth: 1,
                displayColors: false,
                padding: 10,
                cornerRadius: 10,
                callbacks: {
                    label: function(ctx) {
                        return '$' + ctx.parsed.y.toLocaleString();
                    }
                }
            }
        },
        scales: {
            x: {
                grid: { display: false },
                ticks: { color: '#9ca3af', font: { size: 12 } }
            },
            y: {
                grid: { color: '#f3f4f6' },
                ticks: {
                    color: '#9ca3af',
                    callback: function(value) { return '$' + value / 1000 + 'K'; },
                    stepSize: 2000
                },
                min: 0,
                max: 10000
            }
        },
        elements: {
            line: { cubicInterpolationMode: 'monotone' }
        }
    }
});


const donutCtx = document.getElementById('revenueShare').getContext('2d');

new Chart(donutCtx, {
    type: 'doughnut',
    data: {
        labels: ['Full stack', 'Back-end', 'Front-end', 'Data Science'],
        datasets: [{
            data: [43, 22.5, 12, 22.5],
            backgroundColor: ['#DC2626', '#059669', '#1d4ed8', '#374151'],
            borderColor: '#fff',
            borderWidth: 3,
            spacing: 15,  // espace entre les segments
            hoverOffset: 6
        }]
    },
    options: {
        plugins: {
            legend: { display: false },
            tooltip: {
                callbacks: {
                    label: ctx => ctx.label + ': ' + ctx.parsed + '%'
                }
            }
        },
        cutout: '80%',
        layout: {
            padding: 10
        }
    }
});
</script>

</x-app-layout>
