<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="zoom-domain" content="zoom.us">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Réunion Zoom - {{ $meeting->topic }}</title>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html, body {
            width: 100%;
            height: 100%;
            overflow: hidden;
            background-color: #111827;
            color: white;
            font-family: Arial, sans-serif;
        }

        #loading {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            width: 100vw;
            font-size: 1.2rem;
            color: #e5e7eb;
        }

        #zmmtg-root {
            display: none;
            width: 100vw;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
        }

        /* Masquer les watermarks Zoom */
        .watermark,
        .leftwatermark,
        .rightwatermark,
        .powered-by {
            display: none !important;
            visibility: hidden !important;
        }

        /* Style pour le bouton de retour dans le loading */
        .back-button {
            display: inline-block;
            margin-top: 20px;
            padding: 12px 24px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            transition: transform 0.2s;
        }

        .back-button:hover {
            transform: translateY(-2px);
        }
    </style>

    <!-- Scripts Zoom -->
    <link type="text/css" rel="stylesheet" href="https://source.zoom.us/3.8.10/css/bootstrap.css" />
    <link type="text/css" rel="stylesheet" href="https://source.zoom.us/3.8.10/css/react-select.css" />

    <script src="https://source.zoom.us/3.8.10/lib/vendor/react.min.js"></script>
    <script src="https://source.zoom.us/3.8.10/lib/vendor/react-dom.min.js"></script>
    <script src="https://source.zoom.us/3.8.10/lib/vendor/redux.min.js"></script>
    <script src="https://source.zoom.us/3.8.10/lib/vendor/redux-thunk.min.js"></script>
    <script src="https://source.zoom.us/3.8.10/lib/vendor/lodash.min.js"></script>
    <script src="https://source.zoom.us/zoom-meeting-3.8.10.min.js"></script>
</head>
<body>
    <div id="loading">
        <div>🔄 Chargement de la salle Zoom...</div>
    </div>
    <div id="zmmtg-root"></div>

    <script>
        window.addEventListener('load', function() {
            console.log("=== ZOOM SDK INITIALIZATION ===");

            if (typeof ZoomMtg === "undefined") {
                console.error("❌ ZoomMtg is undefined");
                document.getElementById('loading').innerHTML =
                    '<div>❌ SDK Zoom non disponible</div>' +
                    '<a href="{{ route('student.zoom.index') }}" class="back-button">← Retour</a>';
                return;
            }

            console.log("✅ ZoomMtg loaded");

            ZoomMtg.setZoomJSLib('https://source.zoom.us/3.8.10/lib', '/av');
            ZoomMtg.preLoadWasm();
            ZoomMtg.prepareWebSDK();

            const meetConfig = {
                sdkKey: "{{ $sdkKey }}",
                meetingNumber: "{{ $meeting->zoom_meeting_id }}",
                userName: "{{ Auth::user()->name }}",
                passWord: "{{ $meeting->password ?? '' }}",
                leaveUrl: "{{ route('student.zoom.index') }}",
                role: {{ $role ?? 0 }},

                userEmail: "{{ Auth::user()->email }}",
            };

            console.log("SDK Key:", meetConfig.sdkKey);

            if (!meetConfig.sdkKey || meetConfig.sdkKey.length === 0) {
                console.error("❌ SDK Key is empty!");
                document.getElementById('loading').innerHTML =
                    '<div>❌ Configuration SDK manquante</div>' +
                    '<a href="{{ route('student.zoom.index') }}" class="back-button">← Retour</a>';
                return;
            }

            const signatureUrl = "{{ route('student.zoom.signature') }}" +
                `?meetingNumber=${meetConfig.meetingNumber}&role=${meetConfig.role}`;

            fetch(signatureUrl, {
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Accept': 'application/json',
                }
            })
            .then(res => {
                if (!res.ok) throw new Error(`HTTP ${res.status}`);
                return res.json();
            })
            .then(data => {
                console.log("✅ Signature received");

                if (!data.signature) {
                    throw new Error("Signature manquante");
                }

                document.getElementById('loading').style.display = 'none';
                document.getElementById('zmmtg-root').style.display = 'block';

                console.log("=== ZOOM INIT ===");

                ZoomMtg.init({
                    leaveUrl: meetConfig.leaveUrl,
                    patchJsMedia: true,


                    success: function (initSuccess) {
                        console.log("✅ Init success");

                        ZoomMtg.join({
                            signature: data.signature,
                            sdkKey: meetConfig.sdkKey,
                            meetingNumber: meetConfig.meetingNumber,
                            userName: meetConfig.userName,
                            userEmail: meetConfig.userEmail,
                            passWord: meetConfig.passWord,
                            tk: '',

                            success: function (joinSuccess) {
                                console.log("✅ Meeting joined successfully!");
                            },

                            error: function (joinError) {
                                console.error("❌ Join error:", joinError);
                                showError('Erreur de connexion: ' + (joinError.errorMessage || 'Erreur inconnue'));
                            }
                        });
                    },

                    error: function (initError) {
                        console.error("❌ Init error:", initError);
                        showError('Erreur d\'initialisation: ' + (initError.errorMessage || 'Erreur inconnue'));
                    }
                });
            })
            .catch(err => {
                console.error("❌ Fetch error:", err);
                showError('Erreur de chargement: ' + err.message);
            });

            function showError(msg) {
                document.getElementById('loading').style.display = 'flex';
                document.getElementById('loading').innerHTML =
                    `<div style="text-align: center;">
                        <div style="margin-bottom: 20px;">❌ ${msg}</div>
                        <a href="{{ route('student.zoom.index') }}" class="back-button">
                            ← Retour aux réunions
                        </a>
                    </div>`;
                document.getElementById('zmmtg-root').style.display = 'none';
            }
        });
    </script>
</body>
</html>
