<x-app-layout title="Classes en direct (Zoom)">
    <div class="max-w-7xl mx-auto p-6">

        <!-- Header -->
        <div class="mb-8">
            <h2 class="text-2xl font-semibold text-gray-900">
                My Courses
            </h2>
            <p class="text-sm text-gray-600 mt-1">
                View your scheduled live classes
            </p>
        </div>

        @if (session('success'))
            <div class="bg-green-50 border border-green-200 text-green-800 p-4 rounded-lg mb-6">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="bg-red-50 border border-red-200 text-red-800 p-4 rounded-lg mb-6">
                {{ session('error') }}
            </div>
        @endif

        @if($meetings->isEmpty())
            <!-- État vide -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-12 text-center">
                <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                </svg>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Aucune réunion planifiée</h3>
                <p class="text-sm text-gray-600">Vos prochaines classes en direct apparaîtront ici</p>
            </div>
        @else
            <!-- Calendrier/Liste des réunions -->
            <div class="grid gap-4">
                @php
                    $groupedMeetings = $meetings->groupBy(function($meeting) {
                        return \Carbon\Carbon::parse($meeting->start_time)->format('Y-m-d');
                    });
                @endphp

                @foreach($groupedMeetings as $date => $dayMeetings)
                    @php
                        $carbonDate = \Carbon\Carbon::parse($date);
                        $isToday = $carbonDate->isToday();
                        $isTomorrow = $carbonDate->isTomorrow();
                    @endphp

                    <!-- Jour -->
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                        <!-- En-tête du jour -->
                        <div class="bg-gray-50 px-6 py-3 border-b border-gray-200">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-3">
                                    <div class="text-center">
                                        <div class="text-2xl font-bold text-gray-900">
                                            {{ $carbonDate->format('d') }}
                                        </div>
                                        <div class="text-xs text-gray-600 uppercase">
                                            {{ $carbonDate->format('M') }}
                                        </div>
                                    </div>
                                    <div>
                                        <div class="font-medium text-gray-900">
                                            {{ $carbonDate->translatedFormat('l') }}
                                        </div>
                                        <div class="text-sm text-gray-600">
                                            @if($isToday)
                                                Today
                                            @elseif($isTomorrow)
Tomorrow
                                            @else
                                                {{ $carbonDate->translatedFormat('d F Y') }}
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <span class="text-sm text-gray-500">
                                    {{ count($dayMeetings) }} {{ count($dayMeetings) > 1 ? 'réunions' : 'réunion' }}
                                </span>
                            </div>
                        </div>

                        <!-- Liste des réunions du jour -->
                        <div class="divide-y divide-gray-200">
                            @foreach($dayMeetings as $meeting)
                                @php
                                    $startTime = \Carbon\Carbon::parse($meeting->start_time);
                                    $endTime = \Carbon\Carbon::parse($meeting->end_time);
                                    $isActive = now()->between($startTime, $endTime);
                                    $isPast = now()->greaterThan($endTime);
                                @endphp

                                <div class="p-6 hover:bg-gray-50 transition-colors">
                                    <div class="flex items-center justify-between">
                                        <!-- Informations de la réunion -->
                                        <div class="flex-1">
                                            <div class="flex items-center gap-3 mb-2">
                                                <!-- Indicateur de statut -->
                                                @if($isActive)
                                                    <span class="flex items-center gap-1.5 text-xs font-medium text-green-700 bg-green-50 px-2.5 py-1 rounded-full">
                                                        <span class="w-1.5 h-1.5 bg-green-600 rounded-full animate-pulse"></span>
                                                        En cours
                                                    </span>
                                                @elseif($isPast)
                                                    <span class="text-xs font-medium text-gray-500 bg-gray-100 px-2.5 py-1 rounded-full">
                                                        Terminée
                                                    </span>
                                                @else
                                                    <span class="text-xs font-medium text-blue-700 bg-blue-50 px-2.5 py-1 rounded-full">
                                                        Planifiée
                                                    </span>
                                                @endif

                                                <!-- Horaire -->
                                                <span class="text-sm font-medium text-gray-900">
                                                    {{ $startTime->format('H:i') }} - {{ $endTime->format('H:i') }}
                                                </span>
                                            </div>

                                            <!-- Titre -->
                                            <h3 class="text-base font-medium text-gray-900 mb-1">
                                                {{ $meeting->topic }}
                                            </h3>

                                            <!-- ID de la réunion -->
                                            <p class="text-sm text-gray-600">
                                                ID: {{ $meeting->zoom_meeting_id }}
                                            </p>
                                        </div>

                                        <!-- Bouton d'action -->
                                        <div>
                                            @if(!$isPast)
                                                <a href="{{ route('student.zoom.join', $meeting->zoom_meeting_id) }}"
                                                   target="_blank"
                                                   class="inline-flex items-center gap-2 px-4 py-2 bg-gray-900 hover:bg-gray-800 text-white text-sm font-medium rounded-lg transition-colors">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                                    </svg>
                                                    Rejoindre
                                                </a>
                                            @else
                                                <span class="inline-flex items-center gap-2 px-4 py-2 bg-gray-100 text-gray-500 text-sm font-medium rounded-lg cursor-not-allowed">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                    </svg>
                                                    Terminée
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>

    <style>
        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.5;
            }
        }
        .animate-pulse {
            animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }
    </style>
</x-app-layout>
