<x-app-layout title="Mon portefeuille" :points="$points" :section="'Wallet'" :page="'Offline Payment'">
<div class="max-w-6xl mx-auto font-inter"
     x-data="{
        tab: 'offline',
        showUploadModal: false,
        selectedProvider: '',
        amount: '',
        reference: '',
        receiptFile: null
     }"
     x-init="$watch('tab', value => {
        document.getElementById('breadcrumb-page').innerText =
            value === 'offline' ? 'Offline Payment' : 'Transaction History';
     })"
>



     <div class="flex justify-center  border-gray-200 mb-10">

     <button
        @click="tab = 'offline'"
        :class="tab === 'offline'
            ? 'px-6 py-2 text-[#32312D] font-medium text-[32px]'
            : 'px-6 py-2 text-[#C7C4C1] hover:text-gray-700 transition font-medium text-[32px]'"
    >
        Offline Payment
    </button>


    <button
        @click="tab = 'history'"
        :class="tab === 'history'
            ? 'px-6 py-2 text-[#32312D] font-medium text-[32px]'
            : 'px-6 py-2 text-[#C7C4C1] hover:text-gray-700 transition font-medium text-[32px]'"
        class="ml-6"
    >
        Transaction History
    </button>
</div>


        <div x-show="tab === 'offline'" x-transition>
            <div>
                <h1 class="text-2xl font-semibold text-gray-800 mb-2">Offline Payment Methods</h1>
                <p class="text-gray-500 mb-8">Pay at one of our trusted financial partners below and upload your proof of payment.</p>

                <div class="grid sm:grid-cols-2 gap-6">
    @foreach ($paymentMethods as $method)
        <div class="relative bg-white rounded-xl border border-gray-200 shadow-sm p-5 overflow-hidden"
             style="background-image: url('{{ asset($method->BACKGROUND) }}');
                    background-size: cover;
                    background-repeat: no-repeat;
                    background-position: center;">

            <div class="flex items-center gap-3 mb-3">
                <img src="{{ asset($method->logo) }}" class="w-16 h-10 object-contain" alt="{{ $method->name }}">
                <h3 class="font-semibold text-gray-800 text-lg">{{ $method->name }}</h3>
            </div>

            <p class="text-gray-700 text-sm mb-2">Account: <strong>AL Plateforme</strong></p>

            <div class="relative w-full">
                <input type="text" value="{{ $method->account_info }}"
                       class="w-full text-sm bg-gray-50 border rounded-md px-3 py-2 pr-14 focus:ring-2 focus:ring-indigo-200 focus:border-indigo-400 transition"
                       readonly>
                <button type="button"
                        class="absolute right-2 top-1/2 -translate-y-1/2 text-gray-800 text-sm font-medium hover:text-black transition"
                        @click="
                            navigator.clipboard.writeText('{{ $method->account_info }}');
                            Swal.fire({
                                icon: 'success',
                                title: 'Copied!',
                                text: 'Information copied to clipboard',
                                showConfirmButton: false,
                                timer: 1200
                            });
                        ">
                    Copy
                </button>
            </div>

            <button
                @click="selectedProvider = '{{ $method->name }}'; showUploadModal = true"
                class="mt-3 w-full text-sm bg-gray-50 border rounded py-2 hover:bg-gray-100 transition">
                <i class="ri-upload-2-line mr-1"></i> Upload Proof of Payment
            </button>
        </div>
    @endforeach
</div>
            </div>
        </div>

        <!-- ============================= -->
        <!-- 📋 HISTORY SECTION -->
        <!-- ============================= -->
        <div x-show="tab === 'history'" x-transition>
            <div class="max-w-7xl mx-auto">
                <h2 class=" text-2xl text-gray-700 font-semibold mb-6">Transactions</h2>

                <div class="bg-white rounded-xl   overflow-hidden">
                    <table class="min-w-full divide-y divide-gray-100 text-sm">
                        <thead class="bg-[#F6F7F5] text-[#1D1D1E] font-medium">
                            <tr>
                                <th class="px-6 py-3 text-left">ID</th>
                                <th class="px-6 py-3 text-left">Amount</th>
                                <th class="px-6 py-3 text-left">Payment method</th>
                                <th class="px-6 py-3 text-left">Date</th>
                                <th class="px-6 py-3 text-left">Status</th>
                            </tr>
                        </thead>

                       <tbody class="divide-y divide-gray-100 text-gray-600">
    @forelse ($transactions as $t)
        <tr>
            <td class="px-6 py-3">{{ $t->id }}</td>
            <td class="px-6 py-3">{{ number_format($t->amount, 2) }} TND</td>
            <td class="px-6 py-3">{{ $t->paymentMethod->name ?? '—' }}</td>
            <td class="px-6 py-3">{{ $t->created_at->format('Y-m-d') }}</td>
            <td class="px-6 py-3">
                @php
                    $colors = [
                        'pending' => 'bg-[#F7DCC9] text-[#6F492D] font-medium text-[13px] ',
                        'success' => 'bg-[#DBECDD] text-[#436653] font-medium text-[13px] ',
                        'failed'  => 'bg-[#FBDCD9] text-[#7C4944] font-medium text-[13px] '
                    ];
                    $dot = [
                        'pending' => 'bg-[#DF7630]',
                        'success' => 'bg-[#5F9873]',
                        'failed'  => 'bg-[#E26154]'
                    ];
                @endphp
                <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-full text-xs  {{ $colors[$t->status] ?? 'bg-gray-50 text-gray-600 ' }}">
                    <span class="w-1.5 h-1.5 rounded-full {{ $dot[$t->status] ?? 'bg-gray-400' }}"></span>
                    {{ ucfirst($t->status) }}
                </span>
            </td>
        </tr>
    @empty
        <tr>
            <td colspan="5" class="px-6 py-6 text-center text-gray-400">No transactions yet.</td>
        </tr>
    @endforelse
</tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- ============================= -->
        <!-- 📤 UPLOAD MODAL -->
        <!-- ============================= -->
        <div x-show="showUploadModal"
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             class="fixed inset-0 z-50 overflow-y-auto"
             style="display: none;">

            <!-- Backdrop -->
            <div class="fixed inset-0 bg-black bg-opacity-50 transition-opacity" @click="showUploadModal = false"></div>

            <!-- Modal -->
            <div class="flex items-center justify-center min-h-screen p-4">
                <div x-show="showUploadModal"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 transform scale-95"
                     x-transition:enter-end="opacity-100 transform scale-100"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100 transform scale-100"
                     x-transition:leave-end="opacity-0 transform scale-95"
                     class="relative bg-white rounded-2xl shadow-2xl w-full max-w-lg p-6"
                     @click.away="showUploadModal = false">

                    <!-- Header -->
                    <div class="flex items-center justify-between mb-6">
                        <div>
                            <h3 class="text-xl font-semibold text-gray-900">Upload Payment Proof</h3>
                            <p class="text-sm text-gray-500 mt-1">Provider: <span class="font-medium text-gray-700" x-text="selectedProvider"></span></p>
                        </div>
                        <button @click="showUploadModal = false"
                                class="text-gray-400 hover:text-gray-600 transition">
                            <i class="ri-close-line text-2xl"></i>
                        </button>
                    </div>

                    <!-- Form -->
<form action="{{ route('student.wallet.upload') }}" method="POST" enctype="multipart/form-data" class="space-y-5">
                        @csrf

                        <!-- Hidden Provider -->
                        <input type="hidden" name="provider" x-model="selectedProvider">

                        <!-- Amount -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Amount (TND) <span class="text-red-500">*</span>
                            </label>
                            <input type="number"
                                   name="amount"
                                   x-model="amount"
                                   required
                                   step="0.01"
                                   min="1"
                                   placeholder="Enter amount in TND"
                                   class="w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition">
                        </div>

                        <!-- Reference Number -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Transaction Reference <span class="text-red-500">*</span>
                            </label>
                            <input type="text"
                                   name="reference"
                                   x-model="reference"
                                   required
                                   placeholder="Enter transaction reference number"
                                   class="w-full px-4 py-2.5 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition">
                        </div>

                        <!-- File Upload -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Payment Receipt <span class="text-red-500">*</span>
                            </label>
                            <div class="relative border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-indigo-400 transition">
                                <input type="file"
                                       name="receipt"
                                       required
                                       accept="image/*,.pdf"
                                       @change="receiptFile = $event.target.files[0]"
                                       class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">

                                <div x-show="!receiptFile">
                                    <i class="ri-upload-cloud-2-line text-4xl text-gray-400 mb-2"></i>
                                    <p class="text-sm text-gray-600">Click to upload or drag and drop</p>
                                    <p class="text-xs text-gray-400 mt-1">PNG, JPG, PDF (Max 5MB)</p>
                                </div>

                                <div x-show="receiptFile" class="flex items-center justify-center gap-2">
                                    <i class="ri-file-line text-2xl text-indigo-600"></i>
                                    <span class="text-sm text-gray-700" x-text="receiptFile ? receiptFile.name : ''"></span>
                                </div>
                            </div>
                        </div>

                        <!-- Info Note -->
                        <div class="flex items-start gap-2 bg-blue-50 border border-blue-100 rounded-lg p-3">
                            <i class="ri-information-line text-blue-600 text-lg mt-0.5"></i>
                            <p class="text-xs text-blue-700">
                                Your payment will be reviewed within 24-48 hours. You will receive a notification once verified.
                            </p>
                        </div>

                        <!-- Buttons -->
                        <div class="flex gap-3 pt-2">
                            <button type="button"
                                    @click="showUploadModal = false"
                                    class="flex-1 px-4 py-2.5 border border-gray-300 text-gray-700 font-medium rounded-lg hover:bg-gray-50 transition">
                                Cancel
                            </button>
                            <button type="submit"
                                    class="flex-1 px-4 py-2.5 bg-indigo-600 text-white font-medium rounded-lg hover:bg-indigo-700 transition">
                                Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>

    @if (session('success'))
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'success',
                title: 'Succès !',
                text: '{{ session('success') }}',
                showConfirmButton: false,
                timer: 2000
            });
        });
    </script>
@endif

@if (session('error'))
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'error',
                title: 'Erreur',
                text: '{{ session('error') }}',
                confirmButtonColor: '#d33',
            });
        });
    </script>
@endif
</x-app-layout>
