<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $project->name }} - Éditeur</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css" rel="stylesheet">

    <!-- Monaco Editor -->
    <link rel="stylesheet" data-name="vs/editor/editor.main" href="https://cdnjs.cloudflare.com/ajax/libs/monaco-editor/0.44.0/min/vs/editor/editor.main.min.css">
</head>
<body class="bg-gray-900">
    <!-- Header -->
    <div class="bg-gray-800 border-b border-gray-700 px-4 py-3 flex items-center justify-between">
        <div class="flex items-center gap-4">
            <a href="{{ route('student.projects.index') }}"
               class="text-gray-400 hover:text-white transition">
                <i class="ri-arrow-left-line text-xl"></i>
            </a>
            <div>
                <h1 class="text-white font-semibold">{{ $project->name }}</h1>
                <p class="text-xs text-gray-400">{{ $project->main_file }}</p>
            </div>
        </div>
        <div class="flex items-center gap-3">
            <button id="saveBtn"
                    class="flex items-center gap-2 px-4 py-2 bg-green-600 hover:bg-green-700 text-white text-sm font-medium rounded-lg transition">
                <i class="ri-save-line"></i>
                To safeguard
            </button>
        </div>
    </div>

    <!-- Editor -->
    <div id="editor" style="height: calc(100vh - 61px);"></div>

    <!-- Monaco Editor -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/monaco-editor/0.44.0/min/vs/loader.min.js"></script>
    <script>
        require.config({ paths: { vs: 'https://cdnjs.cloudflare.com/ajax/libs/monaco-editor/0.44.0/min/vs' } });

        require(['vs/editor/editor.main'], function() {
            const languageMap = {
                'jsx': 'javascript',
                'java': 'java',
                'py': 'python',
                'html': 'html',
                'js': 'javascript',
                'txt': 'plaintext'
            };

            const extension = '{{ $project->main_file }}'.split('.').pop();
            const language = languageMap[extension] || 'plaintext';

            const editor = monaco.editor.create(document.getElementById('editor'), {
                value: `{!! addslashes($content) !!}`,
                language: language,
                theme: 'vs-dark',
                automaticLayout: true,
                fontSize: 14,
                minimap: { enabled: true },
                scrollBeyondLastLine: false,
            });

            // Sauvegarder
            document.getElementById('saveBtn').addEventListener('click', async () => {
                const content = editor.getValue();

                try {
                    const response = await fetch('{{ route('student.projects.updateFile', $project->id) }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                        },
                        body: JSON.stringify({ content: content })
                    });

                    if (response.ok) {
                        alert('✅ Fichier sauvegardé !');
                    }
                } catch (error) {
                    alert('❌ Erreur lors de la sauvegarde');
                }
            });

            // Ctrl+S pour sauvegarder
            editor.addCommand(monaco.KeyMod.CtrlCmd | monaco.KeyCode.KeyS, () => {
                document.getElementById('saveBtn').click();
            });
        });
    </script>
</body>
</html>
