<x-app-layout title="Nouveau Projet">
    <div class="max-w-2xl mx-auto p-6">
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-8">
            <h2 class="text-2xl font-semibold text-gray-900 mb-6">
               Create a new project
            </h2>

            <form method="POST" action="{{ route('student.projects.store') }}" class="space-y-6">
                @csrf

                <!-- Nom du projet -->
                <div>
                    <label class="block text-sm font-medium text-gray-900 mb-2">
                       Project name
                    </label>
                    <input type="text"
                           name="name"
                           required
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-gray-900 focus:border-transparent"
                           placeholder="Mon super projet">
                    @error('name')
                        <p class="text-red-600 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Description -->
                <div>
                    <label class="block text-sm font-medium text-gray-900 mb-2">
                       Description
                    </label>
                    <textarea name="description"
                              rows="4"
                              class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-gray-900 focus:border-transparent"
                              placeholder="Décrivez votre projet..."></textarea>
                </div>

                <!-- Type de projet -->
                <div>
                    <label class="block text-sm font-medium text-gray-900 mb-3">
                        Project type
                    </label>
                    <div class="grid grid-cols-2 gap-3">
                        @foreach([
                            'react' => ['name' => 'React.js', 'icon' => 'ri-reactjs-line', 'color' => 'blue'],
                            'java' => ['name' => 'Java', 'icon' => 'ri-java-line', 'color' => 'red'],
                            'python' => ['name' => 'Python', 'icon' => 'ri-terminal-box-line', 'color' => 'yellow'],
                            'html' => ['name' => 'HTML/CSS/JS', 'icon' => 'ri-html5-line', 'color' => 'orange'],
                            'nodejs' => ['name' => 'Node.js', 'icon' => 'ri-nodejs-line', 'color' => 'green'],
                            'other' => ['name' => 'Autre', 'icon' => 'ri-file-code-line', 'color' => 'gray'],
                        ] as $type => $info)
                            <label class="relative cursor-pointer">
                                <input type="radio"
                                       name="type"
                                       value="{{ $type }}"
                                       class="peer hidden"
                                       {{ $loop->first ? 'checked' : '' }}>
                                <div class="p-4 border-2 border-gray-200 rounded-lg hover:border-gray-300 peer-checked:border-gray-900 peer-checked:bg-gray-50 transition">
                                    <i class="{{ $info['icon'] }} text-2xl text-{{ $info['color'] }}-500 mb-2 block"></i>
                                    <span class="text-sm font-medium text-gray-900">{{ $info['name'] }}</span>
                                </div>
                            </label>
                        @endforeach
                    </div>
                </div>

                <!-- Boutons -->
                <div class="flex gap-3 pt-4">
                    <a href="{{ route('student.projects.index') }}"
                       class="flex-1 px-4 py-2 border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition text-center">
                       Cancel
                    </a>
                    <button type="submit"
                            class="flex-1 px-4 py-2 bg-[#2282E2] hover:bg-gray-800 text-white text-sm font-medium rounded-lg transition">
                        Create the project
                    </button>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>
