<x-app-layout :title="$title" :section="$section" :page="$page" :points="$points">
    <!-- Prism.js pour la coloration syntaxique -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/themes/prism-tomorrow.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/prism.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-javascript.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-python.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-php.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-java.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-css.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-sql.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/marked/9.1.6/marked.min.js"></script>

    <style>

        #chat-box::-webkit-scrollbar {
    width: 0px;
    background: transparent;
}
#chat-box {
    scrollbar-width: none; /* Firefox */
    -ms-overflow-style: none; /* IE/Edge */
}
        .code-block-container {
            position: relative;
            margin: 0.5rem 0;
        }
        .copy-button {
            position: absolute;
            top: 8px;
            right: 8px;
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid #ddd;
            padding: 4px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            transition: all 0.2s;
            z-index: 10;
        }
        .copy-button:hover {
            background: #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.15);
        }
        .copy-button.copied {
            background: #10b981;
            color: white;
            border-color: #10b981;
        }
        pre[class*="language-"] {
            margin: 0;
            border-radius: 8px;
            padding: 1rem 1rem 1rem 1rem !important;
        }
        code[class*="language-"] {
            font-size: 13px;
            line-height: 1.6;
        }
        .message-content p {
            margin: 0.5rem 0;
        }
        .message-content p:first-child {
            margin-top: 0;
        }
        .message-content p:last-child {
            margin-bottom: 0;
        }
        .message-content ul, .message-content ol {
            margin: 0.5rem 0;
            padding-left: 1.5rem;
        }
        .message-content li {
            margin: 0.25rem 0;
        }
    </style>

    <div class="flex flex-col items-center justify-center min-h-[80vh] font-inter bg-white">

        <!-- 🟦 Message d'accueil -->
        <div id="welcome-message" class="text-center mb-6">
            <h1 class="text-4xl sm:text-4xl text-gray-800 font-semibold">
                Good to see you, {{ $user->name ?? 'Student' }}.
            </h1>
            <p class="text-sm text-gray-500 mt-2">I'm Nova, your coding assistant. Ask me anything about programming!</p>
        </div>

        <!-- 💬 Zone principale -->
        <div id="chat-container" class="w-full max-w-3xl flex flex-col transition-all duration-700 ease-in-out">

            <!-- Zone des messages (cachée au début) -->
            <div id="chat-box" class="flex-1 overflow-y-auto p-6 space-y-4 scroll-smooth hidden"></div>

            <!-- ✅ Barre d'entrée (centrée au début) -->
   <form id="nova-form" class="flex items-center bg-white px-4 py-4 transition-all duration-700 ease-in-out">
    <div class="relative flex flex-col w-full bg-gray-50  rounded-[30px] px-5 py-5 ">

        <!-- Ligne principale -->
        <div class="flex items-center gap-3">
            <input type="text" name="message" id="nova-input"
                class="flex-1 bg-transparent focus:outline-none text-sm text-gray-800"
                placeholder="Ask Nova about coding, debugging, or any programming concept..." autocomplete="off">

            <!-- ✈️ Bouton envoi -->
            <button type="submit" id="send-button"
                class="text-gray-600 hover:text-gray-800 transition">
                <i class="ri-send-plane-2-line text-xl"></i>
            </button>
        </div>

        <!-- Bouton + et input fichier -->
        <div class="flex justify-start mt-3 items-center gap-2">
    <!-- 🔹 Input caché -->
    <input type="file" id="file-upload" class="hidden" accept="image/*,application/pdf">

    <!-- 🔹 Bouton + -->
    <button type="button" id="file-button"
        class="flex items-center justify-center w-8 h-8 rounded-full bg-gray-100 hover:bg-gray-200 text-gray-600 transition">
        <i class="ri-add-line text-xl"></i>
    </button>

    <!-- 🔹 Conteneur pour l'aperçu de l'image -->
    <div id="file-preview-container" class="hidden flex items-center gap-2 bg-gray-100 rounded-lg p-2">
        <img id="file-preview-image" class="w-12 h-12 object-cover rounded" src="" alt="Preview">
        <span id="file-name" class="text-xs text-gray-600 truncate max-w-[150px]"></span>
        <button type="button" id="remove-file" class="text-red-500 hover:text-red-700">
            <i class="ri-close-line text-lg"></i>
        </button>
    </div>
</div>
    </div>
</form>


        </div>
    </div>


    <!-- 🧠 Script Chat amélioré -->
  <script>
// ========================================
// 🔹 DÉCLARATION DES VARIABLES GLOBALES
// ========================================
const form = document.getElementById('nova-form');
const input = document.getElementById('nova-input');
const chatBox = document.getElementById('chat-box');
const welcomeMessage = document.getElementById('welcome-message');
const chatContainer = document.getElementById('chat-container');
const sendButton = document.getElementById('send-button');

const fileButton = document.getElementById('file-button');
const fileInput = document.getElementById('file-upload');
const fileName = document.getElementById('file-name');
const filePreviewContainer = document.getElementById('file-preview-container');
const filePreviewImage = document.getElementById('file-preview-image');
const removeFileButton = document.getElementById('remove-file');

let isFirstMessage = true;
let currentConversationId = null;
let selectedFile = null;
let fileBase64 = null;

// ========================================
// 🔹 CONFIGURATION MARKED
// ========================================
if (typeof marked !== 'undefined') {
    marked.setOptions({
        breaks: true,
        gfm: true,
    });
}

// ========================================
// 🔹 GESTION DES FICHIERS
// ========================================
fileButton.addEventListener('click', () => {
    fileInput.click();
});

fileInput.addEventListener('change', (e) => {
    const file = e.target.files[0];
    if (file) {
        selectedFile = file;
        fileName.textContent = file.name;

        if (file.type.startsWith('image/')) {
            const reader = new FileReader();
            reader.onload = (event) => {
                fileBase64 = event.target.result;
                filePreviewImage.src = event.target.result;
                filePreviewContainer.classList.remove('hidden');
                filePreviewContainer.classList.add('flex');
            };
            reader.readAsDataURL(file);
        }
    }
});

removeFileButton.addEventListener('click', () => {
    selectedFile = null;
    fileBase64 = null;
    fileInput.value = '';
    fileName.textContent = '';
    filePreviewImage.src = '';
    filePreviewContainer.classList.add('hidden');
    filePreviewContainer.classList.remove('flex');
});

// ========================================
// 🔹 ÉVÉNEMENTS WINDOW
// ========================================
window.addEventListener('loadConversation', async (e) => {
    const conversationId = e.detail.conversationId;
    await loadConversation(conversationId);
});

window.addEventListener('conversationDeleted', (e) => {
    const conversationId = e.detail.conversationId;
    if (currentConversationId == conversationId) {
        resetChat();
    }
});

// ========================================
// 🔹 FONCTIONS UTILITAIRES
// ========================================
function resetChat() {
    currentConversationId = null;
    chatBox.innerHTML = '';
    chatBox.classList.add('hidden');
    welcomeMessage.classList.remove('hidden');
    welcomeMessage.style.display = '';
    isFirstMessage = true;

    // Réinitialiser le fichier aussi
    selectedFile = null;
    fileBase64 = null;
    fileInput.value = '';
    filePreviewContainer.classList.add('hidden');
    filePreviewContainer.classList.remove('flex');
}

async function loadConversation(conversationId) {
    try {
        const response = await fetch(`/student/nova/conversation/${conversationId}`, {
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            }
        });

        const data = await response.json();

        if (data.success) {
            currentConversationId = conversationId;
            chatBox.innerHTML = '';
            chatBox.classList.remove('hidden');
            welcomeMessage.style.display = 'none';
            isFirstMessage = false;

            if (!chatContainer.classList.contains('h-[90vh]')) {
                chatContainer.classList.add('h-[90vh]', 'bg-white', 'rounded-2xl',  'overflow-hidden');
                form.classList.add('sticky', 'bottom-0', 'border-t', 'border-gray-100');
                if (isFirstMessage) {
    welcomeMessage.style.opacity = '0';
    setTimeout(() => {
        welcomeMessage.style.display = 'none';
    }, 400);

    chatContainer.classList.add('h-[90vh]', 'bg-white', 'rounded-2xl',  'overflow-hidden');
    chatBox.classList.remove('hidden');
    form.classList.add('sticky', 'bottom-0', 'border-t', 'border-gray-100');

    // ⭐⭐ AJOUTER CETTE LIGNE ⭐⭐
    form.style.marginBottom = "20px";

    isFirstMessage = false;
}
            }

            data.messages.forEach(msg => {
                const isUser = msg.role === 'user';
                const msgDiv = document.createElement('div');
                msgDiv.className = `flex ${isUser ? 'justify-end' : 'justify-start'}`;

                if (isUser) {
                    msgDiv.innerHTML = `
                        <div class="max-w-[80%] bg-gray-50 text-black px-4 py-3 rounded-2xl text-sm">
                            ${escapeHtml(msg.content)}
                        </div>`;
                } else {
                    msgDiv.innerHTML = `
                        <div class="max-w-[80%] text-gray-800 px-4 py-3 rounded-2xl text-sm shadow-sm message-content">
                            ${formatMessage(msg.content)}
                        </div>`;
                }

                chatBox.appendChild(msgDiv);
            });

            applySyntaxHighlighting();
            chatBox.scrollTop = chatBox.scrollHeight;
        }
    } catch (error) {
        console.error('Error loading conversation:', error);
    }
}

function detectLanguage(code) {
    const langPatterns = {
        javascript: /\b(const|let|var|function|=>|console\.log)\b/,
        python: /\b(def|import|from|print|class|self)\b/,
        php: /<\?php|\$[a-zA-Z_]/,
        java: /\b(public|private|class|void|static)\b.*\{/,
        css: /[\w-]+\s*:\s*[^;]+;/,
        sql: /\b(SELECT|FROM|WHERE|INSERT|UPDATE|DELETE)\b/i,
    };

    for (const [lang, pattern] of Object.entries(langPatterns)) {
        if (pattern.test(code)) {
            return lang;
        }
    }
    return 'javascript';
}

function formatMessage(text) {
    let formatted = text.replace(/```(\w+)?\n([\s\S]*?)```/g, (match, lang, code) => {
        const detectedLang = lang || detectLanguage(code);
        const codeId = 'code-' + Math.random().toString(36).substr(2, 9);

        return `<div class="code-block-container">
            <button class="copy-button" onclick="copyCode('${codeId}')">
                <i class="ri-file-copy-line"></i> Copy
            </button>
            <pre class="language-${detectedLang}"><code id="${codeId}" class="language-${detectedLang}">${escapeHtml(code.trim())}</code></pre>
        </div>`;
    });

    formatted = formatted.replace(/`([^`]+)`/g, '<code class="bg-gray-100 px-2 py-1 rounded text-sm">$1</code>');

    if (typeof marked !== 'undefined') {
        formatted = marked.parse(formatted);
    } else {
        formatted = formatted.replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>');
        formatted = formatted.replace(/\*(.*?)\*/g, '<em>$1</em>');
        formatted = formatted.replace(/\n/g, '<br>');
    }

    return formatted;
}

function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

window.copyCode = function(codeId) {
    const codeElement = document.getElementById(codeId);
    const text = codeElement.textContent;

    navigator.clipboard.writeText(text).then(() => {
        const button = codeElement.closest('.code-block-container').querySelector('.copy-button');
        const originalContent = button.innerHTML;
        button.innerHTML = '<i class="ri-check-line"></i> Copied!';
        button.classList.add('copied');

        setTimeout(() => {
            button.innerHTML = originalContent;
            button.classList.remove('copied');
        }, 2000);
    }).catch(err => {
        console.error('Failed to copy:', err);
    });
}

function applySyntaxHighlighting() {
    if (typeof Prism !== 'undefined') {
        Prism.highlightAll();
    }
}

function addConversationToSidebar(convId, title) {
    const conversationsList = document.getElementById('conversations-list');
    if (!conversationsList) return;

    const emptyMessage = conversationsList.querySelector('.text-center');
    if (emptyMessage) {
        emptyMessage.remove();
    }

    conversationsList.querySelectorAll('.conversation-item').forEach(item => {
        item.classList.remove('bg-gray-50');
    });

    const newConvItem = document.createElement('div');
    newConvItem.className = 'conversation-item cursor-pointer p-2 rounded-lg hover:bg-gray-50 transition group bg-gray-50';
    newConvItem.dataset.id = convId;
    newConvItem.innerHTML = `
        <div class="flex items-start justify-between gap-2">
            <div class="flex-1 min-w-0">
                <p class="text-sm text-gray-800 truncate sidebar-text">
                    ${title || 'New Conversation'}
                </p>
                <p class="text-xs text-gray-500 sidebar-text">Just now</p>
            </div>
            <button class="delete-conv opacity-0 group-hover:opacity-100 text-gray-400 hover:text-red-500 transition sidebar-text"
                    data-id="${convId}"
                    onclick="event.stopPropagation()">
                <i class="ri-delete-bin-line text-sm"></i>
            </button>
        </div>`;

    conversationsList.insertBefore(newConvItem, conversationsList.firstChild);
}

// ========================================
// 🔹 SOUMISSION DU FORMULAIRE (UN SEUL)
// ========================================
form.addEventListener('submit', async (e) => {
    e.preventDefault();
    const message = input.value.trim();

    // Permettre l'envoi si message OU fichier existe
    if (!message && !selectedFile) return;

    sendButton.disabled = true;

    if (isFirstMessage) {
        welcomeMessage.style.opacity = '0';
        setTimeout(() => {
            welcomeMessage.style.display = 'none';
        }, 400);
        chatContainer.classList.add('h-[90vh]', 'bg-white', 'rounded-2xl',  'overflow-hidden');
        chatBox.classList.remove('hidden');
        form.classList.add('sticky', 'bottom-0', 'border-t', 'border-gray-100');
        isFirstMessage = false;
    }

    // Message utilisateur avec image
    const userDiv = document.createElement('div');
    userDiv.className = 'flex justify-end';

    let userContent = '';
    if (selectedFile && fileBase64) {
        userContent += `<img src="${fileBase64}" class="max-w-[200px] rounded-lg mb-2" alt="Uploaded image">`;
    }
    if (message) {
        userContent += `<p>${escapeHtml(message)}</p>`;
    }

    userDiv.innerHTML = `
        <div class="max-w-[80%] bg-gray-50 text-black px-4 py-3 rounded-2xl text-sm">
            ${userContent}
        </div>`;
    chatBox.appendChild(userDiv);
    chatBox.scrollTop = chatBox.scrollHeight;

    // Loader
    const typingDiv = document.createElement('div');
    typingDiv.className = 'flex justify-start';
    typingDiv.id = 'typing-indicator';
    typingDiv.innerHTML = `
        <div class="max-w-[80%] text-gray-600 px-4 py-3 rounded-2xl text-sm italic flex items-center gap-2">
            <div class="flex gap-1">
                <span class="w-2 h-2 bg-gray-400 rounded-full animate-bounce" style="animation-delay: 0s"></span>
                <span class="w-2 h-2 bg-gray-400 rounded-full animate-bounce" style="animation-delay: 0.2s"></span>
                <span class="w-2 h-2 bg-gray-400 rounded-full animate-bounce" style="animation-delay: 0.4s"></span>
            </div>
            <span>Nova is typing...</span>
        </div>`;
    chatBox.appendChild(typingDiv);
    chatBox.scrollTop = chatBox.scrollHeight;

    input.value = '';

    // Préparer les données
    const requestData = {
        message: message || "Analyze this image",
        conversation_id: currentConversationId
    };

    if (selectedFile && fileBase64) {
        requestData.image = fileBase64;
        requestData.image_name = selectedFile.name;
    }

    let typingTimeout = null;
    let isTyping = false;
    let hasError = false;

    try {
        const response = await fetch("{{ route('student.nova.message') }}", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": "{{ csrf_token() }}"
            },
            body: JSON.stringify(requestData)
        });

        const data = await response.json();

        if (!response.ok || !data.success) {
            hasError = true;
            throw new Error(data.reply || 'Server error');
        }

        if (typingDiv && typingDiv.parentNode) {
            typingDiv.remove();
        }

        if (!currentConversationId) {
            currentConversationId = data.conversation_id;
            addConversationToSidebar(data.conversation_id, data.conversation_title);
        }

        // Réinitialiser le fichier après envoi
        selectedFile = null;
        fileBase64 = null;
        fileInput.value = '';
        fileName.textContent = '';
        filePreviewContainer.classList.add('hidden');
        filePreviewContainer.classList.remove('flex');

        const novaDiv = document.createElement('div');
        novaDiv.className = 'flex justify-start';
        const messageBubble = document.createElement('div');
        messageBubble.className = 'max-w-[80%] bg-gray-50 text-gray-800 px-4 py-3 rounded-2xl text-sm shadow-sm message-content';
        novaDiv.appendChild(messageBubble);
        chatBox.appendChild(novaDiv);
        chatBox.scrollTop = chatBox.scrollHeight;

        const words = data.reply.split(' ');
        let index = 0;
        isTyping = true;

        function typeNextWord() {
            if (!isTyping) return;
            if (index < words.length) {
                messageBubble.innerHTML = formatMessage(words.slice(0, index + 1).join(' ')) + ' ▌';
                chatBox.scrollTop = chatBox.scrollHeight;
                index++;
                typingTimeout = setTimeout(typeNextWord, 40);
            } else {
                messageBubble.innerHTML = formatMessage(data.reply);
                applySyntaxHighlighting();
                isTyping = false;
            }
        }

        typeNextWord();

    } catch (error) {
        if (typingTimeout) {
            clearTimeout(typingTimeout);
        }
        isTyping = false;

        const existingTyping = document.getElementById('typing-indicator');
        if (existingTyping && existingTyping.parentNode) {
            existingTyping.remove();
        }

        if (hasError) {
            const errDiv = document.createElement('div');
            errDiv.className = 'flex justify-start';
            errDiv.innerHTML = `
                <div class="max-w-[80%] bg-red-50 text-red-700 px-4 py-3 rounded-2xl text-sm shadow-sm">
                    <i class="ri-error-warning-line"></i> ${error.message || 'Network error or server issue. Please try again.'}
                </div>`;
            chatBox.appendChild(errDiv);
            chatBox.scrollTop = chatBox.scrollHeight;
        }

        console.error('Error:', error);
    } finally {
        sendButton.disabled = false;
        input.focus();
    }
});

// Focus automatique
input.focus();
</script>

</x-app-layout>
