<x-app-layout
    :title="($user->groups->first()->name ?? 'Bechir belhadj')"
    :section="' Live sessions'"
    :page="null">
<div class="max-w-[1600px] mx-auto px-4 lg:px-6 font-inter"
x-data="{
    activeView: 'table',
    showSessionModal: false,
    showTaskModal: false,
    selectedSlot: { day: '', hour: '', dayName: '' },

    editSessionModal: false,
    selectedSession: { id:'', title:'', start:'', end:'', notes:'', subtasks: [] },

    // 🆕 Ajouter ces 2 lignes
    viewClassModal: false,
selectedClass: { id:'', title:'', start:'', end:'', description:'', subtasks: [], attachments: [], teacher_name: '' },
    autoSaveSession() {
        fetch('/student/live-sessions/' + this.selectedSession.id + '/update', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify(this.selectedSession)
        });
    },

    refreshPage() {
        window.location.reload();
    }
}">

    <!-- 🏷️ HEADER -->
   <div class="mb-6 lg:mb-8">
    <h1 class="text-[32px] lg:text-[36px] font-bold text-gray-900 tracking-tight">
        Live sessions
    </h1>
</div>

    <!-- 🧩 MAIN LAYOUT -->
    <div class="grid grid-cols-1 xl:grid-cols-[1fr_280px] gap-6">

        <div class="bg-white rounded-xl  overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead>
                        <tr class="border-b border-gray-200">
                           <th class="w-28 sticky left-0 bg-white z-10 text-left px-4 py-3">
    <div class="flex items-center gap-2 font-light text-[14px] text-[#817F7B]" style="font-family: 'Inter', sans-serif;">
           <img src="{{ asset('assets/icons/dashboard right section/clock-refresh (1) 2.svg') }}" class="w-6 h-6 min-w-[24px]" alt="icon">
        <span>Time</span>
    </div>
</th>
                            @foreach(['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'] as $day)
                               <th class="text-center px-3 py-2 min-w-[140px] font-light text-[14px]" style="color: #817F7B; font-family: 'Inter', sans-serif;">
    {{ $day }}
</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $hours = ['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00'];
                            $dayNames = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
                        @endphp
                        @foreach($hours as $hour)
                        <tr class="border-b border-gray-100">
                            <td class="sticky left-0 bg-white z-10 px-4 py-4 align-top border-r border-gray-200">
                                <div class="text-sm font-medium text-black">
                                    {{ $hour }}-<br>{{ sprintf('%02d:00', intval(explode(':',$hour)[0]) + 1) }}
                                </div>
                            </td>

                            @foreach(['monday','tuesday','wednesday','thursday','friday','saturday','sunday'] as $dayIndex => $day)
<td class="relative px-1 py-1 pb-1 align-top border-l border-gray-100 bg-white group"
    style="height: 100px;"
    x-on:dragover.prevent="$el.classList.add('bg-blue-50')"
    x-on:dragleave="$el.classList.remove('bg-blue-50')"
    x-on:drop.prevent="
        $el.classList.remove('bg-blue-50');
        let sessionId = $event.dataTransfer.getData('sessionId');
        let sessionType = $event.dataTransfer.getData('sessionType');
        if (sessionId && sessionType !== 'class') {
            fetch('/student/live-sessions/' + sessionId + '/move', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    day_of_week: '{{ $day }}',
                    start_time: '{{ $hour }}'
                })
            }).then(() => window.location.reload());
        }
    ">                                @php
                                    // 🎯 FIX: Afficher les sessions qui COMMENCENT dans cette tranche horaire
                                    $currentHour = intval(explode(':', $hour)[0]);
                                    $nextHour = $currentHour + 1;

                                   $daySessions = $sessions->where('calendar_day', $day)
    ->filter(function($s) use ($currentHour, $nextHour) {
        $sessionStart = $s->calendar_start;
        $sessionHour = intval(explode(':', $sessionStart)[0]);
        $sessionMinute = intval(explode(':', $sessionStart)[1]);
        $sessionTimeInMinutes = ($sessionHour * 60) + $sessionMinute;

        $slotStartMinutes = $currentHour * 60;
        $slotEndMinutes = $nextHour * 60;

        return $sessionTimeInMinutes >= $slotStartMinutes &&
               $sessionTimeInMinutes < $slotEndMinutes;
    });
                                    $hasSession = $daySessions->isNotEmpty();
                                @endphp

                                @if(!$hasSession)
<button
    @click="
        showSessionModal = true;
        let h = parseInt('{{ $hour }}'.split(':')[0]);
        selectedSlot = {
            day: '{{ $day }}',
            hour: '{{ $hour }}',
            end: (h+1).toString().padStart(2,'0') + ':00',
            dayName: '{{ $dayNames[$dayIndex] }}'
        };
    "
                                            class="absolute inset-0 w-full h-full opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center bg-gray-50/50 hover:bg-gray-100/50 z-0">
                                        <i class="ri-add-line text-2xl text-gray-400"></i>
                                    </button>
                                @endif

                                @forelse($daySessions as $session)
                                    @php
                                        $startTimeStr = is_string($session->calendar_start) ? substr($session->calendar_start, 0, 5) : $session->calendar_start;
                                        $endTimeStr = is_string($session->calendar_end) ? substr($session->calendar_end, 0, 5) : $session->calendar_end;
                                        $startTime = \Carbon\Carbon::createFromFormat('H:i', $startTimeStr);
                                        $endTime = \Carbon\Carbon::createFromFormat('H:i', $endTimeStr);
                                        $durationHours = $startTime->diffInMinutes($endTime) / 60;
                                        $heightPx = (100 * $durationHours) + (max(0, $durationHours - 1) * 1) - 10;
                                        $colors = [
                                            'class' => ['bg' => '#DBECDD', 'dot' => '#5F9873'],
                                            'project' => ['bg' => '#ffe4cc', 'dot' => '#ea580c'],
                                            'break' => ['bg' => '#dbeafe', 'dot' => '#0284c7'],
                                            'meeting' => ['bg' => '#f3e8ff', 'dot' => '#9333ea'],
                                            'lunch' => ['bg' => '#ffe4e6', 'dot' => '#e11d48'],
                                        ];
                                        $color = $colors[$session->calendar_type] ?? $colors['class'];
                                    @endphp

                                    <div class="absolute left-1 right-1 rounded-lg p-3 hover:shadow-lg transition-all z-10 group"
     style="background-color: {{ $color['bg'] }}; height: {{ $heightPx }}px;"
@click="
    @if($session->calendar_type === 'class')
        viewClassModal = true;
        selectedClass = {
            id: '{{ $session->id }}',
            title: '{{ addslashes($session->calendar_title) }}',
            start: '{{ $startTimeStr }}',
            end: '{{ $endTimeStr }}',
            description: `{{ addslashes($session->description ?? '') }}`,
            subtasks: {{ json_encode($session->subtasks ?? []) }},
            attachments: {{ json_encode($session->attachments ?? []) }},
            teacher_name: '{{ $session->user->name ?? 'Teacher' }}'
        };
    @else
        editSessionModal = true;
        selectedSession = {
            id: '{{ $session->id }}',
            title: '{{ $session->calendar_title }}',
            start: '{{ $startTimeStr }}',
            end: '{{ $endTimeStr }}',
            notes: `{{ $session->notes ?? '' }}`,
            subtasks: @js($session->subtasks ?? [])
        };
    @endif
"
     @if($session->calendar_type !== 'class')
         draggable="true"
         x-on:dragstart="$event.dataTransfer.setData('sessionId', '{{ $session->id }}'); $event.dataTransfer.setData('sessionType', '{{ $session->calendar_type }}'); $el.classList.add('opacity-50')"
         x-on:dragend="$el.classList.remove('opacity-50')"
         class="cursor-move"
     @else
         class="cursor-default"
     @endif
     >
                                        <div class="flex flex-col h-full">
                                            <div class="flex items-start gap-2 mb-2">
                                                <div class="w-2 h-2 rounded-full mt-1 flex-shrink-0" style="background-color: {{ $color['dot'] }};"></div>
                                                <div class="flex-1 min-w-0">
                                                    <h4 class="text-sm font-medium text-gray-500 line-clamp-2">{{ $session->calendar_title
 }}</h4>
                                                    <p class="text-xs text-gray-600 mt-0.5">{{ $startTimeStr }} - {{ $endTimeStr }}</p>
                                                </div>
                                            </div>
                                            <div class="flex-1"></div>
                                            <div class="flex items-center justify-between gap-2 mt-auto">

    {{-- JOIN / OPEN BUTTON --}}
    @if($session->calendar_type === 'class' && !empty($session->link))
        <a href="{{ route('student.zoom.join', $session->zoom_meeting_id) }}"
           target="_blank"
           class="inline-flex items-center gap-1.5 text-xs font-medium px-3 py-1.5 transition-all hover:bg-[#DBECDD]/20 border border-[#5F9873] text-[#436653] rounded">
            <i class="ri-links-line text-sm"></i>
            <span>Join</span>
        </a>
    @elseif($session->calendar_type !== 'class' && !empty($session->link))
        <button onclick="window.open('{{ $session->link }}', '_blank')"
                class="inline-flex items-center gap-1.5 text-xs font-medium px-3 py-1.5 rounded-md text-white transition-all hover:opacity-90"
                style="background-color: {{ $color['dot'] }};">
            <i class="ri-external-link-line"></i>
            <span>Open</span>
        </button>
    @endif

    {{-- DELETE BUTTON — ONLY FOR NON-CLASS --}}
    @if($session->calendar_type !== 'class')
        <button
            @click="
                if (confirm('Delete this session?')) {
                    fetch('/student/live-sessions/{{ $session->id }}/delete', {
                        method: 'DELETE',
                        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
                    })
                    .then(() => window.location.reload());
                }
            "
            class="opacity-0 group-hover:opacity-100 transition text-black-500 hover:text-red-700 ml-auto"

        >
            <i class="ri-delete-bin-line text-lg"></i>
        </button>
    @endif

</div>

                                            </div>
                                        </div>
                                    </div>
                                @empty
                                @endforelse
                            </td>
                            @endforeach
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <!-- TO-DO LIST -->
        <div class="w-full xl:w-auto">
    <div class="bg-white rounded-xl overflow-hidden xl:sticky xl:top-10">

        <!-- HEADER (sans +) -->
        <div class="px-5 py-2 pb-[15px] border-b border-gray-200">
            <h3 class="text-base font-bold text-gray-900">— To Do —</h3>
        </div>

       <div class="p-5 space-y-4 max-h-[800px] overflow-y-auto"
     x-data="{
        tasks: {{ json_encode($tasks) }},

        addTask() {
            let newTask = { id: null, title: '', completed: false, editing: true };
            this.tasks.unshift(newTask);

            fetch('{{ route('student.live-sessions.task.store') }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ title: '' })
            })
            .then(res => res.json())
            .then(data => {
                newTask.id = data.id;
            });
        },

        updateTask(task) {
            if (!task.id) return;
            fetch('/student/live-sessions/task/' + task.id + '/update', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ title: task.title })
            });
        },

        toggle(task) {
            fetch('/student/live-sessions/task/' + task.id + '/toggle', {
                method: 'POST',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
            });
            task.completed = !task.completed;
        },

        deleteTask(task, index) {
            fetch('/student/live-sessions/task/' + task.id, {

                method: 'DELETE',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
            });
            this.tasks.splice(index, 1);
        }
     }">
            <!-- TASKS -->
           <template x-for="(task, index) in tasks" :key="task.id ?? index">
    <div class="flex items-start justify-between group">

        <div class="flex items-start gap-3 flex-1">

            <!-- Checkbox -->
            <input type="checkbox"
                class="w-4 h-4 mt-1.5 rounded text-blue-600 cursor-pointer"
                :checked="task.completed"
                @change="toggle(task)">

            <!-- Titre -->
           <div class="flex-1 mb-1">

    <!-- Texte affiché -->
    <span x-show="!task.editing"
          @click="task.editing = true; $nextTick(() => $el.nextElementSibling.focus())"
          class="text-sm cursor-text"
          :class="task.completed ? 'line-through text-gray-400' : 'text-gray-700'">
        <span :class="!task.title ? 'text-gray-400' : ''"
              x-text="task.title || 'To Do...'"></span>
    </span>

    <!-- Input édition -->
    <input x-show="task.editing"
           x-model="task.title"
           @input="updateTask(task)"
           @blur="task.editing = false"
           @keydown.enter="task.editing = false"
           placeholder="To Do..."
           class="text-sm px-2 rounded w-full bg-transparent outline-none border-none focus:ring-0 placeholder-gray-400">
</div>
        </div>

        <!-- Delete -->
        <button
            @click="deleteTask(task, index)"
            class="opacity-0 group-hover:opacity-100 text-gray-400 hover:text-red-600 transition">
            <i class="ri-delete-bin-line text-lg"></i>
        </button>

    </div>
</template>

            <!-- ADD TASK BUTTON -->
           <button
    @click="addTask()"
    class="w-full flex items-center gap-2 text-sm text-gray-600 hover:text-gray-900 hover:bg-gray-100 px-3 py-2 rounded transition">
    <i class="ri-add-line text-lg"></i>
    Add task
</button>
        </div>
    </div>
</div>

    <!-- MODALS (inchangés) -->
    <div x-show="showSessionModal" x-cloak @click.self="showSessionModal = false" class="fixed inset-0 bg-black/50 z-[100001] flex items-center justify-center p-4">
        <div class="bg-white rounded-xl shadow-2xl max-w-lg w-full" @click.stop>
            <div class="px-6 py-4 border-b border-gray-200 flex items-center justify-between">
                <h3 class="text-lg font-bold text-gray-900"></h3>
                <button @click="showSessionModal = false" class="text-gray-400 hover:text-gray-600"><i class="ri-close-line text-xl"></i></button>
            </div>
            <form method="POST" action="{{ route('student.live-sessions.store') }}" class="p-6 space-y-4">
                @csrf
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2"> Title</label>
                    <input type="text" name="title" required placeholder="Enter  title..." class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Type</label>
                    <select name="type" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="project">Project</option>
                        <option value="break">Break</option>
                        <option value="meeting">Meeting</option>
                        <option value="lunch">Lunch</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Day</label>
                    <input type="hidden" name="day_of_week" :value="selectedSlot.day">
                    <input type="text" :value="selectedSlot.dayName" readonly class="w-full px-4 py-2 border border-gray-300 rounded-lg bg-gray-50 text-gray-600">
                </div>
               <div x-data="{ open:false, value: '{{ old('start_time', $selectedSlot->hour ?? '') }}' }" class="relative">
    <label class="block text-sm font-medium text-gray-700 mb-2">Start Time</label>

    <button @click="open = !open"
            type="button"
            class="w-full px-4 py-2 border border-gray-300 rounded-lg text-left bg-white flex items-center justify-between">
        <span x-text="value || 'Select time'"></span>
        <i class="ri-arrow-down-s-line text-gray-500"></i>
    </button>

    <input type="hidden" name="start_time" x-model="value">

    <div x-show="open" @click.outside="open = false"
         class="absolute z-50 mt-2 w-full bg-white border border-gray-200 rounded-lg shadow-lg max-h-48 overflow-y-auto">

        @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00'] as $time)
            <div @click="value='{{ $time }}'; open=false"
                 class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                 :class="{ 'bg-blue-50 font-semibold' : value === '{{ $time }}' }">
                {{ $time }}
            </div>
        @endforeach
    </div>
</div>
                <div x-data="{ open:false, value: '{{ old('end_time', $selectedSlot->end ?? '') }}' }" class="relative">
    <label class="block text-sm font-medium text-gray-700 mb-2">End Time</label>

    <button @click="open = !open"
            type="button"
            class="w-full px-4 py-2 border border-gray-300 rounded-lg text-left bg-white flex items-center justify-between">
        <span x-text="value || 'Select time'"></span>
        <i class="ri-arrow-down-s-line text-gray-500"></i>
    </button>

    <input type="hidden" name="end_time" x-model="value">

    <div x-show="open" @click.outside="open = false"
         class="absolute z-50 mt-2 w-full bg-white border border-gray-200 rounded-lg shadow-lg max-h-48 overflow-y-auto">

        @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00','19:00'] as $time)
            <div @click="value='{{ $time }}'; open=false"
                 class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                 :class="{ 'bg-blue-50 font-semibold' : value === '{{ $time }}' }">
                {{ $time }}
            </div>
        @endforeach
    </div>
</div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Link (optional)</label>
                    <input type="url" name="link" placeholder="https://..." class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                    <select name="status" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        <option value="open">Open</option>
                        <option value="closed">Closed</option>
                    </select>
                </div>
                <input type="hidden" name="group_id" value="{{ $user->groups->first()->id ?? '' }}">
                <div class="flex gap-3 pt-4">
                    <button type="button" @click="showSessionModal = false" class="flex-1 px-4 py-2 border border-gray-300 rounded-lg text-gray-700 font-medium hover:bg-gray-50 transition-colors">Cancel</button>
                    <button type="submit" class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg font-medium hover:bg-blue-700 transition-colors">Create Session</button>
                </div>
            </form>
        </div>
    </div>

    <div x-show="showTaskModal" x-cloak @click.self="showTaskModal = false" class="fixed inset-0 bg-black/50 z-[100001] flex items-center justify-center p-4">
        <div class="bg-white rounded-xl shadow-2xl max-w-md w-full" @click.stop>
            <div class="px-6 py-4 border-b border-gray-200 flex items-center justify-between">
                <h3 class="text-lg font-bold text-gray-900">Create New Task</h3>
                <button @click="showTaskModal = false" class="text-gray-400 hover:text-gray-600"><i class="ri-close-line text-xl"></i></button>
            </div>
            <form method="POST" action="{{ route('student.live-sessions.task.store') }}" class="p-6 space-y-4">
                @csrf
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Task Title</label>
                    <input type="text" name="title" required placeholder="Enter task title..." class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div class="flex gap-3 pt-4">
                    <button type="button" @click="showTaskModal = false" class="flex-1 px-4 py-2 border border-gray-300 rounded-lg text-gray-700 font-medium hover:bg-gray-50 transition-colors">Cancel</button>
                    <button type="submit" class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg font-medium hover:bg-blue-700 transition-colors">Create Task</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- MODAL: EDIT SESSION -->
<!-- MODAL: EDIT LIVE SESSION (STYLE TASK MANAGER) -->
<div x-show="editSessionModal"
     x-cloak
@click.self="editSessionModal = false; refreshPage()"
     class="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-50 p-4">

    <div @click.stop
         class="bg-white rounded-2xl shadow-2xl w-full max-w-4xl max-h-[90vh] overflow-hidden"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 scale-95"
         x-transition:enter-end="opacity-100 scale-100">

        <!-- HEADER -->
        <div class="px-8 py-6 border-b border-gray-200 bg-gradient-to-r from-gray-50 to-white flex justify-between">

            <input type="text"
                   x-model="selectedSession.title"
                   @input="autoSaveSession()"
                   placeholder="Session title..."
                   class="text-2xl font-bold text-gray-900 w-full bg-transparent border-none focus:outline-none focus:ring-0 p-0">

            <button @click="editSessionModal = false"
                    class="text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg p-2 transition-all">
                <i class="ri-close-line text-2xl"></i>
            </button>
        </div>

        <!-- BODY : 2 columns -->
        <div class="flex h-[calc(90vh-120px)]">

            <!-- LEFT COLUMN -->
            <div class="flex-1 overflow-y-auto px-8 py-6 space-y-6">

                <!-- TIME -->
                <div class="grid grid-cols-2 gap-6">

    <!-- START -->
    <div x-data="{ open:false }" class="relative">
        <label class="text-sm text-gray-600 font-medium">Start Time</label>

        <button @click="open = !open"
                type="button"
                class="w-full px-4 py-2 mt-1 bg-gray-100 rounded-lg text-left text-sm flex justify-between items-center">
            <span x-text="selectedSession.start || 'Select time'"></span>
            <i class="ri-time-line text-gray-500"></i>
        </button>

        <div x-show="open" @click.outside="open = false"
             class="absolute z-50 left-0 right-0 mt-2 bg-white border border-gray-200 rounded-lg shadow-md max-h-48 overflow-y-auto">

            @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00'] as $time)
                <div @click="selectedSession.start='{{ $time }}'; open=false; autoSaveSession()"
                     class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                     :class="{ 'bg-blue-50 font-semibold' : selectedSession.start === '{{ $time }}' }">
                    {{ $time }}
                </div>
            @endforeach

        </div>
    </div>

    <!-- END -->
    <div x-data="{ open:false }" class="relative">
        <label class="text-sm text-gray-600 font-medium">End Time</label>

        <button @click="open = !open"
                type="button"
                class="w-full px-4 py-2 mt-1 bg-gray-100 rounded-lg text-left text-sm flex justify-between items-center">
            <span x-text="selectedSession.end || 'Select time'"></span>
            <i class="ri-time-line text-gray-500"></i>
        </button>

        <div x-show="open" @click.outside="open = false"
             class="absolute z-50 left-0 right-0 mt-2 bg-white border border-gray-200 rounded-lg shadow-md max-h-48 overflow-y-auto">

            @foreach(['08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00','19:00'] as $time)
                <div @click="selectedSession.end='{{ $time }}'; open=false; autoSaveSession()"
                     class="px-4 py-2 hover:bg-gray-100 cursor-pointer"
                     :class="{ 'bg-blue-50 font-semibold' : selectedSession.end === '{{ $time }}' }">
                    {{ $time }}
                </div>
            @endforeach

        </div>
    </div>

</div>

                <!-- DESCRIPTION -->
                <div>
                    <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
                        Description
                    </h3>

                    <textarea x-model="selectedSession.notes"
                              @input="autoSaveSession()"
                              rows="4"
                              class="w-full px-4 py-3 bg-gray-50 rounded-lg text-sm text-gray-700"></textarea>
                </div>

                <!-- SUBTASKS -->
                <div>
                    <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
                        Tasks
                    </h3>

                    <div class="space-y-2">

                        <template x-for="(item, index) in selectedSession.subtasks" :key="index">
                            <div class="flex items-center gap-2 group hover:bg-gray-50 p-2 rounded-lg transition-all">

                                <input type="checkbox"
                                       x-model="item.completed"
                                       @change="autoSaveSession()"
                                       class="w-5 h-5 rounded border-gray-300 cursor-pointer">

                                <input type="text"
                                       x-model="item.text"
                                       @input="autoSaveSession()"
                                       placeholder="Sub-task..."
                                       class="flex-1 bg-transparent border-none text-sm focus:outline-none"
                                       :class="item.completed ? 'line-through text-gray-500' : 'text-gray-700'">

                                <button @click="selectedSession.subtasks.splice(index,1); autoSaveSession();"
                                        class="opacity-0 group-hover:opacity-100 text-red-400 hover:text-red-600 transition-all">
                                    <i class="ri-delete-bin-line text-lg"></i>
                                </button>
                            </div>
                        </template>

                        <button @click="selectedSession.subtasks.push({text:'', completed:false}); autoSaveSession();"
                                class="flex items-center gap-2 text-sm text-gray-500 hover:text-indigo-600 hover:bg-indigo-50 px-3 py-2 rounded-lg transition-all">
                            <i class="ri-add-line text-lg"></i>
                            Add task
                        </button>
                    </div>
                </div>

            </div>



        </div>

    </div>

</div>

<div x-show="viewClassModal"
     x-cloak
     @click.self="viewClassModal = false"
     class="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-50 p-4">

    <div @click.stop
         class="bg-white rounded-2xl shadow-2xl w-full max-w-2xl max-h-[90vh] overflow-hidden"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 scale-95"
         x-transition:enter-end="opacity-100 scale-100">

        <!-- HEADER -->
        <div class="px-8 py-6 border-b border-gray-200 bg-gradient-to-r from-[#DBECDD] to-white flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="w-3 h-3 rounded-full bg-[#5F9873]"></div>
                <h2 class="text-2xl font-bold text-gray-900" x-text="selectedClass.title"></h2>
            </div>
            <button @click="viewClassModal = false"
                    class="text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg p-2 transition-all">
                <i class="ri-close-line text-2xl"></i>
            </button>
        </div>

        <!-- BODY -->
        <div class="px-8 py-6 space-y-6 overflow-y-auto max-h-[calc(90vh-120px)]">

            <!-- INFO -->
            <div class="flex flex-wrap gap-4">
                <div class="flex items-center gap-2 px-4 py-2 bg-gray-100 rounded-lg">
                    <i class="ri-time-line text-[#5F9873]"></i>
                    <span class="text-sm text-gray-700" x-text="selectedClass.start + ' - ' + selectedClass.end"></span>
                </div>
                <div class="flex items-center gap-2 px-4 py-2 bg-gray-100 rounded-lg">
                    <i class="ri-user-line text-[#5F9873]"></i>
                    <span class="text-sm text-gray-700" x-text="selectedClass.teacher_name"></span>
                </div>
            </div>

            <!-- DESCRIPTION -->
            <div x-show="selectedClass.description">
                <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
                    Description
                </h3>
                <div class="px-4 py-3 bg-gray-50 rounded-lg text-sm text-gray-700" x-text="selectedClass.description"></div>
            </div>

            <!-- TASKS -->
            <div x-show="selectedClass.subtasks && selectedClass.subtasks.length > 0">
                <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
                    Tasks from Teacher
                </h3>

                <div class="space-y-2">
                    <template x-for="(item, index) in selectedClass.subtasks" :key="index">
                        <div class="flex items-center gap-3 p-3 bg-gray-50 rounded-lg">
                            <div class="w-5 h-5 rounded border-2 border-gray-300 flex items-center justify-center"
                                 :class="item.completed ? 'bg-[#5F9873] border-[#5F9873]' : ''">
                                <i x-show="item.completed" class="ri-check-line text-white text-sm"></i>
                            </div>
                            <span class="text-sm"
                                  :class="item.completed ? 'line-through text-gray-400' : 'text-gray-700'"
                                  x-text="item.text"></span>
                        </div>
                    </template>
                </div>
            </div>
            <div x-show="selectedClass.attachments && selectedClass.attachments.length > 0">
    <h3 class="text-base font-bold text-gray-600 mb-3 flex items-center gap-2">
        Files from Teacher
    </h3>

    <div class="space-y-2">
        <template x-for="(file, index) in selectedClass.attachments" :key="index">
            <div class="flex items-center gap-3 p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-all">

                <!-- Icon selon type -->
                <div class="w-10 h-10 rounded-lg flex items-center justify-center flex-shrink-0"
                     :class="{
                         'bg-red-100 text-red-600': file.type === 'pdf',
                         'bg-blue-100 text-blue-600': file.type === 'doc',
                         'bg-green-100 text-green-600': file.type === 'excel',
                         'bg-orange-100 text-orange-600': file.type === 'ppt',
                         'bg-purple-100 text-purple-600': file.type === 'image',
                         'bg-gray-200 text-gray-600': !['pdf','doc','excel','ppt','image'].includes(file.type)
                     }">
                    <i :class="{
                        'ri-file-pdf-line': file.type === 'pdf',
                        'ri-file-word-line': file.type === 'doc',
                        'ri-file-excel-line': file.type === 'excel',
                        'ri-file-ppt-line': file.type === 'ppt',
                        'ri-image-line': file.type === 'image',
                        'ri-file-line': !['pdf','doc','excel','ppt','image'].includes(file.type)
                    }" class="text-xl"></i>
                </div>

                <!-- Nom du fichier -->
                <div class="flex-1 min-w-0">
                    <p class="text-sm font-medium text-gray-700 truncate" x-text="file.name"></p>
                    <p class="text-xs text-gray-400" x-text="(file.size / 1024).toFixed(1) + ' KB'"></p>
                </div>

                <!-- Bouton télécharger/voir -->
                <a :href="file.url"
                   target="_blank"
                   class="inline-flex items-center gap-1.5 px-3 py-1.5 bg-[#5F9873] text-white text-xs font-medium rounded-lg hover:bg-[#4a7d5c] transition-all">
                    <i class="ri-download-line"></i>
                    <span>View</span>
                </a>
            </div>
        </template>
    </div>
</div>

            <!-- EMPTY STATE -->
            <div x-show="!selectedClass.description && (!selectedClass.subtasks || selectedClass.subtasks.length === 0)"
                 class="text-center py-8 text-gray-400">
                <i class="ri-inbox-line text-4xl mb-2"></i>
                <p>No description or tasks added yet.</p>
            </div>

        </div>



    </div>
</div>

<style>[x-cloak] { display: none !important; }</style>

<style>
[x-cloak] {
    display: none !important;
}

/* 🔥 FIX: Modals au-dessus de TOUT */
div[x-show="showSessionModal"],
div[x-show="showTaskModal"] {
    z-index: 100000 !important;
    background-color: rgba(0, 0, 0, 0.5) !important;
}

/* Contenu des modals encore plus haut */
div[x-show="showSessionModal"] > div,
div[x-show="showTaskModal"] > div {
    z-index: 100001 !important;
    position: relative;
}
</style>
</x-app-layout>
