<x-app-layout title="Feedback & Reports" :section="'Feedback'" :page="''">

<div class="ml-16 mb-4 mr-16"
     x-data="{ showModal: false, showBugModal: false, showTeacherModal: false }">

        <!-- Header -->
        <h1 class="text-4xl font-semibold text-[#32312D]">Closer to perfect.</h1>
        <p class="text-xl text-gray-500 mb-2">
            Your feedback bridges the gap between good and exceptional.
        </p>

        <!-- Ideas Section -->
        <section class="  pt-4">
            <h2 class="text-2xl font-semibold text-gray-900 mb-3">Ideas</h2>

            <form
    x-data="{
        showTextarea: false,
        message: '',
        submitOrShow() {
            if (!this.showTextarea) {
                this.showTextarea = true; // 1er clic → afficher textarea
                return;
            }

            if (this.message.trim() === '') {
                return; // ne rien faire si vide
            }

            $refs.ideaForm.submit(); // 2e clic → envoyer
        }
    }"
    x-ref="ideaForm"
    action="{{ route('student.feedback.store') }}"
    method="POST"
    class="rounded-md bg-white "
>
    @csrf
    <input type="hidden" name="type" value="idea">

    <div class="flex justify-between items-center mb-2">
        <div>
            <h3 class="text-l font-normal border-t pt-3 text-gray-800">Got an idea?</h3>
            <p class="text-l text-gray-500">
                Your vision shapes what’s next. Share your ideas, features, or improvements — and help us move closer to perfect.
            </p>
        </div>

        <!-- 🔥 bouton intelligent -->
        <button
            type="button"
            @click="submitOrShow()"
            class="text-xs px-4 py-1 bg-blue-500 text-white rounded hover:bg-blue-600 transition"
        >
            Share ideas
        </button>
    </div>

    <!-- 🔥 textarea affiché seulement après le premier clic -->
    <textarea
        x-show="showTextarea"
        x-model="message"
        name="message"
        rows="4"
        class="w-full mt-2 p-3 border border-gray-300 rounded-md focus:ring-blue-400 focus:border-blue-400 text-sm"
        placeholder="Write your idea here..."
        x-cloak
    ></textarea>
</form>
        </section>

        <!-- Report Section -->
        <section class="mt-10  pt-6">
            <h2 class="text-2xl font-semibold text-gray-900 mb-3">Report</h2>

            <div class="space-y-6">

                <!-- Experience -->
                <div class="flex justify-between border-t pt-3 items-start">
                    <div>
                        <h3 class="text-l font-normal text-gray-800">Report an experience</h3>
                        <p class="text-l  text-gray-500">
                            Your comfort matters. Share what felt confusing or frustrating so we can improve it.
                        </p>
                    </div>
                    <button @click="showModal = true" type="button"
                    class="text-xs px-7 py-1  rounded border border-gray-300 hover:bg-gray-100 transition"
                            >
                        Report
                    </button>
                </div>

                <!-- Bug -->
               <!-- Bug -->
<div class="flex justify-between items-start">
    <div>
        <h3 class="text-l font-normal text-gray-800">Spot a bug</h3>
        <p class="text-l text-gray-500">
            Every detail counts. Tell us what didn’t work so we can make it seamless.
        </p>
    </div>
    <button @click="showBugModal = true" type="button"
            class="text-xs px-7 py-1  rounded border border-gray-300 hover:bg-gray-100 transition">
        Report
    </button>
</div>

                <!-- Teacher -->
      @unless(auth()->user()->role === 'teacher')
<div class="flex justify-between items-start">
    <div>
        <h3 class="text-l font-normal text-gray-800">Report a teacher</h3>
        <p class="text-l text-gray-500">
            Quality matters. Let us know if a course or instructor fell short of our standards.
        </p>
    </div>

    <button @click="showTeacherModal = true" type="button"
           class="text-xs px-7 py-1  rounded border border-gray-300 hover:bg-gray-100 transition">
        Report
    </button>
</div>
@endunless

            </div>
        </section>

        <!-- Modal -->
       <div x-show="showModal"
     class="fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50 z-50"
     x-cloak>
    <div @click.away="showModal = false"
         class="bg-white rounded-2xl shadow-xl w-full max-w-lg p-8 relative">

        <!-- Header -->
        <div class="text-center mb-8">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/alert-triangle%203.png"
                 alt="Alert icon"
                 class="w-14 h-14 mx-auto mb-3 opacity-80">
            <h2 class="text-2xl font-semibold text-gray-900">Report an experience</h2>
        </div>

        <form action="{{ route('student.feedback.store') }}" method="POST" class="space-y-6">
            @csrf
            <input type="hidden" name="type" value="experience">

            <!-- Category and Suggestion -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label for="category" class="block text-sm font-medium text-gray-700 mb-1">
                        Category
                    </label>
                    <select id="category" name="category"
                            class="w-full border border-gray-300 rounded-lg text-sm py-2 px-3 focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition">
                        <option value="">Select...</option>
                        <option value="Platform">Platform</option>
                        <option value="Support">Support</option>
                        <option value="Course navigation">Course navigation</option>
                        <option value="Payment">Payment</option>
                        <option value="Others">Others</option>
                    </select>
                </div>

                <div>
                    <label for="suggestion" class="block text-sm font-medium text-gray-700 mb-1">
                        Suggestion for improvement
                    </label>
                    <input type="text" id="suggestion" name="suggestion"
                           placeholder="Optional"
                           class="w-full border border-gray-300 rounded-lg text-sm py-2 px-3 focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition">
                </div>
            </div>

            <!-- Description -->
            <div>
                <label for="message" class="block text-sm font-medium text-gray-700 mb-1">
                    Description
                </label>
                <textarea id="message" name="message" rows="5"
                          class="w-full border border-gray-300 rounded-lg p-3 text-sm focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition"
                          placeholder="Describe what happened..."></textarea>
            </div>

            <!-- Buttons -->
            <div class="flex justify-end space-x-3 pt-2">
                <button type="button"
                        @click="showModal = false"
                        class="px-5 py-2 text-sm border border-gray-300 rounded-lg hover:bg-gray-100 transition">
                    Cancel
                </button>
                <button type="submit"
                        class="px-6 py-2 text-sm bg-blue-500 text-white rounded-lg hover:bg-blue-600 focus:ring-2 focus:ring-blue-300 transition">
                    Send
                </button>
            </div>
        </form>
    </div>
</div>

<div x-show="showBugModal"
     class="fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50 z-50"
     x-cloak>
    <div @click.away="showBugModal = false"
         class="bg-white rounded-2xl shadow-xl w-full max-w-lg p-8 relative">

        <!-- Header -->
        <div class="text-center mb-8">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/alert-triangle%203.png"
                 alt="Bug icon"
                 class="w-14 h-14 mx-auto mb-3 opacity-80">
            <h2 class="text-2xl font-semibold text-gray-900">Report a bug</h2>
            <p class="text-xs text-gray-500 mt-1">Every detail counts — help us make it seamless.</p>
        </div>

        <!-- Form -->
        <form action="{{ route('student.feedback.store') }}" method="POST" class="space-y-6">
            @csrf
            <input type="hidden" name="type" value="bug">

            <!-- Bug type & URL -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label for="bug_type" class="block text-sm font-medium text-gray-700 mb-1">
                        Bug Type
                    </label>
                    <select id="bug_type" name="category"
                            class="w-full border border-gray-300 rounded-lg text-sm py-2 px-3 focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition">
                        <option value="">Select...</option>
                        <option value="UI issue">UI issue</option>
                        <option value="Broken link">Broken link</option>
                        <option value="Error message">Error message</option>
                        <option value="Slow loading">Slow loading</option>
                        <option value="Other">Other</option>
                    </select>
                </div>

                <div>
                    <label for="url" class="block text-sm font-medium text-gray-700 mb-1">
                        Affected page (URL)
                    </label>
                    <input type="text" id="url" name="suggestion"
                           placeholder="Optional"
                           class="w-full border border-gray-300 rounded-lg text-sm py-2 px-3 focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition">
                </div>
            </div>

            <!-- Description -->
            <div>
                <label for="message_bug" class="block text-sm font-medium text-gray-700 mb-1">
                    Description
                </label>
                <textarea id="message_bug" name="message" rows="5"
                          class="w-full border border-gray-300 rounded-lg p-3 text-sm focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition"
                          placeholder="Describe the issue..."></textarea>
            </div>

            <!-- Buttons -->
            <div class="flex justify-end space-x-3 pt-2">
                <button type="button"
                        @click="showBugModal = false"
                        class="px-5 py-2 text-sm border border-gray-300 rounded-lg hover:bg-gray-100 transition">
                    Cancel
                </button>
                <button type="submit"
                        class="px-6 py-2 text-sm bg-blue-500 text-white rounded-lg hover:bg-blue-600 focus:ring-2 focus:ring-blue-300 transition">
                    Send
                </button>
            </div>
        </form>
    </div>
</div>
<div x-show="showTeacherModal"
     class="fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50 z-50"
     x-cloak>
    <div @click.away="showTeacherModal = false"
         class="bg-white rounded-2xl shadow-xl w-full max-w-lg p-8 relative">

        <!-- Header -->
        <div class="text-center mb-8">
            <img src="https://pub-480c6c9acfe14a8691b924c7ab9f887d.r2.dev/alert-triangle%203.png"
                 alt="Teacher icon"
                 class="w-14 h-14 mx-auto mb-3 opacity-80">
            <h2 class="text-2xl font-semibold text-gray-900">Report a teacher</h2>
            <p class="text-xs text-gray-500 mt-1">
                Quality matters. Let us know if a course or instructor fell short of our standards.
            </p>
        </div>

        <!-- Form -->
        <form action="{{ route('student.feedback.store') }}" method="POST" class="space-y-6">
            @csrf
            <input type="hidden" name="type" value="teacher">

            <!-- Teacher & Course -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label for="teacher_name" class="block text-sm font-medium text-gray-700 mb-1">
                        Teacher’s name
                    </label>
                    <input type="text" id="teacher_name" name="category"
                           placeholder="e.g. John Smith"
                           class="w-full border border-gray-300 rounded-lg text-sm py-2 px-3 focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition" required>
                </div>

                <div>
                    <label for="course_name" class="block text-sm font-medium text-gray-700 mb-1">
                        Course name
                    </label>
                    <input type="text" id="course_name" name="suggestion"
                           placeholder="e.g. Mathematics 101"
                           class="w-full border border-gray-300 rounded-lg text-sm py-2 px-3 focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition" required>
                </div>
            </div>

            <!-- Description -->
            <div>
                <label for="teacher_message" class="block text-sm font-medium text-gray-700 mb-1">
                    Description
                </label>
                <textarea id="teacher_message" name="message" rows="5"
                          class="w-full border border-gray-300 rounded-lg p-3 text-sm focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition"
                          placeholder="Describe the issue or concern..." required></textarea>
            </div>

            <!-- Buttons -->
            <div class="flex justify-end space-x-3 pt-2">
                <button type="button"
                        @click="showTeacherModal = false"
                        class="px-5 py-2 text-sm border border-gray-300 rounded-lg hover:bg-gray-100 transition">
                    Cancel
                </button>
                <button type="submit"
                        class="px-6 py-2 text-sm bg-blue-500 text-white rounded-lg hover:bg-blue-600 focus:ring-2 focus:ring-blue-300 transition">
                    Send
                </button>
            </div>
        </form>
    </div>
</div>

        <!-- History -->
        @if($feedbacks->count())
            <section class="mt-12 border-t border-gray-200 pt-6">
                <h2 class="text-sm font-semibold text-gray-800 mb-3">Your Previous Feedback</h2>
                <div class="space-y-3">
                    @foreach($feedbacks as $f)
                        <div class="p-3 rounded-md border border-gray-200 bg-gray-50">
                            <p class="text-xs text-gray-600">
                                <strong class="capitalize">{{ $f->type }}</strong> • {{ $f->created_at->format('d M Y, H:i') }}
                            </p>
                            <p class="mt-1 text-sm text-gray-800">{{ $f->message }}</p>
                        </div>
                    @endforeach
                </div>
            </section>
        @endif
    </div>

    {{-- ✅ SweetAlert2 success --}}
    @if(session('success'))
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    icon: 'success',
                    title: 'Success 🎉',
                    text: '{{ session('success') }}',
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'OK',
                    timer: 2500,
                    timerProgressBar: true
                });
            });
        </script>
    @endif
</x-app-layout>
