<x-app-layout title="Dashboard Étudiant" :points="$points" :section="'Home'" :page="''">

    <!-- Header Section -->
    <div class="mt-2 ml-16  mb-8">
        <h2 class="text-4xl font-bold text-gray-900">
            Hello <span class="capitalize">{{ Auth::user()->name ?? 'Bechir' }}</span>
        </h2>

        <div class="flex items-center   gap-x-10">
            <p class="text-4xl font-bold bg-gradient-to-r from-blue-500 via-pink-500 to-red-500 bg-clip-text text-transparent">
                How can I help you today ?
            </p>

            <!-- Bouton Ask Nova -->
           <a href="{{ url('/student/nova') }}"
   class="relative ml-6 mt-4 px-6 py-1 rounded-full font-semibold text-xl
          bg-white hover:scale-105 transition-transform duration-300 group">
    <span class="absolute inset-0 rounded-full bg-gradient-to-r from-blue-500 via-pink-500 to-orange-500 p-[1.5px]">
        <span class="flex h-full w-full items-center justify-center rounded-full bg-white"></span>
    </span>

    <!-- 👇 Taille 16px + semi-bold -->
    <span class="relative text-[16px] font-semibold
                 bg-gradient-to-r from-blue-500 via-pink-500 to-orange-500
                 bg-clip-text text-transparent">
        Ask Nova
    </span>
</a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="px-8 pb-10">

        <!-- Statistiques Principales en Cards -->


        <!-- Section: Activité Récente (7 derniers jours) -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 mb-8">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                    <i class="ri-line-chart-line text-indigo-600"></i>
                    Recent Activity (Last 7 days)
                </h3>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="text-center p-4 bg-blue-50 rounded-xl">
                    <div class="text-4xl font-bold text-blue-600 mb-1">{{ $recentActivity['tasks_completed'] }}</div>
                    <p class="text-sm text-gray-600">Tasks Completed</p>
                </div>
                <div class="text-center p-4 bg-purple-50 rounded-xl">
                    <div class="text-4xl font-bold text-purple-600 mb-1">{{ $recentActivity['goals_completed'] }}</div>
                    <p class="text-sm text-gray-600">Goals Achieved</p>
                </div>
                <div class="text-center p-4 bg-pink-50 rounded-xl">
                    <div class="text-4xl font-bold text-pink-600 mb-1">{{ $recentActivity['nova_conversations'] }}</div>
                    <p class="text-sm text-gray-600">Nova Conversations</p>
                </div>
            </div>
        </div>

        <!-- 2 Colonnes: Tasks et Sessions -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">

            <!-- Today's Tasks -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <i class="ri-checkbox-line text-blue-600"></i>
                        Today's Tasks
                    </h3>
                    <a href="{{ route('student.goals') }}" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
                        View all →
                    </a>
                </div>

                @if($todayTasks->count() > 0)
                    <div class="space-y-3">
                        @foreach($todayTasks as $task)
                        <div class="flex items-center gap-3 p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition">
                            <div class="flex-shrink-0">
                                <input type="checkbox" class="w-5 h-5 rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-medium text-gray-900 truncate">{{ $task->title }}</p>
                                @if($task->category)
                                <span class="text-xs text-gray-500">{{ $task->category }}</span>
                                @endif
                            </div>
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-400">
                        <i class="ri-checkbox-circle-line text-5xl mb-2"></i>
                        <p class="text-sm">No pending tasks for today! 🎉</p>
                    </div>
                @endif
            </div>

           <!-- Upcoming Meetings (Zoom) -->
<div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
    <div class="flex items-center justify-between mb-6">
        <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
            <i class="ri-calendar-event-line text-green-600"></i>
            Upcoming Meetings
        </h3>
        <a href="/student/live-sessions" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
            View all →
        </a>
    </div>

    @if($upcomingSessions->count() > 0)
        <div class="space-y-3">
            @foreach($upcomingSessions as $session)
            <div class="flex items-start gap-3 p-3 border-l-4 border-green-500 rounded-lg hover:bg-gray-50 transition">

                <div class="flex-shrink-0 bg-green-50 p-2 rounded-lg">
                    <i class="ri-video-chat-line text-green-600 text-lg"></i>
                </div>

                <div class="flex-1 min-w-0">
                    <p class="text-sm font-semibold text-gray-900">
                        {{ $session->topic }}
                    </p>

                    <p class="text-xs text-gray-500 mt-1">
                        <i class="ri-time-line"></i>
                        {{ \Carbon\Carbon::parse($session->start_time)->format('d M, H:i') }}
                    </p>

                    @if($session->password)
                    <p class="text-xs text-gray-500 mt-1">
                        <i class="ri-lock-line"></i> Password: {{ $session->password }}
                    </p>
                    @endif
                </div>

                <a href="/student/live-sessions" target="_blank"
                    class="flex-shrink-0 text-xs bg-green-100 text-green-700 px-3 py-1 rounded-full hover:bg-green-200 transition">
                    Join
                </a>

            </div>
            @endforeach
        </div>
    @else
        <div class="text-center py-8 text-gray-400">
            <i class="ri-calendar-check-line text-5xl mb-2"></i>
            <p class="text-sm">No upcoming meetings</p>
        </div>
    @endif
</div>


        </div>

        <!-- Urgent Goals & Groups -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">

            <!-- Urgent Goals -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <i class="ri-alarm-warning-line text-red-600"></i>
                        Urgent Goals
                    </h3>
                    <a href="{{ route('student.goals') }}" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
                        View all →
                    </a>
                </div>

                @if($urgentGoals->count() > 0)
                    <div class="space-y-3">
                        @foreach($urgentGoals as $goal)
                        <div class="flex items-start gap-3 p-3 bg-red-50 border border-red-100 rounded-lg">
                            <div class="flex-1">
                                <p class="text-sm font-semibold text-gray-900">{{ $goal->title }}</p>
                                <div class="flex items-center gap-3 mt-2 text-xs">
                                    <span class="flex items-center gap-1 text-red-600">
                                        <i class="ri-calendar-line"></i>
                                        Due: {{ \Carbon\Carbon::parse($goal->due_date)->format('d M Y') }}
                                    </span>
                                    @if($goal->priority)
                                    <span class="px-2 py-0.5 bg-red-200 text-red-700 rounded-full">
                                        {{ $goal->priority }}
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <span class="flex-shrink-0 px-3 py-1 text-xs rounded-full
                                @if($goal->status == 'in_progress') bg-yellow-100 text-yellow-700
                                @else bg-gray-100 text-gray-600
                                @endif">
                                {{ ucfirst(str_replace('_', ' ', $goal->status)) }}
                            </span>
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-400">
                        <i class="ri-checkbox-circle-line text-5xl mb-2"></i>
                        <p class="text-sm">No urgent goals! You're all caught up! ✨</p>
                    </div>
                @endif
            </div>

            <!-- My Groups -->
            <div id="groups-section" class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                        <i class="ri-group-line text-blue-600"></i>
                        My Group
                    </h3>
                    <span class="text-sm text-gray-500">{{ $groupsCount }} groups</span>
                </div>

                @if($userGroups->count() > 0)
                    <div class="space-y-3">
                        @foreach($userGroups as $group)
                        <div class="flex items-center gap-4 p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-lg hover:shadow-md transition">
                            <div class="flex-shrink-0 w-12 h-12 bg-indigo-600 rounded-xl flex items-center justify-center text-white font-bold text-lg">
                                {{ strtoupper(substr($group->name, 0, 1)) }}
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-semibold text-gray-900 truncate">{{ $group->name }}</p>
                                <p class="text-xs text-gray-500 truncate">{{ $group->description ?? 'No description' }}</p>
                            </div>
                            <span class="flex-shrink-0 text-xs bg-indigo-100 text-indigo-700 px-3 py-1 rounded-full">
                                {{ ucfirst($group->role) }}
                            </span>
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-400">
                        <i class="ri-group-line text-5xl mb-2"></i>
                        <p class="text-sm">You're not in any groups yet</p>
                    </div>
                @endif
            </div>

        </div>

        <!-- Recent Projects -->
        @if($projects->count() > 0)
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 mt-8">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                    <i class="ri-folder-open-line text-orange-600"></i>
                    Recent Projects
                </h3>
                <a href="{{ route('student.projects.index') }}" class="text-sm text-indigo-600 hover:text-indigo-700 font-medium">
                    View all →
                </a>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($projects as $project)
                <div class="p-4 border border-gray-200 rounded-xl hover:shadow-md transition">
                    <div class="flex items-start justify-between mb-3">
                        <div class="flex-shrink-0 w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center">
                            <i class="ri-file-code-line text-orange-600 text-xl"></i>
                        </div>
                        <span class="text-xs px-2 py-1 rounded-full
                            @if($project->status == 'active') bg-green-100 text-green-700
                            @elseif($project->status == 'completed') bg-blue-100 text-blue-700
                            @else bg-gray-100 text-gray-600
                            @endif">
                            {{ ucfirst($project->status) }}
                        </span>
                    </div>
                    <h4 class="font-semibold text-gray-900 mb-1 truncate">{{ $project->name }}</h4>
                    <p class="text-xs text-gray-500 mb-2 line-clamp-2">{{ $project->description ?? 'No description' }}</p>
                    <div class="flex items-center justify-between text-xs text-gray-400">
                        <span>{{ $project->type }}</span>
                        <span>{{ \Carbon\Carbon::parse($project->created_at)->diffForHumans() }}</span>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif

        <!-- Recent Nova Conversations -->
        @if($recentConversations->count() > 0)
        <div class="bg-gradient-to-r from-pink-50 to-purple-50 rounded-2xl shadow-sm border border-purple-100 p-6 mt-8">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-gray-900 flex items-center gap-2">
                    <i class="ri-chat-smile-3-line text-pink-600"></i>
                    Recent Nova Conversations
                </h3>
                <a href="{{ route('student.nova.index') }}" class="text-sm text-pink-600 hover:text-pink-700 font-medium">
                    View all →
                </a>
            </div>

            <div class="space-y-3">
                @foreach($recentConversations as $conversation)
                <a href="{{ route('student.nova.index', $conversation->id) }}"
                   class="flex items-center gap-4 p-4 bg-white rounded-xl hover:shadow-md transition">
                    <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-pink-500 to-purple-500 rounded-full flex items-center justify-center text-white">
                        <i class="ri-sparkling-line"></i>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-semibold text-gray-900 truncate">{{ $conversation->title ?? 'Untitled Conversation' }}</p>
                        <p class="text-xs text-gray-500">{{ \Carbon\Carbon::parse($conversation->last_message_at)->diffForHumans() }}</p>
                    </div>
                    <i class="ri-arrow-right-line text-gray-400"></i>
                </a>
                @endforeach
            </div>
        </div>
        @endif

    </div>

</x-app-layout>
