@props([
    'section' => 'Dashboard',
    'page' => null,
    'points' => 0,
])

<header class="w-full bg-white  flex justify-between items-center py-6 px-6 ">
    <!-- 🧭 Breadcrumb -->
    <div class="flex items-center text-sm text-gray-500 space-x-2">
        <a href="#" class="text-gray-700 hover:text-indigo-600 font-medium">
            {{ $section }}
        </a>

        @if($page)
            <span class="text-gray-400">/</span>
<span id="breadcrumb-page" class="text-gray-500">{{ $page }}</span>
        @endif
    </div>

    <!-- 🎯 Points et Profil -->
     @if (request()->routeIs('student.wallet'))
        <div class="flex items-center gap-4">
            <!-- Points -->
            <div class="bg-blue-600 text-white text-sm font-semibold px-5 py-1.5 rounded-full shadow-sm">
                {{ $points }} Points
            </div>

            <!-- Profil Utilisateur -->
            {{-- Ton code profil ici --}}
        </div>
    @endif
</header>

<style>
    .rotate-180 {
        transform: rotate(180deg);
        transition: transform 0.2s;
    }
</style>
