@props(['name', 'class' => 'w-5 h-5'])

@php
    $path = public_path("assets/icons/dashboard right section/$name.svg");
@endphp

@if (file_exists($path))
    @php
        $svg = file_get_contents($path);

        // Injecte la classe Tailwind dans la balise <svg>
        $svg = preg_replace(
            '/<svg\b(?!.*class=")/',
            '<svg class="' . $class . '" ',
            $svg,
            1
        );

        // Si la balise avait déjà une classe → on fusionne
        $svg = preg_replace(
            '/class="([^"]*)"/',
            'class="' . $class . ' $1"',
            $svg,
            1
        );
    @endphp

    {!! $svg !!}
@else
    <span class="text-red-600">[missing icon]</span>
@endif
