<!-- ============================================ -->
<!-- LAYOUT PRINCIPAL (app.blade.php) -->
<!-- ============================================ -->
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title ?? 'Dashboard Étudiant' }}</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
<meta name="csrf-token" content="{{ csrf_token() }}">

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
   .select-clean {
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        background-position: right 0.8rem center;
        background-repeat: no-repeat;
        background-size: 1rem;
        padding-right: 2rem;
    }

    .sortable-ghost {
    opacity: 0.4;
    background: #e0e7ff !important;
    border: 2px dashed #6366f1 !important;
    border-radius: 12px;
}

/* Style pour l'élément en cours de drag */
.sortable-drag {
    opacity: 1 !important;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
    transform: rotate(2deg);
}

/* Style pour l'élément sélectionné */
.sortable-chosen {
    transform: scale(1.02);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
}

/* Ligne indicatrice entre les éléments */
.sortable-list > .sortable-ghost::before {
    content: '';
    position: absolute;
    left: 0;
    right: 0;
    top: -4px;
    height: 4px;
    background: linear-gradient(90deg, #6366f1, #8b5cf6);
    border-radius: 2px;
}

/* Animation lors du drag */
.is-dragging .sortable-list > div:not(.sortable-ghost):not(.sortable-drag) {
    transition: transform 0.15s ease;
}

/* Highlight de la colonne de destination */
.sortable-list.sortable-hover {
    background: rgba(99, 102, 241, 0.05);
    border-radius: 12px;
}

    /* Taille + arrondi pills */
    .select-pill {
        border-radius: 9999px !important;
        font-weight: 600;
    }
        body {
    font-family: 'Inter', sans-serif !important;
}

        [x-cloak] {
    display: none !important;
}

/* S'assurer que le sidebar a le bon z-index */
#sidebar {
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    overflow: hidden;
    z-index: 40 !important;
}

/* Menu déroulant toujours visible */
.sidebar [x-show] {
    display: none;
}

.sidebar [x-show][style*="display: none"] {
    display: none !important;
}

.sidebar [x-show]:not([style*="display: none"]) {
    display: block !important;
}
        /* Contenu principal qui s'ajuste selon la sidebar */
     #main-content {
        margin-left: 16rem; /* 256px = w-64 */
        transition: margin-left 0.3s ease;
        position: relative;
        z-index: 10;
    }

    #nova-form {
        margin-bottom: 20px;
    }

    /* Quand la sidebar est rétrécie */
    #sidebar.collapsed ~ #main-content {
        margin-left: 5rem; /* 80px = w-20 */
    }

    /* Sidebar doit être au-dessus */
    #sidebar {
        position: fixed;
        top: 0;
        left: 0;
        height: 100vh;
        overflow: hidden;
        z-index: 100 !important;
    }

    /* Scrollbar personnalisée */
    #conversations-list::-webkit-scrollbar {
        width: 6px;
    }

    #conversations-list::-webkit-scrollbar-track {
        background: transparent;
    }

    #conversations-list::-webkit-scrollbar-thumb {
        background: #d1d5db;
        border-radius: 3px;
    }

    #conversations-list::-webkit-scrollbar-thumb:hover {
        background: #ffffff;
    }

    .watermark, .leftwatermark, .rightwatermark, .powered-by {
        display: none !important;
        visibility: hidden !important;
        opacity: 0 !important;
    }

    /* Sidebar ouverte */
body:not(.sidebar-collapsed) #main-content {
    margin-left: 16rem;
}

/* Sidebar fermée */
body.sidebar-collapsed #main-content {
    margin-left: 5rem;
}



    </style>

    <!-- 🔥 SCRIPT POUR APPLIQUER L'ÉTAT AVANT LE RENDU (évite le flash) -->
    <script>
        (function() {
            const sidebarState = localStorage.getItem('sidebarCollapsed');
            if (sidebarState === 'true') {
                document.documentElement.classList.add('sidebar-collapsed-preload');
            }
        })();
    </script>
    <style>
        /* Style pour éviter le flash au chargement */
        html.sidebar-collapsed-preload body {
            --sidebar-width: 5rem;
        }
        html:not(.sidebar-collapsed-preload) body {
            --sidebar-width: 16rem;
        }
        #main-content {
            margin-left: var(--sidebar-width, 16rem);
        }
    </style>
</head>
<body class="flex min-h-screen bg-white font-inter">

    <!-- ✅ Sidebar -->


    <!-- ✅ Contenu principal -->
    <div id="main-content" class="flex-1 flex flex-col">
          <x-sidebar />
        <x-topbar :section="$section ?? 'Dashboard'" :page="$page ?? null" :points="$points ?? 0" />

        <main class="">
            {{ $slot }}
        </main>
    </div>

    <!-- 🔥 SCRIPT UNIQUE POUR TOUT GÉRER -->
 <script>
    document.addEventListener('DOMContentLoaded', function() {
        const toggleBtn = document.getElementById('toggleSidebar');
        const sidebar = document.getElementById('sidebar');
        const profileMenu = document.getElementById('profile-menu');
        const profileToggle = document.getElementById('profile-toggle');
        const profileDropdown = document.getElementById('profile-dropdown');
        const profileToggleBtn = document.querySelector('.profile-toggle-btn');

        // ========================================
        // 🔥 FONCTION POUR APPLIQUER L'ÉTAT DE LA SIDEBAR
        // ========================================
        function applySidebarState(collapsed) {
            if (!sidebar) return;

            if (collapsed) {
                sidebar.classList.add('collapsed');
                sidebar.classList.remove('w-64');
                sidebar.classList.add('w-16');
                document.body.classList.add('sidebar-collapsed');

                if (profileToggleBtn) {
                    profileToggleBtn.classList.remove('w-full');
                    profileToggleBtn.classList.add('w-auto');
                }

                // Cacher les textes
                sidebar.querySelectorAll('.sidebar-text').forEach(el => el.classList.add('hidden'));

                // Gérer le menu profil
                if (profileMenu) {
                    profileMenu.style.width = '4.5rem';
                }
                if (profileToggle) {
                    profileToggle.classList.add('justify-center');
                }
                document.querySelectorAll('.profile-info').forEach(el => {
                    el.style.display = 'none';
                });

                // Changer l'icône
                const icon = toggleBtn?.querySelector('i');
                if (icon) {
                    icon.className = 'ri-arrow-right-double-line text-xl';
                }
            } else {
                sidebar.classList.remove('collapsed');
                sidebar.classList.add('w-64');
                sidebar.classList.remove('w-16');
                document.body.classList.remove('sidebar-collapsed');

                if (profileToggleBtn) {
                    profileToggleBtn.classList.add('w-full');
                    profileToggleBtn.classList.remove('w-auto');
                }

                // Afficher les textes
                sidebar.querySelectorAll('.sidebar-text').forEach(el => el.classList.remove('hidden'));

                // Gérer le menu profil
                if (profileMenu) {
                    profileMenu.style.width = 'calc(16rem - 1rem)';
                }
                if (profileToggle) {
                    profileToggle.classList.remove('justify-center');
                }
                document.querySelectorAll('.profile-info').forEach(el => {
                    el.style.display = 'block';
                });

                // Changer l'icône
                const icon = toggleBtn?.querySelector('i');
                if (icon) {
                    icon.className = 'ri-arrow-left-double-line text-xl';
                }
            }
        }

        // ========================================
        // 🔥 CHARGER L'ÉTAT SAUVEGARDÉ AU DÉMARRAGE
        // ========================================
        const savedState = localStorage.getItem('sidebarCollapsed') === 'true';
        applySidebarState(savedState);

        // Nettoyer la classe preload
        document.documentElement.classList.remove('sidebar-collapsed-preload');

        // ========================================
        // 📌 TOGGLE SIDEBAR
        // ========================================
        if (toggleBtn && sidebar) {
            toggleBtn.addEventListener('click', () => {
                const isCurrentlyCollapsed = sidebar.classList.contains('collapsed');
                const newState = !isCurrentlyCollapsed;

                // Sauvegarder dans localStorage
                localStorage.setItem('sidebarCollapsed', newState);

                // Appliquer le nouvel état
                applySidebarState(newState);
            });
        }

        // ========================================
        // 📌 TOGGLE PROFILE DROPDOWN
        // ========================================
        if (profileToggle && profileDropdown) {
            profileToggle.addEventListener('click', (e) => {
                e.stopPropagation();
                profileDropdown.classList.toggle('hidden');

                // Rotation de la flèche
                const arrow = profileToggle.querySelector('.profile-arrow');
                if (arrow) {
                    arrow.classList.toggle('rotate-180');
                }
            });

            // Fermer le dropdown quand on clique ailleurs
            document.addEventListener('click', (e) => {
                if (!profileMenu.contains(e.target)) {
                    profileDropdown.classList.add('hidden');
                    const arrow = profileToggle.querySelector('.profile-arrow');
                    if (arrow) {
                        arrow.classList.remove('rotate-180');
                    }
                }
            });
        }

        // ========================================
        // 💬 GESTION DES CONVERSATIONS NOVA
        // ========================================
        @if(request()->routeIs('student.nova.index'))
        const newChatBtn = document.getElementById('new-chat-btn');
        const conversationsList = document.getElementById('conversations-list');

        // Nouvelle conversation
        if (newChatBtn) {
            newChatBtn.addEventListener('click', () => {
                window.location.href = "{{ route('student.nova.index') }}";
            });
        }

        // Charger une conversation
        if (conversationsList) {
            conversationsList.addEventListener('click', async (e) => {
                const convItem = e.target.closest('.conversation-item');
                if (!convItem || e.target.closest('.delete-conv')) return;

                const convId = convItem.dataset.id;

                // Dispatch événement personnalisé
                window.dispatchEvent(new CustomEvent('loadConversation', {
                    detail: { conversationId: convId }
                }));

                // Mettre à jour l'état actif
                document.querySelectorAll('.conversation-item').forEach(item => {
                    item.classList.remove('bg-indigo-50');
                });
                convItem.classList.add('bg-indigo-50');
            });

            // Supprimer une conversation
            conversationsList.addEventListener('click', async (e) => {
                if (!e.target.closest('.delete-conv')) return;

                e.stopPropagation();

                const deleteBtn = e.target.closest('.delete-conv');
                const convId = deleteBtn.dataset.id;

                if (!confirm('Êtes-vous sûr de vouloir supprimer cette conversation ?')) return;

                try {
                    const response = await fetch(`{{ route('student.nova.index') }}/conversation/${convId}`, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}",
                            'Accept': 'application/json',
                        }
                    });

                    const data = await response.json();

                    if (data.success) {
                        // Supprimer visuellement l'élément
                        const convItem = deleteBtn.closest('.conversation-item');
                        convItem.remove();

                        // Vérifier s'il reste des conversations
                        const remainingConversations = document.querySelectorAll('.conversation-item');
                        if (remainingConversations.length === 0) {
                            conversationsList.innerHTML = `
                                <div class="text-center py-8 sidebar-text">
                                    <i class="ri-message-3-line text-3xl text-gray-300 mb-2 block"></i>
                                    <p class="text-xs text-gray-400">No conversations yet</p>
                                    <p class="text-xs text-gray-400 mt-1">Start chatting with Nova!</p>
                                </div>`;
                        }

                        // Mettre à jour le compteur
                        const counterElement = document.querySelector('h3 .text-indigo-600');
                        if (counterElement) {
                            counterElement.textContent = `(${remainingConversations.length})`;
                        }

                        // Dispatcher événement
                        window.dispatchEvent(new CustomEvent('conversationDeleted', {
                            detail: { conversationId: convId }
                        }));
                    }
                } catch (error) {
                    console.error('Error deleting conversation:', error);
                    alert('Erreur lors de la suppression. Veuillez réessayer.');
                }
            });
        }
        @endif
    });
</script>
<script>
    // Override global fetch pour ajouter automatiquement les headers nécessaires
    const originalFetch = window.fetch;
    window.fetch = function(resource, options = {}) {
        options.headers = {
            ...(options.headers || {}),
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json'
        };
        return originalFetch(resource, options);
    };
</script>


</body>
</html>
