<x-app-layout title="Dashboard affiliate" :section="'affiliate'" :page="'Dashboard'">

    <div class="px-8 font-inter  min-h-screen">

        <!-- HEADER -->
        <h1 class="text-3xl font-semibold text-gray-900 mb-6">Dashboard</h1>

        <!-- STATS CARDS -->
     <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8"
     x-data="{ openCard: null }">

    <!-- 🟦 Total Revenue -->
    <div class="bg-[#F7FAFE] border border-blue-100 rounded-2xl p-6 relative overflow-visible">
        <div class="flex items-center justify-between mb-2">
            <p class="font-inter text-[15px] font-normal text-[#1D1D1E]">Total revenue</p>

            <button
                @mouseenter="openCard = 'revenue'"
                @mouseleave="openCard = null"
                class="w-5 h-5 flex items-center justify-center rounded-full bg-gray-100 border border-gray-300 text-gray-700 text-xs font-medium">
                ?
            </button>

            <div x-show="openCard === 'revenue'"
                 x-transition
                 class="absolute -top-14 right-1/2 translate-x-1/2 w-56 bg-white text-center text-sm text-[#1D1D1E] font-inter font-normal p-2.5 rounded-xl shadow-lg border border-gray-100 z-50">
                Your total earnings from all time.
            </div>
        </div>
        <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E]">{{ $stats['total_revenue'] }}</h2>
    </div>

    <!-- 🟨 Revenue This Month -->
    <div class="bg-[#FDF9EE] border border-yellow-100 rounded-2xl p-6 relative overflow-visible">
        <div class="flex items-center justify-between mb-2">
            <p class="font-inter text-[15px] font-normal text-[#1D1D1E]">Revenue this month</p>

            <button
                @mouseenter="openCard = 'month'"
                @mouseleave="openCard = null"
                class="w-5 h-5 flex items-center justify-center rounded-full bg-gray-100 border border-gray-300 text-gray-700 text-xs font-medium">
                ?
            </button>

            <div x-show="openCard === 'month'"
                 x-transition
                 class="absolute -top-14 right-1/2 translate-x-1/2 w-60 bg-white text-center text-sm text-[#1D1D1E] font-inter font-normal p-2.5 rounded-xl shadow-lg border border-gray-100 z-50">
                Your confirmed earnings for the current month.
            </div>
        </div>
        <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E]">{{ $stats['month_revenue'] }}</h2>
        <p class="text-xs text-gray-400 mt-1">+23% from last month</p>
    </div>

    <!-- 🟥 Total Teaching Hours -->
    <div class="bg-[#FFF6F5] border border-red-100 rounded-2xl p-6 relative overflow-visible">
        <div class="flex items-center justify-between mb-2">
            <p class="font-inter text-[15px] font-normal text-[#1D1D1E]">Upcoming revenue</p>

            <button
                @mouseenter="openCard = 'hours'"
                @mouseleave="openCard = null"
                class="w-5 h-5 flex items-center justify-center rounded-full bg-gray-100 border border-gray-300 text-gray-700 text-xs font-medium">
                ?
            </button>

            <div x-show="openCard === 'hours'"
                 x-transition
                 class="absolute -top-14 right-1/2 translate-x-1/2 w-60 bg-white text-center text-sm text-[#1D1D1E] font-inter font-normal p-2.5 rounded-xl shadow-lg border border-gray-100 z-50">
                Total hours you've taught across all courses.
            </div>
        </div>
        <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E]">{{ $stats['teaching_hours'] }}</h2>
    </div>

    <!-- ⚪ Balance -->
    <div class="bg-[#F9F8F6] border border-gray-100 rounded-2xl p-6 relative overflow-visible">
        <div class="flex items-center justify-between mb-2">
            <p class="font-inter text-[15px] font-normal text-[#1D1D1E]">Balance</p>

            <button
                @mouseenter="openCard = 'balance'"
                @mouseleave="openCard = null"
                class="w-5 h-5 flex items-center justify-center rounded-full bg-gray-100 border border-gray-300 text-gray-700 text-xs font-medium">
                ?
            </button>

            <div x-show="openCard === 'balance'"
                 x-transition
                 class="absolute -top-14 right-1/2 translate-x-1/2 w-52 bg-white text-center text-sm text-[#1D1D1E] font-inter font-normal p-2.5 rounded-xl shadow-lg border border-gray-100 z-50">
                Your available payout.
            </div>
        </div>
        <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E]">{{ $stats['balance'] }}</h2>
        <p class="text-xs text-gray-400 mt-1">23% from last month</p>
    </div>
</div>


        <!-- TOTAL REVENUE SECTION -->
<!-- TOTAL REVENUE SECTION -->
<div class="bg-white border border-gray-100 rounded-2xl shadow-sm p-6"
     x-data="{ chartTab: 'time' }">

    <!-- HEADER -->
    <div class="flex items-center justify-between mb-6">
        <div>
            <h2 class="font-inter text-[24px] font-medium text-[#1D1D1E] mb-1">Total revenue</h2>
            <div class="flex items-end gap-2">
                <h3 class="font-inter text-[32px] font-semibold text-[#1D1D1E] leading-none">$250,000</h3>
                <span class="text-green-500 font-inter text-sm font-medium">↑ 42%</span>
            </div>
        </div>

        <!-- 🔘 Buttons -->
        <div class="flex justify-center w-full">
            <button
                @click="chartTab = 'time'"
                :class="chartTab === 'time'
                    ? 'px-4 py-2 bg-[#F6F7F5] text-black '
                    : 'px-4 py-2 bg-[#ffffff] text-black  hover:bg-gray-200'"
            >
                Total revenue over time
            </button>

            <button
                @click="chartTab = 'courses'"
                :class="chartTab === 'courses'
                    ? 'px-4 py-2 bg-[#F6F7F5] text-black '
                    : 'px-4 py-2 bg-[#ffffff] text-black  hover:bg-gray-200'"
            >
                Revenue by course
            </button>
        </div>
    </div>


    <!-- ============================== -->
    <!--      CHART AREA : SWITCH       -->
    <!-- ============================== -->

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-10 items-center">

        <!-- LINE CHART (TIME) -->
        <div x-show="chartTab === 'time'" class="lg:col-span-2">
            <canvas id="salesChart"></canvas>

            <!-- Legend -->
            <div class="flex items-center justify-start gap-6 mt-4 text-sm font-inter text-[#1D1D1E]">
                <div class="flex items-center gap-2">
                    <span class="w-4 h-0.5 bg-[#3b82f6]"></span>
                    Jun 6–Jul 5, 2023
                </div>
                <div class="flex items-center gap-2 text-gray-400">
                    <span class="w-4 h-0.5 bg-gray-300"></span>
                    May 7–Jun 5, 2023
                </div>
            </div>
        </div>

        <!-- BAR CHART (COURSES) -->
        <div x-show="chartTab === 'courses'" class="lg:col-span-2">
            <canvas id="courseRevenueChart"></canvas>
        </div>


        <!-- DONUT CHART stays visible ALWAYS -->
        <div class="border border-gray-100 rounded-2xl shadow-sm p-4 h-full flex flex-col justify-center">
            <h3 class="font-inter text-[16px] font-light text-[#1D1D1E] mb-4 text-left">Revenue Share</h3>

            <div class="w-[160px] h-[160px] mx-auto">
                <canvas id="revenueShare"></canvas>
            </div>

            <div class="mt-6 space-y-2 text-[13px] font-inter font-normal text-[#1D1D1E] text-left">
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 rounded-md bg-[#059669]"></span> Back-end
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 rounded-md bg-[#DC2626]"></span> Full stack
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-4 h-4 rounded-md bg-[#374151]"></span> Front-end
                </div>
            </div>
        </div>

    </div>
</div>

    <!-- Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// ========================
// LINE CHART (Already exist)
// ========================
const ctx = document.getElementById('salesChart').getContext('2d');

new Chart(ctx, {
    type: 'line',
    data: {
        labels: ['Jun 6', 'Jun 10', 'Jun 14', 'Jun 18', 'Jun 22', 'Jun 26', 'Jul 1', 'Jul 5'],
        datasets: [
            {
                label: 'Current Period',
                data: [5000, 8500, 4000, 9500, 6000, 7200, 4800, 5300],
                borderColor: '#20afed',
                backgroundColor: 'rgba(32,175,237,0.08)',
                borderWidth: 4,
                fill: true,
                tension: 0.4,
                pointRadius: 0
            },
            {
                label: 'Previous Period',
                data: [4000, 7000, 3000, 8500, 5000, 6500, 4200, 4700],
                borderColor: '#d1d5db',
                borderDash: [4, 4],
                borderWidth: 1.5,
                fill: false,
                tension: 0.4,
                pointRadius: 0
            }
        ]
    },
    options: { responsive: true }
});


// ========================
// BAR CHART — Revenue by Course
// ========================
const courseCtx = document.getElementById('courseRevenueChart').getContext('2d');

new Chart(courseCtx, {
    type: 'bar',
    data: {
        labels: ['Laravel', 'React', 'Python', 'UI/UX', 'NodeJS'],
        datasets: [{
            label: 'Revenue (TND)',
            data: [4500, 3200, 5600, 2100, 3800],
            backgroundColor: '#4F46E5',
            borderRadius: 8,
            barThickness: 40
        }]
    },
    options: {
        plugins: { legend: { display: false }},
        scales: {
            y: { beginAtZero: true }
        }
    }
});


// ========================
// DONUT (Already exist)
// ========================
const donutCtx = document.getElementById('revenueShare').getContext('2d');
new Chart(donutCtx, {
    type: 'doughnut',
    data: {
        labels: ['Full stack', 'Back-end', 'Front-end', 'Data Science'],
        datasets: [{
            data: [43, 22.5, 12, 22.5],
            backgroundColor: ['#DC2626', '#059669', '#1d4ed8', '#374151'],
            borderColor: '#fff',
            borderWidth: 3,
            spacing: 5,
            hoverOffset: 6
        }]
    },
    options: { plugins: { legend: { display: false } }, cutout: '70%' }
});
</script>
</x-app-layout>
