// Copyright 2025 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v1.10.1 with parameter "target=dts+js"
// @generated from file livekit_connector_whatsapp.proto (package livekit, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3 } from "@bufbuild/protobuf";
import type { RoomAgentDispatch } from "./livekit_agent_dispatch_pb.js";
import type { SessionDescription } from "./livekit_rtc_pb.js";

/**
 * @generated from enum livekit.WhatsAppCallDirection
 */
export declare enum WhatsAppCallDirection {
  /**
   * @generated from enum value: WHATSAPP_CALL_DIRECTION_INBOUND = 0;
   */
  WHATSAPP_CALL_DIRECTION_INBOUND = 0,

  /**
   * @generated from enum value: WHATSAPP_CALL_DIRECTION_OUTBOUND = 2;
   */
  WHATSAPP_CALL_DIRECTION_OUTBOUND = 2,
}

/**
 * @generated from message livekit.DialWhatsAppCallRequest
 */
export declare class DialWhatsAppCallRequest extends Message<DialWhatsAppCallRequest> {
  /**
   * The number of the business that is initiating the call
   *
   * @generated from field: string whatsapp_phone_number_id = 1;
   */
  whatsappPhoneNumberId: string;

  /**
   * The number of the user that is supossed to receive the call
   *
   * @generated from field: string whatsapp_to_phone_number = 2;
   */
  whatsappToPhoneNumber: string;

  /**
   * The API key of the business that is initiating the call
   *
   * @generated from field: string whatsapp_api_key = 3;
   */
  whatsappApiKey: string;

  /**
   * An arbitrary string you can pass in that is useful for tracking and logging purposes.
   *
   * @generated from field: string whatsapp_biz_opaque_callback_data = 4;
   */
  whatsappBizOpaqueCallbackData: string;

  /**
   * What LiveKit room should this participant be connected too
   *
   * @generated from field: string room_name = 5;
   */
  roomName: string;

  /**
   * Optional agents to dispatch the call to
   *
   * @generated from field: repeated livekit.RoomAgentDispatch agents = 6;
   */
  agents: RoomAgentDispatch[];

  /**
   * Optional identity of the participant in LiveKit room
   *
   * @generated from field: string participant_identity = 7;
   */
  participantIdentity: string;

  /**
   * Optional name of the participant in LiveKit room
   *
   * @generated from field: string participant_name = 8;
   */
  participantName: string;

  /**
   * Optional user-defined metadata. Will be attached to a created Participant in the room.
   *
   * @generated from field: string participant_metadata = 9;
   */
  participantMetadata: string;

  /**
   * Optional user-defined attributes. Will be attached to a created Participant in the room.
   *
   * @generated from field: map<string, string> participant_attributes = 10;
   */
  participantAttributes: { [key: string]: string };

  /**
   * Country where the call terminates as ISO 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will be used by the livekit infrastructure to route calls.
   *
   * @generated from field: string destination_country = 11;
   */
  destinationCountry: string;

  constructor(data?: PartialMessage<DialWhatsAppCallRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.DialWhatsAppCallRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DialWhatsAppCallRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DialWhatsAppCallRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DialWhatsAppCallRequest;

  static equals(a: DialWhatsAppCallRequest | PlainMessage<DialWhatsAppCallRequest> | undefined, b: DialWhatsAppCallRequest | PlainMessage<DialWhatsAppCallRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.DialWhatsAppCallResponse
 */
export declare class DialWhatsAppCallResponse extends Message<DialWhatsAppCallResponse> {
  /**
   * Call ID sent by Meta
   *
   * @generated from field: string whatsapp_call_id = 1;
   */
  whatsappCallId: string;

  constructor(data?: PartialMessage<DialWhatsAppCallResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.DialWhatsAppCallResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DialWhatsAppCallResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DialWhatsAppCallResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DialWhatsAppCallResponse;

  static equals(a: DialWhatsAppCallResponse | PlainMessage<DialWhatsAppCallResponse> | undefined, b: DialWhatsAppCallResponse | PlainMessage<DialWhatsAppCallResponse> | undefined): boolean;
}

/**
 * @generated from message livekit.DisconnectWhatsAppCallRequest
 */
export declare class DisconnectWhatsAppCallRequest extends Message<DisconnectWhatsAppCallRequest> {
  /**
   * Call ID sent by Meta
   *
   * @generated from field: string whatsapp_call_id = 1;
   */
  whatsappCallId: string;

  /**
   * @generated from field: string whatsapp_api_key = 2;
   */
  whatsappApiKey: string;

  constructor(data?: PartialMessage<DisconnectWhatsAppCallRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.DisconnectWhatsAppCallRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DisconnectWhatsAppCallRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DisconnectWhatsAppCallRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DisconnectWhatsAppCallRequest;

  static equals(a: DisconnectWhatsAppCallRequest | PlainMessage<DisconnectWhatsAppCallRequest> | undefined, b: DisconnectWhatsAppCallRequest | PlainMessage<DisconnectWhatsAppCallRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.DisconnectWhatsAppCallResponse
 */
export declare class DisconnectWhatsAppCallResponse extends Message<DisconnectWhatsAppCallResponse> {
  constructor(data?: PartialMessage<DisconnectWhatsAppCallResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.DisconnectWhatsAppCallResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DisconnectWhatsAppCallResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DisconnectWhatsAppCallResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DisconnectWhatsAppCallResponse;

  static equals(a: DisconnectWhatsAppCallResponse | PlainMessage<DisconnectWhatsAppCallResponse> | undefined, b: DisconnectWhatsAppCallResponse | PlainMessage<DisconnectWhatsAppCallResponse> | undefined): boolean;
}

/**
 * @generated from message livekit.ConnectWhatsAppCallRequest
 */
export declare class ConnectWhatsAppCallRequest extends Message<ConnectWhatsAppCallRequest> {
  /**
   * The number of the business that is conencting the call
   *
   * @generated from field: string whatsapp_phone_number_id = 1;
   */
  whatsappPhoneNumberId: string;

  /**
   * The API key of the business that is connecting the call
   *
   * @generated from field: string whatsapp_api_key = 2;
   */
  whatsappApiKey: string;

  /**
   * Call ID sent by Meta
   *
   * @generated from field: string whatsapp_call_id = 3;
   */
  whatsappCallId: string;

  /**
   * The call connect webhook comes with SDP from Meta
   * It is the answer SDP for a business initiated call
   *
   * @generated from field: livekit.SessionDescription sdp = 4;
   */
  sdp?: SessionDescription;

  constructor(data?: PartialMessage<ConnectWhatsAppCallRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.ConnectWhatsAppCallRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConnectWhatsAppCallRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConnectWhatsAppCallRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConnectWhatsAppCallRequest;

  static equals(a: ConnectWhatsAppCallRequest | PlainMessage<ConnectWhatsAppCallRequest> | undefined, b: ConnectWhatsAppCallRequest | PlainMessage<ConnectWhatsAppCallRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.ConnectWhatsAppCallResponse
 */
export declare class ConnectWhatsAppCallResponse extends Message<ConnectWhatsAppCallResponse> {
  constructor(data?: PartialMessage<ConnectWhatsAppCallResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.ConnectWhatsAppCallResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConnectWhatsAppCallResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConnectWhatsAppCallResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConnectWhatsAppCallResponse;

  static equals(a: ConnectWhatsAppCallResponse | PlainMessage<ConnectWhatsAppCallResponse> | undefined, b: ConnectWhatsAppCallResponse | PlainMessage<ConnectWhatsAppCallResponse> | undefined): boolean;
}

/**
 * @generated from message livekit.AcceptWhatsAppCallRequest
 */
export declare class AcceptWhatsAppCallRequest extends Message<AcceptWhatsAppCallRequest> {
  /**
   * The number of the business that is conencting the call
   *
   * @generated from field: string whatsapp_phone_number_id = 1;
   */
  whatsappPhoneNumberId: string;

  /**
   * The API key of the business that is connecting the call
   *
   * @generated from field: string whatsapp_api_key = 2;
   */
  whatsappApiKey: string;

  /**
   * Call ID sent by Meta
   *
   * @generated from field: string whatsapp_call_id = 3;
   */
  whatsappCallId: string;

  /**
   * An arbitrary string you can pass in that is useful for tracking and logging purposes.
   *
   * @generated from field: string whatsapp_biz_opaque_callback_data = 4;
   */
  whatsappBizOpaqueCallbackData: string;

  /**
   * The call accept webhook comes with SDP from Meta
   * It is the for a user initiated call
   *
   * @generated from field: livekit.SessionDescription sdp = 5;
   */
  sdp?: SessionDescription;

  /**
   * What LiveKit room should this participant be connected too
   *
   * @generated from field: string room_name = 6;
   */
  roomName: string;

  /**
   * Optional agents to dispatch the call to
   *
   * @generated from field: repeated livekit.RoomAgentDispatch agents = 7;
   */
  agents: RoomAgentDispatch[];

  /**
   * Optional identity of the participant in LiveKit room
   *
   * @generated from field: string participant_identity = 8;
   */
  participantIdentity: string;

  /**
   * Optional name of the participant in LiveKit room
   *
   * @generated from field: string participant_name = 9;
   */
  participantName: string;

  /**
   * Optional user-defined metadata. Will be attached to a created Participant in the room.
   *
   * @generated from field: string participant_metadata = 10;
   */
  participantMetadata: string;

  /**
   * Optional user-defined attributes. Will be attached to a created Participant in the room.
   *
   * @generated from field: map<string, string> participant_attributes = 11;
   */
  participantAttributes: { [key: string]: string };

  /**
   * Country where the call terminates as ISO 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will be used by the livekit infrastructure to route calls.
   *
   * @generated from field: string destination_country = 12;
   */
  destinationCountry: string;

  constructor(data?: PartialMessage<AcceptWhatsAppCallRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.AcceptWhatsAppCallRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AcceptWhatsAppCallRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AcceptWhatsAppCallRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AcceptWhatsAppCallRequest;

  static equals(a: AcceptWhatsAppCallRequest | PlainMessage<AcceptWhatsAppCallRequest> | undefined, b: AcceptWhatsAppCallRequest | PlainMessage<AcceptWhatsAppCallRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.AcceptWhatsAppCallResponse
 */
export declare class AcceptWhatsAppCallResponse extends Message<AcceptWhatsAppCallResponse> {
  constructor(data?: PartialMessage<AcceptWhatsAppCallResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.AcceptWhatsAppCallResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AcceptWhatsAppCallResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AcceptWhatsAppCallResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AcceptWhatsAppCallResponse;

  static equals(a: AcceptWhatsAppCallResponse | PlainMessage<AcceptWhatsAppCallResponse> | undefined, b: AcceptWhatsAppCallResponse | PlainMessage<AcceptWhatsAppCallResponse> | undefined): boolean;
}

/**
 * @generated from message livekit.WhatsAppCall
 */
export declare class WhatsAppCall extends Message<WhatsAppCall> {
  /**
   * list of call ids that are currently active
   *
   * @generated from field: string whatsapp_call_id = 1;
   */
  whatsappCallId: string;

  /**
   * Direction of the call
   *
   * @generated from field: livekit.WhatsAppCallDirection direction = 2;
   */
  direction: WhatsAppCallDirection;

  constructor(data?: PartialMessage<WhatsAppCall>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.WhatsAppCall";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WhatsAppCall;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WhatsAppCall;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WhatsAppCall;

  static equals(a: WhatsAppCall | PlainMessage<WhatsAppCall> | undefined, b: WhatsAppCall | PlainMessage<WhatsAppCall> | undefined): boolean;
}

