<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('session_resources', function (Blueprint $table) {
        $table->id();
        $table->foreignId('session_id')->constrained('live_sessions')->onDelete('cascade');
        $table->string('title');
        $table->string('url');
        $table->enum('type', ['pdf', 'video', 'link'])->default('link');
        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('session_resources');
    }
};
