<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('live_sessions', function (Blueprint $table) {
        $table->id();
        $table->foreignId('group_id')->constrained()->onDelete('cascade');
        $table->foreignId('teacher_id')->constrained('users')->onDelete('cascade');
        $table->string('title');
        $table->enum('type', ['class', 'project', 'break', 'meeting', 'lunch']);
        $table->enum('status', ['open', 'closed', 'joinable'])->default('open');
        $table->enum('day_of_week', ['monday','tuesday','wednesday','thursday','friday','saturday','sunday']);
        $table->time('start_time');
        $table->time('end_time');
        $table->string('color')->default('#A5D6A7');
        $table->string('link')->nullable();
        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('live_sessions');
    }
};
