<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('goal_subtasks', function (Blueprint $table) {
        $table->id();
        $table->foreignId('goal_id')->constrained()->onDelete('cascade');
        $table->string('title');
        $table->boolean('completed')->default(false);
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('goal_subtasks');
    }
};
