<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Table pour les conversations
        Schema::create('nova_conversations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('title')->nullable(); // Titre de la conversation
            $table->timestamp('last_message_at')->nullable();
            $table->timestamps();

            $table->index('user_id');
            $table->index('last_message_at');
        });

        // Table pour les messages
        Schema::create('nova_messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conversation_id')->constrained('nova_conversations')->onDelete('cascade');
            $table->enum('role', ['user', 'assistant']); // user ou assistant
            $table->text('content'); // Contenu du message
            $table->json('metadata')->nullable(); // Pour stocker des infos supplémentaires
            $table->timestamps();

            $table->index('conversation_id');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('nova_messages');
        Schema::dropIfExists('nova_conversations');
    }
};
