<?php

namespace App\View\Composers;

use Illuminate\View\View;
use App\Models\NovaConversation;

class SidebarComposer
{
    public function compose(View $view)
    {
        // Vérifier si l'utilisateur est authentifié et sur la page Nova
        if (auth()->check() && request()->routeIs('student.nova.*')) {
            $conversations = NovaConversation::where('user_id', auth()->id())
                ->orderBy('last_message_at', 'desc')
                ->get();

            $view->with('conversations', $conversations);
        } else {
            $view->with('conversations', collect([]));
        }
    }
}
