<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class ZoomService
{
    private function getAccessToken()
    {
        $response = Http::asForm()
            ->withBasicAuth(env('ZOOM_CLIENT_ID'), env('ZOOM_CLIENT_SECRET'))
            ->post('https://zoom.us/oauth/token', [
                'grant_type' => 'account_credentials',
                'account_id' => env('ZOOM_ACCOUNT_ID'),
            ]);

        if ($response->failed()) {
            throw new \Exception('Erreur Zoom : ' . $response->body());
        }

        return $response->json()['access_token'];
    }

    public function createMeeting($topic, $startTime, $duration = 60)
    {
        $token = $this->getAccessToken();

        $response = Http::withToken($token)
            ->post('https://api.zoom.us/v2/users/me/meetings', [
                'topic' => $topic,
                'type' => 2, // Réunion programmée
                'start_time' => $startTime,
                'duration' => $duration,
                'timezone' => 'Africa/Tunis',
                'settings' => [
                    'join_before_host' => true,
                    'host_video' => true,
                    'participant_video' => true,
                    'waiting_room' => false,
                ],
            ]);

        if ($response->failed()) {
            throw new \Exception('Erreur création réunion : ' . $response->body());
        }

        return $response->json(); // Contient join_url, start_url, meeting ID, etc.
    }
}
