<?php

namespace App\Services;

use Firebase\JWT\JWT;

class LiveKitService
{
    public function generateToken($roomName, $identity)
    {
        $key = env('LIVEKIT_API_KEY');
        $secret = env('LIVEKIT_API_SECRET');

        $now = time();
        $exp = $now + 3600;

        $payload = [
            'iss' => $key,
            'sub' => $identity,
            'nbf' => $now - 10,
            'exp' => $exp,
            'video' => [
                'room' => $roomName,
                'roomJoin' => true,
                'canPublish' => true,
                'canSubscribe' => true,
            ]
        ];

        return JWT::encode($payload, $secret, 'HS256');
    }
}
