<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\NovaConversation;

class AppServiceProvider extends ServiceProvider
{
    public function boot()
    {
        // Partager les conversations avec toutes les vues quand on est sur Nova
        View::composer('*', function ($view) {
            if (auth()->check() && request()->routeIs('student.nova.*')) {
                $conversations = NovaConversation::where('user_id', auth()->id())
                    ->orderBy('last_message_at', 'desc')
                    ->get();

                $view->with('conversations', $conversations);
            }
        });
    }

    public function register()
    {
        //
    }
}
