<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WalletTransaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'payment_method_id',
        'amount',
        'reference',
        'receipt_path',
        'status',
        'type',
        'verified_by',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    // 🔹 Relation avec l'utilisateur
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // 🔹 Méthode de paiement utilisée
    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }

    // 🔹 Admin qui a validé
    public function verifier()
    {
        return $this->belongsTo(User::class, 'verified_by');
    }

    // 🔹 Notifications associées
    public function notifications()
    {
        return $this->hasMany(WalletNotification::class, 'transaction_id');
    }

    // 🔹 Helper : statut lisible
    public function getStatusBadgeAttribute()
    {
        return match($this->status) {
            'pending' => ['text' => 'Pending', 'color' => 'orange'],
            'success' => ['text' => 'Success', 'color' => 'green'],
            'failed' => ['text' => 'Failed', 'color' => 'red'],
            default => ['text' => 'Unknown', 'color' => 'gray'],
        };
    }
}
