<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NovaMessage extends Model
{
    protected $fillable = [
        'conversation_id',
        'role',
        'content',
        'metadata',
    ];

    protected $casts = [
        'metadata' => 'array',
    ];

    /**
     * Relation avec la conversation
     */
    public function conversation(): BelongsTo
    {
        return $this->belongsTo(NovaConversation::class, 'conversation_id');
    }

    /**
     * Vérifier si c'est un message utilisateur
     */
    public function isUser(): bool
    {
        return $this->role === 'user';
    }

    /**
     * Vérifier si c'est un message assistant
     */
    public function isAssistant(): bool
    {
        return $this->role === 'assistant';
    }
}
