<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Meeting extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'group_id',
        'topic',
        'zoom_meeting_id',
        'start_url',
        'join_url',
        'password',
        'start_time',
        'end_time',
        'description',
        'subtasks',
        'attachments',
    ];

    protected $casts = [
        'start_time' => 'datetime',
        'end_time' => 'datetime',
        'subtasks' => 'array',
        'attachments' => 'array',
    ];

    public function group()
    {
        return $this->belongsTo(Group::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
