<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LiveSession extends Model
{
    protected $fillable = [
        'group_id',
        'user_id',
        'teacher_id',
        'title',
        'type',
        'status',
        'day_of_week',
        'start_time',
        'end_time',
        'color',
        'link',
        'week_start_date',
        'notes',            // 🟢 Description
        'subtasks'          // 🟢 Checklist JSON
    ];

    protected $casts = [
        'subtasks' => 'array', // 🟢 Auto-cast JSON <-> Array
    ];

    public function group()
    {
        return $this->belongsTo(Group::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function attendances()
    {
        return $this->hasMany(SessionAttendance::class, 'session_id');
    }

    public function resources()
    {
        return $this->hasMany(SessionResource::class, 'session_id');
    }

    public function participants()
    {
        return $this->hasMany(LiveParticipant::class, 'session_id');
    }

    public function messages()
    {
        return $this->hasMany(LiveMessage::class, 'session_id');
    }

    public function files()
    {
        return $this->hasMany(LiveFile::class, 'session_id');
    }
}
