<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LiveParticipant extends Model
{
    use HasFactory;

    protected $table = 'live_participants';

    protected $fillable = [
        'session_id',
        'user_id',
        'role',
        'joined_at',
        'left_at',
        'is_muted',
        'is_camera_on',
    ];

    public $timestamps = false; // car tu utilises joined_at / left_at manuellement

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function session()
    {
        return $this->belongsTo(LiveSession::class, 'session_id');
    }
}
