<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LiveMessage extends Model
{
    use HasFactory;

    protected $table = 'live_messages';

    protected $fillable = [
        'session_id',
        'sender_id',
        'message',
        'sent_at',
    ];

    public $timestamps = false;

    public function session()
    {
        return $this->belongsTo(LiveSession::class, 'session_id');
    }

    public function sender()
    {
        return $this->belongsTo(User::class, 'sender_id');
    }
}
